/*
 * Decompiled with CFR 0.152.
 */
package net.accelbyte.sdk.api.dslogmanager.operations.admin;

import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.accelbyte.sdk.api.dslogmanager.models.ModelsServerLogs;
import net.accelbyte.sdk.core.HttpResponseException;
import net.accelbyte.sdk.core.Operation;
import net.accelbyte.sdk.core.util.Helper;

public class GetServerLogs
extends Operation {
    private String path = "/dslogmanager/admin/namespaces/{namespace}/servers/{podName}/logs";
    private String method = "GET";
    private List<String> consumes = Arrays.asList("application/json");
    private List<String> produces = Arrays.asList("application/json");
    private String locationQuery = null;
    private String namespace;
    private String podName;
    private String logType;
    private Integer offset;
    private String origin;

    @Deprecated
    public GetServerLogs(String namespace, String podName, String logType, Integer offset, String origin) {
        this.namespace = namespace;
        this.podName = podName;
        this.logType = logType;
        this.offset = offset;
        this.origin = origin;
        this.securities.add("Bearer");
    }

    public Map<String, String> getPathParams() {
        HashMap<String, String> pathParams = new HashMap<String, String>();
        if (this.namespace != null) {
            pathParams.put("namespace", this.namespace);
        }
        if (this.podName != null) {
            pathParams.put("podName", this.podName);
        }
        return pathParams;
    }

    public Map<String, List<String>> getQueryParams() {
        HashMap<String, List<String>> queryParams = new HashMap<String, List<String>>();
        queryParams.put("logType", this.logType == null ? null : Arrays.asList(this.logType));
        queryParams.put("offset", this.offset == null ? null : Arrays.asList(String.valueOf(this.offset)));
        queryParams.put("origin", this.origin == null ? null : Arrays.asList(this.origin));
        return queryParams;
    }

    public boolean isValid() {
        if (this.namespace == null) {
            return false;
        }
        return this.podName != null;
    }

    public ModelsServerLogs parseResponse(int code, String contentType, InputStream payload) throws HttpResponseException, IOException {
        if (code != 200) {
            String json = Helper.convertInputStreamToString((InputStream)payload);
            throw new HttpResponseException(code, json);
        }
        String json = Helper.convertInputStreamToString((InputStream)payload);
        return new ModelsServerLogs().createFromJson(json);
    }

    protected Map<String, String> getCollectionFormatMap() {
        HashMap<String, String> result = new HashMap<String, String>();
        result.put("logType", "None");
        result.put("offset", "None");
        result.put("origin", "None");
        return result;
    }

    public static GetServerLogsBuilder builder() {
        return new GetServerLogsBuilder();
    }

    public String getPath() {
        return this.path;
    }

    public String getMethod() {
        return this.method;
    }

    public List<String> getConsumes() {
        return this.consumes;
    }

    public List<String> getProduces() {
        return this.produces;
    }

    public String getLocationQuery() {
        return this.locationQuery;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public String getPodName() {
        return this.podName;
    }

    public String getLogType() {
        return this.logType;
    }

    public Integer getOffset() {
        return this.offset;
    }

    public String getOrigin() {
        return this.origin;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public void setMethod(String method) {
        this.method = method;
    }

    public void setConsumes(List<String> consumes) {
        this.consumes = consumes;
    }

    public void setProduces(List<String> produces) {
        this.produces = produces;
    }

    public void setLocationQuery(String locationQuery) {
        this.locationQuery = locationQuery;
    }

    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    public void setPodName(String podName) {
        this.podName = podName;
    }

    public void setLogType(String logType) {
        this.logType = logType;
    }

    public void setOffset(Integer offset) {
        this.offset = offset;
    }

    public void setOrigin(String origin) {
        this.origin = origin;
    }

    public static class GetServerLogsBuilder {
        private String namespace;
        private String podName;
        private String logType;
        private Integer offset;
        private String origin;

        GetServerLogsBuilder() {
        }

        public GetServerLogsBuilder namespace(String namespace) {
            this.namespace = namespace;
            return this;
        }

        public GetServerLogsBuilder podName(String podName) {
            this.podName = podName;
            return this;
        }

        public GetServerLogsBuilder logType(String logType) {
            this.logType = logType;
            return this;
        }

        public GetServerLogsBuilder offset(Integer offset) {
            this.offset = offset;
            return this;
        }

        public GetServerLogsBuilder origin(String origin) {
            this.origin = origin;
            return this;
        }

        public GetServerLogs build() {
            return new GetServerLogs(this.namespace, this.podName, this.logType, this.offset, this.origin);
        }

        public String toString() {
            return "GetServerLogs.GetServerLogsBuilder(namespace=" + this.namespace + ", podName=" + this.podName + ", logType=" + this.logType + ", offset=" + this.offset + ", origin=" + this.origin + ")";
        }
    }
}

