/*
 * Copyright (c) 2015, 2017, Oracle and/or its affiliates. All rights reserved.
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License, version 2.0, as published by the
 * Free Software Foundation.
 *
 * This program is also distributed with certain software (including but not
 * limited to OpenSSL) that is licensed under separate terms, as designated in a
 * particular file or component or in included license documentation. The
 * authors of MySQL hereby grant you an additional permission to link the
 * program and your derivative works with the separately licensed software that
 * they have included with MySQL.
 *
 * Without limiting anything contained in the foregoing, this file, which is
 * part of MySQL Connector/J, is also subject to the Universal FOSS Exception,
 * version 1.0, a copy of which can be found at
 * http://oss.oracle.com/licenses/universal-foss-exception.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU General Public License, version 2.0,
 * for more details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin St, Fifth Floor, Boston, MA 02110-1301  USA
 */

package com.mysql.cj.x.protobuf;

// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: mysqlx_datatypes.proto

public final class MysqlxDatatypes {
  private MysqlxDatatypes() {}
  public static void registerAllExtensions(
      com.google.protobuf.ExtensionRegistry registry) {
  }
  public interface ScalarOrBuilder extends
      // @@protoc_insertion_point(interface_extends:Mysqlx.Datatypes.Scalar)
      com.google.protobuf.MessageOrBuilder {

    /**
     * <code>required .Mysqlx.Datatypes.Scalar.Type type = 1;</code>
     */
    boolean hasType();
    /**
     * <code>required .Mysqlx.Datatypes.Scalar.Type type = 1;</code>
     */
    com.mysql.cj.x.protobuf.MysqlxDatatypes.Scalar.Type getType();

    /**
     * <code>optional sint64 v_signed_int = 2;</code>
     */
    boolean hasVSignedInt();
    /**
     * <code>optional sint64 v_signed_int = 2;</code>
     */
    long getVSignedInt();

    /**
     * <code>optional uint64 v_unsigned_int = 3;</code>
     */
    boolean hasVUnsignedInt();
    /**
     * <code>optional uint64 v_unsigned_int = 3;</code>
     */
    long getVUnsignedInt();

    /**
     * <code>optional .Mysqlx.Datatypes.Scalar.Octets v_octets = 5;</code>
     *
     * <pre>
     * 4 is unused, was Null which doesn't have a storage anymore
     * </pre>
     */
    boolean hasVOctets();
    /**
     * <code>optional .Mysqlx.Datatypes.Scalar.Octets v_octets = 5;</code>
     *
     * <pre>
     * 4 is unused, was Null which doesn't have a storage anymore
     * </pre>
     */
    com.mysql.cj.x.protobuf.MysqlxDatatypes.Scalar.Octets getVOctets();
    /**
     * <code>optional .Mysqlx.Datatypes.Scalar.Octets v_octets = 5;</code>
     *
     * <pre>
     * 4 is unused, was Null which doesn't have a storage anymore
     * </pre>
     */
    com.mysql.cj.x.protobuf.MysqlxDatatypes.Scalar.OctetsOrBuilder getVOctetsOrBuilder();

    /**
     * <code>optional double v_double = 6;</code>
     */
    boolean hasVDouble();
    /**
     * <code>optional double v_double = 6;</code>
     */
    double getVDouble();

    /**
     * <code>optional float v_float = 7;</code>
     */
    boolean hasVFloat();
    /**
     * <code>optional float v_float = 7;</code>
     */
    float getVFloat();

    /**
     * <code>optional bool v_bool = 8;</code>
     */
    boolean hasVBool();
    /**
     * <code>optional bool v_bool = 8;</code>
     */
    boolean getVBool();

    /**
     * <code>optional .Mysqlx.Datatypes.Scalar.String v_string = 9;</code>
     */
    boolean hasVString();
    /**
     * <code>optional .Mysqlx.Datatypes.Scalar.String v_string = 9;</code>
     */
    com.mysql.cj.x.protobuf.MysqlxDatatypes.Scalar.String getVString();
    /**
     * <code>optional .Mysqlx.Datatypes.Scalar.String v_string = 9;</code>
     */
    com.mysql.cj.x.protobuf.MysqlxDatatypes.Scalar.StringOrBuilder getVStringOrBuilder();
  }
  /**
   * Protobuf type {@code Mysqlx.Datatypes.Scalar}
   *
   * <pre>
   * a scalar
   * </pre>
   */
  public static final class Scalar extends
      com.google.protobuf.GeneratedMessage implements
      // @@protoc_insertion_point(message_implements:Mysqlx.Datatypes.Scalar)
      ScalarOrBuilder {
    // Use Scalar.newBuilder() to construct.
    private Scalar(com.google.protobuf.GeneratedMessage.Builder<?> builder) {
      super(builder);
      this.unknownFields = builder.getUnknownFields();
    }
    private Scalar(boolean noInit) { this.unknownFields = com.google.protobuf.UnknownFieldSet.getDefaultInstance(); }

    private static final Scalar defaultInstance;
    public static Scalar getDefaultInstance() {
      return defaultInstance;
    }

    public Scalar getDefaultInstanceForType() {
      return defaultInstance;
    }

    private final com.google.protobuf.UnknownFieldSet unknownFields;
    @java.lang.Override
    public final com.google.protobuf.UnknownFieldSet
        getUnknownFields() {
      return this.unknownFields;
    }
    private Scalar(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      initFields();
      int mutable_bitField0_ = 0;
      com.google.protobuf.UnknownFieldSet.Builder unknownFields =
          com.google.protobuf.UnknownFieldSet.newBuilder();
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            default: {
              if (!parseUnknownField(input, unknownFields,
                                     extensionRegistry, tag)) {
                done = true;
              }
              break;
            }
            case 8: {
              int rawValue = input.readEnum();
              com.mysql.cj.x.protobuf.MysqlxDatatypes.Scalar.Type value = com.mysql.cj.x.protobuf.MysqlxDatatypes.Scalar.Type.valueOf(rawValue);
              if (value == null) {
                unknownFields.mergeVarintField(1, rawValue);
              } else {
                bitField0_ |= 0x00000001;
                type_ = value;
              }
              break;
            }
            case 16: {
              bitField0_ |= 0x00000002;
              vSignedInt_ = input.readSInt64();
              break;
            }
            case 24: {
              bitField0_ |= 0x00000004;
              vUnsignedInt_ = input.readUInt64();
              break;
            }
            case 42: {
              com.mysql.cj.x.protobuf.MysqlxDatatypes.Scalar.Octets.Builder subBuilder = null;
              if (((bitField0_ & 0x00000008) == 0x00000008)) {
                subBuilder = vOctets_.toBuilder();
              }
              vOctets_ = input.readMessage(com.mysql.cj.x.protobuf.MysqlxDatatypes.Scalar.Octets.PARSER, extensionRegistry);
              if (subBuilder != null) {
                subBuilder.mergeFrom(vOctets_);
                vOctets_ = subBuilder.buildPartial();
              }
              bitField0_ |= 0x00000008;
              break;
            }
            case 49: {
              bitField0_ |= 0x00000010;
              vDouble_ = input.readDouble();
              break;
            }
            case 61: {
              bitField0_ |= 0x00000020;
              vFloat_ = input.readFloat();
              break;
            }
            case 64: {
              bitField0_ |= 0x00000040;
              vBool_ = input.readBool();
              break;
            }
            case 74: {
              com.mysql.cj.x.protobuf.MysqlxDatatypes.Scalar.String.Builder subBuilder = null;
              if (((bitField0_ & 0x00000080) == 0x00000080)) {
                subBuilder = vString_.toBuilder();
              }
              vString_ = input.readMessage(com.mysql.cj.x.protobuf.MysqlxDatatypes.Scalar.String.PARSER, extensionRegistry);
              if (subBuilder != null) {
                subBuilder.mergeFrom(vString_);
                vString_ = subBuilder.buildPartial();
              }
              bitField0_ |= 0x00000080;
              break;
            }
          }
        }
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.setUnfinishedMessage(this);
      } catch (java.io.IOException e) {
        throw new com.google.protobuf.InvalidProtocolBufferException(
            e.getMessage()).setUnfinishedMessage(this);
      } finally {
        this.unknownFields = unknownFields.build();
        makeExtensionsImmutable();
      }
    }
    public static final com.google.protobuf.Descriptors.Descriptor
        getDescriptor() {
      return com.mysql.cj.x.protobuf.MysqlxDatatypes.internal_static_Mysqlx_Datatypes_Scalar_descriptor;
    }

    protected com.google.protobuf.GeneratedMessage.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.mysql.cj.x.protobuf.MysqlxDatatypes.internal_static_Mysqlx_Datatypes_Scalar_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.mysql.cj.x.protobuf.MysqlxDatatypes.Scalar.class, com.mysql.cj.x.protobuf.MysqlxDatatypes.Scalar.Builder.class);
    }

    public static com.google.protobuf.Parser<Scalar> PARSER =
        new com.google.protobuf.AbstractParser<Scalar>() {
      public Scalar parsePartialFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return new Scalar(input, extensionRegistry);
      }
    };

    @java.lang.Override
    public com.google.protobuf.Parser<Scalar> getParserForType() {
      return PARSER;
    }

    /**
     * Protobuf enum {@code Mysqlx.Datatypes.Scalar.Type}
     */
    public enum Type
        implements com.google.protobuf.ProtocolMessageEnum {
      /**
       * <code>V_SINT = 1;</code>
       */
      V_SINT(0, 1),
      /**
       * <code>V_UINT = 2;</code>
       */
      V_UINT(1, 2),
      /**
       * <code>V_NULL = 3;</code>
       */
      V_NULL(2, 3),
      /**
       * <code>V_OCTETS = 4;</code>
       */
      V_OCTETS(3, 4),
      /**
       * <code>V_DOUBLE = 5;</code>
       */
      V_DOUBLE(4, 5),
      /**
       * <code>V_FLOAT = 6;</code>
       */
      V_FLOAT(5, 6),
      /**
       * <code>V_BOOL = 7;</code>
       */
      V_BOOL(6, 7),
      /**
       * <code>V_STRING = 8;</code>
       */
      V_STRING(7, 8),
      ;

      /**
       * <code>V_SINT = 1;</code>
       */
      public static final int V_SINT_VALUE = 1;
      /**
       * <code>V_UINT = 2;</code>
       */
      public static final int V_UINT_VALUE = 2;
      /**
       * <code>V_NULL = 3;</code>
       */
      public static final int V_NULL_VALUE = 3;
      /**
       * <code>V_OCTETS = 4;</code>
       */
      public static final int V_OCTETS_VALUE = 4;
      /**
       * <code>V_DOUBLE = 5;</code>
       */
      public static final int V_DOUBLE_VALUE = 5;
      /**
       * <code>V_FLOAT = 6;</code>
       */
      public static final int V_FLOAT_VALUE = 6;
      /**
       * <code>V_BOOL = 7;</code>
       */
      public static final int V_BOOL_VALUE = 7;
      /**
       * <code>V_STRING = 8;</code>
       */
      public static final int V_STRING_VALUE = 8;


      public final int getNumber() { return value; }

      public static Type valueOf(int value) {
        switch (value) {
          case 1: return V_SINT;
          case 2: return V_UINT;
          case 3: return V_NULL;
          case 4: return V_OCTETS;
          case 5: return V_DOUBLE;
          case 6: return V_FLOAT;
          case 7: return V_BOOL;
          case 8: return V_STRING;
          default: return null;
        }
      }

      public static com.google.protobuf.Internal.EnumLiteMap<Type>
          internalGetValueMap() {
        return internalValueMap;
      }
      private static com.google.protobuf.Internal.EnumLiteMap<Type>
          internalValueMap =
            new com.google.protobuf.Internal.EnumLiteMap<Type>() {
              public Type findValueByNumber(int number) {
                return Type.valueOf(number);
              }
            };

      public final com.google.protobuf.Descriptors.EnumValueDescriptor
          getValueDescriptor() {
        return getDescriptor().getValues().get(index);
      }
      public final com.google.protobuf.Descriptors.EnumDescriptor
          getDescriptorForType() {
        return getDescriptor();
      }
      public static final com.google.protobuf.Descriptors.EnumDescriptor
          getDescriptor() {
        return com.mysql.cj.x.protobuf.MysqlxDatatypes.Scalar.getDescriptor().getEnumTypes().get(0);
      }

      private static final Type[] VALUES = values();

      public static Type valueOf(
          com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
        if (desc.getType() != getDescriptor()) {
          throw new java.lang.IllegalArgumentException(
            "EnumValueDescriptor is not for this type.");
        }
        return VALUES[desc.getIndex()];
      }

      private final int index;
      private final int value;

      private Type(int index, int value) {
        this.index = index;
        this.value = value;
      }

      // @@protoc_insertion_point(enum_scope:Mysqlx.Datatypes.Scalar.Type)
    }

    public interface StringOrBuilder extends
        // @@protoc_insertion_point(interface_extends:Mysqlx.Datatypes.Scalar.String)
        com.google.protobuf.MessageOrBuilder {

      /**
       * <code>required bytes value = 1;</code>
       */
      boolean hasValue();
      /**
       * <code>required bytes value = 1;</code>
       */
      com.google.protobuf.ByteString getValue();

      /**
       * <code>optional uint64 collation = 2;</code>
       */
      boolean hasCollation();
      /**
       * <code>optional uint64 collation = 2;</code>
       */
      long getCollation();
    }
    /**
     * Protobuf type {@code Mysqlx.Datatypes.Scalar.String}
     *
     * <pre>
     * a string with a charset/collation
     * </pre>
     */
    public static final class String extends
        com.google.protobuf.GeneratedMessage implements
        // @@protoc_insertion_point(message_implements:Mysqlx.Datatypes.Scalar.String)
        StringOrBuilder {
      // Use String.newBuilder() to construct.
      private String(com.google.protobuf.GeneratedMessage.Builder<?> builder) {
        super(builder);
        this.unknownFields = builder.getUnknownFields();
      }
      private String(boolean noInit) { this.unknownFields = com.google.protobuf.UnknownFieldSet.getDefaultInstance(); }

      private static final String defaultInstance;
      public static String getDefaultInstance() {
        return defaultInstance;
      }

      public String getDefaultInstanceForType() {
        return defaultInstance;
      }

      private final com.google.protobuf.UnknownFieldSet unknownFields;
      @java.lang.Override
      public final com.google.protobuf.UnknownFieldSet
          getUnknownFields() {
        return this.unknownFields;
      }
      private String(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        initFields();
        int mutable_bitField0_ = 0;
        com.google.protobuf.UnknownFieldSet.Builder unknownFields =
            com.google.protobuf.UnknownFieldSet.newBuilder();
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              default: {
                if (!parseUnknownField(input, unknownFields,
                                       extensionRegistry, tag)) {
                  done = true;
                }
                break;
              }
              case 10: {
                bitField0_ |= 0x00000001;
                value_ = input.readBytes();
                break;
              }
              case 16: {
                bitField0_ |= 0x00000002;
                collation_ = input.readUInt64();
                break;
              }
            }
          }
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.setUnfinishedMessage(this);
        } catch (java.io.IOException e) {
          throw new com.google.protobuf.InvalidProtocolBufferException(
              e.getMessage()).setUnfinishedMessage(this);
        } finally {
          this.unknownFields = unknownFields.build();
          makeExtensionsImmutable();
        }
      }
      public static final com.google.protobuf.Descriptors.Descriptor
          getDescriptor() {
        return com.mysql.cj.x.protobuf.MysqlxDatatypes.internal_static_Mysqlx_Datatypes_Scalar_String_descriptor;
      }

      protected com.google.protobuf.GeneratedMessage.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.mysql.cj.x.protobuf.MysqlxDatatypes.internal_static_Mysqlx_Datatypes_Scalar_String_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.mysql.cj.x.protobuf.MysqlxDatatypes.Scalar.String.class, com.mysql.cj.x.protobuf.MysqlxDatatypes.Scalar.String.Builder.class);
      }

      public static com.google.protobuf.Parser<String> PARSER =
          new com.google.protobuf.AbstractParser<String>() {
        public String parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          return new String(input, extensionRegistry);
        }
      };

      @java.lang.Override
      public com.google.protobuf.Parser<String> getParserForType() {
        return PARSER;
      }

      private int bitField0_;
      public static final int VALUE_FIELD_NUMBER = 1;
      private com.google.protobuf.ByteString value_;
      /**
       * <code>required bytes value = 1;</code>
       */
      public boolean hasValue() {
        return ((bitField0_ & 0x00000001) == 0x00000001);
      }
      /**
       * <code>required bytes value = 1;</code>
       */
      public com.google.protobuf.ByteString getValue() {
        return value_;
      }

      public static final int COLLATION_FIELD_NUMBER = 2;
      private long collation_;
      /**
       * <code>optional uint64 collation = 2;</code>
       */
      public boolean hasCollation() {
        return ((bitField0_ & 0x00000002) == 0x00000002);
      }
      /**
       * <code>optional uint64 collation = 2;</code>
       */
      public long getCollation() {
        return collation_;
      }

      private void initFields() {
        value_ = com.google.protobuf.ByteString.EMPTY;
        collation_ = 0L;
      }
      private byte memoizedIsInitialized = -1;
      public final boolean isInitialized() {
        byte isInitialized = memoizedIsInitialized;
        if (isInitialized == 1) return true;
        if (isInitialized == 0) return false;

        if (!hasValue()) {
          memoizedIsInitialized = 0;
          return false;
        }
        memoizedIsInitialized = 1;
        return true;
      }

      public void writeTo(com.google.protobuf.CodedOutputStream output)
                          throws java.io.IOException {
        getSerializedSize();
        if (((bitField0_ & 0x00000001) == 0x00000001)) {
          output.writeBytes(1, value_);
        }
        if (((bitField0_ & 0x00000002) == 0x00000002)) {
          output.writeUInt64(2, collation_);
        }
        getUnknownFields().writeTo(output);
      }

      private int memoizedSerializedSize = -1;
      public int getSerializedSize() {
        int size = memoizedSerializedSize;
        if (size != -1) return size;

        size = 0;
        if (((bitField0_ & 0x00000001) == 0x00000001)) {
          size += com.google.protobuf.CodedOutputStream
            .computeBytesSize(1, value_);
        }
        if (((bitField0_ & 0x00000002) == 0x00000002)) {
          size += com.google.protobuf.CodedOutputStream
            .computeUInt64Size(2, collation_);
        }
        size += getUnknownFields().getSerializedSize();
        memoizedSerializedSize = size;
        return size;
      }

      private static final long serialVersionUID = 0L;
      @java.lang.Override
      protected java.lang.Object writeReplace()
          throws java.io.ObjectStreamException {
        return super.writeReplace();
      }

      public static com.mysql.cj.x.protobuf.MysqlxDatatypes.Scalar.String parseFrom(
          com.google.protobuf.ByteString data)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }
      public static com.mysql.cj.x.protobuf.MysqlxDatatypes.Scalar.String parseFrom(
          com.google.protobuf.ByteString data,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }
      public static com.mysql.cj.x.protobuf.MysqlxDatatypes.Scalar.String parseFrom(byte[] data)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }
      public static com.mysql.cj.x.protobuf.MysqlxDatatypes.Scalar.String parseFrom(
          byte[] data,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }
      public static com.mysql.cj.x.protobuf.MysqlxDatatypes.Scalar.String parseFrom(java.io.InputStream input)
          throws java.io.IOException {
        return PARSER.parseFrom(input);
      }
      public static com.mysql.cj.x.protobuf.MysqlxDatatypes.Scalar.String parseFrom(
          java.io.InputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        return PARSER.parseFrom(input, extensionRegistry);
      }
      public static com.mysql.cj.x.protobuf.MysqlxDatatypes.Scalar.String parseDelimitedFrom(java.io.InputStream input)
          throws java.io.IOException {
        return PARSER.parseDelimitedFrom(input);
      }
      public static com.mysql.cj.x.protobuf.MysqlxDatatypes.Scalar.String parseDelimitedFrom(
          java.io.InputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        return PARSER.parseDelimitedFrom(input, extensionRegistry);
      }
      public static com.mysql.cj.x.protobuf.MysqlxDatatypes.Scalar.String parseFrom(
          com.google.protobuf.CodedInputStream input)
          throws java.io.IOException {
        return PARSER.parseFrom(input);
      }
      public static com.mysql.cj.x.protobuf.MysqlxDatatypes.Scalar.String parseFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        return PARSER.parseFrom(input, extensionRegistry);
      }

      public static Builder newBuilder() { return Builder.create(); }
      public Builder newBuilderForType() { return newBuilder(); }
      public static Builder newBuilder(com.mysql.cj.x.protobuf.MysqlxDatatypes.Scalar.String prototype) {
        return newBuilder().mergeFrom(prototype);
      }
      public Builder toBuilder() { return newBuilder(this); }

      @java.lang.Override
      protected Builder newBuilderForType(
          com.google.protobuf.GeneratedMessage.BuilderParent parent) {
        Builder builder = new Builder(parent);
        return builder;
      }
      /**
       * Protobuf type {@code Mysqlx.Datatypes.Scalar.String}
       *
       * <pre>
       * a string with a charset/collation
       * </pre>
       */
      public static final class Builder extends
          com.google.protobuf.GeneratedMessage.Builder<Builder> implements
          // @@protoc_insertion_point(builder_implements:Mysqlx.Datatypes.Scalar.String)
          com.mysql.cj.x.protobuf.MysqlxDatatypes.Scalar.StringOrBuilder {
        public static final com.google.protobuf.Descriptors.Descriptor
            getDescriptor() {
          return com.mysql.cj.x.protobuf.MysqlxDatatypes.internal_static_Mysqlx_Datatypes_Scalar_String_descriptor;
        }

        protected com.google.protobuf.GeneratedMessage.FieldAccessorTable
            internalGetFieldAccessorTable() {
          return com.mysql.cj.x.protobuf.MysqlxDatatypes.internal_static_Mysqlx_Datatypes_Scalar_String_fieldAccessorTable
              .ensureFieldAccessorsInitialized(
                  com.mysql.cj.x.protobuf.MysqlxDatatypes.Scalar.String.class, com.mysql.cj.x.protobuf.MysqlxDatatypes.Scalar.String.Builder.class);
        }

        // Construct using com.mysql.cj.x.protobuf.MysqlxDatatypes.Scalar.String.newBuilder()
        private Builder() {
          maybeForceBuilderInitialization();
        }

        private Builder(
            com.google.protobuf.GeneratedMessage.BuilderParent parent) {
          super(parent);
          maybeForceBuilderInitialization();
        }
        private void maybeForceBuilderInitialization() {
          if (com.google.protobuf.GeneratedMessage.alwaysUseFieldBuilders) {
          }
        }
        private static Builder create() {
          return new Builder();
        }

        public Builder clear() {
          super.clear();
          value_ = com.google.protobuf.ByteString.EMPTY;
          bitField0_ = (bitField0_ & ~0x00000001);
          collation_ = 0L;
          bitField0_ = (bitField0_ & ~0x00000002);
          return this;
        }

        public Builder clone() {
          return create().mergeFrom(buildPartial());
        }

        public com.google.protobuf.Descriptors.Descriptor
            getDescriptorForType() {
          return com.mysql.cj.x.protobuf.MysqlxDatatypes.internal_static_Mysqlx_Datatypes_Scalar_String_descriptor;
        }

        public com.mysql.cj.x.protobuf.MysqlxDatatypes.Scalar.String getDefaultInstanceForType() {
          return com.mysql.cj.x.protobuf.MysqlxDatatypes.Scalar.String.getDefaultInstance();
        }

        public com.mysql.cj.x.protobuf.MysqlxDatatypes.Scalar.String build() {
          com.mysql.cj.x.protobuf.MysqlxDatatypes.Scalar.String result = buildPartial();
          if (!result.isInitialized()) {
            throw newUninitializedMessageException(result);
          }
          return result;
        }

        public com.mysql.cj.x.protobuf.MysqlxDatatypes.Scalar.String buildPartial() {
          com.mysql.cj.x.protobuf.MysqlxDatatypes.Scalar.String result = new com.mysql.cj.x.protobuf.MysqlxDatatypes.Scalar.String(this);
          int from_bitField0_ = bitField0_;
          int to_bitField0_ = 0;
          if (((from_bitField0_ & 0x00000001) == 0x00000001)) {
            to_bitField0_ |= 0x00000001;
          }
          result.value_ = value_;
          if (((from_bitField0_ & 0x00000002) == 0x00000002)) {
            to_bitField0_ |= 0x00000002;
          }
          result.collation_ = collation_;
          result.bitField0_ = to_bitField0_;
          onBuilt();
          return result;
        }

        public Builder mergeFrom(com.google.protobuf.Message other) {
          if (other instanceof com.mysql.cj.x.protobuf.MysqlxDatatypes.Scalar.String) {
            return mergeFrom((com.mysql.cj.x.protobuf.MysqlxDatatypes.Scalar.String)other);
          } else {
            super.mergeFrom(other);
            return this;
          }
        }

        public Builder mergeFrom(com.mysql.cj.x.protobuf.MysqlxDatatypes.Scalar.String other) {
          if (other == com.mysql.cj.x.protobuf.MysqlxDatatypes.Scalar.String.getDefaultInstance()) return this;
          if (other.hasValue()) {
            setValue(other.getValue());
          }
          if (other.hasCollation()) {
            setCollation(other.getCollation());
          }
          this.mergeUnknownFields(other.getUnknownFields());
          return this;
        }

        public final boolean isInitialized() {
          if (!hasValue()) {
            
            return false;
          }
          return true;
        }

        public Builder mergeFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
          com.mysql.cj.x.protobuf.MysqlxDatatypes.Scalar.String parsedMessage = null;
          try {
            parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            parsedMessage = (com.mysql.cj.x.protobuf.MysqlxDatatypes.Scalar.String) e.getUnfinishedMessage();
            throw e;
          } finally {
            if (parsedMessage != null) {
              mergeFrom(parsedMessage);
            }
          }
          return this;
        }
        private int bitField0_;

        private com.google.protobuf.ByteString value_ = com.google.protobuf.ByteString.EMPTY;
        /**
         * <code>required bytes value = 1;</code>
         */
        public boolean hasValue() {
          return ((bitField0_ & 0x00000001) == 0x00000001);
        }
        /**
         * <code>required bytes value = 1;</code>
         */
        public com.google.protobuf.ByteString getValue() {
          return value_;
        }
        /**
         * <code>required bytes value = 1;</code>
         */
        public Builder setValue(com.google.protobuf.ByteString value) {
          if (value == null) {
    throw new NullPointerException();
  }
  bitField0_ |= 0x00000001;
          value_ = value;
          onChanged();
          return this;
        }
        /**
         * <code>required bytes value = 1;</code>
         */
        public Builder clearValue() {
          bitField0_ = (bitField0_ & ~0x00000001);
          value_ = getDefaultInstance().getValue();
          onChanged();
          return this;
        }

        private long collation_ ;
        /**
         * <code>optional uint64 collation = 2;</code>
         */
        public boolean hasCollation() {
          return ((bitField0_ & 0x00000002) == 0x00000002);
        }
        /**
         * <code>optional uint64 collation = 2;</code>
         */
        public long getCollation() {
          return collation_;
        }
        /**
         * <code>optional uint64 collation = 2;</code>
         */
        public Builder setCollation(long value) {
          bitField0_ |= 0x00000002;
          collation_ = value;
          onChanged();
          return this;
        }
        /**
         * <code>optional uint64 collation = 2;</code>
         */
        public Builder clearCollation() {
          bitField0_ = (bitField0_ & ~0x00000002);
          collation_ = 0L;
          onChanged();
          return this;
        }

        // @@protoc_insertion_point(builder_scope:Mysqlx.Datatypes.Scalar.String)
      }

      static {
        defaultInstance = new String(true);
        defaultInstance.initFields();
      }

      // @@protoc_insertion_point(class_scope:Mysqlx.Datatypes.Scalar.String)
    }

    public interface OctetsOrBuilder extends
        // @@protoc_insertion_point(interface_extends:Mysqlx.Datatypes.Scalar.Octets)
        com.google.protobuf.MessageOrBuilder {

      /**
       * <code>required bytes value = 1;</code>
       */
      boolean hasValue();
      /**
       * <code>required bytes value = 1;</code>
       */
      com.google.protobuf.ByteString getValue();

      /**
       * <code>optional uint32 content_type = 2;</code>
       */
      boolean hasContentType();
      /**
       * <code>optional uint32 content_type = 2;</code>
       */
      int getContentType();
    }
    /**
     * Protobuf type {@code Mysqlx.Datatypes.Scalar.Octets}
     *
     * <pre>
     * an opaque octet sequence, with an optional content_type
     * See ``Mysqlx.Resultset.ContentType_BYTES`` for list of known values.
     * </pre>
     */
    public static final class Octets extends
        com.google.protobuf.GeneratedMessage implements
        // @@protoc_insertion_point(message_implements:Mysqlx.Datatypes.Scalar.Octets)
        OctetsOrBuilder {
      // Use Octets.newBuilder() to construct.
      private Octets(com.google.protobuf.GeneratedMessage.Builder<?> builder) {
        super(builder);
        this.unknownFields = builder.getUnknownFields();
      }
      private Octets(boolean noInit) { this.unknownFields = com.google.protobuf.UnknownFieldSet.getDefaultInstance(); }

      private static final Octets defaultInstance;
      public static Octets getDefaultInstance() {
        return defaultInstance;
      }

      public Octets getDefaultInstanceForType() {
        return defaultInstance;
      }

      private final com.google.protobuf.UnknownFieldSet unknownFields;
      @java.lang.Override
      public final com.google.protobuf.UnknownFieldSet
          getUnknownFields() {
        return this.unknownFields;
      }
      private Octets(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        initFields();
        int mutable_bitField0_ = 0;
        com.google.protobuf.UnknownFieldSet.Builder unknownFields =
            com.google.protobuf.UnknownFieldSet.newBuilder();
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              default: {
                if (!parseUnknownField(input, unknownFields,
                                       extensionRegistry, tag)) {
                  done = true;
                }
                break;
              }
              case 10: {
                bitField0_ |= 0x00000001;
                value_ = input.readBytes();
                break;
              }
              case 16: {
                bitField0_ |= 0x00000002;
                contentType_ = input.readUInt32();
                break;
              }
            }
          }
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.setUnfinishedMessage(this);
        } catch (java.io.IOException e) {
          throw new com.google.protobuf.InvalidProtocolBufferException(
              e.getMessage()).setUnfinishedMessage(this);
        } finally {
          this.unknownFields = unknownFields.build();
          makeExtensionsImmutable();
        }
      }
      public static final com.google.protobuf.Descriptors.Descriptor
          getDescriptor() {
        return com.mysql.cj.x.protobuf.MysqlxDatatypes.internal_static_Mysqlx_Datatypes_Scalar_Octets_descriptor;
      }

      protected com.google.protobuf.GeneratedMessage.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.mysql.cj.x.protobuf.MysqlxDatatypes.internal_static_Mysqlx_Datatypes_Scalar_Octets_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.mysql.cj.x.protobuf.MysqlxDatatypes.Scalar.Octets.class, com.mysql.cj.x.protobuf.MysqlxDatatypes.Scalar.Octets.Builder.class);
      }

      public static com.google.protobuf.Parser<Octets> PARSER =
          new com.google.protobuf.AbstractParser<Octets>() {
        public Octets parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          return new Octets(input, extensionRegistry);
        }
      };

      @java.lang.Override
      public com.google.protobuf.Parser<Octets> getParserForType() {
        return PARSER;
      }

      private int bitField0_;
      public static final int VALUE_FIELD_NUMBER = 1;
      private com.google.protobuf.ByteString value_;
      /**
       * <code>required bytes value = 1;</code>
       */
      public boolean hasValue() {
        return ((bitField0_ & 0x00000001) == 0x00000001);
      }
      /**
       * <code>required bytes value = 1;</code>
       */
      public com.google.protobuf.ByteString getValue() {
        return value_;
      }

      public static final int CONTENT_TYPE_FIELD_NUMBER = 2;
      private int contentType_;
      /**
       * <code>optional uint32 content_type = 2;</code>
       */
      public boolean hasContentType() {
        return ((bitField0_ & 0x00000002) == 0x00000002);
      }
      /**
       * <code>optional uint32 content_type = 2;</code>
       */
      public int getContentType() {
        return contentType_;
      }

      private void initFields() {
        value_ = com.google.protobuf.ByteString.EMPTY;
        contentType_ = 0;
      }
      private byte memoizedIsInitialized = -1;
      public final boolean isInitialized() {
        byte isInitialized = memoizedIsInitialized;
        if (isInitialized == 1) return true;
        if (isInitialized == 0) return false;

        if (!hasValue()) {
          memoizedIsInitialized = 0;
          return false;
        }
        memoizedIsInitialized = 1;
        return true;
      }

      public void writeTo(com.google.protobuf.CodedOutputStream output)
                          throws java.io.IOException {
        getSerializedSize();
        if (((bitField0_ & 0x00000001) == 0x00000001)) {
          output.writeBytes(1, value_);
        }
        if (((bitField0_ & 0x00000002) == 0x00000002)) {
          output.writeUInt32(2, contentType_);
        }
        getUnknownFields().writeTo(output);
      }

      private int memoizedSerializedSize = -1;
      public int getSerializedSize() {
        int size = memoizedSerializedSize;
        if (size != -1) return size;

        size = 0;
        if (((bitField0_ & 0x00000001) == 0x00000001)) {
          size += com.google.protobuf.CodedOutputStream
            .computeBytesSize(1, value_);
        }
        if (((bitField0_ & 0x00000002) == 0x00000002)) {
          size += com.google.protobuf.CodedOutputStream
            .computeUInt32Size(2, contentType_);
        }
        size += getUnknownFields().getSerializedSize();
        memoizedSerializedSize = size;
        return size;
      }

      private static final long serialVersionUID = 0L;
      @java.lang.Override
      protected java.lang.Object writeReplace()
          throws java.io.ObjectStreamException {
        return super.writeReplace();
      }

      public static com.mysql.cj.x.protobuf.MysqlxDatatypes.Scalar.Octets parseFrom(
          com.google.protobuf.ByteString data)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }
      public static com.mysql.cj.x.protobuf.MysqlxDatatypes.Scalar.Octets parseFrom(
          com.google.protobuf.ByteString data,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }
      public static com.mysql.cj.x.protobuf.MysqlxDatatypes.Scalar.Octets parseFrom(byte[] data)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }
      public static com.mysql.cj.x.protobuf.MysqlxDatatypes.Scalar.Octets parseFrom(
          byte[] data,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }
      public static com.mysql.cj.x.protobuf.MysqlxDatatypes.Scalar.Octets parseFrom(java.io.InputStream input)
          throws java.io.IOException {
        return PARSER.parseFrom(input);
      }
      public static com.mysql.cj.x.protobuf.MysqlxDatatypes.Scalar.Octets parseFrom(
          java.io.InputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        return PARSER.parseFrom(input, extensionRegistry);
      }
      public static com.mysql.cj.x.protobuf.MysqlxDatatypes.Scalar.Octets parseDelimitedFrom(java.io.InputStream input)
          throws java.io.IOException {
        return PARSER.parseDelimitedFrom(input);
      }
      public static com.mysql.cj.x.protobuf.MysqlxDatatypes.Scalar.Octets parseDelimitedFrom(
          java.io.InputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        return PARSER.parseDelimitedFrom(input, extensionRegistry);
      }
      public static com.mysql.cj.x.protobuf.MysqlxDatatypes.Scalar.Octets parseFrom(
          com.google.protobuf.CodedInputStream input)
          throws java.io.IOException {
        return PARSER.parseFrom(input);
      }
      public static com.mysql.cj.x.protobuf.MysqlxDatatypes.Scalar.Octets parseFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        return PARSER.parseFrom(input, extensionRegistry);
      }

      public static Builder newBuilder() { return Builder.create(); }
      public Builder newBuilderForType() { return newBuilder(); }
      public static Builder newBuilder(com.mysql.cj.x.protobuf.MysqlxDatatypes.Scalar.Octets prototype) {
        return newBuilder().mergeFrom(prototype);
      }
      public Builder toBuilder() { return newBuilder(this); }

      @java.lang.Override
      protected Builder newBuilderForType(
          com.google.protobuf.GeneratedMessage.BuilderParent parent) {
        Builder builder = new Builder(parent);
        return builder;
      }
      /**
       * Protobuf type {@code Mysqlx.Datatypes.Scalar.Octets}
       *
       * <pre>
       * an opaque octet sequence, with an optional content_type
       * See ``Mysqlx.Resultset.ContentType_BYTES`` for list of known values.
       * </pre>
       */
      public static final class Builder extends
          com.google.protobuf.GeneratedMessage.Builder<Builder> implements
          // @@protoc_insertion_point(builder_implements:Mysqlx.Datatypes.Scalar.Octets)
          com.mysql.cj.x.protobuf.MysqlxDatatypes.Scalar.OctetsOrBuilder {
        public static final com.google.protobuf.Descriptors.Descriptor
            getDescriptor() {
          return com.mysql.cj.x.protobuf.MysqlxDatatypes.internal_static_Mysqlx_Datatypes_Scalar_Octets_descriptor;
        }

        protected com.google.protobuf.GeneratedMessage.FieldAccessorTable
            internalGetFieldAccessorTable() {
          return com.mysql.cj.x.protobuf.MysqlxDatatypes.internal_static_Mysqlx_Datatypes_Scalar_Octets_fieldAccessorTable
              .ensureFieldAccessorsInitialized(
                  com.mysql.cj.x.protobuf.MysqlxDatatypes.Scalar.Octets.class, com.mysql.cj.x.protobuf.MysqlxDatatypes.Scalar.Octets.Builder.class);
        }

        // Construct using com.mysql.cj.x.protobuf.MysqlxDatatypes.Scalar.Octets.newBuilder()
        private Builder() {
          maybeForceBuilderInitialization();
        }

        private Builder(
            com.google.protobuf.GeneratedMessage.BuilderParent parent) {
          super(parent);
          maybeForceBuilderInitialization();
        }
        private void maybeForceBuilderInitialization() {
          if (com.google.protobuf.GeneratedMessage.alwaysUseFieldBuilders) {
          }
        }
        private static Builder create() {
          return new Builder();
        }

        public Builder clear() {
          super.clear();
          value_ = com.google.protobuf.ByteString.EMPTY;
          bitField0_ = (bitField0_ & ~0x00000001);
          contentType_ = 0;
          bitField0_ = (bitField0_ & ~0x00000002);
          return this;
        }

        public Builder clone() {
          return create().mergeFrom(buildPartial());
        }

        public com.google.protobuf.Descriptors.Descriptor
            getDescriptorForType() {
          return com.mysql.cj.x.protobuf.MysqlxDatatypes.internal_static_Mysqlx_Datatypes_Scalar_Octets_descriptor;
        }

        public com.mysql.cj.x.protobuf.MysqlxDatatypes.Scalar.Octets getDefaultInstanceForType() {
          return com.mysql.cj.x.protobuf.MysqlxDatatypes.Scalar.Octets.getDefaultInstance();
        }

        public com.mysql.cj.x.protobuf.MysqlxDatatypes.Scalar.Octets build() {
          com.mysql.cj.x.protobuf.MysqlxDatatypes.Scalar.Octets result = buildPartial();
          if (!result.isInitialized()) {
            throw newUninitializedMessageException(result);
          }
          return result;
        }

        public com.mysql.cj.x.protobuf.MysqlxDatatypes.Scalar.Octets buildPartial() {
          com.mysql.cj.x.protobuf.MysqlxDatatypes.Scalar.Octets result = new com.mysql.cj.x.protobuf.MysqlxDatatypes.Scalar.Octets(this);
          int from_bitField0_ = bitField0_;
          int to_bitField0_ = 0;
          if (((from_bitField0_ & 0x00000001) == 0x00000001)) {
            to_bitField0_ |= 0x00000001;
          }
          result.value_ = value_;
          if (((from_bitField0_ & 0x00000002) == 0x00000002)) {
            to_bitField0_ |= 0x00000002;
          }
          result.contentType_ = contentType_;
          result.bitField0_ = to_bitField0_;
          onBuilt();
          return result;
        }

        public Builder mergeFrom(com.google.protobuf.Message other) {
          if (other instanceof com.mysql.cj.x.protobuf.MysqlxDatatypes.Scalar.Octets) {
            return mergeFrom((com.mysql.cj.x.protobuf.MysqlxDatatypes.Scalar.Octets)other);
          } else {
            super.mergeFrom(other);
            return this;
          }
        }

        public Builder mergeFrom(com.mysql.cj.x.protobuf.MysqlxDatatypes.Scalar.Octets other) {
          if (other == com.mysql.cj.x.protobuf.MysqlxDatatypes.Scalar.Octets.getDefaultInstance()) return this;
          if (other.hasValue()) {
            setValue(other.getValue());
          }
          if (other.hasContentType()) {
            setContentType(other.getContentType());
          }
          this.mergeUnknownFields(other.getUnknownFields());
          return this;
        }

        public final boolean isInitialized() {
          if (!hasValue()) {
            
            return false;
          }
          return true;
        }

        public Builder mergeFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
          com.mysql.cj.x.protobuf.MysqlxDatatypes.Scalar.Octets parsedMessage = null;
          try {
            parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            parsedMessage = (com.mysql.cj.x.protobuf.MysqlxDatatypes.Scalar.Octets) e.getUnfinishedMessage();
            throw e;
          } finally {
            if (parsedMessage != null) {
              mergeFrom(parsedMessage);
            }
          }
          return this;
        }
        private int bitField0_;

        private com.google.protobuf.ByteString value_ = com.google.protobuf.ByteString.EMPTY;
        /**
         * <code>required bytes value = 1;</code>
         */
        public boolean hasValue() {
          return ((bitField0_ & 0x00000001) == 0x00000001);
        }
        /**
         * <code>required bytes value = 1;</code>
         */
        public com.google.protobuf.ByteString getValue() {
          return value_;
        }
        /**
         * <code>required bytes value = 1;</code>
         */
        public Builder setValue(com.google.protobuf.ByteString value) {
          if (value == null) {
    throw new NullPointerException();
  }
  bitField0_ |= 0x00000001;
          value_ = value;
          onChanged();
          return this;
        }
        /**
         * <code>required bytes value = 1;</code>
         */
        public Builder clearValue() {
          bitField0_ = (bitField0_ & ~0x00000001);
          value_ = getDefaultInstance().getValue();
          onChanged();
          return this;
        }

        private int contentType_ ;
        /**
         * <code>optional uint32 content_type = 2;</code>
         */
        public boolean hasContentType() {
          return ((bitField0_ & 0x00000002) == 0x00000002);
        }
        /**
         * <code>optional uint32 content_type = 2;</code>
         */
        public int getContentType() {
          return contentType_;
        }
        /**
         * <code>optional uint32 content_type = 2;</code>
         */
        public Builder setContentType(int value) {
          bitField0_ |= 0x00000002;
          contentType_ = value;
          onChanged();
          return this;
        }
        /**
         * <code>optional uint32 content_type = 2;</code>
         */
        public Builder clearContentType() {
          bitField0_ = (bitField0_ & ~0x00000002);
          contentType_ = 0;
          onChanged();
          return this;
        }

        // @@protoc_insertion_point(builder_scope:Mysqlx.Datatypes.Scalar.Octets)
      }

      static {
        defaultInstance = new Octets(true);
        defaultInstance.initFields();
      }

      // @@protoc_insertion_point(class_scope:Mysqlx.Datatypes.Scalar.Octets)
    }

    private int bitField0_;
    public static final int TYPE_FIELD_NUMBER = 1;
    private com.mysql.cj.x.protobuf.MysqlxDatatypes.Scalar.Type type_;
    /**
     * <code>required .Mysqlx.Datatypes.Scalar.Type type = 1;</code>
     */
    public boolean hasType() {
      return ((bitField0_ & 0x00000001) == 0x00000001);
    }
    /**
     * <code>required .Mysqlx.Datatypes.Scalar.Type type = 1;</code>
     */
    public com.mysql.cj.x.protobuf.MysqlxDatatypes.Scalar.Type getType() {
      return type_;
    }

    public static final int V_SIGNED_INT_FIELD_NUMBER = 2;
    private long vSignedInt_;
    /**
     * <code>optional sint64 v_signed_int = 2;</code>
     */
    public boolean hasVSignedInt() {
      return ((bitField0_ & 0x00000002) == 0x00000002);
    }
    /**
     * <code>optional sint64 v_signed_int = 2;</code>
     */
    public long getVSignedInt() {
      return vSignedInt_;
    }

    public static final int V_UNSIGNED_INT_FIELD_NUMBER = 3;
    private long vUnsignedInt_;
    /**
     * <code>optional uint64 v_unsigned_int = 3;</code>
     */
    public boolean hasVUnsignedInt() {
      return ((bitField0_ & 0x00000004) == 0x00000004);
    }
    /**
     * <code>optional uint64 v_unsigned_int = 3;</code>
     */
    public long getVUnsignedInt() {
      return vUnsignedInt_;
    }

    public static final int V_OCTETS_FIELD_NUMBER = 5;
    private com.mysql.cj.x.protobuf.MysqlxDatatypes.Scalar.Octets vOctets_;
    /**
     * <code>optional .Mysqlx.Datatypes.Scalar.Octets v_octets = 5;</code>
     *
     * <pre>
     * 4 is unused, was Null which doesn't have a storage anymore
     * </pre>
     */
    public boolean hasVOctets() {
      return ((bitField0_ & 0x00000008) == 0x00000008);
    }
    /**
     * <code>optional .Mysqlx.Datatypes.Scalar.Octets v_octets = 5;</code>
     *
     * <pre>
     * 4 is unused, was Null which doesn't have a storage anymore
     * </pre>
     */
    public com.mysql.cj.x.protobuf.MysqlxDatatypes.Scalar.Octets getVOctets() {
      return vOctets_;
    }
    /**
     * <code>optional .Mysqlx.Datatypes.Scalar.Octets v_octets = 5;</code>
     *
     * <pre>
     * 4 is unused, was Null which doesn't have a storage anymore
     * </pre>
     */
    public com.mysql.cj.x.protobuf.MysqlxDatatypes.Scalar.OctetsOrBuilder getVOctetsOrBuilder() {
      return vOctets_;
    }

    public static final int V_DOUBLE_FIELD_NUMBER = 6;
    private double vDouble_;
    /**
     * <code>optional double v_double = 6;</code>
     */
    public boolean hasVDouble() {
      return ((bitField0_ & 0x00000010) == 0x00000010);
    }
    /**
     * <code>optional double v_double = 6;</code>
     */
    public double getVDouble() {
      return vDouble_;
    }

    public static final int V_FLOAT_FIELD_NUMBER = 7;
    private float vFloat_;
    /**
     * <code>optional float v_float = 7;</code>
     */
    public boolean hasVFloat() {
      return ((bitField0_ & 0x00000020) == 0x00000020);
    }
    /**
     * <code>optional float v_float = 7;</code>
     */
    public float getVFloat() {
      return vFloat_;
    }

    public static final int V_BOOL_FIELD_NUMBER = 8;
    private boolean vBool_;
    /**
     * <code>optional bool v_bool = 8;</code>
     */
    public boolean hasVBool() {
      return ((bitField0_ & 0x00000040) == 0x00000040);
    }
    /**
     * <code>optional bool v_bool = 8;</code>
     */
    public boolean getVBool() {
      return vBool_;
    }

    public static final int V_STRING_FIELD_NUMBER = 9;
    private com.mysql.cj.x.protobuf.MysqlxDatatypes.Scalar.String vString_;
    /**
     * <code>optional .Mysqlx.Datatypes.Scalar.String v_string = 9;</code>
     */
    public boolean hasVString() {
      return ((bitField0_ & 0x00000080) == 0x00000080);
    }
    /**
     * <code>optional .Mysqlx.Datatypes.Scalar.String v_string = 9;</code>
     */
    public com.mysql.cj.x.protobuf.MysqlxDatatypes.Scalar.String getVString() {
      return vString_;
    }
    /**
     * <code>optional .Mysqlx.Datatypes.Scalar.String v_string = 9;</code>
     */
    public com.mysql.cj.x.protobuf.MysqlxDatatypes.Scalar.StringOrBuilder getVStringOrBuilder() {
      return vString_;
    }

    private void initFields() {
      type_ = com.mysql.cj.x.protobuf.MysqlxDatatypes.Scalar.Type.V_SINT;
      vSignedInt_ = 0L;
      vUnsignedInt_ = 0L;
      vOctets_ = com.mysql.cj.x.protobuf.MysqlxDatatypes.Scalar.Octets.getDefaultInstance();
      vDouble_ = 0D;
      vFloat_ = 0F;
      vBool_ = false;
      vString_ = com.mysql.cj.x.protobuf.MysqlxDatatypes.Scalar.String.getDefaultInstance();
    }
    private byte memoizedIsInitialized = -1;
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      if (!hasType()) {
        memoizedIsInitialized = 0;
        return false;
      }
      if (hasVOctets()) {
        if (!getVOctets().isInitialized()) {
          memoizedIsInitialized = 0;
          return false;
        }
      }
      if (hasVString()) {
        if (!getVString().isInitialized()) {
          memoizedIsInitialized = 0;
          return false;
        }
      }
      memoizedIsInitialized = 1;
      return true;
    }

    public void writeTo(com.google.protobuf.CodedOutputStream output)
                        throws java.io.IOException {
      getSerializedSize();
      if (((bitField0_ & 0x00000001) == 0x00000001)) {
        output.writeEnum(1, type_.getNumber());
      }
      if (((bitField0_ & 0x00000002) == 0x00000002)) {
        output.writeSInt64(2, vSignedInt_);
      }
      if (((bitField0_ & 0x00000004) == 0x00000004)) {
        output.writeUInt64(3, vUnsignedInt_);
      }
      if (((bitField0_ & 0x00000008) == 0x00000008)) {
        output.writeMessage(5, vOctets_);
      }
      if (((bitField0_ & 0x00000010) == 0x00000010)) {
        output.writeDouble(6, vDouble_);
      }
      if (((bitField0_ & 0x00000020) == 0x00000020)) {
        output.writeFloat(7, vFloat_);
      }
      if (((bitField0_ & 0x00000040) == 0x00000040)) {
        output.writeBool(8, vBool_);
      }
      if (((bitField0_ & 0x00000080) == 0x00000080)) {
        output.writeMessage(9, vString_);
      }
      getUnknownFields().writeTo(output);
    }

    private int memoizedSerializedSize = -1;
    public int getSerializedSize() {
      int size = memoizedSerializedSize;
      if (size != -1) return size;

      size = 0;
      if (((bitField0_ & 0x00000001) == 0x00000001)) {
        size += com.google.protobuf.CodedOutputStream
          .computeEnumSize(1, type_.getNumber());
      }
      if (((bitField0_ & 0x00000002) == 0x00000002)) {
        size += com.google.protobuf.CodedOutputStream
          .computeSInt64Size(2, vSignedInt_);
      }
      if (((bitField0_ & 0x00000004) == 0x00000004)) {
        size += com.google.protobuf.CodedOutputStream
          .computeUInt64Size(3, vUnsignedInt_);
      }
      if (((bitField0_ & 0x00000008) == 0x00000008)) {
        size += com.google.protobuf.CodedOutputStream
          .computeMessageSize(5, vOctets_);
      }
      if (((bitField0_ & 0x00000010) == 0x00000010)) {
        size += com.google.protobuf.CodedOutputStream
          .computeDoubleSize(6, vDouble_);
      }
      if (((bitField0_ & 0x00000020) == 0x00000020)) {
        size += com.google.protobuf.CodedOutputStream
          .computeFloatSize(7, vFloat_);
      }
      if (((bitField0_ & 0x00000040) == 0x00000040)) {
        size += com.google.protobuf.CodedOutputStream
          .computeBoolSize(8, vBool_);
      }
      if (((bitField0_ & 0x00000080) == 0x00000080)) {
        size += com.google.protobuf.CodedOutputStream
          .computeMessageSize(9, vString_);
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSerializedSize = size;
      return size;
    }

    private static final long serialVersionUID = 0L;
    @java.lang.Override
    protected java.lang.Object writeReplace()
        throws java.io.ObjectStreamException {
      return super.writeReplace();
    }

    public static com.mysql.cj.x.protobuf.MysqlxDatatypes.Scalar parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static com.mysql.cj.x.protobuf.MysqlxDatatypes.Scalar parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static com.mysql.cj.x.protobuf.MysqlxDatatypes.Scalar parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static com.mysql.cj.x.protobuf.MysqlxDatatypes.Scalar parseFrom(
        byte[] data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static com.mysql.cj.x.protobuf.MysqlxDatatypes.Scalar parseFrom(java.io.InputStream input)
        throws java.io.IOException {
      return PARSER.parseFrom(input);
    }
    public static com.mysql.cj.x.protobuf.MysqlxDatatypes.Scalar parseFrom(
        java.io.InputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return PARSER.parseFrom(input, extensionRegistry);
    }
    public static com.mysql.cj.x.protobuf.MysqlxDatatypes.Scalar parseDelimitedFrom(java.io.InputStream input)
        throws java.io.IOException {
      return PARSER.parseDelimitedFrom(input);
    }
    public static com.mysql.cj.x.protobuf.MysqlxDatatypes.Scalar parseDelimitedFrom(
        java.io.InputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return PARSER.parseDelimitedFrom(input, extensionRegistry);
    }
    public static com.mysql.cj.x.protobuf.MysqlxDatatypes.Scalar parseFrom(
        com.google.protobuf.CodedInputStream input)
        throws java.io.IOException {
      return PARSER.parseFrom(input);
    }
    public static com.mysql.cj.x.protobuf.MysqlxDatatypes.Scalar parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return PARSER.parseFrom(input, extensionRegistry);
    }

    public static Builder newBuilder() { return Builder.create(); }
    public Builder newBuilderForType() { return newBuilder(); }
    public static Builder newBuilder(com.mysql.cj.x.protobuf.MysqlxDatatypes.Scalar prototype) {
      return newBuilder().mergeFrom(prototype);
    }
    public Builder toBuilder() { return newBuilder(this); }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessage.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     * Protobuf type {@code Mysqlx.Datatypes.Scalar}
     *
     * <pre>
     * a scalar
     * </pre>
     */
    public static final class Builder extends
        com.google.protobuf.GeneratedMessage.Builder<Builder> implements
        // @@protoc_insertion_point(builder_implements:Mysqlx.Datatypes.Scalar)
        com.mysql.cj.x.protobuf.MysqlxDatatypes.ScalarOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor
          getDescriptor() {
        return com.mysql.cj.x.protobuf.MysqlxDatatypes.internal_static_Mysqlx_Datatypes_Scalar_descriptor;
      }

      protected com.google.protobuf.GeneratedMessage.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.mysql.cj.x.protobuf.MysqlxDatatypes.internal_static_Mysqlx_Datatypes_Scalar_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.mysql.cj.x.protobuf.MysqlxDatatypes.Scalar.class, com.mysql.cj.x.protobuf.MysqlxDatatypes.Scalar.Builder.class);
      }

      // Construct using com.mysql.cj.x.protobuf.MysqlxDatatypes.Scalar.newBuilder()
      private Builder() {
        maybeForceBuilderInitialization();
      }

      private Builder(
          com.google.protobuf.GeneratedMessage.BuilderParent parent) {
        super(parent);
        maybeForceBuilderInitialization();
      }
      private void maybeForceBuilderInitialization() {
        if (com.google.protobuf.GeneratedMessage.alwaysUseFieldBuilders) {
          getVOctetsFieldBuilder();
          getVStringFieldBuilder();
        }
      }
      private static Builder create() {
        return new Builder();
      }

      public Builder clear() {
        super.clear();
        type_ = com.mysql.cj.x.protobuf.MysqlxDatatypes.Scalar.Type.V_SINT;
        bitField0_ = (bitField0_ & ~0x00000001);
        vSignedInt_ = 0L;
        bitField0_ = (bitField0_ & ~0x00000002);
        vUnsignedInt_ = 0L;
        bitField0_ = (bitField0_ & ~0x00000004);
        if (vOctetsBuilder_ == null) {
          vOctets_ = com.mysql.cj.x.protobuf.MysqlxDatatypes.Scalar.Octets.getDefaultInstance();
        } else {
          vOctetsBuilder_.clear();
        }
        bitField0_ = (bitField0_ & ~0x00000008);
        vDouble_ = 0D;
        bitField0_ = (bitField0_ & ~0x00000010);
        vFloat_ = 0F;
        bitField0_ = (bitField0_ & ~0x00000020);
        vBool_ = false;
        bitField0_ = (bitField0_ & ~0x00000040);
        if (vStringBuilder_ == null) {
          vString_ = com.mysql.cj.x.protobuf.MysqlxDatatypes.Scalar.String.getDefaultInstance();
        } else {
          vStringBuilder_.clear();
        }
        bitField0_ = (bitField0_ & ~0x00000080);
        return this;
      }

      public Builder clone() {
        return create().mergeFrom(buildPartial());
      }

      public com.google.protobuf.Descriptors.Descriptor
          getDescriptorForType() {
        return com.mysql.cj.x.protobuf.MysqlxDatatypes.internal_static_Mysqlx_Datatypes_Scalar_descriptor;
      }

      public com.mysql.cj.x.protobuf.MysqlxDatatypes.Scalar getDefaultInstanceForType() {
        return com.mysql.cj.x.protobuf.MysqlxDatatypes.Scalar.getDefaultInstance();
      }

      public com.mysql.cj.x.protobuf.MysqlxDatatypes.Scalar build() {
        com.mysql.cj.x.protobuf.MysqlxDatatypes.Scalar result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      public com.mysql.cj.x.protobuf.MysqlxDatatypes.Scalar buildPartial() {
        com.mysql.cj.x.protobuf.MysqlxDatatypes.Scalar result = new com.mysql.cj.x.protobuf.MysqlxDatatypes.Scalar(this);
        int from_bitField0_ = bitField0_;
        int to_bitField0_ = 0;
        if (((from_bitField0_ & 0x00000001) == 0x00000001)) {
          to_bitField0_ |= 0x00000001;
        }
        result.type_ = type_;
        if (((from_bitField0_ & 0x00000002) == 0x00000002)) {
          to_bitField0_ |= 0x00000002;
        }
        result.vSignedInt_ = vSignedInt_;
        if (((from_bitField0_ & 0x00000004) == 0x00000004)) {
          to_bitField0_ |= 0x00000004;
        }
        result.vUnsignedInt_ = vUnsignedInt_;
        if (((from_bitField0_ & 0x00000008) == 0x00000008)) {
          to_bitField0_ |= 0x00000008;
        }
        if (vOctetsBuilder_ == null) {
          result.vOctets_ = vOctets_;
        } else {
          result.vOctets_ = vOctetsBuilder_.build();
        }
        if (((from_bitField0_ & 0x00000010) == 0x00000010)) {
          to_bitField0_ |= 0x00000010;
        }
        result.vDouble_ = vDouble_;
        if (((from_bitField0_ & 0x00000020) == 0x00000020)) {
          to_bitField0_ |= 0x00000020;
        }
        result.vFloat_ = vFloat_;
        if (((from_bitField0_ & 0x00000040) == 0x00000040)) {
          to_bitField0_ |= 0x00000040;
        }
        result.vBool_ = vBool_;
        if (((from_bitField0_ & 0x00000080) == 0x00000080)) {
          to_bitField0_ |= 0x00000080;
        }
        if (vStringBuilder_ == null) {
          result.vString_ = vString_;
        } else {
          result.vString_ = vStringBuilder_.build();
        }
        result.bitField0_ = to_bitField0_;
        onBuilt();
        return result;
      }

      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.mysql.cj.x.protobuf.MysqlxDatatypes.Scalar) {
          return mergeFrom((com.mysql.cj.x.protobuf.MysqlxDatatypes.Scalar)other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(com.mysql.cj.x.protobuf.MysqlxDatatypes.Scalar other) {
        if (other == com.mysql.cj.x.protobuf.MysqlxDatatypes.Scalar.getDefaultInstance()) return this;
        if (other.hasType()) {
          setType(other.getType());
        }
        if (other.hasVSignedInt()) {
          setVSignedInt(other.getVSignedInt());
        }
        if (other.hasVUnsignedInt()) {
          setVUnsignedInt(other.getVUnsignedInt());
        }
        if (other.hasVOctets()) {
          mergeVOctets(other.getVOctets());
        }
        if (other.hasVDouble()) {
          setVDouble(other.getVDouble());
        }
        if (other.hasVFloat()) {
          setVFloat(other.getVFloat());
        }
        if (other.hasVBool()) {
          setVBool(other.getVBool());
        }
        if (other.hasVString()) {
          mergeVString(other.getVString());
        }
        this.mergeUnknownFields(other.getUnknownFields());
        return this;
      }

      public final boolean isInitialized() {
        if (!hasType()) {
          
          return false;
        }
        if (hasVOctets()) {
          if (!getVOctets().isInitialized()) {
            
            return false;
          }
        }
        if (hasVString()) {
          if (!getVString().isInitialized()) {
            
            return false;
          }
        }
        return true;
      }

      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        com.mysql.cj.x.protobuf.MysqlxDatatypes.Scalar parsedMessage = null;
        try {
          parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          parsedMessage = (com.mysql.cj.x.protobuf.MysqlxDatatypes.Scalar) e.getUnfinishedMessage();
          throw e;
        } finally {
          if (parsedMessage != null) {
            mergeFrom(parsedMessage);
          }
        }
        return this;
      }
      private int bitField0_;

      private com.mysql.cj.x.protobuf.MysqlxDatatypes.Scalar.Type type_ = com.mysql.cj.x.protobuf.MysqlxDatatypes.Scalar.Type.V_SINT;
      /**
       * <code>required .Mysqlx.Datatypes.Scalar.Type type = 1;</code>
       */
      public boolean hasType() {
        return ((bitField0_ & 0x00000001) == 0x00000001);
      }
      /**
       * <code>required .Mysqlx.Datatypes.Scalar.Type type = 1;</code>
       */
      public com.mysql.cj.x.protobuf.MysqlxDatatypes.Scalar.Type getType() {
        return type_;
      }
      /**
       * <code>required .Mysqlx.Datatypes.Scalar.Type type = 1;</code>
       */
      public Builder setType(com.mysql.cj.x.protobuf.MysqlxDatatypes.Scalar.Type value) {
        if (value == null) {
          throw new NullPointerException();
        }
        bitField0_ |= 0x00000001;
        type_ = value;
        onChanged();
        return this;
      }
      /**
       * <code>required .Mysqlx.Datatypes.Scalar.Type type = 1;</code>
       */
      public Builder clearType() {
        bitField0_ = (bitField0_ & ~0x00000001);
        type_ = com.mysql.cj.x.protobuf.MysqlxDatatypes.Scalar.Type.V_SINT;
        onChanged();
        return this;
      }

      private long vSignedInt_ ;
      /**
       * <code>optional sint64 v_signed_int = 2;</code>
       */
      public boolean hasVSignedInt() {
        return ((bitField0_ & 0x00000002) == 0x00000002);
      }
      /**
       * <code>optional sint64 v_signed_int = 2;</code>
       */
      public long getVSignedInt() {
        return vSignedInt_;
      }
      /**
       * <code>optional sint64 v_signed_int = 2;</code>
       */
      public Builder setVSignedInt(long value) {
        bitField0_ |= 0x00000002;
        vSignedInt_ = value;
        onChanged();
        return this;
      }
      /**
       * <code>optional sint64 v_signed_int = 2;</code>
       */
      public Builder clearVSignedInt() {
        bitField0_ = (bitField0_ & ~0x00000002);
        vSignedInt_ = 0L;
        onChanged();
        return this;
      }

      private long vUnsignedInt_ ;
      /**
       * <code>optional uint64 v_unsigned_int = 3;</code>
       */
      public boolean hasVUnsignedInt() {
        return ((bitField0_ & 0x00000004) == 0x00000004);
      }
      /**
       * <code>optional uint64 v_unsigned_int = 3;</code>
       */
      public long getVUnsignedInt() {
        return vUnsignedInt_;
      }
      /**
       * <code>optional uint64 v_unsigned_int = 3;</code>
       */
      public Builder setVUnsignedInt(long value) {
        bitField0_ |= 0x00000004;
        vUnsignedInt_ = value;
        onChanged();
        return this;
      }
      /**
       * <code>optional uint64 v_unsigned_int = 3;</code>
       */
      public Builder clearVUnsignedInt() {
        bitField0_ = (bitField0_ & ~0x00000004);
        vUnsignedInt_ = 0L;
        onChanged();
        return this;
      }

      private com.mysql.cj.x.protobuf.MysqlxDatatypes.Scalar.Octets vOctets_ = com.mysql.cj.x.protobuf.MysqlxDatatypes.Scalar.Octets.getDefaultInstance();
      private com.google.protobuf.SingleFieldBuilder<
          com.mysql.cj.x.protobuf.MysqlxDatatypes.Scalar.Octets, com.mysql.cj.x.protobuf.MysqlxDatatypes.Scalar.Octets.Builder, com.mysql.cj.x.protobuf.MysqlxDatatypes.Scalar.OctetsOrBuilder> vOctetsBuilder_;
      /**
       * <code>optional .Mysqlx.Datatypes.Scalar.Octets v_octets = 5;</code>
       *
       * <pre>
       * 4 is unused, was Null which doesn't have a storage anymore
       * </pre>
       */
      public boolean hasVOctets() {
        return ((bitField0_ & 0x00000008) == 0x00000008);
      }
      /**
       * <code>optional .Mysqlx.Datatypes.Scalar.Octets v_octets = 5;</code>
       *
       * <pre>
       * 4 is unused, was Null which doesn't have a storage anymore
       * </pre>
       */
      public com.mysql.cj.x.protobuf.MysqlxDatatypes.Scalar.Octets getVOctets() {
        if (vOctetsBuilder_ == null) {
          return vOctets_;
        } else {
          return vOctetsBuilder_.getMessage();
        }
      }
      /**
       * <code>optional .Mysqlx.Datatypes.Scalar.Octets v_octets = 5;</code>
       *
       * <pre>
       * 4 is unused, was Null which doesn't have a storage anymore
       * </pre>
       */
      public Builder setVOctets(com.mysql.cj.x.protobuf.MysqlxDatatypes.Scalar.Octets value) {
        if (vOctetsBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          vOctets_ = value;
          onChanged();
        } else {
          vOctetsBuilder_.setMessage(value);
        }
        bitField0_ |= 0x00000008;
        return this;
      }
      /**
       * <code>optional .Mysqlx.Datatypes.Scalar.Octets v_octets = 5;</code>
       *
       * <pre>
       * 4 is unused, was Null which doesn't have a storage anymore
       * </pre>
       */
      public Builder setVOctets(
          com.mysql.cj.x.protobuf.MysqlxDatatypes.Scalar.Octets.Builder builderForValue) {
        if (vOctetsBuilder_ == null) {
          vOctets_ = builderForValue.build();
          onChanged();
        } else {
          vOctetsBuilder_.setMessage(builderForValue.build());
        }
        bitField0_ |= 0x00000008;
        return this;
      }
      /**
       * <code>optional .Mysqlx.Datatypes.Scalar.Octets v_octets = 5;</code>
       *
       * <pre>
       * 4 is unused, was Null which doesn't have a storage anymore
       * </pre>
       */
      public Builder mergeVOctets(com.mysql.cj.x.protobuf.MysqlxDatatypes.Scalar.Octets value) {
        if (vOctetsBuilder_ == null) {
          if (((bitField0_ & 0x00000008) == 0x00000008) &&
              vOctets_ != com.mysql.cj.x.protobuf.MysqlxDatatypes.Scalar.Octets.getDefaultInstance()) {
            vOctets_ =
              com.mysql.cj.x.protobuf.MysqlxDatatypes.Scalar.Octets.newBuilder(vOctets_).mergeFrom(value).buildPartial();
          } else {
            vOctets_ = value;
          }
          onChanged();
        } else {
          vOctetsBuilder_.mergeFrom(value);
        }
        bitField0_ |= 0x00000008;
        return this;
      }
      /**
       * <code>optional .Mysqlx.Datatypes.Scalar.Octets v_octets = 5;</code>
       *
       * <pre>
       * 4 is unused, was Null which doesn't have a storage anymore
       * </pre>
       */
      public Builder clearVOctets() {
        if (vOctetsBuilder_ == null) {
          vOctets_ = com.mysql.cj.x.protobuf.MysqlxDatatypes.Scalar.Octets.getDefaultInstance();
          onChanged();
        } else {
          vOctetsBuilder_.clear();
        }
        bitField0_ = (bitField0_ & ~0x00000008);
        return this;
      }
      /**
       * <code>optional .Mysqlx.Datatypes.Scalar.Octets v_octets = 5;</code>
       *
       * <pre>
       * 4 is unused, was Null which doesn't have a storage anymore
       * </pre>
       */
      public com.mysql.cj.x.protobuf.MysqlxDatatypes.Scalar.Octets.Builder getVOctetsBuilder() {
        bitField0_ |= 0x00000008;
        onChanged();
        return getVOctetsFieldBuilder().getBuilder();
      }
      /**
       * <code>optional .Mysqlx.Datatypes.Scalar.Octets v_octets = 5;</code>
       *
       * <pre>
       * 4 is unused, was Null which doesn't have a storage anymore
       * </pre>
       */
      public com.mysql.cj.x.protobuf.MysqlxDatatypes.Scalar.OctetsOrBuilder getVOctetsOrBuilder() {
        if (vOctetsBuilder_ != null) {
          return vOctetsBuilder_.getMessageOrBuilder();
        } else {
          return vOctets_;
        }
      }
      /**
       * <code>optional .Mysqlx.Datatypes.Scalar.Octets v_octets = 5;</code>
       *
       * <pre>
       * 4 is unused, was Null which doesn't have a storage anymore
       * </pre>
       */
      private com.google.protobuf.SingleFieldBuilder<
          com.mysql.cj.x.protobuf.MysqlxDatatypes.Scalar.Octets, com.mysql.cj.x.protobuf.MysqlxDatatypes.Scalar.Octets.Builder, com.mysql.cj.x.protobuf.MysqlxDatatypes.Scalar.OctetsOrBuilder> 
          getVOctetsFieldBuilder() {
        if (vOctetsBuilder_ == null) {
          vOctetsBuilder_ = new com.google.protobuf.SingleFieldBuilder<
              com.mysql.cj.x.protobuf.MysqlxDatatypes.Scalar.Octets, com.mysql.cj.x.protobuf.MysqlxDatatypes.Scalar.Octets.Builder, com.mysql.cj.x.protobuf.MysqlxDatatypes.Scalar.OctetsOrBuilder>(
                  getVOctets(),
                  getParentForChildren(),
                  isClean());
          vOctets_ = null;
        }
        return vOctetsBuilder_;
      }

      private double vDouble_ ;
      /**
       * <code>optional double v_double = 6;</code>
       */
      public boolean hasVDouble() {
        return ((bitField0_ & 0x00000010) == 0x00000010);
      }
      /**
       * <code>optional double v_double = 6;</code>
       */
      public double getVDouble() {
        return vDouble_;
      }
      /**
       * <code>optional double v_double = 6;</code>
       */
      public Builder setVDouble(double value) {
        bitField0_ |= 0x00000010;
        vDouble_ = value;
        onChanged();
        return this;
      }
      /**
       * <code>optional double v_double = 6;</code>
       */
      public Builder clearVDouble() {
        bitField0_ = (bitField0_ & ~0x00000010);
        vDouble_ = 0D;
        onChanged();
        return this;
      }

      private float vFloat_ ;
      /**
       * <code>optional float v_float = 7;</code>
       */
      public boolean hasVFloat() {
        return ((bitField0_ & 0x00000020) == 0x00000020);
      }
      /**
       * <code>optional float v_float = 7;</code>
       */
      public float getVFloat() {
        return vFloat_;
      }
      /**
       * <code>optional float v_float = 7;</code>
       */
      public Builder setVFloat(float value) {
        bitField0_ |= 0x00000020;
        vFloat_ = value;
        onChanged();
        return this;
      }
      /**
       * <code>optional float v_float = 7;</code>
       */
      public Builder clearVFloat() {
        bitField0_ = (bitField0_ & ~0x00000020);
        vFloat_ = 0F;
        onChanged();
        return this;
      }

      private boolean vBool_ ;
      /**
       * <code>optional bool v_bool = 8;</code>
       */
      public boolean hasVBool() {
        return ((bitField0_ & 0x00000040) == 0x00000040);
      }
      /**
       * <code>optional bool v_bool = 8;</code>
       */
      public boolean getVBool() {
        return vBool_;
      }
      /**
       * <code>optional bool v_bool = 8;</code>
       */
      public Builder setVBool(boolean value) {
        bitField0_ |= 0x00000040;
        vBool_ = value;
        onChanged();
        return this;
      }
      /**
       * <code>optional bool v_bool = 8;</code>
       */
      public Builder clearVBool() {
        bitField0_ = (bitField0_ & ~0x00000040);
        vBool_ = false;
        onChanged();
        return this;
      }

      private com.mysql.cj.x.protobuf.MysqlxDatatypes.Scalar.String vString_ = com.mysql.cj.x.protobuf.MysqlxDatatypes.Scalar.String.getDefaultInstance();
      private com.google.protobuf.SingleFieldBuilder<
          com.mysql.cj.x.protobuf.MysqlxDatatypes.Scalar.String, com.mysql.cj.x.protobuf.MysqlxDatatypes.Scalar.String.Builder, com.mysql.cj.x.protobuf.MysqlxDatatypes.Scalar.StringOrBuilder> vStringBuilder_;
      /**
       * <code>optional .Mysqlx.Datatypes.Scalar.String v_string = 9;</code>
       */
      public boolean hasVString() {
        return ((bitField0_ & 0x00000080) == 0x00000080);
      }
      /**
       * <code>optional .Mysqlx.Datatypes.Scalar.String v_string = 9;</code>
       */
      public com.mysql.cj.x.protobuf.MysqlxDatatypes.Scalar.String getVString() {
        if (vStringBuilder_ == null) {
          return vString_;
        } else {
          return vStringBuilder_.getMessage();
        }
      }
      /**
       * <code>optional .Mysqlx.Datatypes.Scalar.String v_string = 9;</code>
       */
      public Builder setVString(com.mysql.cj.x.protobuf.MysqlxDatatypes.Scalar.String value) {
        if (vStringBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          vString_ = value;
          onChanged();
        } else {
          vStringBuilder_.setMessage(value);
        }
        bitField0_ |= 0x00000080;
        return this;
      }
      /**
       * <code>optional .Mysqlx.Datatypes.Scalar.String v_string = 9;</code>
       */
      public Builder setVString(
          com.mysql.cj.x.protobuf.MysqlxDatatypes.Scalar.String.Builder builderForValue) {
        if (vStringBuilder_ == null) {
          vString_ = builderForValue.build();
          onChanged();
        } else {
          vStringBuilder_.setMessage(builderForValue.build());
        }
        bitField0_ |= 0x00000080;
        return this;
      }
      /**
       * <code>optional .Mysqlx.Datatypes.Scalar.String v_string = 9;</code>
       */
      public Builder mergeVString(com.mysql.cj.x.protobuf.MysqlxDatatypes.Scalar.String value) {
        if (vStringBuilder_ == null) {
          if (((bitField0_ & 0x00000080) == 0x00000080) &&
              vString_ != com.mysql.cj.x.protobuf.MysqlxDatatypes.Scalar.String.getDefaultInstance()) {
            vString_ =
              com.mysql.cj.x.protobuf.MysqlxDatatypes.Scalar.String.newBuilder(vString_).mergeFrom(value).buildPartial();
          } else {
            vString_ = value;
          }
          onChanged();
        } else {
          vStringBuilder_.mergeFrom(value);
        }
        bitField0_ |= 0x00000080;
        return this;
      }
      /**
       * <code>optional .Mysqlx.Datatypes.Scalar.String v_string = 9;</code>
       */
      public Builder clearVString() {
        if (vStringBuilder_ == null) {
          vString_ = com.mysql.cj.x.protobuf.MysqlxDatatypes.Scalar.String.getDefaultInstance();
          onChanged();
        } else {
          vStringBuilder_.clear();
        }
        bitField0_ = (bitField0_ & ~0x00000080);
        return this;
      }
      /**
       * <code>optional .Mysqlx.Datatypes.Scalar.String v_string = 9;</code>
       */
      public com.mysql.cj.x.protobuf.MysqlxDatatypes.Scalar.String.Builder getVStringBuilder() {
        bitField0_ |= 0x00000080;
        onChanged();
        return getVStringFieldBuilder().getBuilder();
      }
      /**
       * <code>optional .Mysqlx.Datatypes.Scalar.String v_string = 9;</code>
       */
      public com.mysql.cj.x.protobuf.MysqlxDatatypes.Scalar.StringOrBuilder getVStringOrBuilder() {
        if (vStringBuilder_ != null) {
          return vStringBuilder_.getMessageOrBuilder();
        } else {
          return vString_;
        }
      }
      /**
       * <code>optional .Mysqlx.Datatypes.Scalar.String v_string = 9;</code>
       */
      private com.google.protobuf.SingleFieldBuilder<
          com.mysql.cj.x.protobuf.MysqlxDatatypes.Scalar.String, com.mysql.cj.x.protobuf.MysqlxDatatypes.Scalar.String.Builder, com.mysql.cj.x.protobuf.MysqlxDatatypes.Scalar.StringOrBuilder> 
          getVStringFieldBuilder() {
        if (vStringBuilder_ == null) {
          vStringBuilder_ = new com.google.protobuf.SingleFieldBuilder<
              com.mysql.cj.x.protobuf.MysqlxDatatypes.Scalar.String, com.mysql.cj.x.protobuf.MysqlxDatatypes.Scalar.String.Builder, com.mysql.cj.x.protobuf.MysqlxDatatypes.Scalar.StringOrBuilder>(
                  getVString(),
                  getParentForChildren(),
                  isClean());
          vString_ = null;
        }
        return vStringBuilder_;
      }

      // @@protoc_insertion_point(builder_scope:Mysqlx.Datatypes.Scalar)
    }

    static {
      defaultInstance = new Scalar(true);
      defaultInstance.initFields();
    }

    // @@protoc_insertion_point(class_scope:Mysqlx.Datatypes.Scalar)
  }

  public interface ObjectOrBuilder extends
      // @@protoc_insertion_point(interface_extends:Mysqlx.Datatypes.Object)
      com.google.protobuf.MessageOrBuilder {

    /**
     * <code>repeated .Mysqlx.Datatypes.Object.ObjectField fld = 1;</code>
     */
    java.util.List<com.mysql.cj.x.protobuf.MysqlxDatatypes.Object.ObjectField> 
        getFldList();
    /**
     * <code>repeated .Mysqlx.Datatypes.Object.ObjectField fld = 1;</code>
     */
    com.mysql.cj.x.protobuf.MysqlxDatatypes.Object.ObjectField getFld(int index);
    /**
     * <code>repeated .Mysqlx.Datatypes.Object.ObjectField fld = 1;</code>
     */
    int getFldCount();
    /**
     * <code>repeated .Mysqlx.Datatypes.Object.ObjectField fld = 1;</code>
     */
    java.util.List<? extends com.mysql.cj.x.protobuf.MysqlxDatatypes.Object.ObjectFieldOrBuilder> 
        getFldOrBuilderList();
    /**
     * <code>repeated .Mysqlx.Datatypes.Object.ObjectField fld = 1;</code>
     */
    com.mysql.cj.x.protobuf.MysqlxDatatypes.Object.ObjectFieldOrBuilder getFldOrBuilder(
        int index);
  }
  /**
   * Protobuf type {@code Mysqlx.Datatypes.Object}
   *
   * <pre>
   * a object
   * </pre>
   */
  public static final class Object extends
      com.google.protobuf.GeneratedMessage implements
      // @@protoc_insertion_point(message_implements:Mysqlx.Datatypes.Object)
      ObjectOrBuilder {
    // Use Object.newBuilder() to construct.
    private Object(com.google.protobuf.GeneratedMessage.Builder<?> builder) {
      super(builder);
      this.unknownFields = builder.getUnknownFields();
    }
    private Object(boolean noInit) { this.unknownFields = com.google.protobuf.UnknownFieldSet.getDefaultInstance(); }

    private static final Object defaultInstance;
    public static Object getDefaultInstance() {
      return defaultInstance;
    }

    public Object getDefaultInstanceForType() {
      return defaultInstance;
    }

    private final com.google.protobuf.UnknownFieldSet unknownFields;
    @java.lang.Override
    public final com.google.protobuf.UnknownFieldSet
        getUnknownFields() {
      return this.unknownFields;
    }
    private Object(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      initFields();
      int mutable_bitField0_ = 0;
      com.google.protobuf.UnknownFieldSet.Builder unknownFields =
          com.google.protobuf.UnknownFieldSet.newBuilder();
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            default: {
              if (!parseUnknownField(input, unknownFields,
                                     extensionRegistry, tag)) {
                done = true;
              }
              break;
            }
            case 10: {
              if (!((mutable_bitField0_ & 0x00000001) == 0x00000001)) {
                fld_ = new java.util.ArrayList<com.mysql.cj.x.protobuf.MysqlxDatatypes.Object.ObjectField>();
                mutable_bitField0_ |= 0x00000001;
              }
              fld_.add(input.readMessage(com.mysql.cj.x.protobuf.MysqlxDatatypes.Object.ObjectField.PARSER, extensionRegistry));
              break;
            }
          }
        }
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.setUnfinishedMessage(this);
      } catch (java.io.IOException e) {
        throw new com.google.protobuf.InvalidProtocolBufferException(
            e.getMessage()).setUnfinishedMessage(this);
      } finally {
        if (((mutable_bitField0_ & 0x00000001) == 0x00000001)) {
          fld_ = java.util.Collections.unmodifiableList(fld_);
        }
        this.unknownFields = unknownFields.build();
        makeExtensionsImmutable();
      }
    }
    public static final com.google.protobuf.Descriptors.Descriptor
        getDescriptor() {
      return com.mysql.cj.x.protobuf.MysqlxDatatypes.internal_static_Mysqlx_Datatypes_Object_descriptor;
    }

    protected com.google.protobuf.GeneratedMessage.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.mysql.cj.x.protobuf.MysqlxDatatypes.internal_static_Mysqlx_Datatypes_Object_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.mysql.cj.x.protobuf.MysqlxDatatypes.Object.class, com.mysql.cj.x.protobuf.MysqlxDatatypes.Object.Builder.class);
    }

    public static com.google.protobuf.Parser<Object> PARSER =
        new com.google.protobuf.AbstractParser<Object>() {
      public Object parsePartialFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return new Object(input, extensionRegistry);
      }
    };

    @java.lang.Override
    public com.google.protobuf.Parser<Object> getParserForType() {
      return PARSER;
    }

    public interface ObjectFieldOrBuilder extends
        // @@protoc_insertion_point(interface_extends:Mysqlx.Datatypes.Object.ObjectField)
        com.google.protobuf.MessageOrBuilder {

      /**
       * <code>required string key = 1;</code>
       */
      boolean hasKey();
      /**
       * <code>required string key = 1;</code>
       */
      java.lang.String getKey();
      /**
       * <code>required string key = 1;</code>
       */
      com.google.protobuf.ByteString
          getKeyBytes();

      /**
       * <code>required .Mysqlx.Datatypes.Any value = 2;</code>
       */
      boolean hasValue();
      /**
       * <code>required .Mysqlx.Datatypes.Any value = 2;</code>
       */
      com.mysql.cj.x.protobuf.MysqlxDatatypes.Any getValue();
      /**
       * <code>required .Mysqlx.Datatypes.Any value = 2;</code>
       */
      com.mysql.cj.x.protobuf.MysqlxDatatypes.AnyOrBuilder getValueOrBuilder();
    }
    /**
     * Protobuf type {@code Mysqlx.Datatypes.Object.ObjectField}
     */
    public static final class ObjectField extends
        com.google.protobuf.GeneratedMessage implements
        // @@protoc_insertion_point(message_implements:Mysqlx.Datatypes.Object.ObjectField)
        ObjectFieldOrBuilder {
      // Use ObjectField.newBuilder() to construct.
      private ObjectField(com.google.protobuf.GeneratedMessage.Builder<?> builder) {
        super(builder);
        this.unknownFields = builder.getUnknownFields();
      }
      private ObjectField(boolean noInit) { this.unknownFields = com.google.protobuf.UnknownFieldSet.getDefaultInstance(); }

      private static final ObjectField defaultInstance;
      public static ObjectField getDefaultInstance() {
        return defaultInstance;
      }

      public ObjectField getDefaultInstanceForType() {
        return defaultInstance;
      }

      private final com.google.protobuf.UnknownFieldSet unknownFields;
      @java.lang.Override
      public final com.google.protobuf.UnknownFieldSet
          getUnknownFields() {
        return this.unknownFields;
      }
      private ObjectField(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        initFields();
        int mutable_bitField0_ = 0;
        com.google.protobuf.UnknownFieldSet.Builder unknownFields =
            com.google.protobuf.UnknownFieldSet.newBuilder();
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              default: {
                if (!parseUnknownField(input, unknownFields,
                                       extensionRegistry, tag)) {
                  done = true;
                }
                break;
              }
              case 10: {
                com.google.protobuf.ByteString bs = input.readBytes();
                bitField0_ |= 0x00000001;
                key_ = bs;
                break;
              }
              case 18: {
                com.mysql.cj.x.protobuf.MysqlxDatatypes.Any.Builder subBuilder = null;
                if (((bitField0_ & 0x00000002) == 0x00000002)) {
                  subBuilder = value_.toBuilder();
                }
                value_ = input.readMessage(com.mysql.cj.x.protobuf.MysqlxDatatypes.Any.PARSER, extensionRegistry);
                if (subBuilder != null) {
                  subBuilder.mergeFrom(value_);
                  value_ = subBuilder.buildPartial();
                }
                bitField0_ |= 0x00000002;
                break;
              }
            }
          }
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.setUnfinishedMessage(this);
        } catch (java.io.IOException e) {
          throw new com.google.protobuf.InvalidProtocolBufferException(
              e.getMessage()).setUnfinishedMessage(this);
        } finally {
          this.unknownFields = unknownFields.build();
          makeExtensionsImmutable();
        }
      }
      public static final com.google.protobuf.Descriptors.Descriptor
          getDescriptor() {
        return com.mysql.cj.x.protobuf.MysqlxDatatypes.internal_static_Mysqlx_Datatypes_Object_ObjectField_descriptor;
      }

      protected com.google.protobuf.GeneratedMessage.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.mysql.cj.x.protobuf.MysqlxDatatypes.internal_static_Mysqlx_Datatypes_Object_ObjectField_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.mysql.cj.x.protobuf.MysqlxDatatypes.Object.ObjectField.class, com.mysql.cj.x.protobuf.MysqlxDatatypes.Object.ObjectField.Builder.class);
      }

      public static com.google.protobuf.Parser<ObjectField> PARSER =
          new com.google.protobuf.AbstractParser<ObjectField>() {
        public ObjectField parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          return new ObjectField(input, extensionRegistry);
        }
      };

      @java.lang.Override
      public com.google.protobuf.Parser<ObjectField> getParserForType() {
        return PARSER;
      }

      private int bitField0_;
      public static final int KEY_FIELD_NUMBER = 1;
      private java.lang.Object key_;
      /**
       * <code>required string key = 1;</code>
       */
      public boolean hasKey() {
        return ((bitField0_ & 0x00000001) == 0x00000001);
      }
      /**
       * <code>required string key = 1;</code>
       */
      public java.lang.String getKey() {
        java.lang.Object ref = key_;
        if (ref instanceof java.lang.String) {
          return (java.lang.String) ref;
        } else {
          com.google.protobuf.ByteString bs = 
              (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          if (bs.isValidUtf8()) {
            key_ = s;
          }
          return s;
        }
      }
      /**
       * <code>required string key = 1;</code>
       */
      public com.google.protobuf.ByteString
          getKeyBytes() {
        java.lang.Object ref = key_;
        if (ref instanceof java.lang.String) {
          com.google.protobuf.ByteString b = 
              com.google.protobuf.ByteString.copyFromUtf8(
                  (java.lang.String) ref);
          key_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }

      public static final int VALUE_FIELD_NUMBER = 2;
      private com.mysql.cj.x.protobuf.MysqlxDatatypes.Any value_;
      /**
       * <code>required .Mysqlx.Datatypes.Any value = 2;</code>
       */
      public boolean hasValue() {
        return ((bitField0_ & 0x00000002) == 0x00000002);
      }
      /**
       * <code>required .Mysqlx.Datatypes.Any value = 2;</code>
       */
      public com.mysql.cj.x.protobuf.MysqlxDatatypes.Any getValue() {
        return value_;
      }
      /**
       * <code>required .Mysqlx.Datatypes.Any value = 2;</code>
       */
      public com.mysql.cj.x.protobuf.MysqlxDatatypes.AnyOrBuilder getValueOrBuilder() {
        return value_;
      }

      private void initFields() {
        key_ = "";
        value_ = com.mysql.cj.x.protobuf.MysqlxDatatypes.Any.getDefaultInstance();
      }
      private byte memoizedIsInitialized = -1;
      public final boolean isInitialized() {
        byte isInitialized = memoizedIsInitialized;
        if (isInitialized == 1) return true;
        if (isInitialized == 0) return false;

        if (!hasKey()) {
          memoizedIsInitialized = 0;
          return false;
        }
        if (!hasValue()) {
          memoizedIsInitialized = 0;
          return false;
        }
        if (!getValue().isInitialized()) {
          memoizedIsInitialized = 0;
          return false;
        }
        memoizedIsInitialized = 1;
        return true;
      }

      public void writeTo(com.google.protobuf.CodedOutputStream output)
                          throws java.io.IOException {
        getSerializedSize();
        if (((bitField0_ & 0x00000001) == 0x00000001)) {
          output.writeBytes(1, getKeyBytes());
        }
        if (((bitField0_ & 0x00000002) == 0x00000002)) {
          output.writeMessage(2, value_);
        }
        getUnknownFields().writeTo(output);
      }

      private int memoizedSerializedSize = -1;
      public int getSerializedSize() {
        int size = memoizedSerializedSize;
        if (size != -1) return size;

        size = 0;
        if (((bitField0_ & 0x00000001) == 0x00000001)) {
          size += com.google.protobuf.CodedOutputStream
            .computeBytesSize(1, getKeyBytes());
        }
        if (((bitField0_ & 0x00000002) == 0x00000002)) {
          size += com.google.protobuf.CodedOutputStream
            .computeMessageSize(2, value_);
        }
        size += getUnknownFields().getSerializedSize();
        memoizedSerializedSize = size;
        return size;
      }

      private static final long serialVersionUID = 0L;
      @java.lang.Override
      protected java.lang.Object writeReplace()
          throws java.io.ObjectStreamException {
        return super.writeReplace();
      }

      public static com.mysql.cj.x.protobuf.MysqlxDatatypes.Object.ObjectField parseFrom(
          com.google.protobuf.ByteString data)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }
      public static com.mysql.cj.x.protobuf.MysqlxDatatypes.Object.ObjectField parseFrom(
          com.google.protobuf.ByteString data,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }
      public static com.mysql.cj.x.protobuf.MysqlxDatatypes.Object.ObjectField parseFrom(byte[] data)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }
      public static com.mysql.cj.x.protobuf.MysqlxDatatypes.Object.ObjectField parseFrom(
          byte[] data,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }
      public static com.mysql.cj.x.protobuf.MysqlxDatatypes.Object.ObjectField parseFrom(java.io.InputStream input)
          throws java.io.IOException {
        return PARSER.parseFrom(input);
      }
      public static com.mysql.cj.x.protobuf.MysqlxDatatypes.Object.ObjectField parseFrom(
          java.io.InputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        return PARSER.parseFrom(input, extensionRegistry);
      }
      public static com.mysql.cj.x.protobuf.MysqlxDatatypes.Object.ObjectField parseDelimitedFrom(java.io.InputStream input)
          throws java.io.IOException {
        return PARSER.parseDelimitedFrom(input);
      }
      public static com.mysql.cj.x.protobuf.MysqlxDatatypes.Object.ObjectField parseDelimitedFrom(
          java.io.InputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        return PARSER.parseDelimitedFrom(input, extensionRegistry);
      }
      public static com.mysql.cj.x.protobuf.MysqlxDatatypes.Object.ObjectField parseFrom(
          com.google.protobuf.CodedInputStream input)
          throws java.io.IOException {
        return PARSER.parseFrom(input);
      }
      public static com.mysql.cj.x.protobuf.MysqlxDatatypes.Object.ObjectField parseFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        return PARSER.parseFrom(input, extensionRegistry);
      }

      public static Builder newBuilder() { return Builder.create(); }
      public Builder newBuilderForType() { return newBuilder(); }
      public static Builder newBuilder(com.mysql.cj.x.protobuf.MysqlxDatatypes.Object.ObjectField prototype) {
        return newBuilder().mergeFrom(prototype);
      }
      public Builder toBuilder() { return newBuilder(this); }

      @java.lang.Override
      protected Builder newBuilderForType(
          com.google.protobuf.GeneratedMessage.BuilderParent parent) {
        Builder builder = new Builder(parent);
        return builder;
      }
      /**
       * Protobuf type {@code Mysqlx.Datatypes.Object.ObjectField}
       */
      public static final class Builder extends
          com.google.protobuf.GeneratedMessage.Builder<Builder> implements
          // @@protoc_insertion_point(builder_implements:Mysqlx.Datatypes.Object.ObjectField)
          com.mysql.cj.x.protobuf.MysqlxDatatypes.Object.ObjectFieldOrBuilder {
        public static final com.google.protobuf.Descriptors.Descriptor
            getDescriptor() {
          return com.mysql.cj.x.protobuf.MysqlxDatatypes.internal_static_Mysqlx_Datatypes_Object_ObjectField_descriptor;
        }

        protected com.google.protobuf.GeneratedMessage.FieldAccessorTable
            internalGetFieldAccessorTable() {
          return com.mysql.cj.x.protobuf.MysqlxDatatypes.internal_static_Mysqlx_Datatypes_Object_ObjectField_fieldAccessorTable
              .ensureFieldAccessorsInitialized(
                  com.mysql.cj.x.protobuf.MysqlxDatatypes.Object.ObjectField.class, com.mysql.cj.x.protobuf.MysqlxDatatypes.Object.ObjectField.Builder.class);
        }

        // Construct using com.mysql.cj.x.protobuf.MysqlxDatatypes.Object.ObjectField.newBuilder()
        private Builder() {
          maybeForceBuilderInitialization();
        }

        private Builder(
            com.google.protobuf.GeneratedMessage.BuilderParent parent) {
          super(parent);
          maybeForceBuilderInitialization();
        }
        private void maybeForceBuilderInitialization() {
          if (com.google.protobuf.GeneratedMessage.alwaysUseFieldBuilders) {
            getValueFieldBuilder();
          }
        }
        private static Builder create() {
          return new Builder();
        }

        public Builder clear() {
          super.clear();
          key_ = "";
          bitField0_ = (bitField0_ & ~0x00000001);
          if (valueBuilder_ == null) {
            value_ = com.mysql.cj.x.protobuf.MysqlxDatatypes.Any.getDefaultInstance();
          } else {
            valueBuilder_.clear();
          }
          bitField0_ = (bitField0_ & ~0x00000002);
          return this;
        }

        public Builder clone() {
          return create().mergeFrom(buildPartial());
        }

        public com.google.protobuf.Descriptors.Descriptor
            getDescriptorForType() {
          return com.mysql.cj.x.protobuf.MysqlxDatatypes.internal_static_Mysqlx_Datatypes_Object_ObjectField_descriptor;
        }

        public com.mysql.cj.x.protobuf.MysqlxDatatypes.Object.ObjectField getDefaultInstanceForType() {
          return com.mysql.cj.x.protobuf.MysqlxDatatypes.Object.ObjectField.getDefaultInstance();
        }

        public com.mysql.cj.x.protobuf.MysqlxDatatypes.Object.ObjectField build() {
          com.mysql.cj.x.protobuf.MysqlxDatatypes.Object.ObjectField result = buildPartial();
          if (!result.isInitialized()) {
            throw newUninitializedMessageException(result);
          }
          return result;
        }

        public com.mysql.cj.x.protobuf.MysqlxDatatypes.Object.ObjectField buildPartial() {
          com.mysql.cj.x.protobuf.MysqlxDatatypes.Object.ObjectField result = new com.mysql.cj.x.protobuf.MysqlxDatatypes.Object.ObjectField(this);
          int from_bitField0_ = bitField0_;
          int to_bitField0_ = 0;
          if (((from_bitField0_ & 0x00000001) == 0x00000001)) {
            to_bitField0_ |= 0x00000001;
          }
          result.key_ = key_;
          if (((from_bitField0_ & 0x00000002) == 0x00000002)) {
            to_bitField0_ |= 0x00000002;
          }
          if (valueBuilder_ == null) {
            result.value_ = value_;
          } else {
            result.value_ = valueBuilder_.build();
          }
          result.bitField0_ = to_bitField0_;
          onBuilt();
          return result;
        }

        public Builder mergeFrom(com.google.protobuf.Message other) {
          if (other instanceof com.mysql.cj.x.protobuf.MysqlxDatatypes.Object.ObjectField) {
            return mergeFrom((com.mysql.cj.x.protobuf.MysqlxDatatypes.Object.ObjectField)other);
          } else {
            super.mergeFrom(other);
            return this;
          }
        }

        public Builder mergeFrom(com.mysql.cj.x.protobuf.MysqlxDatatypes.Object.ObjectField other) {
          if (other == com.mysql.cj.x.protobuf.MysqlxDatatypes.Object.ObjectField.getDefaultInstance()) return this;
          if (other.hasKey()) {
            bitField0_ |= 0x00000001;
            key_ = other.key_;
            onChanged();
          }
          if (other.hasValue()) {
            mergeValue(other.getValue());
          }
          this.mergeUnknownFields(other.getUnknownFields());
          return this;
        }

        public final boolean isInitialized() {
          if (!hasKey()) {
            
            return false;
          }
          if (!hasValue()) {
            
            return false;
          }
          if (!getValue().isInitialized()) {
            
            return false;
          }
          return true;
        }

        public Builder mergeFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
          com.mysql.cj.x.protobuf.MysqlxDatatypes.Object.ObjectField parsedMessage = null;
          try {
            parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            parsedMessage = (com.mysql.cj.x.protobuf.MysqlxDatatypes.Object.ObjectField) e.getUnfinishedMessage();
            throw e;
          } finally {
            if (parsedMessage != null) {
              mergeFrom(parsedMessage);
            }
          }
          return this;
        }
        private int bitField0_;

        private java.lang.Object key_ = "";
        /**
         * <code>required string key = 1;</code>
         */
        public boolean hasKey() {
          return ((bitField0_ & 0x00000001) == 0x00000001);
        }
        /**
         * <code>required string key = 1;</code>
         */
        public java.lang.String getKey() {
          java.lang.Object ref = key_;
          if (!(ref instanceof java.lang.String)) {
            com.google.protobuf.ByteString bs =
                (com.google.protobuf.ByteString) ref;
            java.lang.String s = bs.toStringUtf8();
            if (bs.isValidUtf8()) {
              key_ = s;
            }
            return s;
          } else {
            return (java.lang.String) ref;
          }
        }
        /**
         * <code>required string key = 1;</code>
         */
        public com.google.protobuf.ByteString
            getKeyBytes() {
          java.lang.Object ref = key_;
          if (ref instanceof String) {
            com.google.protobuf.ByteString b = 
                com.google.protobuf.ByteString.copyFromUtf8(
                    (java.lang.String) ref);
            key_ = b;
            return b;
          } else {
            return (com.google.protobuf.ByteString) ref;
          }
        }
        /**
         * <code>required string key = 1;</code>
         */
        public Builder setKey(
            java.lang.String value) {
          if (value == null) {
    throw new NullPointerException();
  }
  bitField0_ |= 0x00000001;
          key_ = value;
          onChanged();
          return this;
        }
        /**
         * <code>required string key = 1;</code>
         */
        public Builder clearKey() {
          bitField0_ = (bitField0_ & ~0x00000001);
          key_ = getDefaultInstance().getKey();
          onChanged();
          return this;
        }
        /**
         * <code>required string key = 1;</code>
         */
        public Builder setKeyBytes(
            com.google.protobuf.ByteString value) {
          if (value == null) {
    throw new NullPointerException();
  }
  bitField0_ |= 0x00000001;
          key_ = value;
          onChanged();
          return this;
        }

        private com.mysql.cj.x.protobuf.MysqlxDatatypes.Any value_ = com.mysql.cj.x.protobuf.MysqlxDatatypes.Any.getDefaultInstance();
        private com.google.protobuf.SingleFieldBuilder<
            com.mysql.cj.x.protobuf.MysqlxDatatypes.Any, com.mysql.cj.x.protobuf.MysqlxDatatypes.Any.Builder, com.mysql.cj.x.protobuf.MysqlxDatatypes.AnyOrBuilder> valueBuilder_;
        /**
         * <code>required .Mysqlx.Datatypes.Any value = 2;</code>
         */
        public boolean hasValue() {
          return ((bitField0_ & 0x00000002) == 0x00000002);
        }
        /**
         * <code>required .Mysqlx.Datatypes.Any value = 2;</code>
         */
        public com.mysql.cj.x.protobuf.MysqlxDatatypes.Any getValue() {
          if (valueBuilder_ == null) {
            return value_;
          } else {
            return valueBuilder_.getMessage();
          }
        }
        /**
         * <code>required .Mysqlx.Datatypes.Any value = 2;</code>
         */
        public Builder setValue(com.mysql.cj.x.protobuf.MysqlxDatatypes.Any value) {
          if (valueBuilder_ == null) {
            if (value == null) {
              throw new NullPointerException();
            }
            value_ = value;
            onChanged();
          } else {
            valueBuilder_.setMessage(value);
          }
          bitField0_ |= 0x00000002;
          return this;
        }
        /**
         * <code>required .Mysqlx.Datatypes.Any value = 2;</code>
         */
        public Builder setValue(
            com.mysql.cj.x.protobuf.MysqlxDatatypes.Any.Builder builderForValue) {
          if (valueBuilder_ == null) {
            value_ = builderForValue.build();
            onChanged();
          } else {
            valueBuilder_.setMessage(builderForValue.build());
          }
          bitField0_ |= 0x00000002;
          return this;
        }
        /**
         * <code>required .Mysqlx.Datatypes.Any value = 2;</code>
         */
        public Builder mergeValue(com.mysql.cj.x.protobuf.MysqlxDatatypes.Any value) {
          if (valueBuilder_ == null) {
            if (((bitField0_ & 0x00000002) == 0x00000002) &&
                value_ != com.mysql.cj.x.protobuf.MysqlxDatatypes.Any.getDefaultInstance()) {
              value_ =
                com.mysql.cj.x.protobuf.MysqlxDatatypes.Any.newBuilder(value_).mergeFrom(value).buildPartial();
            } else {
              value_ = value;
            }
            onChanged();
          } else {
            valueBuilder_.mergeFrom(value);
          }
          bitField0_ |= 0x00000002;
          return this;
        }
        /**
         * <code>required .Mysqlx.Datatypes.Any value = 2;</code>
         */
        public Builder clearValue() {
          if (valueBuilder_ == null) {
            value_ = com.mysql.cj.x.protobuf.MysqlxDatatypes.Any.getDefaultInstance();
            onChanged();
          } else {
            valueBuilder_.clear();
          }
          bitField0_ = (bitField0_ & ~0x00000002);
          return this;
        }
        /**
         * <code>required .Mysqlx.Datatypes.Any value = 2;</code>
         */
        public com.mysql.cj.x.protobuf.MysqlxDatatypes.Any.Builder getValueBuilder() {
          bitField0_ |= 0x00000002;
          onChanged();
          return getValueFieldBuilder().getBuilder();
        }
        /**
         * <code>required .Mysqlx.Datatypes.Any value = 2;</code>
         */
        public com.mysql.cj.x.protobuf.MysqlxDatatypes.AnyOrBuilder getValueOrBuilder() {
          if (valueBuilder_ != null) {
            return valueBuilder_.getMessageOrBuilder();
          } else {
            return value_;
          }
        }
        /**
         * <code>required .Mysqlx.Datatypes.Any value = 2;</code>
         */
        private com.google.protobuf.SingleFieldBuilder<
            com.mysql.cj.x.protobuf.MysqlxDatatypes.Any, com.mysql.cj.x.protobuf.MysqlxDatatypes.Any.Builder, com.mysql.cj.x.protobuf.MysqlxDatatypes.AnyOrBuilder> 
            getValueFieldBuilder() {
          if (valueBuilder_ == null) {
            valueBuilder_ = new com.google.protobuf.SingleFieldBuilder<
                com.mysql.cj.x.protobuf.MysqlxDatatypes.Any, com.mysql.cj.x.protobuf.MysqlxDatatypes.Any.Builder, com.mysql.cj.x.protobuf.MysqlxDatatypes.AnyOrBuilder>(
                    getValue(),
                    getParentForChildren(),
                    isClean());
            value_ = null;
          }
          return valueBuilder_;
        }

        // @@protoc_insertion_point(builder_scope:Mysqlx.Datatypes.Object.ObjectField)
      }

      static {
        defaultInstance = new ObjectField(true);
        defaultInstance.initFields();
      }

      // @@protoc_insertion_point(class_scope:Mysqlx.Datatypes.Object.ObjectField)
    }

    public static final int FLD_FIELD_NUMBER = 1;
    private java.util.List<com.mysql.cj.x.protobuf.MysqlxDatatypes.Object.ObjectField> fld_;
    /**
     * <code>repeated .Mysqlx.Datatypes.Object.ObjectField fld = 1;</code>
     */
    public java.util.List<com.mysql.cj.x.protobuf.MysqlxDatatypes.Object.ObjectField> getFldList() {
      return fld_;
    }
    /**
     * <code>repeated .Mysqlx.Datatypes.Object.ObjectField fld = 1;</code>
     */
    public java.util.List<? extends com.mysql.cj.x.protobuf.MysqlxDatatypes.Object.ObjectFieldOrBuilder> 
        getFldOrBuilderList() {
      return fld_;
    }
    /**
     * <code>repeated .Mysqlx.Datatypes.Object.ObjectField fld = 1;</code>
     */
    public int getFldCount() {
      return fld_.size();
    }
    /**
     * <code>repeated .Mysqlx.Datatypes.Object.ObjectField fld = 1;</code>
     */
    public com.mysql.cj.x.protobuf.MysqlxDatatypes.Object.ObjectField getFld(int index) {
      return fld_.get(index);
    }
    /**
     * <code>repeated .Mysqlx.Datatypes.Object.ObjectField fld = 1;</code>
     */
    public com.mysql.cj.x.protobuf.MysqlxDatatypes.Object.ObjectFieldOrBuilder getFldOrBuilder(
        int index) {
      return fld_.get(index);
    }

    private void initFields() {
      fld_ = java.util.Collections.emptyList();
    }
    private byte memoizedIsInitialized = -1;
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      for (int i = 0; i < getFldCount(); i++) {
        if (!getFld(i).isInitialized()) {
          memoizedIsInitialized = 0;
          return false;
        }
      }
      memoizedIsInitialized = 1;
      return true;
    }

    public void writeTo(com.google.protobuf.CodedOutputStream output)
                        throws java.io.IOException {
      getSerializedSize();
      for (int i = 0; i < fld_.size(); i++) {
        output.writeMessage(1, fld_.get(i));
      }
      getUnknownFields().writeTo(output);
    }

    private int memoizedSerializedSize = -1;
    public int getSerializedSize() {
      int size = memoizedSerializedSize;
      if (size != -1) return size;

      size = 0;
      for (int i = 0; i < fld_.size(); i++) {
        size += com.google.protobuf.CodedOutputStream
          .computeMessageSize(1, fld_.get(i));
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSerializedSize = size;
      return size;
    }

    private static final long serialVersionUID = 0L;
    @java.lang.Override
    protected java.lang.Object writeReplace()
        throws java.io.ObjectStreamException {
      return super.writeReplace();
    }

    public static com.mysql.cj.x.protobuf.MysqlxDatatypes.Object parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static com.mysql.cj.x.protobuf.MysqlxDatatypes.Object parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static com.mysql.cj.x.protobuf.MysqlxDatatypes.Object parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static com.mysql.cj.x.protobuf.MysqlxDatatypes.Object parseFrom(
        byte[] data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static com.mysql.cj.x.protobuf.MysqlxDatatypes.Object parseFrom(java.io.InputStream input)
        throws java.io.IOException {
      return PARSER.parseFrom(input);
    }
    public static com.mysql.cj.x.protobuf.MysqlxDatatypes.Object parseFrom(
        java.io.InputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return PARSER.parseFrom(input, extensionRegistry);
    }
    public static com.mysql.cj.x.protobuf.MysqlxDatatypes.Object parseDelimitedFrom(java.io.InputStream input)
        throws java.io.IOException {
      return PARSER.parseDelimitedFrom(input);
    }
    public static com.mysql.cj.x.protobuf.MysqlxDatatypes.Object parseDelimitedFrom(
        java.io.InputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return PARSER.parseDelimitedFrom(input, extensionRegistry);
    }
    public static com.mysql.cj.x.protobuf.MysqlxDatatypes.Object parseFrom(
        com.google.protobuf.CodedInputStream input)
        throws java.io.IOException {
      return PARSER.parseFrom(input);
    }
    public static com.mysql.cj.x.protobuf.MysqlxDatatypes.Object parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return PARSER.parseFrom(input, extensionRegistry);
    }

    public static Builder newBuilder() { return Builder.create(); }
    public Builder newBuilderForType() { return newBuilder(); }
    public static Builder newBuilder(com.mysql.cj.x.protobuf.MysqlxDatatypes.Object prototype) {
      return newBuilder().mergeFrom(prototype);
    }
    public Builder toBuilder() { return newBuilder(this); }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessage.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     * Protobuf type {@code Mysqlx.Datatypes.Object}
     *
     * <pre>
     * a object
     * </pre>
     */
    public static final class Builder extends
        com.google.protobuf.GeneratedMessage.Builder<Builder> implements
        // @@protoc_insertion_point(builder_implements:Mysqlx.Datatypes.Object)
        com.mysql.cj.x.protobuf.MysqlxDatatypes.ObjectOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor
          getDescriptor() {
        return com.mysql.cj.x.protobuf.MysqlxDatatypes.internal_static_Mysqlx_Datatypes_Object_descriptor;
      }

      protected com.google.protobuf.GeneratedMessage.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.mysql.cj.x.protobuf.MysqlxDatatypes.internal_static_Mysqlx_Datatypes_Object_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.mysql.cj.x.protobuf.MysqlxDatatypes.Object.class, com.mysql.cj.x.protobuf.MysqlxDatatypes.Object.Builder.class);
      }

      // Construct using com.mysql.cj.x.protobuf.MysqlxDatatypes.Object.newBuilder()
      private Builder() {
        maybeForceBuilderInitialization();
      }

      private Builder(
          com.google.protobuf.GeneratedMessage.BuilderParent parent) {
        super(parent);
        maybeForceBuilderInitialization();
      }
      private void maybeForceBuilderInitialization() {
        if (com.google.protobuf.GeneratedMessage.alwaysUseFieldBuilders) {
          getFldFieldBuilder();
        }
      }
      private static Builder create() {
        return new Builder();
      }

      public Builder clear() {
        super.clear();
        if (fldBuilder_ == null) {
          fld_ = java.util.Collections.emptyList();
          bitField0_ = (bitField0_ & ~0x00000001);
        } else {
          fldBuilder_.clear();
        }
        return this;
      }

      public Builder clone() {
        return create().mergeFrom(buildPartial());
      }

      public com.google.protobuf.Descriptors.Descriptor
          getDescriptorForType() {
        return com.mysql.cj.x.protobuf.MysqlxDatatypes.internal_static_Mysqlx_Datatypes_Object_descriptor;
      }

      public com.mysql.cj.x.protobuf.MysqlxDatatypes.Object getDefaultInstanceForType() {
        return com.mysql.cj.x.protobuf.MysqlxDatatypes.Object.getDefaultInstance();
      }

      public com.mysql.cj.x.protobuf.MysqlxDatatypes.Object build() {
        com.mysql.cj.x.protobuf.MysqlxDatatypes.Object result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      public com.mysql.cj.x.protobuf.MysqlxDatatypes.Object buildPartial() {
        com.mysql.cj.x.protobuf.MysqlxDatatypes.Object result = new com.mysql.cj.x.protobuf.MysqlxDatatypes.Object(this);
        int from_bitField0_ = bitField0_;
        if (fldBuilder_ == null) {
          if (((bitField0_ & 0x00000001) == 0x00000001)) {
            fld_ = java.util.Collections.unmodifiableList(fld_);
            bitField0_ = (bitField0_ & ~0x00000001);
          }
          result.fld_ = fld_;
        } else {
          result.fld_ = fldBuilder_.build();
        }
        onBuilt();
        return result;
      }

      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.mysql.cj.x.protobuf.MysqlxDatatypes.Object) {
          return mergeFrom((com.mysql.cj.x.protobuf.MysqlxDatatypes.Object)other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(com.mysql.cj.x.protobuf.MysqlxDatatypes.Object other) {
        if (other == com.mysql.cj.x.protobuf.MysqlxDatatypes.Object.getDefaultInstance()) return this;
        if (fldBuilder_ == null) {
          if (!other.fld_.isEmpty()) {
            if (fld_.isEmpty()) {
              fld_ = other.fld_;
              bitField0_ = (bitField0_ & ~0x00000001);
            } else {
              ensureFldIsMutable();
              fld_.addAll(other.fld_);
            }
            onChanged();
          }
        } else {
          if (!other.fld_.isEmpty()) {
            if (fldBuilder_.isEmpty()) {
              fldBuilder_.dispose();
              fldBuilder_ = null;
              fld_ = other.fld_;
              bitField0_ = (bitField0_ & ~0x00000001);
              fldBuilder_ = 
                com.google.protobuf.GeneratedMessage.alwaysUseFieldBuilders ?
                   getFldFieldBuilder() : null;
            } else {
              fldBuilder_.addAllMessages(other.fld_);
            }
          }
        }
        this.mergeUnknownFields(other.getUnknownFields());
        return this;
      }

      public final boolean isInitialized() {
        for (int i = 0; i < getFldCount(); i++) {
          if (!getFld(i).isInitialized()) {
            
            return false;
          }
        }
        return true;
      }

      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        com.mysql.cj.x.protobuf.MysqlxDatatypes.Object parsedMessage = null;
        try {
          parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          parsedMessage = (com.mysql.cj.x.protobuf.MysqlxDatatypes.Object) e.getUnfinishedMessage();
          throw e;
        } finally {
          if (parsedMessage != null) {
            mergeFrom(parsedMessage);
          }
        }
        return this;
      }
      private int bitField0_;

      private java.util.List<com.mysql.cj.x.protobuf.MysqlxDatatypes.Object.ObjectField> fld_ =
        java.util.Collections.emptyList();
      private void ensureFldIsMutable() {
        if (!((bitField0_ & 0x00000001) == 0x00000001)) {
          fld_ = new java.util.ArrayList<com.mysql.cj.x.protobuf.MysqlxDatatypes.Object.ObjectField>(fld_);
          bitField0_ |= 0x00000001;
         }
      }

      private com.google.protobuf.RepeatedFieldBuilder<
          com.mysql.cj.x.protobuf.MysqlxDatatypes.Object.ObjectField, com.mysql.cj.x.protobuf.MysqlxDatatypes.Object.ObjectField.Builder, com.mysql.cj.x.protobuf.MysqlxDatatypes.Object.ObjectFieldOrBuilder> fldBuilder_;

      /**
       * <code>repeated .Mysqlx.Datatypes.Object.ObjectField fld = 1;</code>
       */
      public java.util.List<com.mysql.cj.x.protobuf.MysqlxDatatypes.Object.ObjectField> getFldList() {
        if (fldBuilder_ == null) {
          return java.util.Collections.unmodifiableList(fld_);
        } else {
          return fldBuilder_.getMessageList();
        }
      }
      /**
       * <code>repeated .Mysqlx.Datatypes.Object.ObjectField fld = 1;</code>
       */
      public int getFldCount() {
        if (fldBuilder_ == null) {
          return fld_.size();
        } else {
          return fldBuilder_.getCount();
        }
      }
      /**
       * <code>repeated .Mysqlx.Datatypes.Object.ObjectField fld = 1;</code>
       */
      public com.mysql.cj.x.protobuf.MysqlxDatatypes.Object.ObjectField getFld(int index) {
        if (fldBuilder_ == null) {
          return fld_.get(index);
        } else {
          return fldBuilder_.getMessage(index);
        }
      }
      /**
       * <code>repeated .Mysqlx.Datatypes.Object.ObjectField fld = 1;</code>
       */
      public Builder setFld(
          int index, com.mysql.cj.x.protobuf.MysqlxDatatypes.Object.ObjectField value) {
        if (fldBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureFldIsMutable();
          fld_.set(index, value);
          onChanged();
        } else {
          fldBuilder_.setMessage(index, value);
        }
        return this;
      }
      /**
       * <code>repeated .Mysqlx.Datatypes.Object.ObjectField fld = 1;</code>
       */
      public Builder setFld(
          int index, com.mysql.cj.x.protobuf.MysqlxDatatypes.Object.ObjectField.Builder builderForValue) {
        if (fldBuilder_ == null) {
          ensureFldIsMutable();
          fld_.set(index, builderForValue.build());
          onChanged();
        } else {
          fldBuilder_.setMessage(index, builderForValue.build());
        }
        return this;
      }
      /**
       * <code>repeated .Mysqlx.Datatypes.Object.ObjectField fld = 1;</code>
       */
      public Builder addFld(com.mysql.cj.x.protobuf.MysqlxDatatypes.Object.ObjectField value) {
        if (fldBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureFldIsMutable();
          fld_.add(value);
          onChanged();
        } else {
          fldBuilder_.addMessage(value);
        }
        return this;
      }
      /**
       * <code>repeated .Mysqlx.Datatypes.Object.ObjectField fld = 1;</code>
       */
      public Builder addFld(
          int index, com.mysql.cj.x.protobuf.MysqlxDatatypes.Object.ObjectField value) {
        if (fldBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureFldIsMutable();
          fld_.add(index, value);
          onChanged();
        } else {
          fldBuilder_.addMessage(index, value);
        }
        return this;
      }
      /**
       * <code>repeated .Mysqlx.Datatypes.Object.ObjectField fld = 1;</code>
       */
      public Builder addFld(
          com.mysql.cj.x.protobuf.MysqlxDatatypes.Object.ObjectField.Builder builderForValue) {
        if (fldBuilder_ == null) {
          ensureFldIsMutable();
          fld_.add(builderForValue.build());
          onChanged();
        } else {
          fldBuilder_.addMessage(builderForValue.build());
        }
        return this;
      }
      /**
       * <code>repeated .Mysqlx.Datatypes.Object.ObjectField fld = 1;</code>
       */
      public Builder addFld(
          int index, com.mysql.cj.x.protobuf.MysqlxDatatypes.Object.ObjectField.Builder builderForValue) {
        if (fldBuilder_ == null) {
          ensureFldIsMutable();
          fld_.add(index, builderForValue.build());
          onChanged();
        } else {
          fldBuilder_.addMessage(index, builderForValue.build());
        }
        return this;
      }
      /**
       * <code>repeated .Mysqlx.Datatypes.Object.ObjectField fld = 1;</code>
       */
      public Builder addAllFld(
          java.lang.Iterable<? extends com.mysql.cj.x.protobuf.MysqlxDatatypes.Object.ObjectField> values) {
        if (fldBuilder_ == null) {
          ensureFldIsMutable();
          com.google.protobuf.AbstractMessageLite.Builder.addAll(
              values, fld_);
          onChanged();
        } else {
          fldBuilder_.addAllMessages(values);
        }
        return this;
      }
      /**
       * <code>repeated .Mysqlx.Datatypes.Object.ObjectField fld = 1;</code>
       */
      public Builder clearFld() {
        if (fldBuilder_ == null) {
          fld_ = java.util.Collections.emptyList();
          bitField0_ = (bitField0_ & ~0x00000001);
          onChanged();
        } else {
          fldBuilder_.clear();
        }
        return this;
      }
      /**
       * <code>repeated .Mysqlx.Datatypes.Object.ObjectField fld = 1;</code>
       */
      public Builder removeFld(int index) {
        if (fldBuilder_ == null) {
          ensureFldIsMutable();
          fld_.remove(index);
          onChanged();
        } else {
          fldBuilder_.remove(index);
        }
        return this;
      }
      /**
       * <code>repeated .Mysqlx.Datatypes.Object.ObjectField fld = 1;</code>
       */
      public com.mysql.cj.x.protobuf.MysqlxDatatypes.Object.ObjectField.Builder getFldBuilder(
          int index) {
        return getFldFieldBuilder().getBuilder(index);
      }
      /**
       * <code>repeated .Mysqlx.Datatypes.Object.ObjectField fld = 1;</code>
       */
      public com.mysql.cj.x.protobuf.MysqlxDatatypes.Object.ObjectFieldOrBuilder getFldOrBuilder(
          int index) {
        if (fldBuilder_ == null) {
          return fld_.get(index);  } else {
          return fldBuilder_.getMessageOrBuilder(index);
        }
      }
      /**
       * <code>repeated .Mysqlx.Datatypes.Object.ObjectField fld = 1;</code>
       */
      public java.util.List<? extends com.mysql.cj.x.protobuf.MysqlxDatatypes.Object.ObjectFieldOrBuilder> 
           getFldOrBuilderList() {
        if (fldBuilder_ != null) {
          return fldBuilder_.getMessageOrBuilderList();
        } else {
          return java.util.Collections.unmodifiableList(fld_);
        }
      }
      /**
       * <code>repeated .Mysqlx.Datatypes.Object.ObjectField fld = 1;</code>
       */
      public com.mysql.cj.x.protobuf.MysqlxDatatypes.Object.ObjectField.Builder addFldBuilder() {
        return getFldFieldBuilder().addBuilder(
            com.mysql.cj.x.protobuf.MysqlxDatatypes.Object.ObjectField.getDefaultInstance());
      }
      /**
       * <code>repeated .Mysqlx.Datatypes.Object.ObjectField fld = 1;</code>
       */
      public com.mysql.cj.x.protobuf.MysqlxDatatypes.Object.ObjectField.Builder addFldBuilder(
          int index) {
        return getFldFieldBuilder().addBuilder(
            index, com.mysql.cj.x.protobuf.MysqlxDatatypes.Object.ObjectField.getDefaultInstance());
      }
      /**
       * <code>repeated .Mysqlx.Datatypes.Object.ObjectField fld = 1;</code>
       */
      public java.util.List<com.mysql.cj.x.protobuf.MysqlxDatatypes.Object.ObjectField.Builder> 
           getFldBuilderList() {
        return getFldFieldBuilder().getBuilderList();
      }
      private com.google.protobuf.RepeatedFieldBuilder<
          com.mysql.cj.x.protobuf.MysqlxDatatypes.Object.ObjectField, com.mysql.cj.x.protobuf.MysqlxDatatypes.Object.ObjectField.Builder, com.mysql.cj.x.protobuf.MysqlxDatatypes.Object.ObjectFieldOrBuilder> 
          getFldFieldBuilder() {
        if (fldBuilder_ == null) {
          fldBuilder_ = new com.google.protobuf.RepeatedFieldBuilder<
              com.mysql.cj.x.protobuf.MysqlxDatatypes.Object.ObjectField, com.mysql.cj.x.protobuf.MysqlxDatatypes.Object.ObjectField.Builder, com.mysql.cj.x.protobuf.MysqlxDatatypes.Object.ObjectFieldOrBuilder>(
                  fld_,
                  ((bitField0_ & 0x00000001) == 0x00000001),
                  getParentForChildren(),
                  isClean());
          fld_ = null;
        }
        return fldBuilder_;
      }

      // @@protoc_insertion_point(builder_scope:Mysqlx.Datatypes.Object)
    }

    static {
      defaultInstance = new Object(true);
      defaultInstance.initFields();
    }

    // @@protoc_insertion_point(class_scope:Mysqlx.Datatypes.Object)
  }

  public interface ArrayOrBuilder extends
      // @@protoc_insertion_point(interface_extends:Mysqlx.Datatypes.Array)
      com.google.protobuf.MessageOrBuilder {

    /**
     * <code>repeated .Mysqlx.Datatypes.Any value = 1;</code>
     */
    java.util.List<com.mysql.cj.x.protobuf.MysqlxDatatypes.Any> 
        getValueList();
    /**
     * <code>repeated .Mysqlx.Datatypes.Any value = 1;</code>
     */
    com.mysql.cj.x.protobuf.MysqlxDatatypes.Any getValue(int index);
    /**
     * <code>repeated .Mysqlx.Datatypes.Any value = 1;</code>
     */
    int getValueCount();
    /**
     * <code>repeated .Mysqlx.Datatypes.Any value = 1;</code>
     */
    java.util.List<? extends com.mysql.cj.x.protobuf.MysqlxDatatypes.AnyOrBuilder> 
        getValueOrBuilderList();
    /**
     * <code>repeated .Mysqlx.Datatypes.Any value = 1;</code>
     */
    com.mysql.cj.x.protobuf.MysqlxDatatypes.AnyOrBuilder getValueOrBuilder(
        int index);
  }
  /**
   * Protobuf type {@code Mysqlx.Datatypes.Array}
   *
   * <pre>
   * a Array
   * </pre>
   */
  public static final class Array extends
      com.google.protobuf.GeneratedMessage implements
      // @@protoc_insertion_point(message_implements:Mysqlx.Datatypes.Array)
      ArrayOrBuilder {
    // Use Array.newBuilder() to construct.
    private Array(com.google.protobuf.GeneratedMessage.Builder<?> builder) {
      super(builder);
      this.unknownFields = builder.getUnknownFields();
    }
    private Array(boolean noInit) { this.unknownFields = com.google.protobuf.UnknownFieldSet.getDefaultInstance(); }

    private static final Array defaultInstance;
    public static Array getDefaultInstance() {
      return defaultInstance;
    }

    public Array getDefaultInstanceForType() {
      return defaultInstance;
    }

    private final com.google.protobuf.UnknownFieldSet unknownFields;
    @java.lang.Override
    public final com.google.protobuf.UnknownFieldSet
        getUnknownFields() {
      return this.unknownFields;
    }
    private Array(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      initFields();
      int mutable_bitField0_ = 0;
      com.google.protobuf.UnknownFieldSet.Builder unknownFields =
          com.google.protobuf.UnknownFieldSet.newBuilder();
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            default: {
              if (!parseUnknownField(input, unknownFields,
                                     extensionRegistry, tag)) {
                done = true;
              }
              break;
            }
            case 10: {
              if (!((mutable_bitField0_ & 0x00000001) == 0x00000001)) {
                value_ = new java.util.ArrayList<com.mysql.cj.x.protobuf.MysqlxDatatypes.Any>();
                mutable_bitField0_ |= 0x00000001;
              }
              value_.add(input.readMessage(com.mysql.cj.x.protobuf.MysqlxDatatypes.Any.PARSER, extensionRegistry));
              break;
            }
          }
        }
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.setUnfinishedMessage(this);
      } catch (java.io.IOException e) {
        throw new com.google.protobuf.InvalidProtocolBufferException(
            e.getMessage()).setUnfinishedMessage(this);
      } finally {
        if (((mutable_bitField0_ & 0x00000001) == 0x00000001)) {
          value_ = java.util.Collections.unmodifiableList(value_);
        }
        this.unknownFields = unknownFields.build();
        makeExtensionsImmutable();
      }
    }
    public static final com.google.protobuf.Descriptors.Descriptor
        getDescriptor() {
      return com.mysql.cj.x.protobuf.MysqlxDatatypes.internal_static_Mysqlx_Datatypes_Array_descriptor;
    }

    protected com.google.protobuf.GeneratedMessage.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.mysql.cj.x.protobuf.MysqlxDatatypes.internal_static_Mysqlx_Datatypes_Array_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.mysql.cj.x.protobuf.MysqlxDatatypes.Array.class, com.mysql.cj.x.protobuf.MysqlxDatatypes.Array.Builder.class);
    }

    public static com.google.protobuf.Parser<Array> PARSER =
        new com.google.protobuf.AbstractParser<Array>() {
      public Array parsePartialFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return new Array(input, extensionRegistry);
      }
    };

    @java.lang.Override
    public com.google.protobuf.Parser<Array> getParserForType() {
      return PARSER;
    }

    public static final int VALUE_FIELD_NUMBER = 1;
    private java.util.List<com.mysql.cj.x.protobuf.MysqlxDatatypes.Any> value_;
    /**
     * <code>repeated .Mysqlx.Datatypes.Any value = 1;</code>
     */
    public java.util.List<com.mysql.cj.x.protobuf.MysqlxDatatypes.Any> getValueList() {
      return value_;
    }
    /**
     * <code>repeated .Mysqlx.Datatypes.Any value = 1;</code>
     */
    public java.util.List<? extends com.mysql.cj.x.protobuf.MysqlxDatatypes.AnyOrBuilder> 
        getValueOrBuilderList() {
      return value_;
    }
    /**
     * <code>repeated .Mysqlx.Datatypes.Any value = 1;</code>
     */
    public int getValueCount() {
      return value_.size();
    }
    /**
     * <code>repeated .Mysqlx.Datatypes.Any value = 1;</code>
     */
    public com.mysql.cj.x.protobuf.MysqlxDatatypes.Any getValue(int index) {
      return value_.get(index);
    }
    /**
     * <code>repeated .Mysqlx.Datatypes.Any value = 1;</code>
     */
    public com.mysql.cj.x.protobuf.MysqlxDatatypes.AnyOrBuilder getValueOrBuilder(
        int index) {
      return value_.get(index);
    }

    private void initFields() {
      value_ = java.util.Collections.emptyList();
    }
    private byte memoizedIsInitialized = -1;
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      for (int i = 0; i < getValueCount(); i++) {
        if (!getValue(i).isInitialized()) {
          memoizedIsInitialized = 0;
          return false;
        }
      }
      memoizedIsInitialized = 1;
      return true;
    }

    public void writeTo(com.google.protobuf.CodedOutputStream output)
                        throws java.io.IOException {
      getSerializedSize();
      for (int i = 0; i < value_.size(); i++) {
        output.writeMessage(1, value_.get(i));
      }
      getUnknownFields().writeTo(output);
    }

    private int memoizedSerializedSize = -1;
    public int getSerializedSize() {
      int size = memoizedSerializedSize;
      if (size != -1) return size;

      size = 0;
      for (int i = 0; i < value_.size(); i++) {
        size += com.google.protobuf.CodedOutputStream
          .computeMessageSize(1, value_.get(i));
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSerializedSize = size;
      return size;
    }

    private static final long serialVersionUID = 0L;
    @java.lang.Override
    protected java.lang.Object writeReplace()
        throws java.io.ObjectStreamException {
      return super.writeReplace();
    }

    public static com.mysql.cj.x.protobuf.MysqlxDatatypes.Array parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static com.mysql.cj.x.protobuf.MysqlxDatatypes.Array parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static com.mysql.cj.x.protobuf.MysqlxDatatypes.Array parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static com.mysql.cj.x.protobuf.MysqlxDatatypes.Array parseFrom(
        byte[] data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static com.mysql.cj.x.protobuf.MysqlxDatatypes.Array parseFrom(java.io.InputStream input)
        throws java.io.IOException {
      return PARSER.parseFrom(input);
    }
    public static com.mysql.cj.x.protobuf.MysqlxDatatypes.Array parseFrom(
        java.io.InputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return PARSER.parseFrom(input, extensionRegistry);
    }
    public static com.mysql.cj.x.protobuf.MysqlxDatatypes.Array parseDelimitedFrom(java.io.InputStream input)
        throws java.io.IOException {
      return PARSER.parseDelimitedFrom(input);
    }
    public static com.mysql.cj.x.protobuf.MysqlxDatatypes.Array parseDelimitedFrom(
        java.io.InputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return PARSER.parseDelimitedFrom(input, extensionRegistry);
    }
    public static com.mysql.cj.x.protobuf.MysqlxDatatypes.Array parseFrom(
        com.google.protobuf.CodedInputStream input)
        throws java.io.IOException {
      return PARSER.parseFrom(input);
    }
    public static com.mysql.cj.x.protobuf.MysqlxDatatypes.Array parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return PARSER.parseFrom(input, extensionRegistry);
    }

    public static Builder newBuilder() { return Builder.create(); }
    public Builder newBuilderForType() { return newBuilder(); }
    public static Builder newBuilder(com.mysql.cj.x.protobuf.MysqlxDatatypes.Array prototype) {
      return newBuilder().mergeFrom(prototype);
    }
    public Builder toBuilder() { return newBuilder(this); }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessage.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     * Protobuf type {@code Mysqlx.Datatypes.Array}
     *
     * <pre>
     * a Array
     * </pre>
     */
    public static final class Builder extends
        com.google.protobuf.GeneratedMessage.Builder<Builder> implements
        // @@protoc_insertion_point(builder_implements:Mysqlx.Datatypes.Array)
        com.mysql.cj.x.protobuf.MysqlxDatatypes.ArrayOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor
          getDescriptor() {
        return com.mysql.cj.x.protobuf.MysqlxDatatypes.internal_static_Mysqlx_Datatypes_Array_descriptor;
      }

      protected com.google.protobuf.GeneratedMessage.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.mysql.cj.x.protobuf.MysqlxDatatypes.internal_static_Mysqlx_Datatypes_Array_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.mysql.cj.x.protobuf.MysqlxDatatypes.Array.class, com.mysql.cj.x.protobuf.MysqlxDatatypes.Array.Builder.class);
      }

      // Construct using com.mysql.cj.x.protobuf.MysqlxDatatypes.Array.newBuilder()
      private Builder() {
        maybeForceBuilderInitialization();
      }

      private Builder(
          com.google.protobuf.GeneratedMessage.BuilderParent parent) {
        super(parent);
        maybeForceBuilderInitialization();
      }
      private void maybeForceBuilderInitialization() {
        if (com.google.protobuf.GeneratedMessage.alwaysUseFieldBuilders) {
          getValueFieldBuilder();
        }
      }
      private static Builder create() {
        return new Builder();
      }

      public Builder clear() {
        super.clear();
        if (valueBuilder_ == null) {
          value_ = java.util.Collections.emptyList();
          bitField0_ = (bitField0_ & ~0x00000001);
        } else {
          valueBuilder_.clear();
        }
        return this;
      }

      public Builder clone() {
        return create().mergeFrom(buildPartial());
      }

      public com.google.protobuf.Descriptors.Descriptor
          getDescriptorForType() {
        return com.mysql.cj.x.protobuf.MysqlxDatatypes.internal_static_Mysqlx_Datatypes_Array_descriptor;
      }

      public com.mysql.cj.x.protobuf.MysqlxDatatypes.Array getDefaultInstanceForType() {
        return com.mysql.cj.x.protobuf.MysqlxDatatypes.Array.getDefaultInstance();
      }

      public com.mysql.cj.x.protobuf.MysqlxDatatypes.Array build() {
        com.mysql.cj.x.protobuf.MysqlxDatatypes.Array result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      public com.mysql.cj.x.protobuf.MysqlxDatatypes.Array buildPartial() {
        com.mysql.cj.x.protobuf.MysqlxDatatypes.Array result = new com.mysql.cj.x.protobuf.MysqlxDatatypes.Array(this);
        int from_bitField0_ = bitField0_;
        if (valueBuilder_ == null) {
          if (((bitField0_ & 0x00000001) == 0x00000001)) {
            value_ = java.util.Collections.unmodifiableList(value_);
            bitField0_ = (bitField0_ & ~0x00000001);
          }
          result.value_ = value_;
        } else {
          result.value_ = valueBuilder_.build();
        }
        onBuilt();
        return result;
      }

      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.mysql.cj.x.protobuf.MysqlxDatatypes.Array) {
          return mergeFrom((com.mysql.cj.x.protobuf.MysqlxDatatypes.Array)other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(com.mysql.cj.x.protobuf.MysqlxDatatypes.Array other) {
        if (other == com.mysql.cj.x.protobuf.MysqlxDatatypes.Array.getDefaultInstance()) return this;
        if (valueBuilder_ == null) {
          if (!other.value_.isEmpty()) {
            if (value_.isEmpty()) {
              value_ = other.value_;
              bitField0_ = (bitField0_ & ~0x00000001);
            } else {
              ensureValueIsMutable();
              value_.addAll(other.value_);
            }
            onChanged();
          }
        } else {
          if (!other.value_.isEmpty()) {
            if (valueBuilder_.isEmpty()) {
              valueBuilder_.dispose();
              valueBuilder_ = null;
              value_ = other.value_;
              bitField0_ = (bitField0_ & ~0x00000001);
              valueBuilder_ = 
                com.google.protobuf.GeneratedMessage.alwaysUseFieldBuilders ?
                   getValueFieldBuilder() : null;
            } else {
              valueBuilder_.addAllMessages(other.value_);
            }
          }
        }
        this.mergeUnknownFields(other.getUnknownFields());
        return this;
      }

      public final boolean isInitialized() {
        for (int i = 0; i < getValueCount(); i++) {
          if (!getValue(i).isInitialized()) {
            
            return false;
          }
        }
        return true;
      }

      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        com.mysql.cj.x.protobuf.MysqlxDatatypes.Array parsedMessage = null;
        try {
          parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          parsedMessage = (com.mysql.cj.x.protobuf.MysqlxDatatypes.Array) e.getUnfinishedMessage();
          throw e;
        } finally {
          if (parsedMessage != null) {
            mergeFrom(parsedMessage);
          }
        }
        return this;
      }
      private int bitField0_;

      private java.util.List<com.mysql.cj.x.protobuf.MysqlxDatatypes.Any> value_ =
        java.util.Collections.emptyList();
      private void ensureValueIsMutable() {
        if (!((bitField0_ & 0x00000001) == 0x00000001)) {
          value_ = new java.util.ArrayList<com.mysql.cj.x.protobuf.MysqlxDatatypes.Any>(value_);
          bitField0_ |= 0x00000001;
         }
      }

      private com.google.protobuf.RepeatedFieldBuilder<
          com.mysql.cj.x.protobuf.MysqlxDatatypes.Any, com.mysql.cj.x.protobuf.MysqlxDatatypes.Any.Builder, com.mysql.cj.x.protobuf.MysqlxDatatypes.AnyOrBuilder> valueBuilder_;

      /**
       * <code>repeated .Mysqlx.Datatypes.Any value = 1;</code>
       */
      public java.util.List<com.mysql.cj.x.protobuf.MysqlxDatatypes.Any> getValueList() {
        if (valueBuilder_ == null) {
          return java.util.Collections.unmodifiableList(value_);
        } else {
          return valueBuilder_.getMessageList();
        }
      }
      /**
       * <code>repeated .Mysqlx.Datatypes.Any value = 1;</code>
       */
      public int getValueCount() {
        if (valueBuilder_ == null) {
          return value_.size();
        } else {
          return valueBuilder_.getCount();
        }
      }
      /**
       * <code>repeated .Mysqlx.Datatypes.Any value = 1;</code>
       */
      public com.mysql.cj.x.protobuf.MysqlxDatatypes.Any getValue(int index) {
        if (valueBuilder_ == null) {
          return value_.get(index);
        } else {
          return valueBuilder_.getMessage(index);
        }
      }
      /**
       * <code>repeated .Mysqlx.Datatypes.Any value = 1;</code>
       */
      public Builder setValue(
          int index, com.mysql.cj.x.protobuf.MysqlxDatatypes.Any value) {
        if (valueBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureValueIsMutable();
          value_.set(index, value);
          onChanged();
        } else {
          valueBuilder_.setMessage(index, value);
        }
        return this;
      }
      /**
       * <code>repeated .Mysqlx.Datatypes.Any value = 1;</code>
       */
      public Builder setValue(
          int index, com.mysql.cj.x.protobuf.MysqlxDatatypes.Any.Builder builderForValue) {
        if (valueBuilder_ == null) {
          ensureValueIsMutable();
          value_.set(index, builderForValue.build());
          onChanged();
        } else {
          valueBuilder_.setMessage(index, builderForValue.build());
        }
        return this;
      }
      /**
       * <code>repeated .Mysqlx.Datatypes.Any value = 1;</code>
       */
      public Builder addValue(com.mysql.cj.x.protobuf.MysqlxDatatypes.Any value) {
        if (valueBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureValueIsMutable();
          value_.add(value);
          onChanged();
        } else {
          valueBuilder_.addMessage(value);
        }
        return this;
      }
      /**
       * <code>repeated .Mysqlx.Datatypes.Any value = 1;</code>
       */
      public Builder addValue(
          int index, com.mysql.cj.x.protobuf.MysqlxDatatypes.Any value) {
        if (valueBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureValueIsMutable();
          value_.add(index, value);
          onChanged();
        } else {
          valueBuilder_.addMessage(index, value);
        }
        return this;
      }
      /**
       * <code>repeated .Mysqlx.Datatypes.Any value = 1;</code>
       */
      public Builder addValue(
          com.mysql.cj.x.protobuf.MysqlxDatatypes.Any.Builder builderForValue) {
        if (valueBuilder_ == null) {
          ensureValueIsMutable();
          value_.add(builderForValue.build());
          onChanged();
        } else {
          valueBuilder_.addMessage(builderForValue.build());
        }
        return this;
      }
      /**
       * <code>repeated .Mysqlx.Datatypes.Any value = 1;</code>
       */
      public Builder addValue(
          int index, com.mysql.cj.x.protobuf.MysqlxDatatypes.Any.Builder builderForValue) {
        if (valueBuilder_ == null) {
          ensureValueIsMutable();
          value_.add(index, builderForValue.build());
          onChanged();
        } else {
          valueBuilder_.addMessage(index, builderForValue.build());
        }
        return this;
      }
      /**
       * <code>repeated .Mysqlx.Datatypes.Any value = 1;</code>
       */
      public Builder addAllValue(
          java.lang.Iterable<? extends com.mysql.cj.x.protobuf.MysqlxDatatypes.Any> values) {
        if (valueBuilder_ == null) {
          ensureValueIsMutable();
          com.google.protobuf.AbstractMessageLite.Builder.addAll(
              values, value_);
          onChanged();
        } else {
          valueBuilder_.addAllMessages(values);
        }
        return this;
      }
      /**
       * <code>repeated .Mysqlx.Datatypes.Any value = 1;</code>
       */
      public Builder clearValue() {
        if (valueBuilder_ == null) {
          value_ = java.util.Collections.emptyList();
          bitField0_ = (bitField0_ & ~0x00000001);
          onChanged();
        } else {
          valueBuilder_.clear();
        }
        return this;
      }
      /**
       * <code>repeated .Mysqlx.Datatypes.Any value = 1;</code>
       */
      public Builder removeValue(int index) {
        if (valueBuilder_ == null) {
          ensureValueIsMutable();
          value_.remove(index);
          onChanged();
        } else {
          valueBuilder_.remove(index);
        }
        return this;
      }
      /**
       * <code>repeated .Mysqlx.Datatypes.Any value = 1;</code>
       */
      public com.mysql.cj.x.protobuf.MysqlxDatatypes.Any.Builder getValueBuilder(
          int index) {
        return getValueFieldBuilder().getBuilder(index);
      }
      /**
       * <code>repeated .Mysqlx.Datatypes.Any value = 1;</code>
       */
      public com.mysql.cj.x.protobuf.MysqlxDatatypes.AnyOrBuilder getValueOrBuilder(
          int index) {
        if (valueBuilder_ == null) {
          return value_.get(index);  } else {
          return valueBuilder_.getMessageOrBuilder(index);
        }
      }
      /**
       * <code>repeated .Mysqlx.Datatypes.Any value = 1;</code>
       */
      public java.util.List<? extends com.mysql.cj.x.protobuf.MysqlxDatatypes.AnyOrBuilder> 
           getValueOrBuilderList() {
        if (valueBuilder_ != null) {
          return valueBuilder_.getMessageOrBuilderList();
        } else {
          return java.util.Collections.unmodifiableList(value_);
        }
      }
      /**
       * <code>repeated .Mysqlx.Datatypes.Any value = 1;</code>
       */
      public com.mysql.cj.x.protobuf.MysqlxDatatypes.Any.Builder addValueBuilder() {
        return getValueFieldBuilder().addBuilder(
            com.mysql.cj.x.protobuf.MysqlxDatatypes.Any.getDefaultInstance());
      }
      /**
       * <code>repeated .Mysqlx.Datatypes.Any value = 1;</code>
       */
      public com.mysql.cj.x.protobuf.MysqlxDatatypes.Any.Builder addValueBuilder(
          int index) {
        return getValueFieldBuilder().addBuilder(
            index, com.mysql.cj.x.protobuf.MysqlxDatatypes.Any.getDefaultInstance());
      }
      /**
       * <code>repeated .Mysqlx.Datatypes.Any value = 1;</code>
       */
      public java.util.List<com.mysql.cj.x.protobuf.MysqlxDatatypes.Any.Builder> 
           getValueBuilderList() {
        return getValueFieldBuilder().getBuilderList();
      }
      private com.google.protobuf.RepeatedFieldBuilder<
          com.mysql.cj.x.protobuf.MysqlxDatatypes.Any, com.mysql.cj.x.protobuf.MysqlxDatatypes.Any.Builder, com.mysql.cj.x.protobuf.MysqlxDatatypes.AnyOrBuilder> 
          getValueFieldBuilder() {
        if (valueBuilder_ == null) {
          valueBuilder_ = new com.google.protobuf.RepeatedFieldBuilder<
              com.mysql.cj.x.protobuf.MysqlxDatatypes.Any, com.mysql.cj.x.protobuf.MysqlxDatatypes.Any.Builder, com.mysql.cj.x.protobuf.MysqlxDatatypes.AnyOrBuilder>(
                  value_,
                  ((bitField0_ & 0x00000001) == 0x00000001),
                  getParentForChildren(),
                  isClean());
          value_ = null;
        }
        return valueBuilder_;
      }

      // @@protoc_insertion_point(builder_scope:Mysqlx.Datatypes.Array)
    }

    static {
      defaultInstance = new Array(true);
      defaultInstance.initFields();
    }

    // @@protoc_insertion_point(class_scope:Mysqlx.Datatypes.Array)
  }

  public interface AnyOrBuilder extends
      // @@protoc_insertion_point(interface_extends:Mysqlx.Datatypes.Any)
      com.google.protobuf.MessageOrBuilder {

    /**
     * <code>required .Mysqlx.Datatypes.Any.Type type = 1;</code>
     */
    boolean hasType();
    /**
     * <code>required .Mysqlx.Datatypes.Any.Type type = 1;</code>
     */
    com.mysql.cj.x.protobuf.MysqlxDatatypes.Any.Type getType();

    /**
     * <code>optional .Mysqlx.Datatypes.Scalar scalar = 2;</code>
     */
    boolean hasScalar();
    /**
     * <code>optional .Mysqlx.Datatypes.Scalar scalar = 2;</code>
     */
    com.mysql.cj.x.protobuf.MysqlxDatatypes.Scalar getScalar();
    /**
     * <code>optional .Mysqlx.Datatypes.Scalar scalar = 2;</code>
     */
    com.mysql.cj.x.protobuf.MysqlxDatatypes.ScalarOrBuilder getScalarOrBuilder();

    /**
     * <code>optional .Mysqlx.Datatypes.Object obj = 3;</code>
     */
    boolean hasObj();
    /**
     * <code>optional .Mysqlx.Datatypes.Object obj = 3;</code>
     */
    com.mysql.cj.x.protobuf.MysqlxDatatypes.Object getObj();
    /**
     * <code>optional .Mysqlx.Datatypes.Object obj = 3;</code>
     */
    com.mysql.cj.x.protobuf.MysqlxDatatypes.ObjectOrBuilder getObjOrBuilder();

    /**
     * <code>optional .Mysqlx.Datatypes.Array array = 4;</code>
     */
    boolean hasArray();
    /**
     * <code>optional .Mysqlx.Datatypes.Array array = 4;</code>
     */
    com.mysql.cj.x.protobuf.MysqlxDatatypes.Array getArray();
    /**
     * <code>optional .Mysqlx.Datatypes.Array array = 4;</code>
     */
    com.mysql.cj.x.protobuf.MysqlxDatatypes.ArrayOrBuilder getArrayOrBuilder();
  }
  /**
   * Protobuf type {@code Mysqlx.Datatypes.Any}
   *
   * <pre>
   * a helper to allow all field types
   * </pre>
   */
  public static final class Any extends
      com.google.protobuf.GeneratedMessage implements
      // @@protoc_insertion_point(message_implements:Mysqlx.Datatypes.Any)
      AnyOrBuilder {
    // Use Any.newBuilder() to construct.
    private Any(com.google.protobuf.GeneratedMessage.Builder<?> builder) {
      super(builder);
      this.unknownFields = builder.getUnknownFields();
    }
    private Any(boolean noInit) { this.unknownFields = com.google.protobuf.UnknownFieldSet.getDefaultInstance(); }

    private static final Any defaultInstance;
    public static Any getDefaultInstance() {
      return defaultInstance;
    }

    public Any getDefaultInstanceForType() {
      return defaultInstance;
    }

    private final com.google.protobuf.UnknownFieldSet unknownFields;
    @java.lang.Override
    public final com.google.protobuf.UnknownFieldSet
        getUnknownFields() {
      return this.unknownFields;
    }
    private Any(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      initFields();
      int mutable_bitField0_ = 0;
      com.google.protobuf.UnknownFieldSet.Builder unknownFields =
          com.google.protobuf.UnknownFieldSet.newBuilder();
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            default: {
              if (!parseUnknownField(input, unknownFields,
                                     extensionRegistry, tag)) {
                done = true;
              }
              break;
            }
            case 8: {
              int rawValue = input.readEnum();
              com.mysql.cj.x.protobuf.MysqlxDatatypes.Any.Type value = com.mysql.cj.x.protobuf.MysqlxDatatypes.Any.Type.valueOf(rawValue);
              if (value == null) {
                unknownFields.mergeVarintField(1, rawValue);
              } else {
                bitField0_ |= 0x00000001;
                type_ = value;
              }
              break;
            }
            case 18: {
              com.mysql.cj.x.protobuf.MysqlxDatatypes.Scalar.Builder subBuilder = null;
              if (((bitField0_ & 0x00000002) == 0x00000002)) {
                subBuilder = scalar_.toBuilder();
              }
              scalar_ = input.readMessage(com.mysql.cj.x.protobuf.MysqlxDatatypes.Scalar.PARSER, extensionRegistry);
              if (subBuilder != null) {
                subBuilder.mergeFrom(scalar_);
                scalar_ = subBuilder.buildPartial();
              }
              bitField0_ |= 0x00000002;
              break;
            }
            case 26: {
              com.mysql.cj.x.protobuf.MysqlxDatatypes.Object.Builder subBuilder = null;
              if (((bitField0_ & 0x00000004) == 0x00000004)) {
                subBuilder = obj_.toBuilder();
              }
              obj_ = input.readMessage(com.mysql.cj.x.protobuf.MysqlxDatatypes.Object.PARSER, extensionRegistry);
              if (subBuilder != null) {
                subBuilder.mergeFrom(obj_);
                obj_ = subBuilder.buildPartial();
              }
              bitField0_ |= 0x00000004;
              break;
            }
            case 34: {
              com.mysql.cj.x.protobuf.MysqlxDatatypes.Array.Builder subBuilder = null;
              if (((bitField0_ & 0x00000008) == 0x00000008)) {
                subBuilder = array_.toBuilder();
              }
              array_ = input.readMessage(com.mysql.cj.x.protobuf.MysqlxDatatypes.Array.PARSER, extensionRegistry);
              if (subBuilder != null) {
                subBuilder.mergeFrom(array_);
                array_ = subBuilder.buildPartial();
              }
              bitField0_ |= 0x00000008;
              break;
            }
          }
        }
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.setUnfinishedMessage(this);
      } catch (java.io.IOException e) {
        throw new com.google.protobuf.InvalidProtocolBufferException(
            e.getMessage()).setUnfinishedMessage(this);
      } finally {
        this.unknownFields = unknownFields.build();
        makeExtensionsImmutable();
      }
    }
    public static final com.google.protobuf.Descriptors.Descriptor
        getDescriptor() {
      return com.mysql.cj.x.protobuf.MysqlxDatatypes.internal_static_Mysqlx_Datatypes_Any_descriptor;
    }

    protected com.google.protobuf.GeneratedMessage.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.mysql.cj.x.protobuf.MysqlxDatatypes.internal_static_Mysqlx_Datatypes_Any_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.mysql.cj.x.protobuf.MysqlxDatatypes.Any.class, com.mysql.cj.x.protobuf.MysqlxDatatypes.Any.Builder.class);
    }

    public static com.google.protobuf.Parser<Any> PARSER =
        new com.google.protobuf.AbstractParser<Any>() {
      public Any parsePartialFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return new Any(input, extensionRegistry);
      }
    };

    @java.lang.Override
    public com.google.protobuf.Parser<Any> getParserForType() {
      return PARSER;
    }

    /**
     * Protobuf enum {@code Mysqlx.Datatypes.Any.Type}
     */
    public enum Type
        implements com.google.protobuf.ProtocolMessageEnum {
      /**
       * <code>SCALAR = 1;</code>
       */
      SCALAR(0, 1),
      /**
       * <code>OBJECT = 2;</code>
       */
      OBJECT(1, 2),
      /**
       * <code>ARRAY = 3;</code>
       */
      ARRAY(2, 3),
      ;

      /**
       * <code>SCALAR = 1;</code>
       */
      public static final int SCALAR_VALUE = 1;
      /**
       * <code>OBJECT = 2;</code>
       */
      public static final int OBJECT_VALUE = 2;
      /**
       * <code>ARRAY = 3;</code>
       */
      public static final int ARRAY_VALUE = 3;


      public final int getNumber() { return value; }

      public static Type valueOf(int value) {
        switch (value) {
          case 1: return SCALAR;
          case 2: return OBJECT;
          case 3: return ARRAY;
          default: return null;
        }
      }

      public static com.google.protobuf.Internal.EnumLiteMap<Type>
          internalGetValueMap() {
        return internalValueMap;
      }
      private static com.google.protobuf.Internal.EnumLiteMap<Type>
          internalValueMap =
            new com.google.protobuf.Internal.EnumLiteMap<Type>() {
              public Type findValueByNumber(int number) {
                return Type.valueOf(number);
              }
            };

      public final com.google.protobuf.Descriptors.EnumValueDescriptor
          getValueDescriptor() {
        return getDescriptor().getValues().get(index);
      }
      public final com.google.protobuf.Descriptors.EnumDescriptor
          getDescriptorForType() {
        return getDescriptor();
      }
      public static final com.google.protobuf.Descriptors.EnumDescriptor
          getDescriptor() {
        return com.mysql.cj.x.protobuf.MysqlxDatatypes.Any.getDescriptor().getEnumTypes().get(0);
      }

      private static final Type[] VALUES = values();

      public static Type valueOf(
          com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
        if (desc.getType() != getDescriptor()) {
          throw new java.lang.IllegalArgumentException(
            "EnumValueDescriptor is not for this type.");
        }
        return VALUES[desc.getIndex()];
      }

      private final int index;
      private final int value;

      private Type(int index, int value) {
        this.index = index;
        this.value = value;
      }

      // @@protoc_insertion_point(enum_scope:Mysqlx.Datatypes.Any.Type)
    }

    private int bitField0_;
    public static final int TYPE_FIELD_NUMBER = 1;
    private com.mysql.cj.x.protobuf.MysqlxDatatypes.Any.Type type_;
    /**
     * <code>required .Mysqlx.Datatypes.Any.Type type = 1;</code>
     */
    public boolean hasType() {
      return ((bitField0_ & 0x00000001) == 0x00000001);
    }
    /**
     * <code>required .Mysqlx.Datatypes.Any.Type type = 1;</code>
     */
    public com.mysql.cj.x.protobuf.MysqlxDatatypes.Any.Type getType() {
      return type_;
    }

    public static final int SCALAR_FIELD_NUMBER = 2;
    private com.mysql.cj.x.protobuf.MysqlxDatatypes.Scalar scalar_;
    /**
     * <code>optional .Mysqlx.Datatypes.Scalar scalar = 2;</code>
     */
    public boolean hasScalar() {
      return ((bitField0_ & 0x00000002) == 0x00000002);
    }
    /**
     * <code>optional .Mysqlx.Datatypes.Scalar scalar = 2;</code>
     */
    public com.mysql.cj.x.protobuf.MysqlxDatatypes.Scalar getScalar() {
      return scalar_;
    }
    /**
     * <code>optional .Mysqlx.Datatypes.Scalar scalar = 2;</code>
     */
    public com.mysql.cj.x.protobuf.MysqlxDatatypes.ScalarOrBuilder getScalarOrBuilder() {
      return scalar_;
    }

    public static final int OBJ_FIELD_NUMBER = 3;
    private com.mysql.cj.x.protobuf.MysqlxDatatypes.Object obj_;
    /**
     * <code>optional .Mysqlx.Datatypes.Object obj = 3;</code>
     */
    public boolean hasObj() {
      return ((bitField0_ & 0x00000004) == 0x00000004);
    }
    /**
     * <code>optional .Mysqlx.Datatypes.Object obj = 3;</code>
     */
    public com.mysql.cj.x.protobuf.MysqlxDatatypes.Object getObj() {
      return obj_;
    }
    /**
     * <code>optional .Mysqlx.Datatypes.Object obj = 3;</code>
     */
    public com.mysql.cj.x.protobuf.MysqlxDatatypes.ObjectOrBuilder getObjOrBuilder() {
      return obj_;
    }

    public static final int ARRAY_FIELD_NUMBER = 4;
    private com.mysql.cj.x.protobuf.MysqlxDatatypes.Array array_;
    /**
     * <code>optional .Mysqlx.Datatypes.Array array = 4;</code>
     */
    public boolean hasArray() {
      return ((bitField0_ & 0x00000008) == 0x00000008);
    }
    /**
     * <code>optional .Mysqlx.Datatypes.Array array = 4;</code>
     */
    public com.mysql.cj.x.protobuf.MysqlxDatatypes.Array getArray() {
      return array_;
    }
    /**
     * <code>optional .Mysqlx.Datatypes.Array array = 4;</code>
     */
    public com.mysql.cj.x.protobuf.MysqlxDatatypes.ArrayOrBuilder getArrayOrBuilder() {
      return array_;
    }

    private void initFields() {
      type_ = com.mysql.cj.x.protobuf.MysqlxDatatypes.Any.Type.SCALAR;
      scalar_ = com.mysql.cj.x.protobuf.MysqlxDatatypes.Scalar.getDefaultInstance();
      obj_ = com.mysql.cj.x.protobuf.MysqlxDatatypes.Object.getDefaultInstance();
      array_ = com.mysql.cj.x.protobuf.MysqlxDatatypes.Array.getDefaultInstance();
    }
    private byte memoizedIsInitialized = -1;
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      if (!hasType()) {
        memoizedIsInitialized = 0;
        return false;
      }
      if (hasScalar()) {
        if (!getScalar().isInitialized()) {
          memoizedIsInitialized = 0;
          return false;
        }
      }
      if (hasObj()) {
        if (!getObj().isInitialized()) {
          memoizedIsInitialized = 0;
          return false;
        }
      }
      if (hasArray()) {
        if (!getArray().isInitialized()) {
          memoizedIsInitialized = 0;
          return false;
        }
      }
      memoizedIsInitialized = 1;
      return true;
    }

    public void writeTo(com.google.protobuf.CodedOutputStream output)
                        throws java.io.IOException {
      getSerializedSize();
      if (((bitField0_ & 0x00000001) == 0x00000001)) {
        output.writeEnum(1, type_.getNumber());
      }
      if (((bitField0_ & 0x00000002) == 0x00000002)) {
        output.writeMessage(2, scalar_);
      }
      if (((bitField0_ & 0x00000004) == 0x00000004)) {
        output.writeMessage(3, obj_);
      }
      if (((bitField0_ & 0x00000008) == 0x00000008)) {
        output.writeMessage(4, array_);
      }
      getUnknownFields().writeTo(output);
    }

    private int memoizedSerializedSize = -1;
    public int getSerializedSize() {
      int size = memoizedSerializedSize;
      if (size != -1) return size;

      size = 0;
      if (((bitField0_ & 0x00000001) == 0x00000001)) {
        size += com.google.protobuf.CodedOutputStream
          .computeEnumSize(1, type_.getNumber());
      }
      if (((bitField0_ & 0x00000002) == 0x00000002)) {
        size += com.google.protobuf.CodedOutputStream
          .computeMessageSize(2, scalar_);
      }
      if (((bitField0_ & 0x00000004) == 0x00000004)) {
        size += com.google.protobuf.CodedOutputStream
          .computeMessageSize(3, obj_);
      }
      if (((bitField0_ & 0x00000008) == 0x00000008)) {
        size += com.google.protobuf.CodedOutputStream
          .computeMessageSize(4, array_);
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSerializedSize = size;
      return size;
    }

    private static final long serialVersionUID = 0L;
    @java.lang.Override
    protected java.lang.Object writeReplace()
        throws java.io.ObjectStreamException {
      return super.writeReplace();
    }

    public static com.mysql.cj.x.protobuf.MysqlxDatatypes.Any parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static com.mysql.cj.x.protobuf.MysqlxDatatypes.Any parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static com.mysql.cj.x.protobuf.MysqlxDatatypes.Any parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static com.mysql.cj.x.protobuf.MysqlxDatatypes.Any parseFrom(
        byte[] data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static com.mysql.cj.x.protobuf.MysqlxDatatypes.Any parseFrom(java.io.InputStream input)
        throws java.io.IOException {
      return PARSER.parseFrom(input);
    }
    public static com.mysql.cj.x.protobuf.MysqlxDatatypes.Any parseFrom(
        java.io.InputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return PARSER.parseFrom(input, extensionRegistry);
    }
    public static com.mysql.cj.x.protobuf.MysqlxDatatypes.Any parseDelimitedFrom(java.io.InputStream input)
        throws java.io.IOException {
      return PARSER.parseDelimitedFrom(input);
    }
    public static com.mysql.cj.x.protobuf.MysqlxDatatypes.Any parseDelimitedFrom(
        java.io.InputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return PARSER.parseDelimitedFrom(input, extensionRegistry);
    }
    public static com.mysql.cj.x.protobuf.MysqlxDatatypes.Any parseFrom(
        com.google.protobuf.CodedInputStream input)
        throws java.io.IOException {
      return PARSER.parseFrom(input);
    }
    public static com.mysql.cj.x.protobuf.MysqlxDatatypes.Any parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return PARSER.parseFrom(input, extensionRegistry);
    }

    public static Builder newBuilder() { return Builder.create(); }
    public Builder newBuilderForType() { return newBuilder(); }
    public static Builder newBuilder(com.mysql.cj.x.protobuf.MysqlxDatatypes.Any prototype) {
      return newBuilder().mergeFrom(prototype);
    }
    public Builder toBuilder() { return newBuilder(this); }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessage.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     * Protobuf type {@code Mysqlx.Datatypes.Any}
     *
     * <pre>
     * a helper to allow all field types
     * </pre>
     */
    public static final class Builder extends
        com.google.protobuf.GeneratedMessage.Builder<Builder> implements
        // @@protoc_insertion_point(builder_implements:Mysqlx.Datatypes.Any)
        com.mysql.cj.x.protobuf.MysqlxDatatypes.AnyOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor
          getDescriptor() {
        return com.mysql.cj.x.protobuf.MysqlxDatatypes.internal_static_Mysqlx_Datatypes_Any_descriptor;
      }

      protected com.google.protobuf.GeneratedMessage.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.mysql.cj.x.protobuf.MysqlxDatatypes.internal_static_Mysqlx_Datatypes_Any_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.mysql.cj.x.protobuf.MysqlxDatatypes.Any.class, com.mysql.cj.x.protobuf.MysqlxDatatypes.Any.Builder.class);
      }

      // Construct using com.mysql.cj.x.protobuf.MysqlxDatatypes.Any.newBuilder()
      private Builder() {
        maybeForceBuilderInitialization();
      }

      private Builder(
          com.google.protobuf.GeneratedMessage.BuilderParent parent) {
        super(parent);
        maybeForceBuilderInitialization();
      }
      private void maybeForceBuilderInitialization() {
        if (com.google.protobuf.GeneratedMessage.alwaysUseFieldBuilders) {
          getScalarFieldBuilder();
          getObjFieldBuilder();
          getArrayFieldBuilder();
        }
      }
      private static Builder create() {
        return new Builder();
      }

      public Builder clear() {
        super.clear();
        type_ = com.mysql.cj.x.protobuf.MysqlxDatatypes.Any.Type.SCALAR;
        bitField0_ = (bitField0_ & ~0x00000001);
        if (scalarBuilder_ == null) {
          scalar_ = com.mysql.cj.x.protobuf.MysqlxDatatypes.Scalar.getDefaultInstance();
        } else {
          scalarBuilder_.clear();
        }
        bitField0_ = (bitField0_ & ~0x00000002);
        if (objBuilder_ == null) {
          obj_ = com.mysql.cj.x.protobuf.MysqlxDatatypes.Object.getDefaultInstance();
        } else {
          objBuilder_.clear();
        }
        bitField0_ = (bitField0_ & ~0x00000004);
        if (arrayBuilder_ == null) {
          array_ = com.mysql.cj.x.protobuf.MysqlxDatatypes.Array.getDefaultInstance();
        } else {
          arrayBuilder_.clear();
        }
        bitField0_ = (bitField0_ & ~0x00000008);
        return this;
      }

      public Builder clone() {
        return create().mergeFrom(buildPartial());
      }

      public com.google.protobuf.Descriptors.Descriptor
          getDescriptorForType() {
        return com.mysql.cj.x.protobuf.MysqlxDatatypes.internal_static_Mysqlx_Datatypes_Any_descriptor;
      }

      public com.mysql.cj.x.protobuf.MysqlxDatatypes.Any getDefaultInstanceForType() {
        return com.mysql.cj.x.protobuf.MysqlxDatatypes.Any.getDefaultInstance();
      }

      public com.mysql.cj.x.protobuf.MysqlxDatatypes.Any build() {
        com.mysql.cj.x.protobuf.MysqlxDatatypes.Any result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      public com.mysql.cj.x.protobuf.MysqlxDatatypes.Any buildPartial() {
        com.mysql.cj.x.protobuf.MysqlxDatatypes.Any result = new com.mysql.cj.x.protobuf.MysqlxDatatypes.Any(this);
        int from_bitField0_ = bitField0_;
        int to_bitField0_ = 0;
        if (((from_bitField0_ & 0x00000001) == 0x00000001)) {
          to_bitField0_ |= 0x00000001;
        }
        result.type_ = type_;
        if (((from_bitField0_ & 0x00000002) == 0x00000002)) {
          to_bitField0_ |= 0x00000002;
        }
        if (scalarBuilder_ == null) {
          result.scalar_ = scalar_;
        } else {
          result.scalar_ = scalarBuilder_.build();
        }
        if (((from_bitField0_ & 0x00000004) == 0x00000004)) {
          to_bitField0_ |= 0x00000004;
        }
        if (objBuilder_ == null) {
          result.obj_ = obj_;
        } else {
          result.obj_ = objBuilder_.build();
        }
        if (((from_bitField0_ & 0x00000008) == 0x00000008)) {
          to_bitField0_ |= 0x00000008;
        }
        if (arrayBuilder_ == null) {
          result.array_ = array_;
        } else {
          result.array_ = arrayBuilder_.build();
        }
        result.bitField0_ = to_bitField0_;
        onBuilt();
        return result;
      }

      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.mysql.cj.x.protobuf.MysqlxDatatypes.Any) {
          return mergeFrom((com.mysql.cj.x.protobuf.MysqlxDatatypes.Any)other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(com.mysql.cj.x.protobuf.MysqlxDatatypes.Any other) {
        if (other == com.mysql.cj.x.protobuf.MysqlxDatatypes.Any.getDefaultInstance()) return this;
        if (other.hasType()) {
          setType(other.getType());
        }
        if (other.hasScalar()) {
          mergeScalar(other.getScalar());
        }
        if (other.hasObj()) {
          mergeObj(other.getObj());
        }
        if (other.hasArray()) {
          mergeArray(other.getArray());
        }
        this.mergeUnknownFields(other.getUnknownFields());
        return this;
      }

      public final boolean isInitialized() {
        if (!hasType()) {
          
          return false;
        }
        if (hasScalar()) {
          if (!getScalar().isInitialized()) {
            
            return false;
          }
        }
        if (hasObj()) {
          if (!getObj().isInitialized()) {
            
            return false;
          }
        }
        if (hasArray()) {
          if (!getArray().isInitialized()) {
            
            return false;
          }
        }
        return true;
      }

      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        com.mysql.cj.x.protobuf.MysqlxDatatypes.Any parsedMessage = null;
        try {
          parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          parsedMessage = (com.mysql.cj.x.protobuf.MysqlxDatatypes.Any) e.getUnfinishedMessage();
          throw e;
        } finally {
          if (parsedMessage != null) {
            mergeFrom(parsedMessage);
          }
        }
        return this;
      }
      private int bitField0_;

      private com.mysql.cj.x.protobuf.MysqlxDatatypes.Any.Type type_ = com.mysql.cj.x.protobuf.MysqlxDatatypes.Any.Type.SCALAR;
      /**
       * <code>required .Mysqlx.Datatypes.Any.Type type = 1;</code>
       */
      public boolean hasType() {
        return ((bitField0_ & 0x00000001) == 0x00000001);
      }
      /**
       * <code>required .Mysqlx.Datatypes.Any.Type type = 1;</code>
       */
      public com.mysql.cj.x.protobuf.MysqlxDatatypes.Any.Type getType() {
        return type_;
      }
      /**
       * <code>required .Mysqlx.Datatypes.Any.Type type = 1;</code>
       */
      public Builder setType(com.mysql.cj.x.protobuf.MysqlxDatatypes.Any.Type value) {
        if (value == null) {
          throw new NullPointerException();
        }
        bitField0_ |= 0x00000001;
        type_ = value;
        onChanged();
        return this;
      }
      /**
       * <code>required .Mysqlx.Datatypes.Any.Type type = 1;</code>
       */
      public Builder clearType() {
        bitField0_ = (bitField0_ & ~0x00000001);
        type_ = com.mysql.cj.x.protobuf.MysqlxDatatypes.Any.Type.SCALAR;
        onChanged();
        return this;
      }

      private com.mysql.cj.x.protobuf.MysqlxDatatypes.Scalar scalar_ = com.mysql.cj.x.protobuf.MysqlxDatatypes.Scalar.getDefaultInstance();
      private com.google.protobuf.SingleFieldBuilder<
          com.mysql.cj.x.protobuf.MysqlxDatatypes.Scalar, com.mysql.cj.x.protobuf.MysqlxDatatypes.Scalar.Builder, com.mysql.cj.x.protobuf.MysqlxDatatypes.ScalarOrBuilder> scalarBuilder_;
      /**
       * <code>optional .Mysqlx.Datatypes.Scalar scalar = 2;</code>
       */
      public boolean hasScalar() {
        return ((bitField0_ & 0x00000002) == 0x00000002);
      }
      /**
       * <code>optional .Mysqlx.Datatypes.Scalar scalar = 2;</code>
       */
      public com.mysql.cj.x.protobuf.MysqlxDatatypes.Scalar getScalar() {
        if (scalarBuilder_ == null) {
          return scalar_;
        } else {
          return scalarBuilder_.getMessage();
        }
      }
      /**
       * <code>optional .Mysqlx.Datatypes.Scalar scalar = 2;</code>
       */
      public Builder setScalar(com.mysql.cj.x.protobuf.MysqlxDatatypes.Scalar value) {
        if (scalarBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          scalar_ = value;
          onChanged();
        } else {
          scalarBuilder_.setMessage(value);
        }
        bitField0_ |= 0x00000002;
        return this;
      }
      /**
       * <code>optional .Mysqlx.Datatypes.Scalar scalar = 2;</code>
       */
      public Builder setScalar(
          com.mysql.cj.x.protobuf.MysqlxDatatypes.Scalar.Builder builderForValue) {
        if (scalarBuilder_ == null) {
          scalar_ = builderForValue.build();
          onChanged();
        } else {
          scalarBuilder_.setMessage(builderForValue.build());
        }
        bitField0_ |= 0x00000002;
        return this;
      }
      /**
       * <code>optional .Mysqlx.Datatypes.Scalar scalar = 2;</code>
       */
      public Builder mergeScalar(com.mysql.cj.x.protobuf.MysqlxDatatypes.Scalar value) {
        if (scalarBuilder_ == null) {
          if (((bitField0_ & 0x00000002) == 0x00000002) &&
              scalar_ != com.mysql.cj.x.protobuf.MysqlxDatatypes.Scalar.getDefaultInstance()) {
            scalar_ =
              com.mysql.cj.x.protobuf.MysqlxDatatypes.Scalar.newBuilder(scalar_).mergeFrom(value).buildPartial();
          } else {
            scalar_ = value;
          }
          onChanged();
        } else {
          scalarBuilder_.mergeFrom(value);
        }
        bitField0_ |= 0x00000002;
        return this;
      }
      /**
       * <code>optional .Mysqlx.Datatypes.Scalar scalar = 2;</code>
       */
      public Builder clearScalar() {
        if (scalarBuilder_ == null) {
          scalar_ = com.mysql.cj.x.protobuf.MysqlxDatatypes.Scalar.getDefaultInstance();
          onChanged();
        } else {
          scalarBuilder_.clear();
        }
        bitField0_ = (bitField0_ & ~0x00000002);
        return this;
      }
      /**
       * <code>optional .Mysqlx.Datatypes.Scalar scalar = 2;</code>
       */
      public com.mysql.cj.x.protobuf.MysqlxDatatypes.Scalar.Builder getScalarBuilder() {
        bitField0_ |= 0x00000002;
        onChanged();
        return getScalarFieldBuilder().getBuilder();
      }
      /**
       * <code>optional .Mysqlx.Datatypes.Scalar scalar = 2;</code>
       */
      public com.mysql.cj.x.protobuf.MysqlxDatatypes.ScalarOrBuilder getScalarOrBuilder() {
        if (scalarBuilder_ != null) {
          return scalarBuilder_.getMessageOrBuilder();
        } else {
          return scalar_;
        }
      }
      /**
       * <code>optional .Mysqlx.Datatypes.Scalar scalar = 2;</code>
       */
      private com.google.protobuf.SingleFieldBuilder<
          com.mysql.cj.x.protobuf.MysqlxDatatypes.Scalar, com.mysql.cj.x.protobuf.MysqlxDatatypes.Scalar.Builder, com.mysql.cj.x.protobuf.MysqlxDatatypes.ScalarOrBuilder> 
          getScalarFieldBuilder() {
        if (scalarBuilder_ == null) {
          scalarBuilder_ = new com.google.protobuf.SingleFieldBuilder<
              com.mysql.cj.x.protobuf.MysqlxDatatypes.Scalar, com.mysql.cj.x.protobuf.MysqlxDatatypes.Scalar.Builder, com.mysql.cj.x.protobuf.MysqlxDatatypes.ScalarOrBuilder>(
                  getScalar(),
                  getParentForChildren(),
                  isClean());
          scalar_ = null;
        }
        return scalarBuilder_;
      }

      private com.mysql.cj.x.protobuf.MysqlxDatatypes.Object obj_ = com.mysql.cj.x.protobuf.MysqlxDatatypes.Object.getDefaultInstance();
      private com.google.protobuf.SingleFieldBuilder<
          com.mysql.cj.x.protobuf.MysqlxDatatypes.Object, com.mysql.cj.x.protobuf.MysqlxDatatypes.Object.Builder, com.mysql.cj.x.protobuf.MysqlxDatatypes.ObjectOrBuilder> objBuilder_;
      /**
       * <code>optional .Mysqlx.Datatypes.Object obj = 3;</code>
       */
      public boolean hasObj() {
        return ((bitField0_ & 0x00000004) == 0x00000004);
      }
      /**
       * <code>optional .Mysqlx.Datatypes.Object obj = 3;</code>
       */
      public com.mysql.cj.x.protobuf.MysqlxDatatypes.Object getObj() {
        if (objBuilder_ == null) {
          return obj_;
        } else {
          return objBuilder_.getMessage();
        }
      }
      /**
       * <code>optional .Mysqlx.Datatypes.Object obj = 3;</code>
       */
      public Builder setObj(com.mysql.cj.x.protobuf.MysqlxDatatypes.Object value) {
        if (objBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          obj_ = value;
          onChanged();
        } else {
          objBuilder_.setMessage(value);
        }
        bitField0_ |= 0x00000004;
        return this;
      }
      /**
       * <code>optional .Mysqlx.Datatypes.Object obj = 3;</code>
       */
      public Builder setObj(
          com.mysql.cj.x.protobuf.MysqlxDatatypes.Object.Builder builderForValue) {
        if (objBuilder_ == null) {
          obj_ = builderForValue.build();
          onChanged();
        } else {
          objBuilder_.setMessage(builderForValue.build());
        }
        bitField0_ |= 0x00000004;
        return this;
      }
      /**
       * <code>optional .Mysqlx.Datatypes.Object obj = 3;</code>
       */
      public Builder mergeObj(com.mysql.cj.x.protobuf.MysqlxDatatypes.Object value) {
        if (objBuilder_ == null) {
          if (((bitField0_ & 0x00000004) == 0x00000004) &&
              obj_ != com.mysql.cj.x.protobuf.MysqlxDatatypes.Object.getDefaultInstance()) {
            obj_ =
              com.mysql.cj.x.protobuf.MysqlxDatatypes.Object.newBuilder(obj_).mergeFrom(value).buildPartial();
          } else {
            obj_ = value;
          }
          onChanged();
        } else {
          objBuilder_.mergeFrom(value);
        }
        bitField0_ |= 0x00000004;
        return this;
      }
      /**
       * <code>optional .Mysqlx.Datatypes.Object obj = 3;</code>
       */
      public Builder clearObj() {
        if (objBuilder_ == null) {
          obj_ = com.mysql.cj.x.protobuf.MysqlxDatatypes.Object.getDefaultInstance();
          onChanged();
        } else {
          objBuilder_.clear();
        }
        bitField0_ = (bitField0_ & ~0x00000004);
        return this;
      }
      /**
       * <code>optional .Mysqlx.Datatypes.Object obj = 3;</code>
       */
      public com.mysql.cj.x.protobuf.MysqlxDatatypes.Object.Builder getObjBuilder() {
        bitField0_ |= 0x00000004;
        onChanged();
        return getObjFieldBuilder().getBuilder();
      }
      /**
       * <code>optional .Mysqlx.Datatypes.Object obj = 3;</code>
       */
      public com.mysql.cj.x.protobuf.MysqlxDatatypes.ObjectOrBuilder getObjOrBuilder() {
        if (objBuilder_ != null) {
          return objBuilder_.getMessageOrBuilder();
        } else {
          return obj_;
        }
      }
      /**
       * <code>optional .Mysqlx.Datatypes.Object obj = 3;</code>
       */
      private com.google.protobuf.SingleFieldBuilder<
          com.mysql.cj.x.protobuf.MysqlxDatatypes.Object, com.mysql.cj.x.protobuf.MysqlxDatatypes.Object.Builder, com.mysql.cj.x.protobuf.MysqlxDatatypes.ObjectOrBuilder> 
          getObjFieldBuilder() {
        if (objBuilder_ == null) {
          objBuilder_ = new com.google.protobuf.SingleFieldBuilder<
              com.mysql.cj.x.protobuf.MysqlxDatatypes.Object, com.mysql.cj.x.protobuf.MysqlxDatatypes.Object.Builder, com.mysql.cj.x.protobuf.MysqlxDatatypes.ObjectOrBuilder>(
                  getObj(),
                  getParentForChildren(),
                  isClean());
          obj_ = null;
        }
        return objBuilder_;
      }

      private com.mysql.cj.x.protobuf.MysqlxDatatypes.Array array_ = com.mysql.cj.x.protobuf.MysqlxDatatypes.Array.getDefaultInstance();
      private com.google.protobuf.SingleFieldBuilder<
          com.mysql.cj.x.protobuf.MysqlxDatatypes.Array, com.mysql.cj.x.protobuf.MysqlxDatatypes.Array.Builder, com.mysql.cj.x.protobuf.MysqlxDatatypes.ArrayOrBuilder> arrayBuilder_;
      /**
       * <code>optional .Mysqlx.Datatypes.Array array = 4;</code>
       */
      public boolean hasArray() {
        return ((bitField0_ & 0x00000008) == 0x00000008);
      }
      /**
       * <code>optional .Mysqlx.Datatypes.Array array = 4;</code>
       */
      public com.mysql.cj.x.protobuf.MysqlxDatatypes.Array getArray() {
        if (arrayBuilder_ == null) {
          return array_;
        } else {
          return arrayBuilder_.getMessage();
        }
      }
      /**
       * <code>optional .Mysqlx.Datatypes.Array array = 4;</code>
       */
      public Builder setArray(com.mysql.cj.x.protobuf.MysqlxDatatypes.Array value) {
        if (arrayBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          array_ = value;
          onChanged();
        } else {
          arrayBuilder_.setMessage(value);
        }
        bitField0_ |= 0x00000008;
        return this;
      }
      /**
       * <code>optional .Mysqlx.Datatypes.Array array = 4;</code>
       */
      public Builder setArray(
          com.mysql.cj.x.protobuf.MysqlxDatatypes.Array.Builder builderForValue) {
        if (arrayBuilder_ == null) {
          array_ = builderForValue.build();
          onChanged();
        } else {
          arrayBuilder_.setMessage(builderForValue.build());
        }
        bitField0_ |= 0x00000008;
        return this;
      }
      /**
       * <code>optional .Mysqlx.Datatypes.Array array = 4;</code>
       */
      public Builder mergeArray(com.mysql.cj.x.protobuf.MysqlxDatatypes.Array value) {
        if (arrayBuilder_ == null) {
          if (((bitField0_ & 0x00000008) == 0x00000008) &&
              array_ != com.mysql.cj.x.protobuf.MysqlxDatatypes.Array.getDefaultInstance()) {
            array_ =
              com.mysql.cj.x.protobuf.MysqlxDatatypes.Array.newBuilder(array_).mergeFrom(value).buildPartial();
          } else {
            array_ = value;
          }
          onChanged();
        } else {
          arrayBuilder_.mergeFrom(value);
        }
        bitField0_ |= 0x00000008;
        return this;
      }
      /**
       * <code>optional .Mysqlx.Datatypes.Array array = 4;</code>
       */
      public Builder clearArray() {
        if (arrayBuilder_ == null) {
          array_ = com.mysql.cj.x.protobuf.MysqlxDatatypes.Array.getDefaultInstance();
          onChanged();
        } else {
          arrayBuilder_.clear();
        }
        bitField0_ = (bitField0_ & ~0x00000008);
        return this;
      }
      /**
       * <code>optional .Mysqlx.Datatypes.Array array = 4;</code>
       */
      public com.mysql.cj.x.protobuf.MysqlxDatatypes.Array.Builder getArrayBuilder() {
        bitField0_ |= 0x00000008;
        onChanged();
        return getArrayFieldBuilder().getBuilder();
      }
      /**
       * <code>optional .Mysqlx.Datatypes.Array array = 4;</code>
       */
      public com.mysql.cj.x.protobuf.MysqlxDatatypes.ArrayOrBuilder getArrayOrBuilder() {
        if (arrayBuilder_ != null) {
          return arrayBuilder_.getMessageOrBuilder();
        } else {
          return array_;
        }
      }
      /**
       * <code>optional .Mysqlx.Datatypes.Array array = 4;</code>
       */
      private com.google.protobuf.SingleFieldBuilder<
          com.mysql.cj.x.protobuf.MysqlxDatatypes.Array, com.mysql.cj.x.protobuf.MysqlxDatatypes.Array.Builder, com.mysql.cj.x.protobuf.MysqlxDatatypes.ArrayOrBuilder> 
          getArrayFieldBuilder() {
        if (arrayBuilder_ == null) {
          arrayBuilder_ = new com.google.protobuf.SingleFieldBuilder<
              com.mysql.cj.x.protobuf.MysqlxDatatypes.Array, com.mysql.cj.x.protobuf.MysqlxDatatypes.Array.Builder, com.mysql.cj.x.protobuf.MysqlxDatatypes.ArrayOrBuilder>(
                  getArray(),
                  getParentForChildren(),
                  isClean());
          array_ = null;
        }
        return arrayBuilder_;
      }

      // @@protoc_insertion_point(builder_scope:Mysqlx.Datatypes.Any)
    }

    static {
      defaultInstance = new Any(true);
      defaultInstance.initFields();
    }

    // @@protoc_insertion_point(class_scope:Mysqlx.Datatypes.Any)
  }

  private static final com.google.protobuf.Descriptors.Descriptor
    internal_static_Mysqlx_Datatypes_Scalar_descriptor;
  private static
    com.google.protobuf.GeneratedMessage.FieldAccessorTable
      internal_static_Mysqlx_Datatypes_Scalar_fieldAccessorTable;
  private static final com.google.protobuf.Descriptors.Descriptor
    internal_static_Mysqlx_Datatypes_Scalar_String_descriptor;
  private static
    com.google.protobuf.GeneratedMessage.FieldAccessorTable
      internal_static_Mysqlx_Datatypes_Scalar_String_fieldAccessorTable;
  private static final com.google.protobuf.Descriptors.Descriptor
    internal_static_Mysqlx_Datatypes_Scalar_Octets_descriptor;
  private static
    com.google.protobuf.GeneratedMessage.FieldAccessorTable
      internal_static_Mysqlx_Datatypes_Scalar_Octets_fieldAccessorTable;
  private static final com.google.protobuf.Descriptors.Descriptor
    internal_static_Mysqlx_Datatypes_Object_descriptor;
  private static
    com.google.protobuf.GeneratedMessage.FieldAccessorTable
      internal_static_Mysqlx_Datatypes_Object_fieldAccessorTable;
  private static final com.google.protobuf.Descriptors.Descriptor
    internal_static_Mysqlx_Datatypes_Object_ObjectField_descriptor;
  private static
    com.google.protobuf.GeneratedMessage.FieldAccessorTable
      internal_static_Mysqlx_Datatypes_Object_ObjectField_fieldAccessorTable;
  private static final com.google.protobuf.Descriptors.Descriptor
    internal_static_Mysqlx_Datatypes_Array_descriptor;
  private static
    com.google.protobuf.GeneratedMessage.FieldAccessorTable
      internal_static_Mysqlx_Datatypes_Array_fieldAccessorTable;
  private static final com.google.protobuf.Descriptors.Descriptor
    internal_static_Mysqlx_Datatypes_Any_descriptor;
  private static
    com.google.protobuf.GeneratedMessage.FieldAccessorTable
      internal_static_Mysqlx_Datatypes_Any_fieldAccessorTable;

  public static com.google.protobuf.Descriptors.FileDescriptor
      getDescriptor() {
    return descriptor;
  }
  private static com.google.protobuf.Descriptors.FileDescriptor
      descriptor;
  static {
    java.lang.String[] descriptorData = {
      "\n\026mysqlx_datatypes.proto\022\020Mysqlx.Datatyp" +
      "es\"\306\003\n\006Scalar\022+\n\004type\030\001 \002(\0162\035.Mysqlx.Dat" +
      "atypes.Scalar.Type\022\024\n\014v_signed_int\030\002 \001(\022" +
      "\022\026\n\016v_unsigned_int\030\003 \001(\004\0221\n\010v_octets\030\005 \001" +
      "(\0132\037.Mysqlx.Datatypes.Scalar.Octets\022\020\n\010v" +
      "_double\030\006 \001(\001\022\017\n\007v_float\030\007 \001(\002\022\016\n\006v_bool" +
      "\030\010 \001(\010\0221\n\010v_string\030\t \001(\0132\037.Mysqlx.Dataty" +
      "pes.Scalar.String\032*\n\006String\022\r\n\005value\030\001 \002" +
      "(\014\022\021\n\tcollation\030\002 \001(\004\032-\n\006Octets\022\r\n\005value" +
      "\030\001 \002(\014\022\024\n\014content_type\030\002 \001(\r\"m\n\004Type\022\n\n\006",
      "V_SINT\020\001\022\n\n\006V_UINT\020\002\022\n\n\006V_NULL\020\003\022\014\n\010V_OC" +
      "TETS\020\004\022\014\n\010V_DOUBLE\020\005\022\013\n\007V_FLOAT\020\006\022\n\n\006V_B" +
      "OOL\020\007\022\014\n\010V_STRING\020\010\"}\n\006Object\0221\n\003fld\030\001 \003" +
      "(\0132$.Mysqlx.Datatypes.Object.ObjectField" +
      "\032@\n\013ObjectField\022\013\n\003key\030\001 \002(\t\022$\n\005value\030\002 " +
      "\002(\0132\025.Mysqlx.Datatypes.Any\"-\n\005Array\022$\n\005v" +
      "alue\030\001 \003(\0132\025.Mysqlx.Datatypes.Any\"\323\001\n\003An" +
      "y\022(\n\004type\030\001 \002(\0162\032.Mysqlx.Datatypes.Any.T" +
      "ype\022(\n\006scalar\030\002 \001(\0132\030.Mysqlx.Datatypes.S" +
      "calar\022%\n\003obj\030\003 \001(\0132\030.Mysqlx.Datatypes.Ob",
      "ject\022&\n\005array\030\004 \001(\0132\027.Mysqlx.Datatypes.A" +
      "rray\")\n\004Type\022\n\n\006SCALAR\020\001\022\n\n\006OBJECT\020\002\022\t\n\005" +
      "ARRAY\020\003B\031\n\027com.mysql.cj.x.protobuf"
    };
    com.google.protobuf.Descriptors.FileDescriptor.InternalDescriptorAssigner assigner =
        new com.google.protobuf.Descriptors.FileDescriptor.    InternalDescriptorAssigner() {
          public com.google.protobuf.ExtensionRegistry assignDescriptors(
              com.google.protobuf.Descriptors.FileDescriptor root) {
            descriptor = root;
            return null;
          }
        };
    com.google.protobuf.Descriptors.FileDescriptor
      .internalBuildGeneratedFileFrom(descriptorData,
        new com.google.protobuf.Descriptors.FileDescriptor[] {
        }, assigner);
    internal_static_Mysqlx_Datatypes_Scalar_descriptor =
      getDescriptor().getMessageTypes().get(0);
    internal_static_Mysqlx_Datatypes_Scalar_fieldAccessorTable = new
      com.google.protobuf.GeneratedMessage.FieldAccessorTable(
        internal_static_Mysqlx_Datatypes_Scalar_descriptor,
        new java.lang.String[] { "Type", "VSignedInt", "VUnsignedInt", "VOctets", "VDouble", "VFloat", "VBool", "VString", });
    internal_static_Mysqlx_Datatypes_Scalar_String_descriptor =
      internal_static_Mysqlx_Datatypes_Scalar_descriptor.getNestedTypes().get(0);
    internal_static_Mysqlx_Datatypes_Scalar_String_fieldAccessorTable = new
      com.google.protobuf.GeneratedMessage.FieldAccessorTable(
        internal_static_Mysqlx_Datatypes_Scalar_String_descriptor,
        new java.lang.String[] { "Value", "Collation", });
    internal_static_Mysqlx_Datatypes_Scalar_Octets_descriptor =
      internal_static_Mysqlx_Datatypes_Scalar_descriptor.getNestedTypes().get(1);
    internal_static_Mysqlx_Datatypes_Scalar_Octets_fieldAccessorTable = new
      com.google.protobuf.GeneratedMessage.FieldAccessorTable(
        internal_static_Mysqlx_Datatypes_Scalar_Octets_descriptor,
        new java.lang.String[] { "Value", "ContentType", });
    internal_static_Mysqlx_Datatypes_Object_descriptor =
      getDescriptor().getMessageTypes().get(1);
    internal_static_Mysqlx_Datatypes_Object_fieldAccessorTable = new
      com.google.protobuf.GeneratedMessage.FieldAccessorTable(
        internal_static_Mysqlx_Datatypes_Object_descriptor,
        new java.lang.String[] { "Fld", });
    internal_static_Mysqlx_Datatypes_Object_ObjectField_descriptor =
      internal_static_Mysqlx_Datatypes_Object_descriptor.getNestedTypes().get(0);
    internal_static_Mysqlx_Datatypes_Object_ObjectField_fieldAccessorTable = new
      com.google.protobuf.GeneratedMessage.FieldAccessorTable(
        internal_static_Mysqlx_Datatypes_Object_ObjectField_descriptor,
        new java.lang.String[] { "Key", "Value", });
    internal_static_Mysqlx_Datatypes_Array_descriptor =
      getDescriptor().getMessageTypes().get(2);
    internal_static_Mysqlx_Datatypes_Array_fieldAccessorTable = new
      com.google.protobuf.GeneratedMessage.FieldAccessorTable(
        internal_static_Mysqlx_Datatypes_Array_descriptor,
        new java.lang.String[] { "Value", });
    internal_static_Mysqlx_Datatypes_Any_descriptor =
      getDescriptor().getMessageTypes().get(3);
    internal_static_Mysqlx_Datatypes_Any_fieldAccessorTable = new
      com.google.protobuf.GeneratedMessage.FieldAccessorTable(
        internal_static_Mysqlx_Datatypes_Any_descriptor,
        new java.lang.String[] { "Type", "Scalar", "Obj", "Array", });
  }

  // @@protoc_insertion_point(outer_class_scope)
}
