/*
 * Decompiled with CFR 0.152.
 */
package com.mysql.cj.mysqlx.io;

import java.nio.ByteBuffer;
import java.nio.channels.AsynchronousSocketChannel;
import java.nio.channels.CompletionHandler;
import java.nio.channels.ReadPendingException;
import java.nio.channels.WritePendingException;
import java.util.LinkedList;
import java.util.Map;
import java.util.Objects;
import java.util.Queue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;

public class SerializingBufferWriter
implements CompletionHandler<Long, Void> {
    protected AsynchronousSocketChannel channel;
    private Queue<ByteBuffer> pendingWrites = new LinkedList<ByteBuffer>();
    private Map<Integer, CompletionHandler<Long, Void>> bufToHandler = new ConcurrentHashMap<Integer, CompletionHandler<Long, Void>>();

    public SerializingBufferWriter(AsynchronousSocketChannel channel) {
        this.channel = channel;
    }

    private void initiateWrite() {
        try {
            ByteBuffer[] bufs = this.pendingWrites.toArray(new ByteBuffer[this.pendingWrites.size()]);
            this.channel.write(bufs, 0, this.pendingWrites.size(), 0L, TimeUnit.MILLISECONDS, null, this);
        }
        catch (ReadPendingException | WritePendingException t) {
            return;
        }
        catch (Throwable t) {
            this.failed(t, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void queueBuffer(ByteBuffer buf, CompletionHandler<Long, Void> callback) {
        if (callback != null) {
            this.bufToHandler.put(System.identityHashCode(buf), callback);
        }
        Queue<ByteBuffer> queue = this.pendingWrites;
        synchronized (queue) {
            this.pendingWrites.add(buf);
            if (this.pendingWrites.size() == 1) {
                this.initiateWrite();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void completed(Long bytesWritten, Void v) {
        LinkedList<ByteBuffer> completedWrites = new LinkedList<ByteBuffer>();
        Queue<ByteBuffer> queue = this.pendingWrites;
        synchronized (queue) {
            while (this.pendingWrites.peek() != null && !this.pendingWrites.peek().hasRemaining()) {
                completedWrites.add(this.pendingWrites.remove());
            }
            completedWrites.stream().map(System::identityHashCode).map(this.bufToHandler::remove).filter(Objects::nonNull).forEach(l -> {
                try {
                    l.completed(0L, null);
                }
                catch (Throwable ex) {
                    try {
                        l.failed(ex, null);
                    }
                    catch (Throwable ex2) {
                        ex2.printStackTrace();
                    }
                }
            });
            if (this.pendingWrites.size() > 0) {
                this.initiateWrite();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void failed(Throwable t, Void v) {
        try {
            this.channel.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.bufToHandler.values().forEach(l -> {
            try {
                l.failed(t, null);
            }
            catch (Exception exception) {
                // empty catch block
            }
        });
        this.bufToHandler.clear();
        Queue<ByteBuffer> queue = this.pendingWrites;
        synchronized (queue) {
            this.pendingWrites.clear();
        }
    }

    public void setChannel(AsynchronousSocketChannel channel) {
        this.channel = channel;
    }
}

