/*
 * Decompiled with CFR 0.152.
 */
package org.monetdb.monetdbe;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.HashMap;
import java.util.Map;

public class MonetTypes {
    static Map<Integer, Integer> typeMapMonetToSQL = new HashMap<Integer, Integer>();
    static final String[] sqlDefaultTypeNames;
    static final Map<Integer, Integer> typeMapSQLToMonet;
    static final String[] monetdbeTypes;
    static final Map<Integer, Integer> sizeMapMonet;
    static final Map<String, Integer> typeMapSQLNameToSQLInt;

    protected static int getSQLTypeFromMonet(int monetdbetype) {
        return typeMapMonetToSQL.get(monetdbetype);
    }

    protected static String getSQLTypeNameFromMonet(int monetdbetype) {
        return sqlDefaultTypeNames[monetdbetype];
    }

    protected static int getMonetTypeFromSQL(int sqltype) {
        return typeMapSQLToMonet.getOrDefault(sqltype, 14);
    }

    protected static int getMonetTypeIntFromSQLName(String sqlTypeName) {
        return MonetTypes.getMonetTypeFromSQL(MonetTypes.getSQLIntFromSQLName(sqlTypeName));
    }

    protected static Class<?> getClassForSQLType(int sqlType) {
        switch (sqlType) {
            case -16: 
            case -15: 
            case -9: 
            case -1: 
            case 1: 
            case 12: {
                return String.class;
            }
            case 2: 
            case 3: {
                return BigDecimal.class;
            }
            case 16: {
                return Boolean.class;
            }
            case -7: 
            case -6: 
            case 5: {
                return Short.class;
            }
            case 4: {
                return Integer.class;
            }
            case -5: {
                return Long.class;
            }
            case 7: {
                return Float.class;
            }
            case 6: 
            case 8: {
                return Double.class;
            }
            case -4: 
            case -3: 
            case -2: {
                return byte[].class;
            }
            case 91: {
                return Date.class;
            }
            case 92: {
                return Time.class;
            }
            case 93: {
                return Timestamp.class;
            }
            case 2005: {
                return Clob.class;
            }
            case 2004: {
                return Blob.class;
            }
        }
        return String.class;
    }

    protected static int getDefaultSQLTypeForClass(Class<?> javaClass) {
        if (javaClass == String.class) {
            return 12;
        }
        if (javaClass == Boolean.class) {
            return 16;
        }
        if (javaClass == Short.class) {
            return 5;
        }
        if (javaClass == Integer.class) {
            return 4;
        }
        if (javaClass == Long.class) {
            return -5;
        }
        if (javaClass == Float.class) {
            return 7;
        }
        if (javaClass == Double.class) {
            return 8;
        }
        if (javaClass == byte[].class) {
            return -2;
        }
        if (javaClass == Date.class) {
            return 91;
        }
        if (javaClass == Time.class) {
            return 92;
        }
        if (javaClass == Timestamp.class) {
            return 93;
        }
        if (javaClass == Clob.class) {
            return 2005;
        }
        if (javaClass == Blob.class) {
            return 2004;
        }
        if (javaClass == BigDecimal.class) {
            return 2;
        }
        return 12;
    }

    protected static boolean convertTojavaClass(int monetdbetype, Class<?> javaClass) {
        if (javaClass == String.class) {
            return monetdbetype != 10 && monetdbetype >= 0 && monetdbetype <= 13;
        }
        if (javaClass == Boolean.class || javaClass == Short.class || javaClass == Integer.class || javaClass == Long.class || javaClass == Float.class || javaClass == Double.class || javaClass == BigDecimal.class) {
            return monetdbetype >= 0 && monetdbetype <= 9;
        }
        if (javaClass == Date.class) {
            return monetdbetype == 9 || monetdbetype == 11 || monetdbetype == 13;
        }
        if (javaClass == Time.class) {
            return monetdbetype == 9 || monetdbetype == 12 || monetdbetype == 13;
        }
        if (javaClass == Timestamp.class) {
            return monetdbetype >= 9 && monetdbetype <= 13;
        }
        if (javaClass == Blob.class || javaClass == byte[].class) {
            return monetdbetype == 10;
        }
        if (javaClass == Clob.class) {
            return monetdbetype == 9;
        }
        if (javaClass == BigInteger.class) {
            return monetdbetype == 4 || monetdbetype == 5 || monetdbetype == 9;
        }
        return false;
    }

    protected static Class<?> getClassForMonetType(int monetdbeType) {
        return MonetTypes.getClassForSQLType(MonetTypes.getSQLTypeFromMonet(monetdbeType));
    }

    protected static String getMonetTypeString(int monetdbetype) {
        return monetdbeTypes[monetdbetype];
    }

    protected static int getMonetSize(int monetdbetype) {
        if (monetdbetype >= 9) {
            return 0;
        }
        return sizeMapMonet.get(monetdbetype);
    }

    protected static int getSQLIntFromSQLName(String sqlTypeName) {
        return typeMapSQLNameToSQLInt.get(sqlTypeName);
    }

    protected static boolean isSigned(int sqlType) {
        switch (sqlType) {
            case -6: 
            case -5: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                return true;
            }
        }
        return false;
    }

    protected static int getPrecision(int sqlType) {
        switch (sqlType) {
            case -6: {
                return 3;
            }
            case 5: {
                return 5;
            }
            case 4: 
            case 7: {
                return 10;
            }
            case -5: 
            case 6: 
            case 8: {
                return 19;
            }
            case 2: 
            case 3: {
                return 0;
            }
            case -1: 
            case 1: 
            case 12: 
            case 2005: {
                return 0;
            }
            case 91: 
            case 92: 
            case 93: {
                return 0;
            }
        }
        return 0;
    }

    static {
        typeMapMonetToSQL.put(0, 16);
        typeMapMonetToSQL.put(1, -6);
        typeMapMonetToSQL.put(2, 5);
        typeMapMonetToSQL.put(3, 4);
        typeMapMonetToSQL.put(4, -5);
        typeMapMonetToSQL.put(5, 2);
        typeMapMonetToSQL.put(6, 4);
        typeMapMonetToSQL.put(7, 7);
        typeMapMonetToSQL.put(8, 8);
        typeMapMonetToSQL.put(9, 12);
        typeMapMonetToSQL.put(10, 2004);
        typeMapMonetToSQL.put(11, 91);
        typeMapMonetToSQL.put(12, 92);
        typeMapMonetToSQL.put(13, 93);
        typeMapMonetToSQL.put(14, 0);
        sqlDefaultTypeNames = new String[]{"BOOLEAN", "TINYINT", "SMALLINT", "INTEGER", "BIGINT", "INTEGER", "REAL", "DOUBLE", "VARCHAR", "BLOB", "DATE", "TIME", "TIMESTAMP", "NULL"};
        typeMapSQLToMonet = new HashMap<Integer, Integer>();
        typeMapSQLToMonet.put(16, 0);
        typeMapSQLToMonet.put(-7, 0);
        typeMapSQLToMonet.put(-6, 1);
        typeMapSQLToMonet.put(5, 2);
        typeMapSQLToMonet.put(4, 3);
        typeMapSQLToMonet.put(-5, 4);
        typeMapSQLToMonet.put(7, 7);
        typeMapSQLToMonet.put(6, 7);
        typeMapSQLToMonet.put(8, 8);
        typeMapSQLToMonet.put(1, 9);
        typeMapSQLToMonet.put(12, 9);
        typeMapSQLToMonet.put(-1, 9);
        typeMapSQLToMonet.put(-15, 9);
        typeMapSQLToMonet.put(-9, 9);
        typeMapSQLToMonet.put(-16, 9);
        typeMapSQLToMonet.put(2005, 9);
        typeMapSQLToMonet.put(2004, 10);
        typeMapSQLToMonet.put(-2, 10);
        typeMapSQLToMonet.put(-3, 10);
        typeMapSQLToMonet.put(-4, 10);
        typeMapSQLToMonet.put(91, 11);
        typeMapSQLToMonet.put(92, 12);
        typeMapSQLToMonet.put(93, 13);
        typeMapSQLToMonet.put(0, 14);
        typeMapSQLToMonet.put(1111, 14);
        typeMapSQLToMonet.put(2, 5);
        typeMapSQLToMonet.put(3, 5);
        monetdbeTypes = new String[]{"monetdbe_bool", "monetdbe_int8_t", "monetdbe_int16_t", "monetdbe_int32_t", "monetdbe_int64_t", "monetdbe_int128_t", "monetdbe_size_t", "monetdbe_float", "monetdbe_double", "monetdbe_str", "monetdbe_blob", "monetdbe_date", "monetdbe_time", "monetdbe_timestamp", "monetdbe_type_unknown"};
        sizeMapMonet = new HashMap<Integer, Integer>();
        sizeMapMonet.put(0, 1);
        sizeMapMonet.put(1, 1);
        sizeMapMonet.put(2, 2);
        sizeMapMonet.put(3, 4);
        sizeMapMonet.put(4, 8);
        sizeMapMonet.put(5, 16);
        sizeMapMonet.put(6, 4);
        sizeMapMonet.put(7, 4);
        sizeMapMonet.put(8, 8);
        typeMapSQLNameToSQLInt = new HashMap<String, Integer>();
        typeMapSQLNameToSQLInt.put("BOOLEAN", 16);
        typeMapSQLNameToSQLInt.put("BIT", -7);
        typeMapSQLNameToSQLInt.put("TINYINT", -6);
        typeMapSQLNameToSQLInt.put("SMALLINT", 5);
        typeMapSQLNameToSQLInt.put("INTEGER", 4);
        typeMapSQLNameToSQLInt.put("BIGINT", -5);
        typeMapSQLNameToSQLInt.put("REAL", 7);
        typeMapSQLNameToSQLInt.put("FLOAT", 6);
        typeMapSQLNameToSQLInt.put("DOUBLE", 8);
        typeMapSQLNameToSQLInt.put("CHAR", 1);
        typeMapSQLNameToSQLInt.put("VARCHAR", 12);
        typeMapSQLNameToSQLInt.put("LONGVARCHAR", -1);
        typeMapSQLNameToSQLInt.put("NCHAR", -15);
        typeMapSQLNameToSQLInt.put("LONGNVARCHAR", -16);
        typeMapSQLNameToSQLInt.put("BLOB", 2004);
        typeMapSQLNameToSQLInt.put("DATE", 91);
        typeMapSQLNameToSQLInt.put("TIME", 92);
        typeMapSQLNameToSQLInt.put("TIMESTAMP", 93);
        typeMapSQLNameToSQLInt.put("NUMERIC", 2);
        typeMapSQLNameToSQLInt.put("DECIMAL", 3);
        typeMapSQLNameToSQLInt.put("BINARY", -2);
        typeMapSQLNameToSQLInt.put("VARBINARY", -3);
        typeMapSQLNameToSQLInt.put("LONGVARBINARY", -4);
        typeMapSQLNameToSQLInt.put("CLOB", 2005);
        typeMapSQLNameToSQLInt.put("NULL", 0);
        typeMapSQLNameToSQLInt.put("OTHER", 1111);
    }
}

