/*
 * Decompiled with CFR 0.152.
 */
package org.monetdb.monetdbe;

import java.sql.BatchUpdateException;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import org.monetdb.monetdbe.MonetConnection;
import org.monetdb.monetdbe.MonetNative;
import org.monetdb.monetdbe.MonetPreparedStatement;
import org.monetdb.monetdbe.MonetResultSet;
import org.monetdb.monetdbe.MonetWrapper;

public class MonetStatement
extends MonetWrapper
implements Statement {
    protected MonetConnection conn;
    protected MonetResultSet resultSet;
    protected List<String> batch;
    protected int updateCount = -1;
    protected long largeUpdateCount = -1L;
    private int queryTimeout = 0;
    private boolean closed = false;
    private boolean closeOnCompletion = false;
    private SQLWarning warnings;
    private int maxRows = 0;
    private long largeMaxRows = 0L;
    private int fetchSize;
    private int fetchDirection = 1002;
    private int resultSetType = 1004;
    private int resultSetConcurrency = 1007;
    private int resultSetHoldability = 1;

    public MonetStatement(MonetConnection conn) {
        this.conn = conn;
        this.resultSet = null;
        this.batch = new ArrayList<String>();
    }

    public MonetStatement(MonetConnection conn, int queryTimeout) {
        this.conn = conn;
        this.resultSet = null;
        this.batch = new ArrayList<String>();
        this.queryTimeout = queryTimeout;
    }

    public MonetStatement(MonetConnection conn, int resultSetType, int resultSetConcurrency, int resultSetHoldability) {
        this.conn = conn;
        this.resultSet = null;
        this.resultSetType = resultSetType;
        this.resultSetConcurrency = resultSetConcurrency;
        this.resultSetHoldability = resultSetHoldability;
        this.batch = new ArrayList<String>();
    }

    private final void addWarning(String reason, String sqlstate) {
        SQLWarning warn = new SQLWarning(reason, sqlstate);
        if (this.warnings == null) {
            this.warnings = warn;
        } else {
            this.warnings.setNextWarning(warn);
        }
    }

    public void checkNotClosed() throws SQLException {
        if (this.isClosed()) {
            throw new SQLException("Statement is closed", "M1M20");
        }
    }

    @Override
    public void close() throws SQLException {
        this.checkNotClosed();
        if (this.resultSet != null && !this.resultSet.isClosed()) {
            this.resultSet.close();
        }
        if (this instanceof MonetPreparedStatement && ((MonetPreparedStatement)this).statementNative != null) {
            MonetNative.monetdbe_cleanup_statement(this.conn.getDbNative(), ((MonetPreparedStatement)this).statementNative);
        }
        this.closed = true;
    }

    @Override
    public void cancel() throws SQLException {
        throw new SQLFeatureNotSupportedException("Query cancelling is currently not supported by the driver.", "0A000");
    }

    @Override
    public boolean isClosed() throws SQLException {
        return this.closed;
    }

    @Override
    public void closeOnCompletion() throws SQLException {
        this.checkNotClosed();
        this.closeOnCompletion = true;
    }

    @Override
    public boolean isCloseOnCompletion() throws SQLException {
        this.checkNotClosed();
        return this.closeOnCompletion;
    }

    protected void closeIfComplete() throws SQLException {
        if (!this.closed && this.closeOnCompletion) {
            this.close();
        }
    }

    @Override
    public boolean execute(String sql) throws SQLException {
        this.checkNotClosed();
        int lastUpdateCount = this.updateCount;
        MonetResultSet lastResultSet = this.resultSet;
        this.resultSet = null;
        this.updateCount = -1;
        String error_msg = MonetNative.monetdbe_query(this.conn.getDbNative(), sql, this, false, this.getMaxRows());
        if (error_msg != null) {
            this.updateCount = lastUpdateCount;
            this.resultSet = lastResultSet;
            throw new SQLException(error_msg);
        }
        if (this.resultSet != null) {
            return true;
        }
        if (this.updateCount >= 0 || this.updateCount == -2) {
            return false;
        }
        throw new SQLException("Error in monetdbe_query");
    }

    @Override
    public ResultSet executeQuery(String sql) throws SQLException {
        if (!this.execute(sql)) {
            throw new SQLException("Query did not produce a result set", "M1M19");
        }
        return this.getResultSet();
    }

    @Override
    public int executeUpdate(String sql) throws SQLException {
        if (this.execute(sql)) {
            throw new SQLException("Query produced a result set", "M1M17");
        }
        return this.getUpdateCount();
    }

    @Override
    public long executeLargeUpdate(String sql) throws SQLException {
        this.checkNotClosed();
        long lastUpdateCount = this.largeUpdateCount;
        MonetResultSet lastResultSet = this.resultSet;
        this.resultSet = null;
        this.largeUpdateCount = -1L;
        String error_msg = MonetNative.monetdbe_query(this.conn.getDbNative(), sql, this, true, this.getMaxRows());
        if (error_msg != null) {
            this.largeUpdateCount = lastUpdateCount;
            this.resultSet = lastResultSet;
            throw new SQLException(error_msg);
        }
        if (this.resultSet != null) {
            throw new SQLException("Query produced a result set", "M1M17");
        }
        return this.getLargeUpdateCount();
    }

    @Override
    public int[] executeBatch() throws SQLException {
        this.checkNotClosed();
        if (this.batch == null || this.batch.isEmpty()) {
            return new int[0];
        }
        int[] counts = new int[this.batch.size()];
        int count = -1;
        for (int i = 0; i < this.batch.size(); ++i) {
            String query = this.batch.get(i);
            try {
                count = this.executeUpdate(query);
            }
            catch (SQLException e) {
                throw new BatchUpdateException();
            }
            counts[i] = count >= 0 ? count : -2;
        }
        this.clearBatch();
        return counts;
    }

    @Override
    public void addBatch(String sql) throws SQLException {
        this.checkNotClosed();
        if (this.batch == null) {
            this.batch = new ArrayList<String>();
        }
        this.batch.add(sql);
    }

    @Override
    public void clearBatch() throws SQLException {
        this.checkNotClosed();
        if (this.batch != null) {
            this.batch.clear();
        }
    }

    @Override
    public long[] executeLargeBatch() throws SQLException {
        this.checkNotClosed();
        if (this.batch == null || this.batch.isEmpty()) {
            return new long[0];
        }
        long[] counts = new long[this.batch.size()];
        long count = -1L;
        for (int i = 0; i < this.batch.size(); ++i) {
            String query = this.batch.get(i);
            try {
                count = this.executeLargeUpdate(query);
            }
            catch (SQLException e) {
                throw new BatchUpdateException();
            }
            counts[i] = count >= 0L ? count : -2L;
        }
        this.clearBatch();
        return counts;
    }

    @Override
    public boolean getMoreResults(int current) throws SQLException {
        this.checkNotClosed();
        throw new SQLFeatureNotSupportedException("getMoreResults()");
    }

    @Override
    public boolean getMoreResults() throws SQLException {
        return this.getMoreResults(1);
    }

    @Override
    public int getUpdateCount() throws SQLException {
        this.checkNotClosed();
        return this.updateCount;
    }

    @Override
    public ResultSet getResultSet() throws SQLException {
        this.checkNotClosed();
        return this.resultSet;
    }

    @Override
    public void setEscapeProcessing(boolean enable) throws SQLException {
        this.checkNotClosed();
        if (enable) {
            this.addWarning("setEscapeProcessing: JDBC escape syntax is not supported by this driver", "01M22");
        }
    }

    @Override
    public int getQueryTimeout() throws SQLException {
        this.checkNotClosed();
        return this.queryTimeout;
    }

    @Override
    public void setQueryTimeout(int seconds) throws SQLException {
        this.checkNotClosed();
        if (seconds < 0) {
            throw new SQLException("Illegal timeout value: " + seconds);
        }
        this.queryTimeout = seconds;
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        this.checkNotClosed();
        return this.warnings;
    }

    @Override
    public void clearWarnings() throws SQLException {
        this.checkNotClosed();
        this.warnings = null;
    }

    @Override
    public void setCursorName(String name) throws SQLException {
        this.checkNotClosed();
        this.addWarning("setCursorName: positioned updates/deletes not supported", "01M21");
    }

    @Override
    public void setFetchDirection(int direction) throws SQLException {
        this.checkNotClosed();
        if (direction != 1000 && direction != 1001 && direction != 1002) {
            throw new SQLException("Illegal direction: " + direction, "M1M05");
        }
        this.fetchDirection = direction;
    }

    @Override
    public int getFetchDirection() throws SQLException {
        this.checkNotClosed();
        return this.fetchDirection;
    }

    @Override
    public void setFetchSize(int rows) throws SQLException {
        this.checkNotClosed();
        if (rows < 0 || this.getMaxRows() != 0 && rows > this.getMaxRows()) {
            throw new SQLException("Illegal fetch size value: " + rows, "M1M05");
        }
        this.fetchSize = rows;
    }

    @Override
    public int getFetchSize() throws SQLException {
        this.checkNotClosed();
        return this.fetchSize;
    }

    @Override
    public int getResultSetConcurrency() throws SQLException {
        this.checkNotClosed();
        return this.resultSetConcurrency;
    }

    @Override
    public int getResultSetType() throws SQLException {
        this.checkNotClosed();
        return this.resultSetType;
    }

    @Override
    public Connection getConnection() throws SQLException {
        this.checkNotClosed();
        return this.conn;
    }

    @Override
    public int getResultSetHoldability() throws SQLException {
        this.checkNotClosed();
        return this.resultSetHoldability;
    }

    @Override
    public void setPoolable(boolean poolable) throws SQLException {
        throw new SQLFeatureNotSupportedException("Poolable statements are currently not supported by the driver.");
    }

    @Override
    public boolean isPoolable() throws SQLException {
        this.checkNotClosed();
        return false;
    }

    @Override
    public long getLargeUpdateCount() throws SQLException {
        this.checkNotClosed();
        return this.largeUpdateCount;
    }

    @Override
    public void setLargeMaxRows(long max) throws SQLException {
        this.checkNotClosed();
        this.largeMaxRows = max;
    }

    @Override
    public long getLargeMaxRows() throws SQLException {
        this.checkNotClosed();
        return this.largeMaxRows;
    }

    @Override
    public int getMaxFieldSize() throws SQLException {
        this.checkNotClosed();
        return 0;
    }

    @Override
    public void setMaxFieldSize(int max) throws SQLException {
        this.checkNotClosed();
        if (max < 0) {
            throw new SQLException("Illegal max value: " + max, "M1M05");
        }
        if (max > 0) {
            this.addWarning("setMaxFieldSize: field size limitation not supported", "01M23");
        }
    }

    @Override
    public int getMaxRows() throws SQLException {
        this.checkNotClosed();
        return this.maxRows;
    }

    @Override
    public void setMaxRows(int max) throws SQLException {
        this.checkNotClosed();
        if (max < 0) {
            throw new SQLException("Illegal max value: " + max, "M1M05");
        }
        this.maxRows = max;
    }

    @Override
    public boolean execute(String sql, int autoGeneratedKeys) throws SQLException {
        return false;
    }

    @Override
    public boolean execute(String sql, int[] columnIndexes) throws SQLException {
        return false;
    }

    @Override
    public boolean execute(String sql, String[] columnNames) throws SQLException {
        return false;
    }

    @Override
    public int executeUpdate(String sql, int autoGeneratedKeys) throws SQLException {
        return 0;
    }

    @Override
    public int executeUpdate(String sql, int[] columnIndexes) throws SQLException {
        return 0;
    }

    @Override
    public int executeUpdate(String sql, String[] columnNames) throws SQLException {
        return 0;
    }

    @Override
    public long executeLargeUpdate(String sql, int autoGeneratedKeys) throws SQLException {
        return 0L;
    }

    @Override
    public long executeLargeUpdate(String sql, int[] columnIndexes) throws SQLException {
        return 0L;
    }

    @Override
    public long executeLargeUpdate(String sql, String[] columnNames) throws SQLException {
        return 0L;
    }

    @Override
    public ResultSet getGeneratedKeys() throws SQLException {
        return null;
    }
}

