/*
 * Decompiled with CFR 0.152.
 */
package org.monetdb.monetdbe;

import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import org.monetdb.monetdbe.MonetColumn;
import org.monetdb.monetdbe.MonetTypes;
import org.monetdb.monetdbe.MonetWrapper;

public class MonetResultSetMetaData
extends MonetWrapper
implements ResultSetMetaData {
    private final String[] names;
    private final int[] types;
    private final String[] monetTypes;
    private final int[] monetTypesInt;
    private final int[] sqlTypes;
    private final String[] javaTypes;
    private final int[] scales;

    MonetResultSetMetaData(String[] resultNames, int[] resultMonetTypes, int ncols) {
        this.names = resultNames;
        this.types = resultMonetTypes;
        this.monetTypes = new String[ncols];
        this.monetTypesInt = new int[ncols];
        this.sqlTypes = new int[ncols];
        this.javaTypes = new String[ncols];
        this.scales = new int[ncols];
        for (int i = 0; i < ncols; ++i) {
            this.monetTypes[i] = MonetTypes.getMonetTypeString(resultMonetTypes[i]);
            this.monetTypesInt[i] = resultMonetTypes[i];
            this.sqlTypes[i] = MonetTypes.getSQLTypeFromMonet(resultMonetTypes[i]);
            this.javaTypes[i] = MonetTypes.getClassForMonetType(resultMonetTypes[i]).getName();
        }
    }

    MonetResultSetMetaData(MonetColumn[] columns, int ncols) {
        this.names = new String[ncols];
        this.types = new int[ncols];
        this.monetTypes = new String[ncols];
        this.monetTypesInt = new int[ncols];
        this.sqlTypes = new int[ncols];
        this.javaTypes = new String[ncols];
        this.scales = new int[ncols];
        for (int i = 0; i < ncols; ++i) {
            this.names[i] = columns[i].getName();
            this.types[i] = columns[i].getMonetdbeType();
            this.monetTypes[i] = columns[i].getTypeName();
            this.monetTypesInt[i] = columns[i].getMonetdbeType();
            this.sqlTypes[i] = MonetTypes.getSQLTypeFromMonet(columns[i].getMonetdbeType());
            this.javaTypes[i] = MonetTypes.getClassForMonetType(columns[i].getMonetdbeType()).getName();
            this.scales[i] = columns[i].getScaleJDBC();
        }
    }

    protected String[] getNames() {
        return this.names;
    }

    @Override
    public int getColumnCount() throws SQLException {
        return this.names.length;
    }

    @Override
    public boolean isAutoIncrement(int column) throws SQLException {
        return false;
    }

    @Override
    public boolean isCaseSensitive(int column) throws SQLException {
        switch (this.getColumnType(column)) {
            case -1: 
            case 1: 
            case 12: 
            case 2005: {
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean isSearchable(int column) throws SQLException {
        return true;
    }

    @Override
    public boolean isCurrency(int column) throws SQLException {
        return false;
    }

    @Override
    public int isNullable(int column) throws SQLException {
        return 2;
    }

    @Override
    public boolean isSigned(int column) throws SQLException {
        return MonetTypes.isSigned(this.getColumnType(column));
    }

    @Override
    public int getColumnDisplaySize(int column) throws SQLException {
        return 0;
    }

    @Override
    public String getColumnLabel(int column) throws SQLException {
        return this.getColumnName(column);
    }

    @Override
    public String getColumnName(int column) throws SQLException {
        try {
            return this.names[column - 1];
        }
        catch (IndexOutOfBoundsException e) {
            throw new SQLException("columnIndex out of bounds");
        }
    }

    @Override
    public String getSchemaName(int column) throws SQLException {
        return "";
    }

    @Override
    public String getTableName(int column) throws SQLException {
        return "";
    }

    @Override
    public int getPrecision(int column) throws SQLException {
        return MonetTypes.getPrecision(this.getColumnType(column));
    }

    @Override
    public int getScale(int column) throws SQLException {
        return this.scales[column - 1];
    }

    @Override
    public String getCatalogName(int column) throws SQLException {
        return "";
    }

    @Override
    public int getColumnType(int column) throws SQLException {
        try {
            return this.sqlTypes[column - 1];
        }
        catch (IndexOutOfBoundsException e) {
            throw new SQLException("columnIndex out of bounds");
        }
    }

    @Override
    public String getColumnTypeName(int column) throws SQLException {
        try {
            return this.monetTypes[column - 1];
        }
        catch (IndexOutOfBoundsException e) {
            throw new SQLException("columnIndex out of bounds");
        }
    }

    public int getColumnTypeInt(int column) throws SQLException {
        try {
            return this.monetTypesInt[column - 1];
        }
        catch (IndexOutOfBoundsException e) {
            throw new SQLException("columnIndex out of bounds");
        }
    }

    @Override
    public String getColumnClassName(int column) throws SQLException {
        try {
            return this.javaTypes[column - 1];
        }
        catch (IndexOutOfBoundsException e) {
            throw new SQLException("columnIndex out of bounds");
        }
    }

    @Override
    public boolean isReadOnly(int column) throws SQLException {
        return true;
    }

    @Override
    public boolean isWritable(int column) throws SQLException {
        return false;
    }

    @Override
    public boolean isDefinitelyWritable(int column) throws SQLException {
        return false;
    }
}

