/*
 * Decompiled with CFR 0.152.
 */
package org.monetdb.monetdbe;

import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.ByteBuffer;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.NClob;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.sql.SQLType;
import java.sql.SQLWarning;
import java.sql.SQLXML;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZoneOffset;
import java.time.format.DateTimeParseException;
import java.util.Calendar;
import java.util.Map;
import org.monetdb.monetdbe.MonetBlob;
import org.monetdb.monetdbe.MonetClob;
import org.monetdb.monetdbe.MonetColumn;
import org.monetdb.monetdbe.MonetConnection;
import org.monetdb.monetdbe.MonetNative;
import org.monetdb.monetdbe.MonetResultSetMetaData;
import org.monetdb.monetdbe.MonetStatement;
import org.monetdb.monetdbe.MonetTypes;
import org.monetdb.monetdbe.MonetWrapper;

public class MonetResultSet
extends MonetWrapper
implements ResultSet {
    private final MonetStatement statement;
    private ByteBuffer nativeResult;
    private MonetResultSetMetaData metaData;
    private final int nRows;
    private final int nColumns;
    private int curRow;
    private MonetColumn[] columns;
    private String name;
    private SQLWarning warnings;
    private boolean lastReadWasNull = true;
    private boolean closed = false;
    private int resultSetType = 1004;
    private int concurrency = 1007;
    private int fetchDirection = 1002;
    private int resultSetHoldability = 1;
    private int fetchSize;

    MonetResultSet(MonetStatement statement, ByteBuffer nativeResult, int nRows, int nColumns, String name, int maxRows) {
        this.statement = statement;
        this.nativeResult = nativeResult;
        this.nColumns = nColumns;
        this.curRow = 0;
        this.columns = MonetNative.monetdbe_result_fetch_all(nativeResult, nRows, nColumns);
        if (this.columns == null) {
            System.out.println("ResultSet fetch error");
            try {
                this.close();
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        }
        this.name = name;
        this.nRows = maxRows != 0 && maxRows < nRows ? maxRows : nRows;
    }

    public int getRowsNumber() {
        return this.nRows;
    }

    public int getColumnsNumber() {
        return this.nColumns;
    }

    @Override
    public Object getObject(int columnIndex) throws SQLException {
        this.checkNotClosed();
        if (columnIndex > this.nColumns) {
            throw new SQLException("columnIndex is not valid");
        }
        int type = this.columns[columnIndex - 1].getMonetdbeType();
        switch (type) {
            case 0: {
                return this.getBoolean(columnIndex);
            }
            case 1: {
                return this.getShort(columnIndex);
            }
            case 2: {
                return this.getShort(columnIndex);
            }
            case 3: {
                return this.getInt(columnIndex);
            }
            case 4: {
                return this.getLong(columnIndex);
            }
            case 5: {
                return this.getBigInteger(columnIndex);
            }
            case 6: {
                return this.getInt(columnIndex);
            }
            case 7: {
                return Float.valueOf(this.getFloat(columnIndex));
            }
            case 8: {
                return this.getDouble(columnIndex);
            }
            case 9: {
                return this.getString(columnIndex);
            }
            case 10: {
                return this.getBlob(columnIndex);
            }
            case 11: {
                return this.getDate(columnIndex);
            }
            case 12: {
                return this.getTime(columnIndex);
            }
            case 13: {
                return this.getTimestamp(columnIndex);
            }
        }
        return null;
    }

    @Override
    public Object getObject(int columnIndex, Map<String, Class<?>> map) throws SQLException {
        this.checkNotClosed();
        if (columnIndex > this.nColumns) {
            throw new SQLException("columnIndex is not valid");
        }
        if (map == null) {
            return this.getObject(columnIndex);
        }
        int monetdbeType = this.columns[columnIndex - 1].getMonetdbeType();
        String sqlDefaultType = MonetTypes.getSQLTypeNameFromMonet(monetdbeType);
        if (sqlDefaultType.equals("NULL")) {
            return null;
        }
        if (map.containsKey(sqlDefaultType)) {
            Class<?> convertClass = map.get(sqlDefaultType);
            return this.getObject(columnIndex, convertClass);
        }
        for (String keyType : map.keySet()) {
            if (MonetTypes.getMonetTypeIntFromSQLName(keyType) != monetdbeType) continue;
            Class<?> convertClass = map.get(keyType);
            return this.getObject(columnIndex, convertClass);
        }
        return this.getObject(columnIndex);
    }

    @Override
    public <T> T getObject(int columnIndex, Class<T> type) throws SQLException {
        this.checkNotClosed();
        if (type == null) {
            throw new SQLException("Type is null");
        }
        if (columnIndex > this.nColumns) {
            throw new SQLException("columnIndex is not valid");
        }
        int monetdbeType = this.columns[columnIndex - 1].getMonetdbeType();
        if (MonetTypes.convertTojavaClass(monetdbeType, type)) {
            Object defaultValue = this.getObject(columnIndex);
            return type.cast(defaultValue);
        }
        throw new SQLException("Conversion is not supported");
    }

    @Override
    public int findColumn(String columnLabel) throws SQLException {
        this.checkNotClosed();
        String[] names = ((MonetResultSetMetaData)this.getMetaData()).getNames();
        if (columnLabel != null) {
            int i;
            int array_size = names.length;
            for (i = 0; i < array_size; ++i) {
                if (!columnLabel.equals(names[i])) continue;
                return i + 1;
            }
            for (i = 0; i < array_size; ++i) {
                if (!columnLabel.equalsIgnoreCase(names[i])) continue;
                return i + 1;
            }
        }
        throw new SQLException("No such column name: " + columnLabel, "M1M05");
    }

    @Override
    public String getString(int columnIndex) throws SQLException {
        this.checkNotClosed();
        if (this.curRow <= 0 || this.curRow > this.nRows) {
            throw new SQLException("Current row " + this.curRow + " does not support operation");
        }
        try {
            String val = this.columns[columnIndex - 1].getString(this.curRow - 1);
            if (val == null) {
                this.lastReadWasNull = true;
                return null;
            }
            this.lastReadWasNull = false;
            return val;
        }
        catch (IndexOutOfBoundsException e) {
            throw new SQLException("columnIndex out of bounds");
        }
    }

    @Override
    public boolean getBoolean(int columnIndex) throws SQLException {
        this.checkNotClosed();
        if (this.curRow <= 0 || this.curRow > this.nRows) {
            throw new SQLException("Current row " + this.curRow + " does not support operation");
        }
        try {
            Boolean val = this.columns[columnIndex - 1].getBoolean(this.curRow - 1);
            this.lastReadWasNull = false;
            return val;
        }
        catch (IndexOutOfBoundsException e) {
            throw new SQLException("columnIndex out of bounds");
        }
    }

    @Override
    public byte getByte(int columnIndex) throws SQLException {
        this.checkNotClosed();
        if (this.curRow <= 0 || this.curRow > this.nRows) {
            throw new SQLException("Current row " + this.curRow + " does not support operation");
        }
        try {
            Byte val = this.columns[columnIndex - 1].getByte(this.curRow - 1);
            if (val == null) {
                this.lastReadWasNull = true;
                return 0;
            }
            this.lastReadWasNull = false;
            return val;
        }
        catch (IndexOutOfBoundsException e) {
            throw new SQLException("columnIndex out of bounds");
        }
    }

    @Override
    public short getShort(int columnIndex) throws SQLException {
        this.checkNotClosed();
        if (this.curRow <= 0 || this.curRow > this.nRows) {
            throw new SQLException("Current row " + this.curRow + " does not support operation");
        }
        try {
            Short val = this.columns[columnIndex - 1].getShort(this.curRow - 1);
            if (val == null) {
                this.lastReadWasNull = true;
                return 0;
            }
            this.lastReadWasNull = false;
            return val;
        }
        catch (IndexOutOfBoundsException e) {
            throw new SQLException("columnIndex out of bounds");
        }
    }

    @Override
    public int getInt(int columnIndex) throws SQLException {
        this.checkNotClosed();
        if (this.curRow <= 0 || this.curRow > this.nRows) {
            throw new SQLException("Current row " + this.curRow + " does not support operation");
        }
        try {
            Integer val = this.columns[columnIndex - 1].getInt(this.curRow - 1);
            if (val == null) {
                this.lastReadWasNull = true;
                return 0;
            }
            this.lastReadWasNull = false;
            return val;
        }
        catch (IndexOutOfBoundsException e) {
            throw new SQLException("columnIndex out of bounds");
        }
    }

    @Override
    public long getLong(int columnIndex) throws SQLException {
        this.checkNotClosed();
        if (this.curRow <= 0 || this.curRow > this.nRows) {
            throw new SQLException("Current row " + this.curRow + " does not support operation");
        }
        try {
            Long val = this.columns[columnIndex - 1].getLong(this.curRow - 1);
            if (val == null) {
                this.lastReadWasNull = true;
                return 0L;
            }
            this.lastReadWasNull = false;
            return val;
        }
        catch (IndexOutOfBoundsException e) {
            throw new SQLException("columnIndex out of bounds");
        }
    }

    @Override
    public float getFloat(int columnIndex) throws SQLException {
        this.checkNotClosed();
        if (this.curRow <= 0 || this.curRow > this.nRows) {
            throw new SQLException("Current row " + this.curRow + " does not support operation");
        }
        try {
            Float val = this.columns[columnIndex - 1].getFloat(this.curRow - 1);
            if (val.isNaN()) {
                this.lastReadWasNull = true;
                return 0.0f;
            }
            this.lastReadWasNull = false;
            return val.floatValue();
        }
        catch (IndexOutOfBoundsException e) {
            throw new SQLException("columnIndex out of bounds");
        }
    }

    @Override
    public double getDouble(int columnIndex) throws SQLException {
        this.checkNotClosed();
        if (this.curRow <= 0 || this.curRow > this.nRows) {
            throw new SQLException("Current row " + this.curRow + " does not support operation");
        }
        try {
            Double val = this.columns[columnIndex - 1].getDouble(this.curRow - 1);
            if (val.isNaN()) {
                this.lastReadWasNull = true;
                return 0.0;
            }
            this.lastReadWasNull = false;
            return val;
        }
        catch (IndexOutOfBoundsException e) {
            throw new SQLException("columnIndex out of bounds");
        }
    }

    @Override
    public byte[] getBytes(int columnIndex) throws SQLException {
        this.checkNotClosed();
        if (this.curRow <= 0 || this.curRow > this.nRows) {
            throw new SQLException("Current row " + this.curRow + " does not support operation");
        }
        try {
            byte[] val = this.columns[columnIndex - 1].getBytes(this.curRow - 1);
            if (val == null) {
                this.lastReadWasNull = true;
                return null;
            }
            this.lastReadWasNull = false;
            return val;
        }
        catch (IndexOutOfBoundsException e) {
            throw new SQLException("columnIndex out of bounds");
        }
    }

    @Override
    public BigDecimal getBigDecimal(int columnIndex) throws SQLException {
        this.checkNotClosed();
        if (this.curRow <= 0 || this.curRow > this.nRows) {
            throw new SQLException("Current row " + this.curRow + " does not support operation");
        }
        try {
            BigDecimal val = this.columns[columnIndex - 1].getBigDecimal(this.curRow - 1);
            if (val == null) {
                this.lastReadWasNull = true;
                return BigDecimal.ZERO;
            }
            this.lastReadWasNull = false;
            return val;
        }
        catch (IndexOutOfBoundsException e) {
            throw new SQLException("columnIndex out of bounds");
        }
    }

    public BigInteger getBigInteger(int columnIndex) throws SQLException {
        this.checkNotClosed();
        if (this.curRow <= 0 || this.curRow > this.nRows) {
            throw new SQLException("Current row " + this.curRow + " does not support operation");
        }
        try {
            BigInteger val = this.columns[columnIndex - 1].getBigInteger(this.curRow - 1);
            if (val == null) {
                this.lastReadWasNull = true;
                return BigInteger.ZERO;
            }
            this.lastReadWasNull = false;
            return val;
        }
        catch (IndexOutOfBoundsException e) {
            throw new SQLException("columnIndex out of bounds");
        }
    }

    public LocalDate getLocalDate(int columnIndex) throws SQLException {
        this.checkNotClosed();
        if (this.curRow <= 0 || this.curRow > this.nRows) {
            throw new SQLException("Current row " + this.curRow + " does not support operation");
        }
        try {
            LocalDate val = this.columns[columnIndex - 1].getLocalDate(this.curRow - 1);
            if (val == null) {
                this.lastReadWasNull = true;
                return null;
            }
            this.lastReadWasNull = false;
            return val;
        }
        catch (IndexOutOfBoundsException e) {
            throw new SQLException("columnIndex out of bounds");
        }
        catch (DateTimeParseException e) {
            throw new SQLException("DateTime string could not be parsed");
        }
    }

    @Override
    public Date getDate(int columnIndex, Calendar cal) throws SQLException {
        LocalDate val = this.getLocalDate(columnIndex);
        if (cal != null && val != null) {
            val = LocalDateTime.of(val, LocalTime.now()).atZone(cal.getTimeZone().toZoneId()).withZoneSameInstant(ZoneOffset.UTC).toLocalDate();
        }
        return val != null ? Date.valueOf(val) : null;
    }

    public LocalTime getLocalTime(int columnIndex) throws SQLException {
        this.checkNotClosed();
        if (this.curRow <= 0 || this.curRow > this.nRows) {
            throw new SQLException("Current row " + this.curRow + " does not support operation");
        }
        try {
            LocalTime val = this.columns[columnIndex - 1].getLocalTime(this.curRow - 1);
            if (val == null) {
                this.lastReadWasNull = true;
                return null;
            }
            this.lastReadWasNull = false;
            return val;
        }
        catch (IndexOutOfBoundsException e) {
            throw new SQLException("columnIndex out of bounds");
        }
        catch (DateTimeParseException e) {
            throw new SQLException("DateTime string could not be parsed");
        }
    }

    @Override
    public Time getTime(int columnIndex, Calendar cal) throws SQLException {
        LocalTime val = this.getLocalTime(columnIndex);
        if (cal != null && val != null) {
            val = LocalDateTime.of(LocalDate.now(), val).atZone(cal.getTimeZone().toZoneId()).withZoneSameInstant(ZoneOffset.UTC).toLocalTime();
        }
        return val != null ? Time.valueOf(val) : null;
    }

    public LocalDateTime getLocalDateTime(int columnIndex) throws SQLException {
        this.checkNotClosed();
        if (this.curRow <= 0 || this.curRow > this.nRows) {
            throw new SQLException("Current row " + this.curRow + " does not support operation");
        }
        try {
            LocalDateTime val = this.columns[columnIndex - 1].getLocalDateTime(this.curRow - 1);
            if (val == null) {
                this.lastReadWasNull = true;
                return null;
            }
            this.lastReadWasNull = false;
            return val;
        }
        catch (IndexOutOfBoundsException e) {
            throw new SQLException("columnIndex out of bounds");
        }
        catch (DateTimeParseException e) {
            throw new SQLException("DateTime string could not be parsed");
        }
    }

    @Override
    public Timestamp getTimestamp(int columnIndex, Calendar cal) throws SQLException {
        LocalDateTime val = this.getLocalDateTime(columnIndex);
        if (cal != null && val != null) {
            val = val.atZone(cal.getTimeZone().toZoneId()).withZoneSameInstant(ZoneOffset.UTC).toLocalDateTime();
        }
        return val != null ? Timestamp.valueOf(val) : null;
    }

    @Override
    public Blob getBlob(int columnIndex) throws SQLException {
        this.checkNotClosed();
        if (this.curRow <= 0 || this.curRow > this.nRows) {
            throw new SQLException("Current row " + this.curRow + " does not support operation");
        }
        try {
            MonetBlob val = this.columns[columnIndex - 1].getBlob(this.curRow - 1);
            if (val == null) {
                this.lastReadWasNull = true;
                return null;
            }
            this.lastReadWasNull = false;
            return val;
        }
        catch (IndexOutOfBoundsException e) {
            throw new SQLException("columnIndex out of bounds");
        }
    }

    @Override
    public Clob getClob(int columnIndex) throws SQLException {
        this.checkNotClosed();
        if (this.curRow <= 0 || this.curRow > this.nRows) {
            throw new SQLException("Current row " + this.curRow + " does not support operation");
        }
        try {
            String val = this.columns[columnIndex - 1].getString(this.curRow - 1);
            if (val == null) {
                this.lastReadWasNull = true;
                return null;
            }
            this.lastReadWasNull = false;
            return new MonetClob(val);
        }
        catch (IndexOutOfBoundsException e) {
            throw new SQLException("columnIndex out of bounds");
        }
    }

    @Override
    public URL getURL(int columnIndex) throws SQLException {
        this.checkNotClosed();
        if (this.curRow <= 0 || this.curRow > this.nRows) {
            throw new SQLException("Current row " + this.curRow + " does not support operation");
        }
        try {
            String val = this.columns[columnIndex - 1].getString(this.curRow - 1);
            if (val == null) {
                this.lastReadWasNull = true;
                return null;
            }
            this.lastReadWasNull = false;
            return new URL(val);
        }
        catch (IndexOutOfBoundsException e) {
            throw new SQLException("columnIndex out of bounds");
        }
        catch (MalformedURLException e) {
            throw new SQLException("column is not a valid URL");
        }
    }

    @Override
    public InputStream getBinaryStream(int columnIndex) throws SQLException {
        this.checkNotClosed();
        if (this.curRow <= 0 || this.curRow > this.nRows) {
            throw new SQLException("Current row " + this.curRow + " does not support operation");
        }
        try {
            MonetBlob val = this.columns[columnIndex - 1].getBlob(this.curRow - 1);
            if (val == null) {
                return null;
            }
            return val.getBinaryStream();
        }
        catch (IndexOutOfBoundsException e) {
            throw new SQLException("columnIndex out of bounds");
        }
    }

    @Override
    public Reader getCharacterStream(int columnIndex) throws SQLException {
        this.checkNotClosed();
        if (this.curRow <= 0 || this.curRow > this.nRows) {
            throw new SQLException("Current row " + this.curRow + " does not support operation");
        }
        try {
            String val = this.columns[columnIndex - 1].getString(this.curRow - 1);
            if (val == null) {
                this.lastReadWasNull = true;
                return null;
            }
            this.lastReadWasNull = false;
            return new StringReader(val);
        }
        catch (IndexOutOfBoundsException e) {
            throw new SQLException("columnIndex out of bounds");
        }
    }

    @Override
    public Date getDate(int columnIndex) throws SQLException {
        return this.getDate(columnIndex, null);
    }

    @Override
    public Time getTime(int columnIndex) throws SQLException {
        return this.getTime(columnIndex, null);
    }

    @Override
    public Timestamp getTimestamp(int columnIndex) throws SQLException {
        return this.getTimestamp(columnIndex, null);
    }

    private void checkNotClosed() throws SQLException {
        if (this.isClosed()) {
            throw new SQLException("ResultSet is closed", "M1M20");
        }
    }

    @Override
    public boolean isClosed() throws SQLException {
        return this.closed;
    }

    @Override
    public void close() throws SQLException {
        if (this.isClosed()) {
            return;
        }
        String error_msg = MonetNative.monetdbe_result_cleanup(((MonetConnection)this.statement.getConnection()).getDbNative(), this.nativeResult);
        if (error_msg != null) {
            throw new SQLException(error_msg);
        }
        this.closed = true;
        this.columns = null;
        this.statement.closeIfComplete();
    }

    @Override
    public ResultSetMetaData getMetaData() throws SQLException {
        this.checkNotClosed();
        if (this.metaData == null) {
            this.metaData = new MonetResultSetMetaData(this.columns, this.nColumns);
        }
        return this.metaData;
    }

    @Override
    public boolean absolute(int row) throws SQLException {
        this.checkNotClosed();
        if (this.resultSetType == 1003) {
            throw new SQLException("(Absolute) positioning not allowed on forward  only result sets!", "M1M05");
        }
        if (row < 0) {
            row = this.nRows + row + 1;
        } else {
            if (row == 0) {
                this.curRow = 0;
                return false;
            }
            if (row > this.nRows) {
                this.curRow = this.nRows + 1;
                return false;
            }
        }
        this.curRow = row;
        return true;
    }

    @Override
    public boolean relative(int rows) throws SQLException {
        return this.absolute(this.curRow + rows);
    }

    @Override
    public boolean next() throws SQLException {
        return this.relative(1);
    }

    @Override
    public boolean previous() throws SQLException {
        return this.relative(-1);
    }

    @Override
    public boolean isBeforeFirst() throws SQLException {
        this.checkNotClosed();
        return this.curRow == 0;
    }

    @Override
    public boolean isAfterLast() throws SQLException {
        this.checkNotClosed();
        return this.curRow == this.nRows + 1;
    }

    @Override
    public boolean isFirst() throws SQLException {
        this.checkNotClosed();
        return this.curRow == 1;
    }

    @Override
    public boolean isLast() throws SQLException {
        this.checkNotClosed();
        return this.curRow == this.nRows;
    }

    @Override
    public void beforeFirst() throws SQLException {
        this.absolute(0);
    }

    @Override
    public void afterLast() throws SQLException {
        this.absolute(this.nRows + 1);
    }

    @Override
    public boolean first() throws SQLException {
        return this.absolute(1);
    }

    @Override
    public boolean last() throws SQLException {
        return this.absolute(this.nRows);
    }

    @Override
    public Statement getStatement() throws SQLException {
        this.checkNotClosed();
        return this.statement;
    }

    @Override
    public int getRow() throws SQLException {
        this.checkNotClosed();
        return this.curRow;
    }

    @Override
    public int getType() throws SQLException {
        this.checkNotClosed();
        return this.resultSetType;
    }

    @Override
    public int getConcurrency() throws SQLException {
        this.checkNotClosed();
        return this.concurrency;
    }

    @Override
    public boolean wasNull() throws SQLException {
        this.checkNotClosed();
        return this.lastReadWasNull;
    }

    @Override
    public int getHoldability() throws SQLException {
        this.checkNotClosed();
        return this.resultSetHoldability;
    }

    @Override
    public void setFetchDirection(int direction) throws SQLException {
        this.checkNotClosed();
        this.fetchDirection = direction;
    }

    @Override
    public int getFetchDirection() throws SQLException {
        this.checkNotClosed();
        return this.fetchDirection;
    }

    @Override
    public void setFetchSize(int rows) throws SQLException {
        this.checkNotClosed();
        this.fetchSize = rows;
    }

    @Override
    public int getFetchSize() throws SQLException {
        this.checkNotClosed();
        return this.fetchSize;
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        this.checkNotClosed();
        return this.warnings;
    }

    @Override
    public void clearWarnings() throws SQLException {
        this.checkNotClosed();
        this.warnings = new SQLWarning();
    }

    private final void addWarning(String reason, String sqlstate) {
        SQLWarning warn = new SQLWarning(reason, sqlstate);
        if (this.warnings == null) {
            this.warnings = warn;
        } else {
            this.warnings.setNextWarning(warn);
        }
    }

    @Override
    public String getCursorName() throws SQLException {
        this.checkNotClosed();
        return this.name;
    }

    @Override
    @Deprecated
    public BigDecimal getBigDecimal(int columnIndex, int scale) throws SQLException {
        this.checkNotClosed();
        if (scale != 0) {
            this.addWarning("getBigDecimal(int columnIndex, int scale) is deprecated. Please use getBigDecimal(int columnIndex).setScale(int scale)", "");
            return null;
        }
        return this.getBigDecimal(columnIndex);
    }

    @Override
    public String getNString(int columnIndex) throws SQLException {
        return this.getString(columnIndex);
    }

    @Override
    public Reader getNCharacterStream(int columnIndex) throws SQLException {
        return this.getCharacterStream(columnIndex);
    }

    @Override
    public Object getObject(String columnLabel) throws SQLException {
        return this.getObject(this.findColumn(columnLabel));
    }

    @Override
    public Object getObject(String columnLabel, Map<String, Class<?>> map) throws SQLException {
        return this.getObject(this.findColumn(columnLabel), map);
    }

    @Override
    public <T> T getObject(String columnLabel, Class<T> type) throws SQLException {
        return this.getObject(this.findColumn(columnLabel), type);
    }

    @Override
    public String getString(String columnLabel) throws SQLException {
        return this.getString(this.findColumn(columnLabel));
    }

    @Override
    public boolean getBoolean(String columnLabel) throws SQLException {
        return this.getBoolean(this.findColumn(columnLabel));
    }

    @Override
    public byte getByte(String columnLabel) throws SQLException {
        return this.getByte(this.findColumn(columnLabel));
    }

    @Override
    public short getShort(String columnLabel) throws SQLException {
        return this.getShort(this.findColumn(columnLabel));
    }

    @Override
    public int getInt(String columnLabel) throws SQLException {
        return this.getInt(this.findColumn(columnLabel));
    }

    @Override
    public long getLong(String columnLabel) throws SQLException {
        return this.getLong(this.findColumn(columnLabel));
    }

    @Override
    public float getFloat(String columnLabel) throws SQLException {
        return this.getFloat(this.findColumn(columnLabel));
    }

    @Override
    public double getDouble(String columnLabel) throws SQLException {
        return this.getDouble(this.findColumn(columnLabel));
    }

    @Override
    @Deprecated
    public BigDecimal getBigDecimal(String columnLabel, int scale) throws SQLException {
        return this.getBigDecimal(this.findColumn(columnLabel), scale);
    }

    @Override
    public BigDecimal getBigDecimal(String columnLabel) throws SQLException {
        return this.getBigDecimal(this.findColumn(columnLabel));
    }

    @Override
    public byte[] getBytes(String columnLabel) throws SQLException {
        return this.getBytes(this.findColumn(columnLabel));
    }

    @Override
    public Date getDate(String columnLabel) throws SQLException {
        return this.getDate(this.findColumn(columnLabel));
    }

    @Override
    public Time getTime(String columnLabel) throws SQLException {
        return this.getTime(this.findColumn(columnLabel));
    }

    @Override
    public Timestamp getTimestamp(String columnLabel) throws SQLException {
        return this.getTimestamp(this.findColumn(columnLabel));
    }

    @Override
    public Blob getBlob(String columnLabel) throws SQLException {
        return this.getBlob(this.findColumn(columnLabel));
    }

    @Override
    public Clob getClob(String columnLabel) throws SQLException {
        return this.getClob(this.findColumn(columnLabel));
    }

    @Override
    public URL getURL(String columnLabel) throws SQLException {
        return this.getURL(this.findColumn(columnLabel));
    }

    @Override
    public String getNString(String columnLabel) throws SQLException {
        return this.getNString(this.findColumn(columnLabel));
    }

    @Override
    public InputStream getBinaryStream(String columnLabel) throws SQLException {
        return this.getBinaryStream(this.findColumn(columnLabel));
    }

    @Override
    public Reader getCharacterStream(String columnLabel) throws SQLException {
        return this.getCharacterStream(this.findColumn(columnLabel));
    }

    @Override
    public Reader getNCharacterStream(String columnLabel) throws SQLException {
        return this.getNCharacterStream(this.findColumn(columnLabel));
    }

    @Override
    public Date getDate(String columnLabel, Calendar cal) throws SQLException {
        return this.getDate(this.findColumn(columnLabel), cal);
    }

    @Override
    public Time getTime(String columnLabel, Calendar cal) throws SQLException {
        return this.getTime(this.findColumn(columnLabel), cal);
    }

    @Override
    public Timestamp getTimestamp(String columnLabel, Calendar cal) throws SQLException {
        return this.getTimestamp(this.findColumn(columnLabel), cal);
    }

    public BigInteger getBigInteger(String columnLabel) throws SQLException {
        return this.getBigInteger(this.findColumn(columnLabel));
    }

    @Override
    public NClob getNClob(int columnIndex) throws SQLException {
        throw new SQLFeatureNotSupportedException("getNClob");
    }

    @Override
    public SQLXML getSQLXML(int columnIndex) throws SQLException {
        throw new SQLFeatureNotSupportedException("getSQLXML");
    }

    @Override
    public InputStream getAsciiStream(int columnIndex) throws SQLException {
        throw new SQLFeatureNotSupportedException("getAsciiStream");
    }

    @Override
    public InputStream getUnicodeStream(int columnIndex) throws SQLException {
        throw new SQLFeatureNotSupportedException("getUnicodeStream");
    }

    @Override
    public RowId getRowId(int columnIndex) throws SQLException {
        throw new SQLFeatureNotSupportedException("rowId");
    }

    @Override
    public Array getArray(int columnIndex) throws SQLException {
        throw new SQLFeatureNotSupportedException("getArray");
    }

    @Override
    public Ref getRef(int columnIndex) throws SQLException {
        throw new SQLFeatureNotSupportedException("getRef");
    }

    @Override
    public Ref getRef(String columnLabel) throws SQLException {
        return this.getRef(this.findColumn(columnLabel));
    }

    @Override
    public Array getArray(String columnLabel) throws SQLException {
        return this.getArray(this.findColumn(columnLabel));
    }

    @Override
    public RowId getRowId(String columnLabel) throws SQLException {
        return this.getRowId(this.findColumn(columnLabel));
    }

    @Override
    public NClob getNClob(String columnLabel) throws SQLException {
        return this.getNClob(this.findColumn(columnLabel));
    }

    @Override
    public SQLXML getSQLXML(String columnLabel) throws SQLException {
        return this.getSQLXML(this.findColumn(columnLabel));
    }

    @Override
    public InputStream getAsciiStream(String columnLabel) throws SQLException {
        return this.getAsciiStream(this.findColumn(columnLabel));
    }

    @Override
    public InputStream getUnicodeStream(String columnLabel) throws SQLException {
        return this.getUnicodeStream(this.findColumn(columnLabel));
    }

    @Override
    public boolean rowUpdated() throws SQLException {
        throw new SQLFeatureNotSupportedException("update");
    }

    @Override
    public boolean rowInserted() throws SQLException {
        throw new SQLFeatureNotSupportedException("update");
    }

    @Override
    public boolean rowDeleted() throws SQLException {
        throw new SQLFeatureNotSupportedException("update");
    }

    @Override
    public void updateObject(int columnIndex, Object x, SQLType targetSqlType, int scaleOrLength) throws SQLException {
        throw new SQLFeatureNotSupportedException("update");
    }

    @Override
    public void updateObject(String columnLabel, Object x, SQLType targetSqlType, int scaleOrLength) throws SQLException {
        throw new SQLFeatureNotSupportedException("update");
    }

    @Override
    public void updateObject(int columnIndex, Object x, SQLType targetSqlType) throws SQLException {
        throw new SQLFeatureNotSupportedException("update");
    }

    @Override
    public void updateObject(String columnLabel, Object x, SQLType targetSqlType) throws SQLException {
        throw new SQLFeatureNotSupportedException("update");
    }

    @Override
    public void updateNull(int columnIndex) throws SQLException {
        throw new SQLFeatureNotSupportedException("update");
    }

    @Override
    public void updateBoolean(int columnIndex, boolean x) throws SQLException {
        throw new SQLFeatureNotSupportedException("update");
    }

    @Override
    public void updateByte(int columnIndex, byte x) throws SQLException {
        throw new SQLFeatureNotSupportedException("update");
    }

    @Override
    public void updateShort(int columnIndex, short x) throws SQLException {
        throw new SQLFeatureNotSupportedException("update");
    }

    @Override
    public void updateInt(int columnIndex, int x) throws SQLException {
        throw new SQLFeatureNotSupportedException("update");
    }

    @Override
    public void updateLong(int columnIndex, long x) throws SQLException {
        throw new SQLFeatureNotSupportedException("update");
    }

    @Override
    public void updateFloat(int columnIndex, float x) throws SQLException {
        throw new SQLFeatureNotSupportedException("update");
    }

    @Override
    public void updateDouble(int columnIndex, double x) throws SQLException {
        throw new SQLFeatureNotSupportedException("update");
    }

    @Override
    public void updateBigDecimal(int columnIndex, BigDecimal x) throws SQLException {
        throw new SQLFeatureNotSupportedException("update");
    }

    @Override
    public void updateString(int columnIndex, String x) throws SQLException {
        throw new SQLFeatureNotSupportedException("update");
    }

    @Override
    public void updateBytes(int columnIndex, byte[] x) throws SQLException {
        throw new SQLFeatureNotSupportedException("update");
    }

    @Override
    public void updateDate(int columnIndex, Date x) throws SQLException {
        throw new SQLFeatureNotSupportedException("update");
    }

    @Override
    public void updateTime(int columnIndex, Time x) throws SQLException {
        throw new SQLFeatureNotSupportedException("update");
    }

    @Override
    public void updateTimestamp(int columnIndex, Timestamp x) throws SQLException {
        throw new SQLFeatureNotSupportedException("update");
    }

    @Override
    public void updateAsciiStream(int columnIndex, InputStream x, int length) throws SQLException {
        throw new SQLFeatureNotSupportedException("update");
    }

    @Override
    public void updateBinaryStream(int columnIndex, InputStream x, int length) throws SQLException {
        throw new SQLFeatureNotSupportedException("update");
    }

    @Override
    public void updateCharacterStream(int columnIndex, Reader x, int length) throws SQLException {
        throw new SQLFeatureNotSupportedException("update");
    }

    @Override
    public void updateObject(int columnIndex, Object x, int scaleOrLength) throws SQLException {
        throw new SQLFeatureNotSupportedException("update");
    }

    @Override
    public void updateObject(int columnIndex, Object x) throws SQLException {
        throw new SQLFeatureNotSupportedException("update");
    }

    @Override
    public void updateNull(String columnLabel) throws SQLException {
        throw new SQLFeatureNotSupportedException("update");
    }

    @Override
    public void updateBoolean(String columnLabel, boolean x) throws SQLException {
        throw new SQLFeatureNotSupportedException("update");
    }

    @Override
    public void updateByte(String columnLabel, byte x) throws SQLException {
        throw new SQLFeatureNotSupportedException("update");
    }

    @Override
    public void updateShort(String columnLabel, short x) throws SQLException {
        throw new SQLFeatureNotSupportedException("update");
    }

    @Override
    public void updateInt(String columnLabel, int x) throws SQLException {
        throw new SQLFeatureNotSupportedException("update");
    }

    @Override
    public void updateLong(String columnLabel, long x) throws SQLException {
        throw new SQLFeatureNotSupportedException("update");
    }

    @Override
    public void updateFloat(String columnLabel, float x) throws SQLException {
        throw new SQLFeatureNotSupportedException("update");
    }

    @Override
    public void updateDouble(String columnLabel, double x) throws SQLException {
        throw new SQLFeatureNotSupportedException("update");
    }

    @Override
    public void updateBigDecimal(String columnLabel, BigDecimal x) throws SQLException {
        throw new SQLFeatureNotSupportedException("update");
    }

    @Override
    public void updateString(String columnLabel, String x) throws SQLException {
        throw new SQLFeatureNotSupportedException("update");
    }

    @Override
    public void updateBytes(String columnLabel, byte[] x) throws SQLException {
        throw new SQLFeatureNotSupportedException("update");
    }

    @Override
    public void updateDate(String columnLabel, Date x) throws SQLException {
        throw new SQLFeatureNotSupportedException("update");
    }

    @Override
    public void updateTime(String columnLabel, Time x) throws SQLException {
        throw new SQLFeatureNotSupportedException("update");
    }

    @Override
    public void updateTimestamp(String columnLabel, Timestamp x) throws SQLException {
        throw new SQLFeatureNotSupportedException("update");
    }

    @Override
    public void updateAsciiStream(String columnLabel, InputStream x, int length) throws SQLException {
        throw new SQLFeatureNotSupportedException("update");
    }

    @Override
    public void updateBinaryStream(String columnLabel, InputStream x, int length) throws SQLException {
        throw new SQLFeatureNotSupportedException("update");
    }

    @Override
    public void updateCharacterStream(String columnLabel, Reader reader, int length) throws SQLException {
        throw new SQLFeatureNotSupportedException("update");
    }

    @Override
    public void updateObject(String columnLabel, Object x, int scaleOrLength) throws SQLException {
        throw new SQLFeatureNotSupportedException("update");
    }

    @Override
    public void updateObject(String columnLabel, Object x) throws SQLException {
        throw new SQLFeatureNotSupportedException("update");
    }

    @Override
    public void insertRow() throws SQLException {
        throw new SQLFeatureNotSupportedException("update");
    }

    @Override
    public void updateRow() throws SQLException {
        throw new SQLFeatureNotSupportedException("update");
    }

    @Override
    public void deleteRow() throws SQLException {
        throw new SQLFeatureNotSupportedException("update");
    }

    @Override
    public void refreshRow() throws SQLException {
        throw new SQLFeatureNotSupportedException("update");
    }

    @Override
    public void cancelRowUpdates() throws SQLException {
        throw new SQLFeatureNotSupportedException("update");
    }

    @Override
    public void moveToInsertRow() throws SQLException {
        throw new SQLFeatureNotSupportedException("update");
    }

    @Override
    public void moveToCurrentRow() throws SQLException {
        throw new SQLFeatureNotSupportedException("update");
    }

    @Override
    public void updateRef(int columnIndex, Ref x) throws SQLException {
        throw new SQLFeatureNotSupportedException("update");
    }

    @Override
    public void updateRef(String columnLabel, Ref x) throws SQLException {
        throw new SQLFeatureNotSupportedException("update");
    }

    @Override
    public void updateBlob(int columnIndex, Blob x) throws SQLException {
        throw new SQLFeatureNotSupportedException("update");
    }

    @Override
    public void updateBlob(String columnLabel, Blob x) throws SQLException {
        throw new SQLFeatureNotSupportedException("update");
    }

    @Override
    public void updateClob(int columnIndex, Clob x) throws SQLException {
        throw new SQLFeatureNotSupportedException("update");
    }

    @Override
    public void updateClob(String columnLabel, Clob x) throws SQLException {
        throw new SQLFeatureNotSupportedException("update");
    }

    @Override
    public void updateArray(int columnIndex, Array x) throws SQLException {
        throw new SQLFeatureNotSupportedException("update");
    }

    @Override
    public void updateArray(String columnLabel, Array x) throws SQLException {
        throw new SQLFeatureNotSupportedException("update");
    }

    @Override
    public void updateRowId(int columnIndex, RowId x) throws SQLException {
        throw new SQLFeatureNotSupportedException("update");
    }

    @Override
    public void updateRowId(String columnLabel, RowId x) throws SQLException {
        throw new SQLFeatureNotSupportedException("update");
    }

    @Override
    public void updateNString(int columnIndex, String nString) throws SQLException {
        throw new SQLFeatureNotSupportedException("update");
    }

    @Override
    public void updateNString(String columnLabel, String nString) throws SQLException {
        throw new SQLFeatureNotSupportedException("update");
    }

    @Override
    public void updateNClob(int columnIndex, NClob nClob) throws SQLException {
        throw new SQLFeatureNotSupportedException("update");
    }

    @Override
    public void updateNClob(String columnLabel, NClob nClob) throws SQLException {
        throw new SQLFeatureNotSupportedException("update");
    }

    @Override
    public void updateSQLXML(int columnIndex, SQLXML xmlObject) throws SQLException {
        throw new SQLFeatureNotSupportedException("update");
    }

    @Override
    public void updateSQLXML(String columnLabel, SQLXML xmlObject) throws SQLException {
        throw new SQLFeatureNotSupportedException("update");
    }

    @Override
    public void updateNCharacterStream(int columnIndex, Reader x, long length) throws SQLException {
        throw new SQLFeatureNotSupportedException("update");
    }

    @Override
    public void updateNCharacterStream(String columnLabel, Reader reader, long length) throws SQLException {
        throw new SQLFeatureNotSupportedException("update");
    }

    @Override
    public void updateAsciiStream(int columnIndex, InputStream x, long length) throws SQLException {
        throw new SQLFeatureNotSupportedException("update");
    }

    @Override
    public void updateBinaryStream(int columnIndex, InputStream x, long length) throws SQLException {
        throw new SQLFeatureNotSupportedException("update");
    }

    @Override
    public void updateCharacterStream(int columnIndex, Reader x, long length) throws SQLException {
        throw new SQLFeatureNotSupportedException("update");
    }

    @Override
    public void updateAsciiStream(String columnLabel, InputStream x, long length) throws SQLException {
        throw new SQLFeatureNotSupportedException("update");
    }

    @Override
    public void updateBinaryStream(String columnLabel, InputStream x, long length) throws SQLException {
        throw new SQLFeatureNotSupportedException("update");
    }

    @Override
    public void updateCharacterStream(String columnLabel, Reader reader, long length) throws SQLException {
        throw new SQLFeatureNotSupportedException("update");
    }

    @Override
    public void updateBlob(int columnIndex, InputStream inputStream, long length) throws SQLException {
        throw new SQLFeatureNotSupportedException("update");
    }

    @Override
    public void updateBlob(String columnLabel, InputStream inputStream, long length) throws SQLException {
        throw new SQLFeatureNotSupportedException("update");
    }

    @Override
    public void updateClob(int columnIndex, Reader reader, long length) throws SQLException {
        throw new SQLFeatureNotSupportedException("update");
    }

    @Override
    public void updateClob(String columnLabel, Reader reader, long length) throws SQLException {
        throw new SQLFeatureNotSupportedException("update");
    }

    @Override
    public void updateNClob(int columnIndex, Reader reader, long length) throws SQLException {
        throw new SQLFeatureNotSupportedException("update");
    }

    @Override
    public void updateNClob(String columnLabel, Reader reader, long length) throws SQLException {
        throw new SQLFeatureNotSupportedException("update");
    }

    @Override
    public void updateNCharacterStream(int columnIndex, Reader x) throws SQLException {
        throw new SQLFeatureNotSupportedException("update");
    }

    @Override
    public void updateNCharacterStream(String columnLabel, Reader reader) throws SQLException {
        throw new SQLFeatureNotSupportedException("update");
    }

    @Override
    public void updateAsciiStream(int columnIndex, InputStream x) throws SQLException {
        throw new SQLFeatureNotSupportedException("update");
    }

    @Override
    public void updateBinaryStream(int columnIndex, InputStream x) throws SQLException {
        throw new SQLFeatureNotSupportedException("update");
    }

    @Override
    public void updateCharacterStream(int columnIndex, Reader x) throws SQLException {
        throw new SQLFeatureNotSupportedException("update");
    }

    @Override
    public void updateAsciiStream(String columnLabel, InputStream x) throws SQLException {
        throw new SQLFeatureNotSupportedException("update");
    }

    @Override
    public void updateBinaryStream(String columnLabel, InputStream x) throws SQLException {
        throw new SQLFeatureNotSupportedException("update");
    }

    @Override
    public void updateCharacterStream(String columnLabel, Reader reader) throws SQLException {
        throw new SQLFeatureNotSupportedException("update");
    }

    @Override
    public void updateBlob(int columnIndex, InputStream inputStream) throws SQLException {
        throw new SQLFeatureNotSupportedException("update");
    }

    @Override
    public void updateBlob(String columnLabel, InputStream inputStream) throws SQLException {
        throw new SQLFeatureNotSupportedException("update");
    }

    @Override
    public void updateClob(int columnIndex, Reader reader) throws SQLException {
        throw new SQLFeatureNotSupportedException("update");
    }

    @Override
    public void updateClob(String columnLabel, Reader reader) throws SQLException {
        throw new SQLFeatureNotSupportedException("update");
    }

    @Override
    public void updateNClob(int columnIndex, Reader reader) throws SQLException {
        throw new SQLFeatureNotSupportedException("update");
    }

    @Override
    public void updateNClob(String columnLabel, Reader reader) throws SQLException {
        throw new SQLFeatureNotSupportedException("update");
    }
}

