/*
 * Decompiled with CFR 0.152.
 */
package org.monetdb.monetdbe;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.RoundingMode;
import java.net.URL;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.sql.Array;
import java.sql.BatchUpdateException;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.NClob;
import java.sql.ParameterMetaData;
import java.sql.PreparedStatement;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.sql.SQLType;
import java.sql.SQLXML;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZoneOffset;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import org.monetdb.monetdbe.MonetBlob;
import org.monetdb.monetdbe.MonetConnection;
import org.monetdb.monetdbe.MonetNative;
import org.monetdb.monetdbe.MonetParameterMetaData;
import org.monetdb.monetdbe.MonetResultSet;
import org.monetdb.monetdbe.MonetStatement;
import org.monetdb.monetdbe.MonetTypes;

public class MonetPreparedStatement
extends MonetStatement
implements PreparedStatement {
    protected ByteBuffer statementNative;
    private MonetParameterMetaData parameterMetaData;
    protected int nParams;
    protected int[] monetdbeTypes;
    private Object[] parameters;
    private List<Object[]> parametersBatch = null;

    public MonetPreparedStatement(MonetConnection conn, String sql) {
        super(conn);
        String error_msg = MonetNative.monetdbe_prepare(conn.getDbNative(), sql, this);
        if (this.statementNative == null || error_msg != null) {
            System.out.println("Prepare statement error: " + error_msg);
            try {
                this.close();
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        }
        if (this.nParams >= 0) {
            this.parameterMetaData = new MonetParameterMetaData(this.nParams, this.monetdbeTypes);
            this.parameters = new Object[this.nParams];
        }
    }

    @Override
    public boolean execute() throws SQLException {
        this.checkNotClosed();
        int lastUpdateCount = this.updateCount;
        MonetResultSet lastResultSet = this.resultSet;
        this.resultSet = null;
        this.updateCount = -1;
        String error_msg = MonetNative.monetdbe_execute(this.statementNative, this, false, this.getMaxRows());
        if (error_msg != null) {
            this.updateCount = lastUpdateCount;
            this.resultSet = lastResultSet;
            throw new SQLException(error_msg);
        }
        if (this.resultSet != null) {
            return true;
        }
        if (this.updateCount >= 0 || this.updateCount == -2) {
            return false;
        }
        throw new SQLException("No update count or result set returned");
    }

    @Override
    public boolean execute(String q) throws SQLException {
        throw new SQLException("This method is not available in a PreparedStatement!", "M1M05");
    }

    @Override
    public ResultSet executeQuery() throws SQLException {
        if (!this.execute()) {
            throw new SQLException("Query did not produce a result set", "M1M19");
        }
        return this.getResultSet();
    }

    @Override
    public ResultSet executeQuery(String q) throws SQLException {
        throw new SQLException("This method is not available in a PreparedStatement!", "M1M05");
    }

    @Override
    public int executeUpdate() throws SQLException {
        if (this.execute()) {
            throw new SQLException("Query produced a result set", "M1M17");
        }
        return this.getUpdateCount();
    }

    @Override
    public int executeUpdate(String q) throws SQLException {
        throw new SQLException("This method is not available in a PreparedStatement!", "M1M05");
    }

    @Override
    public void addBatch() throws SQLException {
        this.checkNotClosed();
        if (this.parametersBatch == null) {
            this.parametersBatch = new ArrayList<Object[]>();
        }
        this.parametersBatch.add(this.parameters);
        this.parameters = new Object[this.nParams];
    }

    @Override
    public void addBatch(String q) throws SQLException {
        throw new SQLException("This method is not available in a PreparedStatement!", "M1M05");
    }

    @Override
    public int[] executeBatch() throws SQLException {
        this.checkNotClosed();
        if (this.parametersBatch == null || this.parametersBatch.isEmpty()) {
            return new int[0];
        }
        int[] counts = new int[this.parametersBatch.size()];
        int count = -1;
        for (int i = 0; i < this.parametersBatch.size(); ++i) {
            Object[] cur_batch = this.parametersBatch.get(i);
            for (int j = 0; j < this.nParams; ++j) {
                this.setObject(j + 1, cur_batch[j]);
            }
            try {
                count = this.executeUpdate();
            }
            catch (SQLException e) {
                throw new BatchUpdateException();
            }
            counts[i] = count >= 0 ? count : -2;
        }
        this.clearBatch();
        return counts;
    }

    @Override
    public long[] executeLargeBatch() throws SQLException {
        this.checkNotClosed();
        if (this.parametersBatch == null || this.parametersBatch.isEmpty()) {
            return new long[0];
        }
        long[] counts = new long[this.parametersBatch.size()];
        long count = -1L;
        for (int i = 0; i < this.parametersBatch.size(); ++i) {
            Object[] cur_batch = this.parametersBatch.get(i);
            for (int j = 0; j < this.nParams; ++j) {
                this.setObject(j + 1, cur_batch[j]);
            }
            try {
                count = this.executeLargeUpdate();
            }
            catch (SQLException e) {
                throw new BatchUpdateException();
            }
            counts[i] = count >= 0L ? count : -2L;
        }
        this.clearBatch();
        return counts;
    }

    @Override
    public void clearBatch() throws SQLException {
        this.checkNotClosed();
        this.parametersBatch = null;
    }

    @Override
    public long executeLargeUpdate() throws SQLException {
        this.checkNotClosed();
        long lastUpdateCount = this.largeUpdateCount;
        MonetResultSet lastResultSet = this.resultSet;
        this.resultSet = null;
        this.largeUpdateCount = -1L;
        String error_msg = MonetNative.monetdbe_execute(this.statementNative, this, true, this.getMaxRows());
        if (error_msg != null) {
            this.largeUpdateCount = lastUpdateCount;
            this.resultSet = lastResultSet;
            throw new SQLException(error_msg);
        }
        if (this.resultSet != null) {
            throw new SQLException("Query produced a result set", "M1M17");
        }
        return this.getLargeUpdateCount();
    }

    @Override
    public ResultSetMetaData getMetaData() throws SQLException {
        this.checkNotClosed();
        return null;
    }

    @Override
    public ParameterMetaData getParameterMetaData() throws SQLException {
        this.checkNotClosed();
        return this.parameterMetaData;
    }

    @Override
    public void clearParameters() throws SQLException {
        this.checkNotClosed();
        MonetNative.monetdbe_cleanup_statement(this.conn.getDbNative(), this.statementNative);
        this.close();
    }

    @Override
    public void setObject(int parameterIndex, Object x, int targetSqlType, int scaleOrLength) throws SQLException {
        block15: {
            block19: {
                block18: {
                    block17: {
                        block16: {
                            block14: {
                                this.checkNotClosed();
                                if (parameterIndex > this.nParams) {
                                    throw new SQLException("parameterIndex is not valid");
                                }
                                if (x == null) {
                                    this.setNull(parameterIndex, targetSqlType);
                                }
                                if (!(x instanceof String)) break block14;
                                this.setString(parameterIndex, String.valueOf(x));
                                break block15;
                            }
                            if (!(x instanceof BigDecimal) && !(x instanceof Byte) && !(x instanceof Short) && !(x instanceof Integer) && !(x instanceof Long) && !(x instanceof Float) && !(x instanceof Double)) break block16;
                            Number num = (Number)x;
                            this.setObjectNum(parameterIndex, targetSqlType, num, x, scaleOrLength);
                            break block15;
                        }
                        if (!(x instanceof Boolean)) break block17;
                        boolean bool = (Boolean)x;
                        this.setObjectBool(parameterIndex, targetSqlType, bool);
                        break block15;
                    }
                    if (!(x instanceof BigInteger)) break block18;
                    BigInteger num = (BigInteger)x;
                    switch (targetSqlType) {
                        case -5: {
                            this.setLong(parameterIndex, num.longValue());
                            break;
                        }
                        case -1: 
                        case 1: 
                        case 12: {
                            this.setString(parameterIndex, num.toString());
                            break;
                        }
                        default: {
                            throw new SQLException("Conversion not allowed", "M1M05");
                        }
                    }
                    break block15;
                }
                if (!(x instanceof byte[])) break block19;
                switch (targetSqlType) {
                    case -4: 
                    case -3: 
                    case -2: {
                        this.setBytes(parameterIndex, (byte[])x);
                        break block15;
                    }
                    default: {
                        throw new SQLException("Conversion not allowed", "M1M05");
                    }
                }
            }
            if (x instanceof Date || x instanceof Timestamp || x instanceof Time || x instanceof Calendar || x instanceof java.util.Date || x instanceof LocalDate || x instanceof LocalTime || x instanceof LocalDateTime) {
                this.setObjectDate(parameterIndex, targetSqlType, x);
            } else if (x instanceof MonetBlob || x instanceof Blob) {
                this.setBlob(parameterIndex, (Blob)x);
            } else if (x instanceof URL) {
                this.setURL(parameterIndex, (URL)x);
            }
        }
    }

    private void setObjectBool(int parameterIndex, int sqlType, Boolean bool) throws SQLException {
        switch (sqlType) {
            case -6: {
                this.setByte(parameterIndex, (byte)(bool != false ? 1 : 0));
                break;
            }
            case 5: {
                this.setShort(parameterIndex, (short)(bool != false ? 1 : 0));
                break;
            }
            case 4: {
                this.setInt(parameterIndex, bool != false ? 1 : 0);
                break;
            }
            case -5: {
                this.setLong(parameterIndex, bool != false ? 1 : 0);
                break;
            }
            case 6: 
            case 7: {
                this.setFloat(parameterIndex, (float)(bool != false ? 1.0 : 0.0));
                break;
            }
            case 8: {
                this.setDouble(parameterIndex, bool != false ? 1.0 : 0.0);
                break;
            }
            case 2: 
            case 3: {
                BigDecimal dec;
                try {
                    dec = new BigDecimal(bool != false ? 1.0 : 0.0);
                }
                catch (NumberFormatException e) {
                    throw new SQLException("Internal error: unable to create template BigDecimal: " + e.getMessage(), "M0M03");
                }
                this.setBigDecimal(parameterIndex, dec);
                break;
            }
            case -7: 
            case 16: {
                this.setBoolean(parameterIndex, bool);
                break;
            }
            case -1: 
            case 1: 
            case 12: {
                this.setString(parameterIndex, bool.toString());
                break;
            }
            default: {
                throw new SQLException("Conversion not allowed", "M1M05");
            }
        }
    }

    private void setObjectNum(int parameterIndex, int sqlType, Number num, Object x, int scale) throws SQLException {
        switch (sqlType) {
            case -6: {
                this.setByte(parameterIndex, num.byteValue());
                break;
            }
            case 5: {
                this.setShort(parameterIndex, num.shortValue());
                break;
            }
            case 4: {
                this.setInt(parameterIndex, num.intValue());
                break;
            }
            case -5: {
                this.setLong(parameterIndex, num.longValue());
                break;
            }
            case 6: 
            case 7: {
                this.setFloat(parameterIndex, num.floatValue());
                break;
            }
            case 8: {
                this.setDouble(parameterIndex, num.doubleValue());
                break;
            }
            case 2: 
            case 3: {
                if (x instanceof BigDecimal) {
                    this.setBigDecimal(parameterIndex, (BigDecimal)x);
                    break;
                }
                if (scale == 0) {
                    this.setBigDecimal(parameterIndex, new BigDecimal(num.doubleValue()));
                    break;
                }
                this.setBigDecimal(parameterIndex, new BigDecimal(num.doubleValue()).setScale(scale, RoundingMode.HALF_UP));
                break;
            }
            case -7: 
            case 16: {
                if (num.doubleValue() != 0.0) {
                    this.setBoolean(parameterIndex, true);
                    break;
                }
                this.setBoolean(parameterIndex, false);
                break;
            }
            case -1: 
            case 1: 
            case 12: {
                this.setString(parameterIndex, num.toString());
                break;
            }
            default: {
                throw new SQLException("Conversion not allowed", "M1M05");
            }
        }
    }

    private void setObjectDate(int parameterIndex, int sqlType, Object x) throws SQLException {
        switch (sqlType) {
            case 91: {
                if (x instanceof Date) {
                    this.setDate(parameterIndex, (Date)x);
                    break;
                }
                if (x instanceof Timestamp) {
                    this.setDate(parameterIndex, new Date(((Timestamp)x).getTime()));
                    break;
                }
                if (x instanceof java.util.Date) {
                    this.setDate(parameterIndex, new Date(((java.util.Date)x).getTime()));
                    break;
                }
                if (x instanceof Calendar) {
                    this.setDate(parameterIndex, new Date(((Calendar)x).getTimeInMillis()));
                    break;
                }
                if (x instanceof LocalDate) {
                    this.setDate(parameterIndex, Date.valueOf((LocalDate)x));
                    break;
                }
                throw new SQLException("Conversion not allowed", "M1M05");
            }
            case 92: {
                if (x instanceof Time) {
                    this.setTime(parameterIndex, (Time)x);
                    break;
                }
                if (x instanceof Timestamp) {
                    this.setTime(parameterIndex, new Time(((Timestamp)x).getTime()));
                    break;
                }
                if (x instanceof java.util.Date) {
                    this.setTime(parameterIndex, new Time(((java.util.Date)x).getTime()));
                    break;
                }
                if (x instanceof Calendar) {
                    this.setTime(parameterIndex, new Time(((Calendar)x).getTimeInMillis()));
                    break;
                }
                if (x instanceof LocalTime) {
                    this.setTime(parameterIndex, Time.valueOf((LocalTime)x));
                    break;
                }
                throw new SQLException("Conversion not allowed", "M1M05");
            }
            case 93: {
                if (x instanceof Timestamp) {
                    this.setTimestamp(parameterIndex, (Timestamp)x);
                    break;
                }
                if (x instanceof Date) {
                    this.setTimestamp(parameterIndex, new Timestamp(((Date)x).getTime()));
                    break;
                }
                if (x instanceof java.util.Date) {
                    this.setTimestamp(parameterIndex, new Timestamp(((java.util.Date)x).getTime()));
                    break;
                }
                if (x instanceof Calendar) {
                    this.setTimestamp(parameterIndex, new Timestamp(((Calendar)x).getTimeInMillis()));
                    break;
                }
                if (x instanceof LocalDateTime) {
                    this.setTimestamp(parameterIndex, Timestamp.valueOf((LocalDateTime)x));
                    break;
                }
                throw new SQLException("Conversion not allowed", "M1M05");
            }
            case -1: 
            case 1: 
            case 12: 
            case 2005: {
                this.setString(parameterIndex, x.toString());
                break;
            }
            default: {
                throw new SQLException("Conversion not allowed", "M1M05");
            }
        }
    }

    @Override
    public void setObject(int parameterIndex, Object x, SQLType targetSqlType, int scaleOrLength) throws SQLException {
        this.setObject(parameterIndex, x, MonetTypes.getSQLIntFromSQLName(targetSqlType.getName()), scaleOrLength);
    }

    @Override
    public void setObject(int parameterIndex, Object x, SQLType targetSqlType) throws SQLException {
        this.setObject(parameterIndex, x, targetSqlType, 0);
    }

    @Override
    public void setObject(int parameterIndex, Object x, int targetSqlType) throws SQLException {
        this.setObject(parameterIndex, x, targetSqlType, 0);
    }

    @Override
    public void setObject(int parameterIndex, Object x) throws SQLException {
        int sqltype = MonetTypes.getDefaultSQLTypeForClass(x.getClass());
        this.setObject(parameterIndex, x, sqltype, 0);
    }

    @Override
    public void setNull(int parameterIndex, int sqlType) throws SQLException {
        this.checkNotClosed();
        if (parameterIndex <= 0 || parameterIndex > this.nParams) {
            throw new SQLException("parameterIndex does not correspond to a parameter marker in the statement");
        }
        int monettype = MonetTypes.getMonetTypeFromSQL(sqlType);
        if (monettype == 14) {
            throw new SQLFeatureNotSupportedException("sqlType not supported");
        }
        String error_msg = MonetNative.monetdbe_bind_null(this.conn.getDbNative(), monettype, this.statementNative, parameterIndex - 1);
        if (error_msg != null) {
            throw new SQLException(error_msg);
        }
        this.parameters[parameterIndex - 1] = null;
    }

    @Override
    public void setBoolean(int parameterIndex, boolean x) throws SQLException {
        this.checkNotClosed();
        if (parameterIndex <= 0 || parameterIndex > this.nParams) {
            throw new SQLException("parameterIndex does not correspond to a parameter marker in the statement");
        }
        String error_msg = MonetNative.monetdbe_bind_bool(this.statementNative, parameterIndex - 1, x);
        if (error_msg != null) {
            throw new SQLException(error_msg);
        }
        this.parameters[parameterIndex - 1] = x;
    }

    @Override
    public void setByte(int parameterIndex, byte x) throws SQLException {
        this.checkNotClosed();
        if (parameterIndex <= 0 || parameterIndex > this.nParams) {
            throw new SQLException("parameterIndex does not correspond to a parameter marker in the statement");
        }
        String error_msg = MonetNative.monetdbe_bind_byte(this.statementNative, parameterIndex - 1, x);
        if (error_msg != null) {
            throw new SQLException(error_msg);
        }
        this.parameters[parameterIndex - 1] = x;
    }

    @Override
    public void setShort(int parameterIndex, short x) throws SQLException {
        this.checkNotClosed();
        if (parameterIndex <= 0 || parameterIndex > this.nParams) {
            throw new SQLException("parameterIndex does not correspond to a parameter marker in the statement");
        }
        String error_msg = MonetNative.monetdbe_bind_short(this.statementNative, parameterIndex - 1, x);
        if (error_msg != null) {
            throw new SQLException(error_msg);
        }
        this.parameters[parameterIndex - 1] = x;
    }

    @Override
    public void setInt(int parameterIndex, int x) throws SQLException {
        this.checkNotClosed();
        if (parameterIndex <= 0 || parameterIndex > this.nParams) {
            throw new SQLException("parameterIndex does not correspond to a parameter marker in the statement");
        }
        String error_msg = MonetNative.monetdbe_bind_int(this.statementNative, parameterIndex - 1, x);
        if (error_msg != null) {
            throw new SQLException(error_msg);
        }
        this.parameters[parameterIndex - 1] = x;
    }

    @Override
    public void setLong(int parameterIndex, long x) throws SQLException {
        this.checkNotClosed();
        if (parameterIndex <= 0 || parameterIndex > this.nParams) {
            throw new SQLException("parameterIndex does not correspond to a parameter marker in the statement");
        }
        String error_msg = MonetNative.monetdbe_bind_long(this.statementNative, parameterIndex - 1, x);
        if (error_msg != null) {
            throw new SQLException(error_msg);
        }
        this.parameters[parameterIndex - 1] = x;
    }

    @Override
    public void setFloat(int parameterIndex, float x) throws SQLException {
        this.checkNotClosed();
        if (parameterIndex <= 0 || parameterIndex > this.nParams) {
            throw new SQLException("parameterIndex does not correspond to a parameter marker in the statement");
        }
        String error_msg = MonetNative.monetdbe_bind_float(this.statementNative, parameterIndex - 1, x);
        if (error_msg != null) {
            throw new SQLException(error_msg);
        }
        this.parameters[parameterIndex - 1] = Float.valueOf(x);
    }

    @Override
    public void setDouble(int parameterIndex, double x) throws SQLException {
        this.checkNotClosed();
        if (parameterIndex <= 0 || parameterIndex > this.nParams) {
            throw new SQLException("parameterIndex does not correspond to a parameter marker in the statement");
        }
        String error_msg = MonetNative.monetdbe_bind_double(this.statementNative, parameterIndex - 1, x);
        if (error_msg != null) {
            throw new SQLException(error_msg);
        }
        this.parameters[parameterIndex - 1] = x;
    }

    @Override
    public void setBigDecimal(int parameterIndex, BigDecimal x) throws SQLException {
        int type;
        Number numberBind;
        this.checkNotClosed();
        if (parameterIndex <= 0 || parameterIndex > this.nParams) {
            throw new SQLException("parameterIndex does not correspond to a parameter marker in the statement");
        }
        BigInteger unscaled = x.unscaledValue();
        int bitLenght = unscaled.bitLength();
        if (bitLenght <= 8) {
            numberBind = unscaled.byteValueExact();
            type = 1;
        } else if (bitLenght <= 16) {
            numberBind = unscaled.shortValueExact();
            type = 2;
        } else if (bitLenght <= 32) {
            numberBind = unscaled.intValueExact();
            type = 3;
        } else if (bitLenght <= 64) {
            numberBind = unscaled.longValueExact();
            type = 4;
        } else {
            numberBind = unscaled;
            type = 5;
        }
        MonetNative.monetdbe_bind_decimal(this.statementNative, numberBind, type, x.scale(), parameterIndex - 1);
        this.parameters[parameterIndex - 1] = x;
    }

    public void setBigInteger(int parameterIndex, BigInteger x) throws SQLException {
        this.checkNotClosed();
        if (parameterIndex <= 0 || parameterIndex > this.nParams) {
            throw new SQLException("parameterIndex does not correspond to a parameter marker in the statement");
        }
        String error_msg = MonetNative.monetdbe_bind_hugeint(this.statementNative, parameterIndex - 1, x);
        if (error_msg != null) {
            throw new SQLException(error_msg);
        }
        this.parameters[parameterIndex - 1] = x;
    }

    @Override
    public void setString(int parameterIndex, String x) throws SQLException {
        this.checkNotClosed();
        if (parameterIndex <= 0 || parameterIndex > this.nParams) {
            throw new SQLException("parameterIndex does not correspond to a parameter marker in the statement");
        }
        String error_msg = MonetNative.monetdbe_bind_string(this.statementNative, parameterIndex - 1, x);
        if (error_msg != null) {
            throw new SQLException(error_msg);
        }
        this.parameters[parameterIndex - 1] = x;
    }

    @Override
    public void setDate(int parameterIndex, Date x, Calendar cal) throws SQLException {
        String error_msg;
        this.checkNotClosed();
        if (parameterIndex <= 0 || parameterIndex > this.nParams) {
            throw new SQLException("parameterIndex does not correspond to a parameter marker in the statement");
        }
        LocalDate localDate = x.toLocalDate();
        if (cal != null && localDate != null) {
            localDate = LocalDateTime.of(localDate, LocalTime.now()).atZone(cal.getTimeZone().toZoneId()).withZoneSameInstant(ZoneOffset.UTC).toLocalDate();
        }
        if ((error_msg = MonetNative.monetdbe_bind_date(this.statementNative, parameterIndex - 1, (short)localDate.getYear(), (byte)localDate.getMonthValue(), (byte)localDate.getDayOfMonth())) != null) {
            throw new SQLException(error_msg);
        }
        this.parameters[parameterIndex - 1] = x;
    }

    @Override
    public void setTime(int parameterIndex, Time x, Calendar cal) throws SQLException {
        String error_msg;
        this.checkNotClosed();
        if (parameterIndex <= 0 || parameterIndex > this.nParams) {
            throw new SQLException("parameterIndex does not correspond to a parameter marker in the statement");
        }
        LocalTime localTime = x.toLocalTime();
        if (cal != null && localTime != null) {
            localTime = LocalDateTime.of(LocalDate.now(), localTime).atZone(cal.getTimeZone().toZoneId()).withZoneSameInstant(ZoneOffset.UTC).toLocalTime();
        }
        if ((error_msg = MonetNative.monetdbe_bind_time(this.statementNative, parameterIndex - 1, localTime.getHour(), localTime.getMinute(), localTime.getSecond(), localTime.getNano() * 1000)) != null) {
            throw new SQLException(error_msg);
        }
        this.parameters[parameterIndex - 1] = x;
    }

    @Override
    public void setTimestamp(int parameterIndex, Timestamp x, Calendar cal) throws SQLException {
        String error_msg;
        this.checkNotClosed();
        if (parameterIndex <= 0 || parameterIndex > this.nParams) {
            throw new SQLException("parameterIndex does not correspond to a parameter marker in the statement");
        }
        LocalDateTime localDateTime = x.toLocalDateTime();
        if (cal != null && localDateTime != null) {
            localDateTime = localDateTime.atZone(cal.getTimeZone().toZoneId()).withZoneSameInstant(ZoneOffset.UTC).toLocalDateTime();
        }
        if ((error_msg = MonetNative.monetdbe_bind_timestamp(this.statementNative, parameterIndex - 1, localDateTime.getYear(), localDateTime.getMonthValue(), localDateTime.getDayOfMonth(), localDateTime.getHour(), localDateTime.getMinute(), localDateTime.getSecond(), localDateTime.getNano() * 1000)) != null) {
            throw new SQLException(error_msg);
        }
        this.parameters[parameterIndex - 1] = x;
    }

    @Override
    public void setDate(int parameterIndex, Date x) throws SQLException {
        this.setDate(parameterIndex, x, null);
    }

    @Override
    public void setTime(int parameterIndex, Time x) throws SQLException {
        this.setTime(parameterIndex, x, null);
    }

    @Override
    public void setTimestamp(int parameterIndex, Timestamp x) throws SQLException {
        this.setTimestamp(parameterIndex, x, null);
    }

    @Override
    public void setBytes(int parameterIndex, byte[] x) throws SQLException {
        this.checkNotClosed();
        if (parameterIndex <= 0 || parameterIndex > this.nParams) {
            throw new SQLException("parameterIndex does not correspond to a parameter marker in the statement");
        }
        String error_msg = MonetNative.monetdbe_bind_blob(this.statementNative, parameterIndex - 1, x, x.length);
        if (error_msg != null) {
            throw new SQLException(error_msg);
        }
        this.parameters[parameterIndex - 1] = x;
    }

    @Override
    public void setURL(int parameterIndex, URL x) throws SQLException {
        this.checkNotClosed();
        if (parameterIndex <= 0 || parameterIndex > this.nParams) {
            throw new SQLException("parameterIndex does not correspond to a parameter marker in the statement");
        }
        this.setString(parameterIndex, x.toString());
        this.parameters[parameterIndex - 1] = x;
    }

    @Override
    public void setBlob(int parameterIndex, Blob x) throws SQLException {
        this.checkNotClosed();
        if (parameterIndex <= 0 || parameterIndex > this.nParams) {
            throw new SQLException("parameterIndex does not correspond to a parameter marker in the statement");
        }
        long size = x.length();
        if (size > 0L) {
            byte[] blob_data = x.getBytes(1L, (int)size);
            String error_msg = MonetNative.monetdbe_bind_blob(this.statementNative, parameterIndex - 1, blob_data, x.length());
            if (error_msg != null) {
                throw new SQLException(error_msg);
            }
            this.parameters[parameterIndex - 1] = x;
        } else {
            this.setNull(parameterIndex, 2004);
        }
    }

    @Override
    public void setClob(int parameterIndex, Clob x) throws SQLException {
        this.checkNotClosed();
        if (parameterIndex <= 0 || parameterIndex > this.nParams) {
            throw new SQLException("parameterIndex does not correspond to a parameter marker in the statement");
        }
        long size = x.length();
        if (size > 0L) {
            String error_msg = MonetNative.monetdbe_bind_string(this.statementNative, parameterIndex - 1, x.toString());
            if (error_msg != null) {
                throw new SQLException(error_msg);
            }
            this.parameters[parameterIndex - 1] = x;
        } else {
            this.setNull(parameterIndex, 2004);
        }
    }

    @Override
    public void setClob(int parameterIndex, Reader reader) throws SQLException {
        if (reader == null) {
            this.setNull(parameterIndex, -1);
            return;
        }
        int size = 8192;
        char[] arr = new char[8192];
        StringBuilder buf = new StringBuilder(262144);
        try {
            int numChars;
            while ((numChars = reader.read(arr, 0, 8192)) > 0) {
                buf.append(arr, 0, numChars);
            }
            this.setString(parameterIndex, buf.toString());
        }
        catch (IOException e) {
            throw new SQLException("failed to read from stream: " + e.getMessage(), "M1M25");
        }
    }

    @Override
    public void setClob(int parameterIndex, Reader reader, long length) throws SQLException {
        if (reader == null) {
            this.setNull(parameterIndex, -1);
            return;
        }
        if (length < 0L || length > Integer.MAX_VALUE) {
            throw new SQLException("Invalid length value: " + length, "M1M05");
        }
        CharBuffer buf = CharBuffer.allocate((int)length);
        try {
            reader.read(buf);
            buf.rewind();
            this.setString(parameterIndex, buf.toString());
        }
        catch (IOException e) {
            throw new SQLException("failed to read from stream: " + e.getMessage(), "M1M25");
        }
    }

    @Override
    public void setNull(int parameterIndex, int sqlType, String typeName) throws SQLException {
        this.setNull(parameterIndex, sqlType);
    }

    @Override
    public void setNString(int parameterIndex, String value) throws SQLException {
        this.setString(parameterIndex, value);
    }

    @Override
    public void setCharacterStream(int parameterIndex, Reader reader, int length) throws SQLException {
        this.setClob(parameterIndex, reader, length);
    }

    @Override
    public void setCharacterStream(int parameterIndex, Reader reader, long length) throws SQLException {
        this.setClob(parameterIndex, reader, length);
    }

    @Override
    public void setCharacterStream(int parameterIndex, Reader reader) throws SQLException {
        this.setClob(parameterIndex, reader);
    }

    @Override
    public void setNCharacterStream(int parameterIndex, Reader value) throws SQLException {
        this.setClob(parameterIndex, value);
    }

    @Override
    public void setNCharacterStream(int parameterIndex, Reader value, long length) throws SQLException {
        this.setClob(parameterIndex, value, length);
    }

    @Override
    public void setAsciiStream(int parameterIndex, InputStream x, int length) throws SQLException {
        throw new SQLFeatureNotSupportedException("setAsciiStream");
    }

    @Override
    public void setAsciiStream(int parameterIndex, InputStream x, long length) throws SQLException {
        throw new SQLFeatureNotSupportedException("setAsciiStream");
    }

    @Override
    public void setAsciiStream(int parameterIndex, InputStream x) throws SQLException {
        throw new SQLFeatureNotSupportedException("setAsciiStream");
    }

    @Override
    public void setUnicodeStream(int parameterIndex, InputStream x, int length) throws SQLException {
        throw new SQLFeatureNotSupportedException("setUnicodeStream");
    }

    @Override
    public void setBinaryStream(int parameterIndex, InputStream x, int length) throws SQLException {
        throw new SQLFeatureNotSupportedException("setBinaryStream");
    }

    @Override
    public void setBinaryStream(int parameterIndex, InputStream x, long length) throws SQLException {
        throw new SQLFeatureNotSupportedException("setBinaryStream");
    }

    @Override
    public void setBinaryStream(int parameterIndex, InputStream x) throws SQLException {
        throw new SQLFeatureNotSupportedException("setBinaryStream");
    }

    @Override
    public void setBlob(int parameterIndex, InputStream inputStream) throws SQLException {
        throw new SQLFeatureNotSupportedException("setBlob(int parameterIndex, InputStream inputStream)");
    }

    @Override
    public void setBlob(int parameterIndex, InputStream inputStream, long length) throws SQLException {
        throw new SQLFeatureNotSupportedException("setBlob(int parameterIndex, InputStream inputStream, long lenght)");
    }

    @Override
    public void setRef(int parameterIndex, Ref x) throws SQLException {
        throw new SQLFeatureNotSupportedException("setRef");
    }

    @Override
    public void setSQLXML(int parameterIndex, SQLXML xmlObject) throws SQLException {
        throw new SQLFeatureNotSupportedException("setSQLXML");
    }

    @Override
    public void setArray(int parameterIndex, Array x) throws SQLException {
        throw new SQLFeatureNotSupportedException("setArray");
    }

    @Override
    public void setRowId(int parameterIndex, RowId x) throws SQLException {
        throw new SQLFeatureNotSupportedException("setRowId");
    }

    @Override
    public void setNClob(int parameterIndex, NClob value) throws SQLException {
        throw new SQLFeatureNotSupportedException("setNClob");
    }

    @Override
    public void setNClob(int parameterIndex, Reader reader, long length) throws SQLException {
        throw new SQLFeatureNotSupportedException("setNClob");
    }

    @Override
    public void setNClob(int parameterIndex, Reader reader) throws SQLException {
        throw new SQLFeatureNotSupportedException("setNClob");
    }
}

