/*
 * Decompiled with CFR 0.152.
 */
package org.monetdb.monetdbe;

import java.sql.ParameterMetaData;
import java.sql.SQLException;
import org.monetdb.monetdbe.MonetTypes;
import org.monetdb.monetdbe.MonetWrapper;

public class MonetParameterMetaData
extends MonetWrapper
implements ParameterMetaData {
    protected final int parameterCount;
    protected final int[] types;
    protected final String[] monetTypes;
    protected final int[] sqlTypes;
    private final String[] javaTypes;

    MonetParameterMetaData(int parameterCount, int[] monetdbeTypes) {
        this.parameterCount = parameterCount;
        this.types = monetdbeTypes;
        this.monetTypes = new String[parameterCount];
        this.sqlTypes = new int[parameterCount];
        this.javaTypes = new String[parameterCount];
        for (int i = 0; i < parameterCount; ++i) {
            this.monetTypes[i] = MonetTypes.getMonetTypeString(monetdbeTypes[i]);
            this.sqlTypes[i] = MonetTypes.getSQLTypeFromMonet(monetdbeTypes[i]);
            this.javaTypes[i] = MonetTypes.getClassForMonetType(monetdbeTypes[i]).getName();
        }
    }

    @Override
    public int getParameterCount() throws SQLException {
        return this.parameterCount;
    }

    @Override
    public int isNullable(int param) throws SQLException {
        return 2;
    }

    @Override
    public boolean isSigned(int param) throws SQLException {
        return MonetTypes.isSigned(this.getParameterType(param));
    }

    @Override
    public int getPrecision(int param) throws SQLException {
        return MonetTypes.getPrecision(this.sqlTypes[param]);
    }

    @Override
    public int getScale(int param) throws SQLException {
        return 0;
    }

    @Override
    public int getParameterType(int param) throws SQLException {
        try {
            return this.sqlTypes[param - 1];
        }
        catch (IndexOutOfBoundsException e) {
            throw new SQLException("columnIndex out of bounds");
        }
    }

    @Override
    public String getParameterTypeName(int param) throws SQLException {
        try {
            return this.monetTypes[param - 1];
        }
        catch (IndexOutOfBoundsException e) {
            throw new SQLException("columnIndex out of bounds");
        }
    }

    @Override
    public String getParameterClassName(int param) throws SQLException {
        try {
            return this.javaTypes[param - 1];
        }
        catch (IndexOutOfBoundsException e) {
            throw new SQLException("columnIndex out of bounds");
        }
    }

    @Override
    public int getParameterMode(int param) throws SQLException {
        return 1;
    }
}

