/*
 * Decompiled with CFR 0.152.
 */
package org.monetdb.monetdbe;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import org.monetdb.monetdbe.MonetColumn;
import org.monetdb.monetdbe.MonetConnection;
import org.monetdb.monetdbe.MonetPreparedStatement;
import org.monetdb.monetdbe.MonetStatement;

public class MonetNative {
    static void copyLib(String directory, String libName) throws IOException {
        InputStream is = MonetNative.class.getResourceAsStream("/lib/" + directory + "/" + libName);
        if (is == null) {
            throw new IOException("Library " + libName + " could not be found.");
        }
        Files.copy(is, new File(System.getProperty("java.io.tmpdir") + "/" + libName).toPath(), StandardCopyOption.REPLACE_EXISTING);
    }

    static void loadLib(String directory, String libName) throws IOException {
        InputStream is = MonetNative.class.getResourceAsStream("/lib/" + directory + "/" + libName);
        if (is == null) {
            throw new IOException("Library " + libName + " could not be found.");
        }
        Path temp_lib = new File(System.getProperty("java.io.tmpdir") + "/" + libName).toPath();
        Files.copy(is, temp_lib, StandardCopyOption.REPLACE_EXISTING);
        System.load(temp_lib.toString());
    }

    protected static native String monetdbe_open(String var0, MonetConnection var1);

    protected static native String monetdbe_open(String var0, MonetConnection var1, int var2, int var3, int var4, int var5);

    protected static native String monetdbe_open(String var0, MonetConnection var1, int var2, int var3, int var4, int var5, String var6, int var7, String var8, String var9, String var10);

    protected static native String monetdbe_close(ByteBuffer var0);

    protected static native String monetdbe_query(ByteBuffer var0, String var1, MonetStatement var2, boolean var3, int var4);

    protected static native MonetColumn[] monetdbe_result_fetch_all(ByteBuffer var0, int var1, int var2);

    protected static native String monetdbe_result_cleanup(ByteBuffer var0, ByteBuffer var1);

    protected static native String monetdbe_error(ByteBuffer var0);

    protected static native String monetdbe_set_autocommit(ByteBuffer var0, int var1);

    protected static native boolean monetdbe_get_autocommit(ByteBuffer var0);

    protected static native String monetdbe_prepare(ByteBuffer var0, String var1, MonetPreparedStatement var2);

    protected static native String monetdbe_execute(ByteBuffer var0, MonetPreparedStatement var1, boolean var2, int var3);

    protected static native String monetdbe_cleanup_statement(ByteBuffer var0, ByteBuffer var1);

    protected static native String monetdbe_clear_bindings(ByteBuffer var0, ByteBuffer var1);

    protected static native String monetdbe_bind_bool(ByteBuffer var0, int var1, boolean var2);

    protected static native String monetdbe_bind_byte(ByteBuffer var0, int var1, byte var2);

    protected static native String monetdbe_bind_short(ByteBuffer var0, int var1, short var2);

    protected static native String monetdbe_bind_int(ByteBuffer var0, int var1, int var2);

    protected static native String monetdbe_bind_long(ByteBuffer var0, int var1, long var2);

    protected static native String monetdbe_bind_hugeint(ByteBuffer var0, int var1, BigInteger var2);

    protected static native String monetdbe_bind_float(ByteBuffer var0, int var1, float var2);

    protected static native String monetdbe_bind_double(ByteBuffer var0, int var1, double var2);

    protected static native String monetdbe_bind_string(ByteBuffer var0, int var1, String var2);

    protected static native String monetdbe_bind_blob(ByteBuffer var0, int var1, byte[] var2, long var3);

    protected static native String monetdbe_bind_date(ByteBuffer var0, int var1, int var2, int var3, int var4);

    protected static native String monetdbe_bind_time(ByteBuffer var0, int var1, int var2, int var3, int var4, int var5);

    protected static native String monetdbe_bind_timestamp(ByteBuffer var0, int var1, int var2, int var3, int var4, int var5, int var6, int var7, int var8);

    protected static native String monetdbe_bind_decimal(ByteBuffer var0, Object var1, int var2, int var3, int var4);

    protected static native String monetdbe_bind_null(ByteBuffer var0, int var1, ByteBuffer var2, int var3);

    static {
        try {
            String os_name = System.getProperty("os.name").toLowerCase().trim();
            String[] dependencyLibs = null;
            String loadLib = null;
            String directory = null;
            if (os_name.startsWith("linux")) {
                dependencyLibs = new String[]{"libstream.so.14", "libbat.so.21", "libmapi.so.12", "libmonetdb5.so.30", "libmonetdbsql.so.11", "libmonetdbe.so.1"};
                loadLib = "libmonetdbe-lowlevel.so";
                directory = "linux";
            } else if (os_name.startsWith("mac")) {
                dependencyLibs = new String[]{"libstream.14.dylib", "libbat.21.dylib", "libmapi.12.dylib", "libmonetdb5.30.dylib", "libmonetdbsql.11.dylib", "libmonetdbe.1.dylib"};
                loadLib = "libmonetdbe-lowlevel.dylib";
                directory = "mac";
            } else if (os_name.startsWith("windows")) {
                String[] transitiveDependencies;
                dependencyLibs = new String[]{"stream.dll", "bat.dll", "mapi.dll", "monetdb5.dll", "monetdbsql.dll", "monetdbe.dll"};
                String[] stringArray = transitiveDependencies = new String[]{"iconv-2.dll", "lzma.dll", "zlib1.dll", "libcurl.dll", "bz2.dll", "libcrypto-1_1-x64.dll", "pcre.dll", "libxml2.dll"};
                int n = stringArray.length;
                for (int i = 0; i < n; ++i) {
                    String td = stringArray[i];
                    MonetNative.loadLib("windows", td);
                }
                loadLib = "libmonetdbe-lowlevel.dll";
                directory = "windows";
            }
            if (dependencyLibs != null && loadLib != null && directory != null) {
                for (String l : dependencyLibs) {
                    if (loadLib.endsWith(".dll")) {
                        MonetNative.loadLib("windows", l);
                        continue;
                    }
                    MonetNative.copyLib(directory, l);
                }
            } else {
                throw new IOException("Library dependencies could not be found");
            }
            MonetNative.loadLib(directory, loadLib);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

