/*
 * Decompiled with CFR 0.152.
 */
package org.monetdb.monetdbe;

import java.net.URI;
import java.net.URISyntaxException;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.DriverPropertyInfo;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.util.Properties;
import java.util.logging.Logger;
import org.monetdb.monetdbe.MonetConnection;

public final class MonetDriver
implements Driver {
    static final String MONETURL = "jdbc:monetdb:";
    static final String MAPIURL = "mapi:monetdb:";
    static final String MEMORYURL = "jdbc:monetdb:memory:";

    private void parseOptions(String urlQuery, Properties info) {
        if (urlQuery != null) {
            String[] args = urlQuery.split("&");
            for (int i = 0; i < args.length; ++i) {
                int pos = args[i].indexOf(61);
                if (pos <= 0) continue;
                info.put(args[i].substring(0, pos).toLowerCase(), args[i].substring(pos + 1));
            }
        }
    }

    private Connection connectJDBC(String url, Properties info) throws SQLException {
        if (url.startsWith(MEMORYURL)) {
            info.put("connectionType", "memory");
        } else {
            String path = url.substring(18);
            if (path.indexOf(63) != -1) {
                info.put("path", path.substring(0, path.indexOf(63)));
            } else {
                info.put("path", path);
            }
            info.put("connectionType", "file");
        }
        if (url.contains("?")) {
            this.parseOptions(url.substring(url.lastIndexOf(63) + 1), info);
        }
        return new MonetConnection(info);
    }

    private Connection connectMapi(String url, Properties info) throws SQLException {
        String database;
        int uri_port;
        URI uri;
        try {
            uri = new URI(url.substring(5));
        }
        catch (URISyntaxException e) {
            System.out.println("Uri '" + url + "' not parseable");
            return null;
        }
        String uri_host = uri.getHost();
        if (uri_host != null) {
            info.put("host", uri_host);
        }
        if ((uri_port = uri.getPort()) > 0) {
            info.put("port", Integer.toString(uri_port));
        }
        if ((database = uri.getPath()) != null) {
            info.put("database", database.substring(1));
        }
        String uri_query = uri.getQuery();
        this.parseOptions(uri_query, info);
        info.put("connectionType", "remote");
        return new MonetConnection(info);
    }

    @Override
    public Connection connect(String url, Properties info) throws SQLException {
        if (url == null) {
            throw new SQLException("url cannot be null");
        }
        if (!this.acceptsURL(url)) {
            return null;
        }
        if (info == null) {
            info = new Properties();
        }
        info.setProperty("jdbc-url", url);
        if (url.startsWith(MONETURL)) {
            return this.connectJDBC(url, info);
        }
        if (url.startsWith(MAPIURL)) {
            return this.connectMapi(url, info);
        }
        return null;
    }

    @Override
    public boolean acceptsURL(String url) {
        return url != null && (url.startsWith(MONETURL) || url.startsWith(MAPIURL));
    }

    @Override
    public DriverPropertyInfo[] getPropertyInfo(String url, Properties info) {
        if (!this.acceptsURL(url)) {
            return null;
        }
        DriverPropertyInfo[] dpi = new DriverPropertyInfo[7];
        DriverPropertyInfo prop = new DriverPropertyInfo("user", info != null ? info.getProperty("user") : null);
        prop.required = false;
        prop.description = "The user loginname to use when authenticating on the database server";
        dpi[0] = prop;
        prop = new DriverPropertyInfo("password", info != null ? info.getProperty("password") : null);
        prop.required = false;
        prop.description = "The password to use when authenticating on the database server";
        dpi[1] = prop;
        prop = new DriverPropertyInfo("session_timeout", "0");
        prop.required = false;
        prop.description = "Graceful terminate the session after a few seconds";
        dpi[2] = prop;
        prop = new DriverPropertyInfo("query_timeout", "0");
        prop.required = false;
        prop.description = "Graceful terminate query after a few seconds";
        dpi[3] = prop;
        prop = new DriverPropertyInfo("memory_limit", "0");
        prop.required = false;
        prop.description = "Top off the amount of RAM to be used, in MB";
        dpi[4] = prop;
        prop = new DriverPropertyInfo("nr_threads", "0");
        prop.required = false;
        prop.description = "Maximum number of worker treads, limits level of parallelism";
        dpi[5] = prop;
        prop = new DriverPropertyInfo("autocommit", "true");
        prop.required = false;
        prop.description = "If the autocommit mode is on or off.";
        dpi[6] = prop;
        return dpi;
    }

    @Override
    public int getMajorVersion() {
        return 1;
    }

    @Override
    public int getMinorVersion() {
        return 0;
    }

    static final int getDriverMajorVersion() {
        return 1;
    }

    static final int getDriverMinorVersion() {
        return 1;
    }

    public static final String getDriverVersion() {
        return MonetDriver.getDriverMajorVersion() + "." + MonetDriver.getDriverMinorVersion();
    }

    static final int getDatabaseMajorVersion() {
        return 11;
    }

    static final int getDatabaseMinorVersion() {
        return 40;
    }

    public static final String getDatabaseVersion() {
        return MonetDriver.getDatabaseMajorVersion() + "." + MonetDriver.getDatabaseMinorVersion();
    }

    @Override
    public boolean jdbcCompliant() {
        return false;
    }

    @Override
    public Logger getParentLogger() throws SQLFeatureNotSupportedException {
        throw new SQLFeatureNotSupportedException("getParentLogger");
    }

    static {
        try {
            DriverManager.registerDriver(new MonetDriver());
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }
}

