/*
 * Decompiled with CFR 0.152.
 */
package org.monetdb.monetdbe;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.RowIdLifetime;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import java.util.Map;
import org.monetdb.monetdbe.MonetConnection;
import org.monetdb.monetdbe.MonetDriver;
import org.monetdb.monetdbe.MonetWrapper;

public class MonetDatabaseMetaData
extends MonetWrapper
implements DatabaseMetaData {
    private final MonetConnection con;
    private static final String FunctionsSelect = "SELECT DISTINCT CASE WHEN \"language\" > 0 THEN s.\"name\"||'.'||f.\"name\" ELSE f.\"name\" END FROM \"sys\".\"functions\" f JOIN \"sys\".\"schemas\" s ON f.\"schema_id\" = s.\"id\" WHERE ";
    private static final String FunctionsWhere = "(f.\"id\" IN (SELECT \"func_id\" FROM \"sys\".\"args\" WHERE \"number\" = 1 AND \"name\" = 'arg_1' AND \"type\" IN ";
    private static final String OrFunctionsMaxMin = " OR f.\"name\" IN ('sql_max','sql_min','least','greatest')";
    private static final String FunctionsOrderBy1 = " ORDER BY 1";
    private static final Map<String, Integer> typeMap = new HashMap<String, Integer>();
    private static final String keyQuery = "SELECT cast(null AS char(1)) AS \"PKTABLE_CAT\", pkschema.\"name\" AS \"PKTABLE_SCHEM\", pktable.\"name\" AS \"PKTABLE_NAME\", pkkeycol.\"name\" AS \"PKCOLUMN_NAME\", cast(null AS char(1)) AS \"FKTABLE_CAT\", fkschema.\"name\" AS \"FKTABLE_SCHEM\", fktable.\"name\" AS \"FKTABLE_NAME\", fkkeycol.\"name\" AS \"FKCOLUMN_NAME\", cast(1 + \"pkkeycol\".\"nr\" AS smallint) AS \"KEY_SEQ\", 3 AS \"UPDATE_RULE\", 3 AS \"DELETE_RULE\", fkkey.\"name\" AS \"FK_NAME\", pkkey.\"name\" AS \"PK_NAME\", 7 AS \"DEFERRABILITY\" FROM \"sys\".\"keys\" pkkey JOIN \"sys\".\"objects\" pkkeycol ON pkkey.\"id\" = pkkeycol.\"id\" JOIN \"sys\".\"tables\" pktable ON pktable.\"id\" = pkkey.\"table_id\" JOIN \"sys\".\"schemas\" pkschema ON pkschema.\"id\" = pktable.\"schema_id\" JOIN \"sys\".\"keys\" fkkey ON fkkey.\"rkey\" = pkkey.\"id\" JOIN \"sys\".\"objects\" fkkeycol ON (fkkey.\"id\" = fkkeycol.\"id\" AND fkkeycol.\"nr\" = pkkeycol.\"nr\") JOIN \"sys\".\"tables\" fktable ON fktable.\"id\" = fkkey.\"table_id\" JOIN \"sys\".\"schemas\" fkschema ON fkschema.\"id\" = fktable.\"schema_id\" WHERE fkkey.\"rkey\" > 0";

    public MonetDatabaseMetaData(MonetConnection parent) {
        this.con = parent;
    }

    @Override
    public boolean allProceduresAreCallable() {
        return false;
    }

    @Override
    public boolean allTablesAreSelectable() {
        return false;
    }

    @Override
    public String getURL() throws SQLException {
        return this.con.getJdbcURL();
    }

    @Override
    public String getUserName() throws SQLException {
        return this.con.getUserName();
    }

    @Override
    public boolean isReadOnly() {
        return false;
    }

    @Override
    public boolean nullsAreSortedHigh() {
        return false;
    }

    @Override
    public boolean nullsAreSortedLow() {
        return true;
    }

    @Override
    public boolean nullsAreSortedAtStart() {
        return false;
    }

    @Override
    public boolean nullsAreSortedAtEnd() {
        return false;
    }

    @Override
    public String getDatabaseProductName() {
        return "MonetDB";
    }

    @Override
    public String getDatabaseProductVersion() throws SQLException {
        return MonetDriver.getDatabaseVersion();
    }

    @Override
    public String getDriverName() {
        return "MonetDB Native Driver";
    }

    @Override
    public String getDriverVersion() {
        return MonetDriver.getDriverVersion();
    }

    @Override
    public int getDriverMajorVersion() {
        return MonetDriver.getDriverMajorVersion();
    }

    @Override
    public int getDriverMinorVersion() {
        return MonetDriver.getDriverMinorVersion();
    }

    @Override
    public boolean usesLocalFiles() {
        return false;
    }

    @Override
    public boolean usesLocalFilePerTable() {
        return false;
    }

    @Override
    public boolean supportsMixedCaseIdentifiers() {
        return false;
    }

    @Override
    public boolean storesUpperCaseIdentifiers() {
        return false;
    }

    @Override
    public boolean storesLowerCaseIdentifiers() {
        return true;
    }

    @Override
    public boolean storesMixedCaseIdentifiers() {
        return false;
    }

    @Override
    public boolean supportsMixedCaseQuotedIdentifiers() {
        return true;
    }

    @Override
    public boolean storesUpperCaseQuotedIdentifiers() {
        return false;
    }

    @Override
    public boolean storesLowerCaseQuotedIdentifiers() {
        return false;
    }

    @Override
    public boolean storesMixedCaseQuotedIdentifiers() {
        return false;
    }

    @Override
    public String getIdentifierQuoteString() {
        return "\"";
    }

    @Override
    public String getSQLKeywords() {
        String keywords = this.getConcatenatedStringFromQuery("SELECT \"keyword\" FROM \"sys\".\"keywords\" ORDER BY 1");
        return keywords.isEmpty() ? "ADMIN,AFTER,AGGREGATE,ALWAYS,ASYMMETRIC,ATOMIC,AUTO_INCREMENT,BEFORE,BIGINT,BIGSERIAL,BINARY,BLOB,CALL,CHAIN,CLOB,COMMITTED,COPY,CORR,CUME_DIST,CURRENT_ROLE,CYCLE,DATABASE,DELIMITERS,DENSE_RANK,DO,EACH,ELSEIF,ENCRYPTED,EVERY,EXCLUDE,FOLLOWING,FUNCTION,GENERATED,IF,ILIKE,INCREMENT,LAG,LEAD,LIMIT,LOCALTIME,LOCALTIMESTAMP,LOCKED,MAXVALUE,MEDIAN,MEDIUMINT,MERGE,MINVALUE,NEW,NOCYCLE,NOMAXVALUE,NOMINVALUE,NOW,OFFSET,OLD,OTHERS,OVER,PARTITION,PERCENT_RANK,PLAN,PRECEDING,PROD,QUANTILE,RANGE,RANK,RECORDS,REFERENCING,REMOTE,RENAME,REPEATABLE,REPLICA,RESTART,RETURN,RETURNS,ROW_NUMBER,ROWS,SAMPLE,SAVEPOINT,SCHEMA,SEQUENCE,SERIAL,SERIALIZABLE,SIMPLE,START,STATEMENT,STDIN,STDOUT,STREAM,STRING,SYMMETRIC,TIES,TINYINT,TRIGGER,UNBOUNDED,UNCOMMITTED,UNENCRYPTED,WHILE,XMLAGG,XMLATTRIBUTES,XMLCOMMENT,XMLCONCAT,XMLDOCUMENT,XMLELEMENT,XMLFOREST,XMLNAMESPACES,XMLPARSE,XMLPI,XMLQUERY,XMLSCHEMA,XMLTEXT,XMLVALIDATE" : keywords;
    }

    private String getConcatenatedStringFromQuery(String query) {
        StringBuilder sb = new StringBuilder(1024);
        Statement st = null;
        ResultSet rs = null;
        try {
            st = this.con.createStatement();
            rs = st.executeQuery(query);
            boolean isfirst = true;
            while (rs.next()) {
                String value = rs.getString(1);
                if (value == null) continue;
                if (isfirst) {
                    isfirst = false;
                } else {
                    sb.append(',');
                }
                sb.append(value);
            }
            st.close();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        return sb.toString();
    }

    @Override
    public String getNumericFunctions() {
        String match = "('tinyint','smallint','int','bigint','hugeint','decimal','double','real')) AND \"type\" = 1 AND f.\"name\" NOT IN ('code','not_uniques','rotate_xor_hash','space')) OR f.\"name\" IN ('alpha','degrees','fuse','ms_round','ms_str','ms_trunc','pi','radians')";
        return this.getConcatenatedStringFromQuery("SELECT DISTINCT CASE WHEN \"language\" > 0 THEN s.\"name\"||'.'||f.\"name\" ELSE f.\"name\" END FROM \"sys\".\"functions\" f JOIN \"sys\".\"schemas\" s ON f.\"schema_id\" = s.\"id\" WHERE (f.\"id\" IN (SELECT \"func_id\" FROM \"sys\".\"args\" WHERE \"number\" = 1 AND \"name\" = 'arg_1' AND \"type\" IN ('tinyint','smallint','int','bigint','hugeint','decimal','double','real')) AND \"type\" = 1 AND f.\"name\" NOT IN ('code','not_uniques','rotate_xor_hash','space')) OR f.\"name\" IN ('alpha','degrees','fuse','ms_round','ms_str','ms_trunc','pi','radians') OR f.\"name\" IN ('sql_max','sql_min','least','greatest') ORDER BY 1");
    }

    @Override
    public String getStringFunctions() {
        String match = "('char','varchar','clob','json','url')) AND \"type\" = 1 AND \"mod\" <> 'sql') OR \"mod\" = 'str' OR f.\"name\" IN ('isarray','isobject','isvalid','md5','ms_stuff','reverse')";
        String unionPart = " UNION SELECT 'position'";
        return this.getConcatenatedStringFromQuery("SELECT DISTINCT CASE WHEN \"language\" > 0 THEN s.\"name\"||'.'||f.\"name\" ELSE f.\"name\" END FROM \"sys\".\"functions\" f JOIN \"sys\".\"schemas\" s ON f.\"schema_id\" = s.\"id\" WHERE (f.\"id\" IN (SELECT \"func_id\" FROM \"sys\".\"args\" WHERE \"number\" = 1 AND \"name\" = 'arg_1' AND \"type\" IN ('char','varchar','clob','json','url')) AND \"type\" = 1 AND \"mod\" <> 'sql') OR \"mod\" = 'str' OR f.\"name\" IN ('isarray','isobject','isvalid','md5','ms_stuff','reverse') OR f.\"name\" IN ('sql_max','sql_min','least','greatest') UNION SELECT 'position' ORDER BY 1");
    }

    @Override
    public String getSystemFunctions() {
        String wherePart = "f.\"name\" IN ('columnsize','debug','get_value_for','hash','hashsize','heapsize','ifthenelse','imprintsize','isaurl','isauuid','isnull','masterclock','mastertick','newurl','next_value_for','password_hash','replicaclock','replicatick','uuid') UNION ALL SELECT * FROM (VALUES('cast'),('coalesce'),('convert'),('nullif')) as sf";
        return this.getConcatenatedStringFromQuery("SELECT DISTINCT CASE WHEN \"language\" > 0 THEN s.\"name\"||'.'||f.\"name\" ELSE f.\"name\" END FROM \"sys\".\"functions\" f JOIN \"sys\".\"schemas\" s ON f.\"schema_id\" = s.\"id\" WHERE f.\"name\" IN ('columnsize','debug','get_value_for','hash','hashsize','heapsize','ifthenelse','imprintsize','isaurl','isauuid','isnull','masterclock','mastertick','newurl','next_value_for','password_hash','replicaclock','replicatick','uuid') UNION ALL SELECT * FROM (VALUES('cast'),('coalesce'),('convert'),('nullif')) as sf ORDER BY 1");
    }

    @Override
    public String getTimeDateFunctions() {
        String wherePart = "\"mod\" IN ('mtime','timestamp') OR f.\"name\" IN ('localtime','localtimestamp','date_trunc')";
        String unionPart = " UNION SELECT 'extract' UNION SELECT 'now'";
        return this.getConcatenatedStringFromQuery("SELECT DISTINCT CASE WHEN \"language\" > 0 THEN s.\"name\"||'.'||f.\"name\" ELSE f.\"name\" END FROM \"sys\".\"functions\" f JOIN \"sys\".\"schemas\" s ON f.\"schema_id\" = s.\"id\" WHERE \"mod\" IN ('mtime','timestamp') OR f.\"name\" IN ('localtime','localtimestamp','date_trunc') OR f.\"name\" IN ('sql_max','sql_min','least','greatest') UNION SELECT 'extract' UNION SELECT 'now' ORDER BY 1");
    }

    @Override
    public String getSearchStringEscape() {
        return "\\";
    }

    @Override
    public String getExtraNameCharacters() {
        return "";
    }

    @Override
    public boolean supportsAlterTableWithAddColumn() {
        return true;
    }

    @Override
    public boolean supportsAlterTableWithDropColumn() {
        return true;
    }

    @Override
    public boolean supportsColumnAliasing() {
        return true;
    }

    @Override
    public boolean nullPlusNonNullIsNull() {
        return true;
    }

    @Override
    public boolean supportsConvert() {
        return true;
    }

    @Override
    public boolean supportsConvert(int fromType, int toType) {
        switch (fromType) {
            case 16: {
                switch (toType) {
                    case -6: 
                    case -5: 
                    case 1: 
                    case 4: 
                    case 5: 
                    case 12: 
                    case 16: 
                    case 2005: {
                        return true;
                    }
                }
                return false;
            }
            case 2004: {
                switch (toType) {
                    case 12: 
                    case 2004: 
                    case 2005: {
                        return true;
                    }
                }
                return false;
            }
            case -6: 
            case -5: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                switch (toType) {
                    case -6: 
                    case -5: 
                    case 1: 
                    case 2: 
                    case 3: 
                    case 4: 
                    case 5: 
                    case 6: 
                    case 7: 
                    case 8: 
                    case 12: 
                    case 16: 
                    case 2005: {
                        return true;
                    }
                }
                return false;
            }
            case 1: 
            case 12: 
            case 2005: {
                switch (toType) {
                    case -6: 
                    case -5: 
                    case 1: 
                    case 2: 
                    case 3: 
                    case 4: 
                    case 5: 
                    case 6: 
                    case 7: 
                    case 8: 
                    case 12: 
                    case 16: 
                    case 91: 
                    case 92: 
                    case 93: 
                    case 2004: 
                    case 2005: 
                    case 2013: 
                    case 2014: {
                        return true;
                    }
                }
                return false;
            }
            case 91: {
                switch (toType) {
                    case 1: 
                    case 12: 
                    case 91: 
                    case 93: 
                    case 2005: 
                    case 2014: {
                        return true;
                    }
                }
                return false;
            }
            case 92: 
            case 2013: {
                switch (toType) {
                    case 1: 
                    case 12: 
                    case 92: 
                    case 2005: 
                    case 2013: {
                        return true;
                    }
                }
                return false;
            }
            case 93: 
            case 2014: {
                switch (toType) {
                    case 1: 
                    case 12: 
                    case 91: 
                    case 92: 
                    case 93: 
                    case 2005: 
                    case 2013: 
                    case 2014: {
                        return true;
                    }
                }
                return false;
            }
        }
        return false;
    }

    @Override
    public boolean supportsTableCorrelationNames() {
        return true;
    }

    @Override
    public boolean supportsDifferentTableCorrelationNames() {
        return false;
    }

    @Override
    public boolean supportsExpressionsInOrderBy() {
        return true;
    }

    @Override
    public boolean supportsOrderByUnrelated() {
        return true;
    }

    @Override
    public boolean supportsGroupBy() {
        return true;
    }

    @Override
    public boolean supportsGroupByUnrelated() {
        return true;
    }

    @Override
    public boolean supportsGroupByBeyondSelect() {
        return true;
    }

    @Override
    public boolean supportsLikeEscapeClause() {
        return true;
    }

    @Override
    public boolean supportsMultipleResultSets() {
        return false;
    }

    @Override
    public boolean supportsMultipleTransactions() {
        return true;
    }

    @Override
    public boolean supportsNonNullableColumns() {
        return true;
    }

    @Override
    public boolean supportsMinimumSQLGrammar() {
        return true;
    }

    @Override
    public boolean supportsCoreSQLGrammar() {
        return true;
    }

    @Override
    public boolean supportsExtendedSQLGrammar() {
        return false;
    }

    @Override
    public boolean supportsANSI92EntryLevelSQL() {
        return true;
    }

    @Override
    public boolean supportsANSI92IntermediateSQL() {
        return false;
    }

    @Override
    public boolean supportsANSI92FullSQL() {
        return false;
    }

    @Override
    public boolean supportsIntegrityEnhancementFacility() {
        return false;
    }

    @Override
    public boolean supportsOuterJoins() {
        return true;
    }

    @Override
    public boolean supportsFullOuterJoins() {
        return true;
    }

    @Override
    public boolean supportsLimitedOuterJoins() {
        return false;
    }

    @Override
    public String getSchemaTerm() {
        return "schema";
    }

    @Override
    public String getProcedureTerm() {
        return "procedure";
    }

    @Override
    public String getCatalogTerm() {
        return "cat";
    }

    @Override
    public boolean isCatalogAtStart() {
        return true;
    }

    @Override
    public String getCatalogSeparator() {
        return null;
    }

    @Override
    public boolean supportsSchemasInDataManipulation() {
        return true;
    }

    @Override
    public boolean supportsSchemasInProcedureCalls() {
        return true;
    }

    @Override
    public boolean supportsSchemasInTableDefinitions() {
        return true;
    }

    @Override
    public boolean supportsSchemasInIndexDefinitions() {
        return false;
    }

    @Override
    public boolean supportsSchemasInPrivilegeDefinitions() {
        return true;
    }

    @Override
    public boolean supportsCatalogsInDataManipulation() {
        return false;
    }

    @Override
    public boolean supportsCatalogsInProcedureCalls() {
        return false;
    }

    @Override
    public boolean supportsCatalogsInTableDefinitions() {
        return false;
    }

    @Override
    public boolean supportsCatalogsInIndexDefinitions() {
        return false;
    }

    @Override
    public boolean supportsCatalogsInPrivilegeDefinitions() {
        return false;
    }

    @Override
    public boolean supportsPositionedDelete() {
        return false;
    }

    @Override
    public boolean supportsPositionedUpdate() {
        return false;
    }

    @Override
    public boolean supportsSelectForUpdate() {
        return false;
    }

    @Override
    public boolean supportsStoredProcedures() {
        return true;
    }

    @Override
    public boolean supportsSubqueriesInComparisons() {
        return true;
    }

    @Override
    public boolean supportsSubqueriesInExists() {
        return true;
    }

    @Override
    public boolean supportsSubqueriesInIns() {
        return true;
    }

    @Override
    public boolean supportsSubqueriesInQuantifieds() {
        return true;
    }

    @Override
    public boolean supportsCorrelatedSubqueries() {
        return true;
    }

    @Override
    public boolean supportsUnion() {
        return true;
    }

    @Override
    public boolean supportsUnionAll() {
        return true;
    }

    @Override
    public boolean supportsOpenCursorsAcrossCommit() {
        return true;
    }

    @Override
    public boolean supportsOpenCursorsAcrossRollback() {
        return true;
    }

    @Override
    public boolean supportsOpenStatementsAcrossCommit() {
        return true;
    }

    @Override
    public boolean supportsOpenStatementsAcrossRollback() {
        return true;
    }

    @Override
    public int getMaxBinaryLiteralLength() {
        return 0x7FFFFFFE;
    }

    @Override
    public int getMaxCharLiteralLength() {
        return 0x7FFFFFFE;
    }

    @Override
    public int getMaxColumnNameLength() {
        return 1024;
    }

    @Override
    public int getMaxColumnsInGroupBy() {
        return 0;
    }

    @Override
    public int getMaxColumnsInIndex() {
        return 0;
    }

    @Override
    public int getMaxColumnsInOrderBy() {
        return 0;
    }

    @Override
    public int getMaxColumnsInSelect() {
        return 0;
    }

    @Override
    public int getMaxColumnsInTable() {
        return 100000;
    }

    @Override
    public int getMaxConnections() throws SQLException {
        return this.con.getMaxConnections();
    }

    @Override
    public int getMaxCursorNameLength() {
        return 0;
    }

    @Override
    public int getMaxIndexLength() {
        return 0;
    }

    @Override
    public int getMaxSchemaNameLength() {
        return 1024;
    }

    @Override
    public int getMaxProcedureNameLength() {
        return 256;
    }

    @Override
    public int getMaxCatalogNameLength() {
        return 0;
    }

    @Override
    public int getMaxRowSize() {
        return 0;
    }

    @Override
    public boolean doesMaxRowSizeIncludeBlobs() {
        return true;
    }

    @Override
    public int getMaxStatementLength() {
        return 0x7FFFFFFE;
    }

    @Override
    public int getMaxStatements() {
        return 0;
    }

    @Override
    public int getMaxTableNameLength() {
        return 1024;
    }

    @Override
    public int getMaxTablesInSelect() {
        return 0;
    }

    @Override
    public int getMaxUserNameLength() {
        return 1024;
    }

    @Override
    public int getDefaultTransactionIsolation() {
        return 8;
    }

    @Override
    public boolean supportsTransactions() {
        return true;
    }

    @Override
    public boolean supportsTransactionIsolationLevel(int level) {
        return level == 8;
    }

    @Override
    public boolean supportsDataDefinitionAndDataManipulationTransactions() {
        return true;
    }

    @Override
    public boolean supportsDataManipulationTransactionsOnly() {
        return false;
    }

    @Override
    public boolean dataDefinitionCausesTransactionCommit() {
        return false;
    }

    @Override
    public boolean dataDefinitionIgnoredInTransactions() {
        return false;
    }

    @Override
    public ResultSet getProcedures(String catalog, String schemaPattern, String procedureNamePattern) throws SQLException {
        StringBuilder query = new StringBuilder(980);
        query.append("SELECT cast(null as char(1)) AS \"PROCEDURE_CAT\", s.\"name\" AS \"PROCEDURE_SCHEM\", f.\"name\" AS \"PROCEDURE_NAME\", cast(null as char(1)) AS \"Field4\", cast(null as char(1)) AS \"Field5\", cast(null as char(1)) AS \"Field6\", cast(null as char(1)) AS \"REMARKS\", cast(").append(1).append(" AS smallint) AS \"PROCEDURE_TYPE\", cast(f.\"id\" as varchar(10)) AS \"SPECIFIC_NAME\" FROM \"sys\".\"functions\" f JOIN \"sys\".\"schemas\" s ON f.\"schema_id\" = s.\"id\" WHERE f.\"type\" = 2");
        if (catalog != null && !catalog.isEmpty()) {
            System.out.println("C");
            query.append(" AND 1=0");
        } else {
            if (schemaPattern != null && !schemaPattern.equals("%")) {
                System.out.println("S");
                query.append(" AND s.\"name\" ").append(this.composeMatchPart(schemaPattern));
            }
            if (procedureNamePattern != null && !procedureNamePattern.equals("%")) {
                System.out.println("P");
                query.append(" AND f.\"name\" ").append(this.composeMatchPart(procedureNamePattern));
            }
        }
        query.append(" ORDER BY \"PROCEDURE_SCHEM\", \"PROCEDURE_NAME\", \"SPECIFIC_NAME\"");
        return this.executeMetaDataQuery(query.toString());
    }

    static final String getSQLTypeMap(String column) {
        StringBuilder val = new StringBuilder(typeMap.size() * 25 + 14);
        for (Map.Entry<String, Integer> entry : typeMap.entrySet()) {
            val.append(" WHEN '").append(entry.getKey()).append("' THEN ").append(entry.getValue().toString());
        }
        val.append(" ELSE ").append(1111).append(" END");
        return "CASE " + column + val.toString();
    }

    @Override
    public ResultSet getProcedureColumns(String catalog, String schemaPattern, String procedureNamePattern, String columnNamePattern) throws SQLException {
        StringBuilder query = new StringBuilder(2900);
        query.append("SELECT cast(null as char(1)) AS \"PROCEDURE_CAT\", s.\"name\" AS \"PROCEDURE_SCHEM\", f.\"name\" AS \"PROCEDURE_NAME\", a.\"name\" AS \"COLUMN_NAME\", cast(CASE a.\"inout\" WHEN 0 THEN (CASE a.\"number\" WHEN 0 THEN ").append(5).append(" ELSE ").append(4).append(" END) WHEN 1 THEN ").append(1).append(" ELSE ").append(0).append(" END AS smallint) AS \"COLUMN_TYPE\", cast(").append(MonetDatabaseMetaData.getSQLTypeMap("a.\"type\"")).append(" AS int) AS \"DATA_TYPE\", a.\"type\" AS \"TYPE_NAME\", CASE a.\"type\" WHEN 'tinyint' THEN 3 WHEN 'smallint' THEN 5 WHEN 'int' THEN 10 WHEN 'bigint' THEN 19 WHEN 'hugeint' THEN 38 WHEN 'oid' THEN 19 WHEN 'wrd' THEN 19 ELSE a.\"type_digits\" END AS \"PRECISION\", CASE a.\"type\" WHEN 'tinyint' THEN 1 WHEN 'smallint' THEN 2 WHEN 'int' THEN 4 WHEN 'bigint' THEN 8 WHEN 'hugeint' THEN 16 WHEN 'oid' THEN 8 WHEN 'wrd' THEN 8 ELSE a.\"type_digits\" END AS \"LENGTH\", cast(CASE WHEN a.\"type\" IN ('tinyint','smallint','int','bigint','hugeint','oid','wrd','decimal','numeric','time','timetz','timestamp','timestamptz','sec_interval') THEN a.\"type_scale\" ELSE NULL END AS smallint) AS \"SCALE\", cast(CASE WHEN a.\"type\" IN ('tinyint','smallint','int','bigint','hugeint','oid','wrd','decimal','numeric') THEN 10 WHEN a.\"type\" IN ('real','float','double') THEN 2 ELSE NULL END AS smallint) AS \"RADIX\", cast(").append(2).append(" AS smallint) AS \"NULLABLE\", cast(null as char(1)) AS \"REMARKS\", cast(null as char(1)) AS \"COLUMN_DEF\", cast(0 as int) AS \"SQL_DATA_TYPE\", cast(0 as int) AS \"SQL_DATETIME_SUB\", cast(CASE WHEN a.\"type\" IN ('char','varchar','clob') THEN a.\"type_digits\" ELSE NULL END as int) AS \"CHAR_OCTET_LENGTH\", cast(a.\"number\" + 1 as int) AS \"ORDINAL_POSITION\", cast('' as varchar(3)) AS \"IS_NULLABLE\", cast(f.\"id\" as varchar(10)) AS \"SPECIFIC_NAME\" FROM \"sys\".\"args\" a JOIN \"sys\".\"functions\" f ON a.\"func_id\" = f.\"id\" JOIN \"sys\".\"schemas\" s ON f.\"schema_id\" = s.\"id\" WHERE f.\"type\" = 2");
        if (catalog != null && !catalog.isEmpty()) {
            query.append(" AND 1=0");
        } else {
            if (schemaPattern != null && !schemaPattern.equals("%")) {
                query.append(" AND s.\"name\" ").append(this.composeMatchPart(schemaPattern));
            }
            if (procedureNamePattern != null && !procedureNamePattern.equals("%")) {
                query.append(" AND f.\"name\" ").append(this.composeMatchPart(procedureNamePattern));
            }
            if (columnNamePattern != null && !columnNamePattern.equals("%")) {
                query.append(" AND a.\"name\" ").append(this.composeMatchPart(columnNamePattern));
            }
        }
        query.append(" ORDER BY \"PROCEDURE_SCHEM\", \"PROCEDURE_NAME\", \"SPECIFIC_NAME\", \"ORDINAL_POSITION\"");
        return this.executeMetaDataQuery(query.toString());
    }

    @Override
    public ResultSet getTables(String catalog, String schemaPattern, String tableNamePattern, String[] types) throws SQLException {
        StringBuilder query = new StringBuilder();
        query.append("SELECT cast(null as char(1)) AS \"TABLE_CAT\", s.\"name\" AS \"TABLE_SCHEM\", t.\"name\" AS \"TABLE_NAME\", tt.\"table_type_name\" AS \"TABLE_TYPE\", t.\"query\"  AS \"REMARKS\", cast(null as char(1)) AS \"TYPE_CAT\", cast(null as char(1)) AS \"TYPE_SCHEM\", cast(null as char(1)) AS \"TYPE_NAME\", cast(null as char(1)) AS \"SELF_REFERENCING_COL_NAME\", cast(null as char(1)) AS \"REF_GENERATION\" FROM \"sys\".\"tables\" t JOIN \"sys\".\"table_types\" tt ON t.\"type\" = tt.\"table_type_id\"JOIN \"sys\".\"schemas\" s ON t.\"schema_id\" = s.\"id\" ");
        query.append("WHERE 1=1");
        if (catalog != null && !catalog.isEmpty()) {
            query.append(" AND 1=0");
        } else {
            if (schemaPattern != null && !schemaPattern.equals("%")) {
                query.append(" AND s.\"name\" ").append(this.composeMatchPart(schemaPattern));
            }
            if (tableNamePattern != null && !tableNamePattern.equals("%")) {
                query.append(" AND t.\"name\" ").append(this.composeMatchPart(tableNamePattern));
            }
        }
        if (types != null && types.length > 0) {
            query.append(" AND tt.\"table_type_name\" IN (");
            for (int i = 0; i < types.length; ++i) {
                if (i > 0) {
                    query.append(", ");
                }
                query.append("'").append(types[i]).append("'");
            }
            query.append(")");
        }
        query.append(" ORDER BY \"TABLE_TYPE\", \"TABLE_SCHEM\", \"TABLE_NAME\"");
        return this.executeMetaDataQuery(query.toString());
    }

    @Override
    public ResultSet getSchemas(String catalog, String schemaPattern) throws SQLException {
        StringBuilder query = new StringBuilder(170);
        query.append("SELECT \"name\" AS \"TABLE_SCHEM\", cast(null as char(1)) AS \"TABLE_CATALOG\" FROM \"sys\".\"schemas\"");
        if (catalog != null && !catalog.isEmpty()) {
            query.append(" WHERE 1=0");
        } else if (schemaPattern != null && !schemaPattern.equals("%")) {
            query.append(" WHERE \"name\" ").append(this.composeMatchPart(schemaPattern));
        }
        query.append(" ORDER BY \"TABLE_SCHEM\"");
        return this.executeMetaDataQuery(query.toString());
    }

    @Override
    public ResultSet getCatalogs() throws SQLException {
        return this.executeMetaDataQuery("SELECT cast(null as char(1)) AS \"TABLE_CAT\" WHERE 1=0");
    }

    @Override
    public ResultSet getTableTypes() throws SQLException {
        String query = "SELECT \"table_type_name\" AS \"TABLE_TYPE\" FROM \"sys\".\"table_types\" ORDER BY 1";
        if ("11.19.15".compareTo(this.getDatabaseProductVersion()) >= 0) {
            query = "SELECT 'SESSION TABLE' AS \"TABLE_TYPE\" UNION ALL SELECT 'SESSION VIEW' UNION ALL SELECT 'SYSTEM SESSION TABLE' UNION ALL SELECT 'SYSTEM SESSION VIEW' UNION ALL SELECT 'SYSTEM TABLE' UNION ALL SELECT 'SYSTEM VIEW' UNION ALL SELECT 'TABLE' UNION ALL SELECT 'VIEW' ORDER BY 1";
        }
        return this.executeMetaDataQuery(query);
    }

    @Override
    public ResultSet getColumns(String catalog, String schemaPattern, String tableNamePattern, String columnNamePattern) throws SQLException {
        StringBuilder query = new StringBuilder(2450);
        query.append("SELECT cast(null as char(1)) AS \"TABLE_CAT\", s.\"name\" AS \"TABLE_SCHEM\", t.\"name\" AS \"TABLE_NAME\", c.\"name\" AS \"COLUMN_NAME\", cast(").append(MonetDatabaseMetaData.getSQLTypeMap("c.\"type\"")).append(" AS int) AS \"DATA_TYPE\", c.\"type\" AS \"TYPE_NAME\", c.\"type_digits\" AS \"COLUMN_SIZE\", cast(0 as int) AS \"BUFFER_LENGTH\", c.\"type_scale\" AS \"DECIMAL_DIGITS\", cast(CASE WHEN c.\"type\" IN ('decimal', 'numeric', 'sec_interval') THEN 10 WHEN c.\"type\" IN ('int', 'smallint', 'tinyint', 'bigint', 'hugeint', 'float', 'real', 'double', 'oid', 'wrd') THEN 2 ELSE 0 END AS int) AS \"NUM_PREC_RADIX\", cast(CASE c.\"null\" WHEN true THEN ").append(1).append(" WHEN false THEN ").append(0).append(" END AS int) AS \"NULLABLE\", ").append("cast(null AS varchar(9999))").append(" AS \"REMARKS\", c.\"default\" AS \"COLUMN_DEF\", cast(0 as int) AS \"SQL_DATA_TYPE\", cast(0 as int) AS \"SQL_DATETIME_SUB\", cast(CASE WHEN c.\"type\" IN ('char','varchar','clob') THEN c.\"type_digits\" ELSE NULL END as int) AS \"CHAR_OCTET_LENGTH\", cast(c.\"number\" + 1 as int) AS \"ORDINAL_POSITION\", cast(CASE c.\"null\" WHEN true THEN 'YES' WHEN false THEN 'NO' ELSE '' END AS varchar(3)) AS \"IS_NULLABLE\", cast(null AS char(1)) AS \"SCOPE_CATALOG\", cast(null AS char(1)) AS \"SCOPE_SCHEMA\", cast(null AS char(1)) AS \"SCOPE_TABLE\", cast(null AS char(1)) AS \"SOURCE_DATA_TYPE\", cast(CASE WHEN c.\"default\" IS NOT NULL AND c.\"default\" LIKE 'next value for %' THEN 'YES' ELSE 'NO' END AS varchar(3)) AS \"IS_AUTOINCREMENT\", cast('NO' AS varchar(3)) AS \"IS_GENERATEDCOLUMN\" FROM \"sys\".\"columns\" c JOIN \"sys\".\"tables\" t ON c.\"table_id\" = t.\"id\" JOIN \"sys\".\"schemas\" s ON t.\"schema_id\" = s.\"id\" ");
        query.append("WHERE 1=1");
        if (catalog != null && !catalog.isEmpty()) {
            query.append(" AND 1=0");
        } else {
            if (schemaPattern != null && !schemaPattern.equals("%")) {
                query.append(" AND s.\"name\" ").append(this.composeMatchPart(schemaPattern));
            }
            if (tableNamePattern != null && !tableNamePattern.equals("%")) {
                query.append(" AND t.\"name\" ").append(this.composeMatchPart(tableNamePattern));
            }
            if (columnNamePattern != null && !columnNamePattern.equals("%")) {
                query.append(" AND c.\"name\" ").append(this.composeMatchPart(columnNamePattern));
            }
        }
        query.append(" ORDER BY \"TABLE_SCHEM\", \"TABLE_NAME\", \"ORDINAL_POSITION\"");
        return this.executeMetaDataQuery(query.toString());
    }

    @Override
    public ResultSet getColumnPrivileges(String catalog, String schemaPattern, String tableNamePattern, String columnNamePattern) throws SQLException {
        StringBuilder query = new StringBuilder();
        query.append("SELECT cast(null as char(1)) AS \"TABLE_CAT\", s.\"name\" AS \"TABLE_SCHEM\", t.\"name\" AS \"TABLE_NAME\", c.\"name\" AS \"COLUMN_NAME\", grantors.\"name\" AS \"GRANTOR\", grantees.\"name\" AS \"GRANTEE\", pc.\"privilege_code_name\" AS \"PRIVILEGE\", cast(CASE p.\"grantable\" WHEN 0 THEN 'NO' WHEN 1 THEN 'YES' ELSE NULL END AS varchar(3)) AS \"IS_GRANTABLE\" FROM \"sys\".\"privileges\" p JOIN \"sys\".\"columns\" c ON p.\"obj_id\" = c.\"table_id\" JOIN \"sys\".\"tables\" t ON c.\"table_id\" = t.\"id\" JOIN \"sys\".\"schemas\" s ON t.\"schema_id\" = s.\"id\" JOIN \"sys\".\"auths\" grantors ON p.\"grantor\" = grantors.\"id\" JOIN \"sys\".\"auths\" grantees ON p.\"auth_id\" = grantees.\"id\" JOIN \"sys\".\"privilege_codes\" pc ON p.\"privileges\" = pc.\"privilege_code_id\" ");
        query.append("WHERE 1=1");
        if (catalog != null && !catalog.isEmpty()) {
            query.append(" AND 1=0");
        } else {
            if (schemaPattern != null && !schemaPattern.equals("%")) {
                query.append(" AND s.\"name\" ").append(this.composeMatchPart(schemaPattern));
            }
            if (tableNamePattern != null && !tableNamePattern.equals("%")) {
                query.append(" AND t.\"name\" ").append(this.composeMatchPart(tableNamePattern));
            }
            if (columnNamePattern != null && !columnNamePattern.equals("%")) {
                query.append(" AND c.\"name\" ").append(this.composeMatchPart(columnNamePattern));
            }
        }
        query.append(" ORDER BY \"TABLE_SCHEM\", \"TABLE_NAME\", \"COLUMN_NAME\", \"PRIVILEGE\"");
        return this.executeMetaDataQuery(query.toString());
    }

    @Override
    public ResultSet getTablePrivileges(String catalog, String schemaPattern, String tableNamePattern) throws SQLException {
        StringBuilder query = new StringBuilder(1000);
        query.append("SELECT cast(null as char(1)) AS \"TABLE_CAT\", s.\"name\" AS \"TABLE_SCHEM\", t.\"name\" AS \"TABLE_NAME\", grantors.\"name\" AS \"GRANTOR\", grantees.\"name\" AS \"GRANTEE\", pc.\"privilege_code_name\" AS \"PRIVILEGE\", cast(CASE p.\"grantable\" WHEN 0 THEN 'NO' WHEN 1 THEN 'YES' ELSE NULL END AS varchar(3)) AS \"IS_GRANTABLE\" FROM \"sys\".\"privileges\" p JOIN \"sys\".\"tables\" t ON p.\"obj_id\" = t.\"id\" JOIN \"sys\".\"schemas\" s ON t.\"schema_id\" = s.\"id\" JOIN \"sys\".\"auths\" grantors ON p.\"grantor\" = grantors.\"id\" JOIN \"sys\".\"auths\" grantees ON p.\"auth_id\" = grantees.\"id\" JOIN \"sys\".\"privilege_codes\" pc ON p.\"privileges\" = pc.\"privilege_code_id\"");
        query.append("WHERE 1=1");
        if (catalog != null && !catalog.isEmpty()) {
            query.append(" AND 1=0");
        } else {
            if (schemaPattern != null && !schemaPattern.equals("%")) {
                query.append(" AND s.\"name\" ").append(this.composeMatchPart(schemaPattern));
            }
            if (tableNamePattern != null && !tableNamePattern.equals("%")) {
                query.append(" AND t.\"name\" ").append(this.composeMatchPart(tableNamePattern));
            }
        }
        query.append(" ORDER BY \"TABLE_SCHEM\", \"TABLE_NAME\", \"PRIVILEGE\"");
        return this.executeMetaDataQuery(query.toString());
    }

    @Override
    public ResultSet getBestRowIdentifier(String catalog, String schema, String table, int scope, boolean nullable) throws SQLException {
        return null;
    }

    @Override
    public ResultSet getVersionColumns(String catalog, String schema, String table) throws SQLException {
        String query = "SELECT cast(0 as smallint) AS \"SCOPE\", cast(null as char(1)) AS \"COLUMN_NAME\", cast(0 as int) AS \"DATA_TYPE\", cast(null as char(1)) AS \"TYPE_NAME\", cast(0 as int) AS \"COLUMN_SIZE\", cast(0 as int) AS \"BUFFER_LENGTH\", cast(0 as smallint) AS \"DECIMAL_DIGITS\", cast(0 as smallint) AS \"PSEUDO_COLUMN\" WHERE 1=0";
        return this.executeMetaDataQuery("SELECT cast(0 as smallint) AS \"SCOPE\", cast(null as char(1)) AS \"COLUMN_NAME\", cast(0 as int) AS \"DATA_TYPE\", cast(null as char(1)) AS \"TYPE_NAME\", cast(0 as int) AS \"COLUMN_SIZE\", cast(0 as int) AS \"BUFFER_LENGTH\", cast(0 as smallint) AS \"DECIMAL_DIGITS\", cast(0 as smallint) AS \"PSEUDO_COLUMN\" WHERE 1=0");
    }

    @Override
    public ResultSet getPrimaryKeys(String catalog, String schema, String table) throws SQLException {
        StringBuilder query = new StringBuilder(600);
        query.append("SELECT cast(null AS char(1)) AS \"TABLE_CAT\", s.\"name\" AS \"TABLE_SCHEM\", t.\"name\" AS \"TABLE_NAME\", o.\"name\" AS \"COLUMN_NAME\", cast(1 + o.\"nr\" AS smallint) AS \"KEY_SEQ\",  k.\"name\" AS \"PK_NAME\" FROM \"sys\".\"keys\" k JOIN \"sys\".\"objects\" o ON k.\"id\" = o.\"id\" JOIN \"sys\".\"tables\" t ON k.\"table_id\" = t.\"id\" JOIN \"sys\".\"schemas\" s ON t.\"schema_id\" = s.\"id\" WHERE k.\"type\" = 0");
        if (catalog != null && !catalog.isEmpty()) {
            query.append(" AND 1=0");
        } else {
            if (schema != null && !schema.equals("%")) {
                query.append(" AND s.\"name\" ").append(this.composeMatchPart(schema));
            }
            if (table != null && !table.equals("%")) {
                query.append(" AND t.\"name\" ").append(this.composeMatchPart(table));
            }
        }
        query.append(" ORDER BY \"TABLE_SCHEM\", \"TABLE_NAME\", \"COLUMN_NAME\"");
        return this.executeMetaDataQuery(query.toString());
    }

    @Override
    public ResultSet getImportedKeys(String catalog, String schema, String table) throws SQLException {
        StringBuilder query = new StringBuilder(keyQuery.length() + 250);
        query.append(keyQuery);
        if (catalog != null && !catalog.isEmpty()) {
            query.append(" AND 1=0");
        } else {
            if (schema != null && !schema.equals("%")) {
                query.append(" AND fkschema.\"name\" ").append(this.composeMatchPart(schema));
            }
            if (table != null && !table.equals("%")) {
                query.append(" AND fktable.\"name\" ").append(this.composeMatchPart(table));
            }
        }
        query.append(" ORDER BY \"PKTABLE_SCHEM\", \"PKTABLE_NAME\", \"PK_NAME\", \"KEY_SEQ\"");
        return this.executeMetaDataQuery(query.toString());
    }

    @Override
    public ResultSet getExportedKeys(String catalog, String schema, String table) throws SQLException {
        StringBuilder query = new StringBuilder(keyQuery.length() + 250);
        query.append(keyQuery);
        if (catalog != null && !catalog.isEmpty()) {
            query.append(" AND 1=0");
        } else {
            if (schema != null && !schema.equals("%")) {
                query.append(" AND pkschema.\"name\" ").append(this.composeMatchPart(schema));
            }
            if (table != null && !table.equals("%")) {
                query.append(" AND pktable.\"name\" ").append(this.composeMatchPart(table));
            }
        }
        query.append(" ORDER BY \"FKTABLE_SCHEM\", \"FKTABLE_NAME\", \"FK_NAME\", \"KEY_SEQ\"");
        return this.executeMetaDataQuery(query.toString());
    }

    @Override
    public ResultSet getCrossReference(String pcatalog, String pschema, String ptable, String fcatalog, String fschema, String ftable) throws SQLException {
        StringBuilder query = new StringBuilder(keyQuery.length() + 350);
        query.append(keyQuery);
        if (pcatalog != null && !pcatalog.isEmpty() || fcatalog != null && !fcatalog.isEmpty()) {
            query.append(" AND 1=0");
        } else {
            if (pschema != null && !pschema.equals("%")) {
                query.append(" AND pkschema.\"name\" ").append(this.composeMatchPart(pschema));
            }
            if (ptable != null && !ptable.equals("%")) {
                query.append(" AND pktable.\"name\" ").append(this.composeMatchPart(ptable));
            }
            if (fschema != null && !fschema.equals("%")) {
                query.append(" AND fkschema.\"name\" ").append(this.composeMatchPart(fschema));
            }
            if (ftable != null && !ftable.equals("%")) {
                query.append(" AND fktable.\"name\" ").append(this.composeMatchPart(ftable));
            }
        }
        query.append(" ORDER BY \"FKTABLE_SCHEM\", \"FKTABLE_NAME\", \"FK_NAME\", \"KEY_SEQ\"");
        return this.executeMetaDataQuery(query.toString());
    }

    @Override
    public ResultSet getTypeInfo() throws SQLException {
        StringBuilder query = new StringBuilder(2300);
        query.append("SELECT \"sqlname\" AS \"TYPE_NAME\", cast(").append(MonetDatabaseMetaData.getSQLTypeMap("\"sqlname\"")).append(" AS int) AS \"DATA_TYPE\", \"digits\" AS \"PRECISION\", cast(CASE WHEN \"systemname\" IN ('str','inet','json','url','uuid','blob','sqlblob') THEN '''' ELSE NULL END AS varchar(2)) AS \"LITERAL_PREFIX\", cast(CASE WHEN \"systemname\" IN ('str','inet','json','url','uuid','blob','sqlblob') THEN '''' ELSE NULL END AS varchar(2)) AS \"LITERAL_SUFFIX\", CASE WHEN \"sqlname\" IN ('char', 'varchar') THEN 'max length' WHEN \"sqlname\" = 'decimal' THEN 'precision, scale' WHEN \"sqlname\" IN ('time', 'timetz', 'timestamp', 'timestamptz', 'sec_interval') THEN 'precision' ELSE NULL END AS \"CREATE_PARAMS\", cast(CASE WHEN \"systemname\" = 'oid' THEN ").append(0).append(" ELSE ").append(1).append(" END AS smallint) AS \"NULLABLE\", CASE WHEN \"systemname\" IN ('str','json','url') THEN true ELSE false END AS \"CASE_SENSITIVE\", cast(CASE WHEN \"systemname\" IN ('str','inet','json','url','uuid','blob','sqlblob') THEN ").append(3).append(" ELSE ").append(2).append(" END AS smallint) AS \"SEARCHABLE\", CASE WHEN \"sqlname\" IN ('tinyint','smallint','int','bigint','hugeint','decimal','real','double','sec_interval','month_interval') THEN false ELSE true END AS \"UNSIGNED_ATTRIBUTE\", CASE \"sqlname\" WHEN 'decimal' THEN true ELSE false END AS \"FIXED_PREC_SCALE\", CASE WHEN \"sqlname\" IN ('tinyint','smallint','int','bigint','hugeint','decimal','oid','wrd') THEN true ELSE false END AS \"AUTO_INCREMENT\", \"systemname\" AS \"LOCAL_TYPE_NAME\", cast(0 AS smallint) AS \"MINIMUM_SCALE\", cast(CASE WHEN \"sqlname\" = 'decimal' THEN (CASE \"systemname\" WHEN 'lng' THEN 18 WHEN 'hge' THEN 38 WHEN 'int' THEN 9 WHEN 'sht' THEN 4 WHEN 'bte' THEN 2 ELSE 0 END) WHEN \"sqlname\" IN ('time', 'timetz', 'timestamp', 'timestamptz', 'sec_interval') THEN 6 ELSE 0 END AS smallint) AS \"MAXIMUM_SCALE\", cast(0 AS int) AS \"SQL_DATA_TYPE\", cast(0 AS int) AS \"SQL_DATETIME_SUB\", cast(\"radix\" as int) AS \"NUM_PREC_RADIX\" FROM \"sys\".\"types\" ORDER BY \"DATA_TYPE\", \"sqlname\", \"id\"");
        return this.executeMetaDataQuery(query.toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ResultSet getIndexInfo(String catalog, String schema, String table, boolean unique, boolean approximate) throws SQLException {
        String table_row_count = "0";
        if (!(approximate || schema == null || schema.isEmpty() || schema.contains("%") || table == null || table.isEmpty() || table.contains("%"))) {
            try (ResultSet count = null;){
                String count_value;
                count = this.executeMetaDataQuery("SELECT COUNT(*) FROM \"" + schema + "\".\"" + table + "\"");
                if (count != null && count.next() && (count_value = count.getString(1)) != null && !count_value.isEmpty()) {
                    table_row_count = count_value;
                }
            }
        }
        StringBuilder query = new StringBuilder(1250);
        query.append("SELECT cast(null AS char(1)) AS \"TABLE_CAT\", s.\"name\" AS \"TABLE_SCHEM\", t.\"name\" AS \"TABLE_NAME\", CASE WHEN k.\"name\" IS NULL THEN true ELSE false END AS \"NON_UNIQUE\", cast(null AS char(1)) AS \"INDEX_QUALIFIER\", i.\"name\" AS \"INDEX_NAME\", CASE i.\"type\" WHEN 0 THEN ").append(2).append(" ELSE ").append(3).append(" END AS \"TYPE\", cast(o.\"nr\" +1 AS smallint) AS \"ORDINAL_POSITION\", c.\"name\" AS \"COLUMN_NAME\", cast(null AS char(1)) AS \"ASC_OR_DESC\", cast(").append(table_row_count).append(" AS int) AS \"CARDINALITY\", cast(0 AS int) AS \"PAGES\", cast(null AS char(1)) AS \"FILTER_CONDITION\" FROM \"sys\".\"idxs\" i JOIN \"sys\".\"tables\" t ON i.\"table_id\" = t.\"id\" JOIN \"sys\".\"schemas\" s ON t.\"schema_id\" = s.\"id\" JOIN \"sys\".\"objects\" o ON i.\"id\" = o.\"id\" JOIN \"sys\".\"columns\" c ON (t.\"id\" = c.\"table_id\" AND o.\"name\" = c.\"name\") LEFT OUTER JOIN \"sys\".\"keys\" k ON (i.\"name\" = k.\"name\" AND i.\"table_id\" = k.\"table_id\" AND k.\"type\" IN (0,1)) WHERE 1=1");
        if (catalog != null && !catalog.isEmpty()) {
            query.append(" AND 1=0");
        } else {
            if (schema != null && !schema.equals("%")) {
                query.append(" AND s.\"name\" ").append(this.composeMatchPart(schema));
            }
            if (table != null && !table.equals("%")) {
                query.append(" AND t.\"name\" ").append(this.composeMatchPart(table));
            }
            if (unique) {
                query.append(" AND k.\"name\" IS NOT NULL");
            }
        }
        query.append(" ORDER BY \"NON_UNIQUE\", \"TYPE\", \"INDEX_NAME\", \"ORDINAL_POSITION\"");
        return this.executeMetaDataQuery(query.toString());
    }

    @Override
    public boolean supportsResultSetType(int type) throws SQLException {
        return type != 1005;
    }

    @Override
    public boolean supportsResultSetConcurrency(int type, int concurrency) throws SQLException {
        if (type == 1005) {
            return false;
        }
        return concurrency == 1007;
    }

    @Override
    public boolean ownUpdatesAreVisible(int type) {
        return false;
    }

    @Override
    public boolean ownDeletesAreVisible(int type) {
        return false;
    }

    @Override
    public boolean ownInsertsAreVisible(int type) {
        return false;
    }

    @Override
    public boolean othersUpdatesAreVisible(int type) {
        return false;
    }

    @Override
    public boolean othersDeletesAreVisible(int i) {
        return false;
    }

    @Override
    public boolean othersInsertsAreVisible(int type) {
        return false;
    }

    @Override
    public boolean updatesAreDetected(int type) {
        return false;
    }

    @Override
    public boolean deletesAreDetected(int i) {
        return false;
    }

    @Override
    public boolean insertsAreDetected(int type) {
        return false;
    }

    @Override
    public boolean supportsBatchUpdates() {
        return true;
    }

    @Override
    public ResultSet getUDTs(String catalog, String schemaPattern, String typeNamePattern, int[] types) throws SQLException {
        return null;
    }

    @Override
    public Connection getConnection() {
        return this.con;
    }

    @Override
    public boolean supportsSavepoints() {
        return true;
    }

    @Override
    public boolean supportsNamedParameters() {
        return false;
    }

    @Override
    public boolean supportsMultipleOpenResults() {
        return false;
    }

    @Override
    public boolean supportsGetGeneratedKeys() {
        return true;
    }

    @Override
    public ResultSet getSuperTypes(String catalog, String schemaPattern, String typeNamePattern) throws SQLException {
        String query = "SELECT cast(null as char(1)) AS \"TYPE_CAT\", '' AS \"TYPE_SCHEM\", '' AS \"TYPE_NAME\", cast(null as char(1)) AS \"SUPERTYPE_CAT\", '' AS \"SUPERTYPE_SCHEM\", '' AS \"SUPERTYPE_NAME\" WHERE 1=0";
        return this.executeMetaDataQuery("SELECT cast(null as char(1)) AS \"TYPE_CAT\", '' AS \"TYPE_SCHEM\", '' AS \"TYPE_NAME\", cast(null as char(1)) AS \"SUPERTYPE_CAT\", '' AS \"SUPERTYPE_SCHEM\", '' AS \"SUPERTYPE_NAME\" WHERE 1=0");
    }

    @Override
    public ResultSet getSuperTables(String catalog, String schemaPattern, String tableNamePattern) throws SQLException {
        String query = "SELECT cast(null as char(1)) AS \"TABLE_CAT\", '' AS \"TABLE_SCHEM\", '' AS \"TABLE_NAME\", '' AS \"SUPERTABLE_NAME\" WHERE 1=0";
        return this.executeMetaDataQuery("SELECT cast(null as char(1)) AS \"TABLE_CAT\", '' AS \"TABLE_SCHEM\", '' AS \"TABLE_NAME\", '' AS \"SUPERTABLE_NAME\" WHERE 1=0");
    }

    @Override
    public ResultSet getAttributes(String catalog, String schemaPattern, String typeNamePattern, String attributeNamePattern) throws SQLException {
        String query = "SELECT cast(null as char(1)) AS \"TYPE_CAT\", '' AS \"TYPE_SCHEM\", '' AS \"TYPE_NAME\", '' AS \"ATTR_NAME\", cast(0 as int) AS \"DATA_TYPE\", '' AS \"ATTR_TYPE_NAME\", cast(0 as int) AS \"ATTR_SIZE\", cast(0 as int) AS \"DECIMAL_DIGITS\", cast(0 as int) AS \"NUM_PREC_RADIX\", cast(0 as int) AS \"NULLABLE\", '' AS \"REMARKS\", '' AS \"ATTR_DEF\", cast(0 as int) AS \"SQL_DATA_TYPE\", cast(0 as int) AS \"SQL_DATETIME_SUB\", cast(0 as int) AS \"CHAR_OCTET_LENGTH\", cast(0 as int) AS \"ORDINAL_POSITION\", 'YES' AS \"IS_NULLABLE\", '' AS \"SCOPE_CATALOG\", '' AS \"SCOPE_SCHEMA\", '' AS \"SCOPE_TABLE\", cast(0 as smallint) AS \"SOURCE_DATA_TYPE\" WHERE 1=0";
        return this.executeMetaDataQuery("SELECT cast(null as char(1)) AS \"TYPE_CAT\", '' AS \"TYPE_SCHEM\", '' AS \"TYPE_NAME\", '' AS \"ATTR_NAME\", cast(0 as int) AS \"DATA_TYPE\", '' AS \"ATTR_TYPE_NAME\", cast(0 as int) AS \"ATTR_SIZE\", cast(0 as int) AS \"DECIMAL_DIGITS\", cast(0 as int) AS \"NUM_PREC_RADIX\", cast(0 as int) AS \"NULLABLE\", '' AS \"REMARKS\", '' AS \"ATTR_DEF\", cast(0 as int) AS \"SQL_DATA_TYPE\", cast(0 as int) AS \"SQL_DATETIME_SUB\", cast(0 as int) AS \"CHAR_OCTET_LENGTH\", cast(0 as int) AS \"ORDINAL_POSITION\", 'YES' AS \"IS_NULLABLE\", '' AS \"SCOPE_CATALOG\", '' AS \"SCOPE_SCHEMA\", '' AS \"SCOPE_TABLE\", cast(0 as smallint) AS \"SOURCE_DATA_TYPE\" WHERE 1=0");
    }

    @Override
    public boolean supportsResultSetHoldability(int holdability) {
        return holdability == 1;
    }

    @Override
    public int getResultSetHoldability() {
        return 1;
    }

    @Override
    public int getDatabaseMajorVersion() throws SQLException {
        return MonetDriver.getDatabaseMajorVersion();
    }

    @Override
    public int getDatabaseMinorVersion() throws SQLException {
        return MonetDriver.getDatabaseMinorVersion();
    }

    @Override
    public int getJDBCMajorVersion() {
        return 4;
    }

    @Override
    public int getJDBCMinorVersion() {
        return 3;
    }

    @Override
    public int getSQLStateType() {
        return 2;
    }

    @Override
    public boolean locatorsUpdateCopy() {
        return true;
    }

    @Override
    public boolean supportsStatementPooling() {
        return false;
    }

    @Override
    public RowIdLifetime getRowIdLifetime() {
        return RowIdLifetime.ROWID_UNSUPPORTED;
    }

    @Override
    public ResultSet getSchemas() throws SQLException {
        return this.getSchemas(null, null);
    }

    @Override
    public boolean supportsStoredFunctionsUsingCallSyntax() {
        return false;
    }

    @Override
    public boolean autoCommitFailureClosesAllResultSets() {
        return false;
    }

    @Override
    public ResultSet getClientInfoProperties() throws SQLException {
        String query = "SELECT 'host' AS \"NAME\", cast(1024 as int) AS \"MAX_LEN\", 'localhost' AS \"DEFAULT_VALUE\", 'DSN or IP-address of machine running MonetDB' AS \"DESCRIPTION\" UNION ALL SELECT 'port', 5, '50000', 'communication port number of MonetDB server process' UNION ALL SELECT 'user', 1024, 'monetdb', 'user name to login to MonetDB server' UNION ALL SELECT 'password', 128, 'monetdb', 'password for user name to login to MonetDB server' UNION ALL SELECT 'language', 16, 'sql', 'language (sql or mal) used to parse commands in MonetDB server' UNION ALL SELECT 'database', 1024, 'demo', 'name of database. It matches the dbfarm subdirectory name' UNION ALL SELECT 'so_timeout', 10, '0', 'timeout (in milliseconds) of communication socket. 0 means no timeout is set' ORDER BY \"NAME\"";
        return this.executeMetaDataQuery("SELECT 'host' AS \"NAME\", cast(1024 as int) AS \"MAX_LEN\", 'localhost' AS \"DEFAULT_VALUE\", 'DSN or IP-address of machine running MonetDB' AS \"DESCRIPTION\" UNION ALL SELECT 'port', 5, '50000', 'communication port number of MonetDB server process' UNION ALL SELECT 'user', 1024, 'monetdb', 'user name to login to MonetDB server' UNION ALL SELECT 'password', 128, 'monetdb', 'password for user name to login to MonetDB server' UNION ALL SELECT 'language', 16, 'sql', 'language (sql or mal) used to parse commands in MonetDB server' UNION ALL SELECT 'database', 1024, 'demo', 'name of database. It matches the dbfarm subdirectory name' UNION ALL SELECT 'so_timeout', 10, '0', 'timeout (in milliseconds) of communication socket. 0 means no timeout is set' ORDER BY \"NAME\"");
    }

    @Override
    public ResultSet getFunctions(String catalog, String schemaPattern, String functionNamePattern) throws SQLException {
        StringBuilder query = new StringBuilder(800);
        query.append("SELECT cast(null as char(1)) AS \"FUNCTION_CAT\", s.\"name\" AS \"FUNCTION_SCHEM\", f.\"name\" AS \"FUNCTION_NAME\", cast(f.\"func\" as varchar(9999)) AS \"REMARKS\", CASE WHEN f.\"type\" IN (1,2,3,4,6) THEN ").append(1).append(" WHEN f.\"type\" IN (5,7) THEN ").append(2).append(" ELSE ").append(0).append(" END AS \"FUNCTION_TYPE\", cast(f.\"id\" as varchar(10)) AS \"SPECIFIC_NAME\" FROM \"sys\".\"functions\" f JOIN \"sys\".\"schemas\" s ON f.\"schema_id\" = s.\"id\" ");
        query.append("WHERE f.\"type\" <> 2");
        if (catalog != null && !catalog.isEmpty()) {
            query.append(" AND 1=0");
        } else {
            if (schemaPattern != null && !schemaPattern.equals("%")) {
                query.append(" AND s.\"name\" ").append(this.composeMatchPart(schemaPattern));
            }
            if (functionNamePattern != null && !functionNamePattern.equals("%")) {
                query.append(" AND f.\"name\" ").append(this.composeMatchPart(functionNamePattern));
            }
        }
        query.append(" ORDER BY \"FUNCTION_SCHEM\", \"FUNCTION_NAME\", \"SPECIFIC_NAME\"");
        return this.executeMetaDataQuery(query.toString());
    }

    @Override
    public ResultSet getFunctionColumns(String catalog, String schemaPattern, String functionNamePattern, String columnNamePattern) throws SQLException {
        StringBuilder query = new StringBuilder(2600);
        query.append("SELECT cast(null as char(1)) AS \"FUNCTION_CAT\", s.\"name\" AS \"FUNCTION_SCHEM\", f.\"name\" AS \"FUNCTION_NAME\", a.\"name\" AS \"COLUMN_NAME\", cast(CASE a.\"inout\" WHEN 0 THEN (CASE a.\"number\" WHEN 0 THEN ").append(4).append(" ELSE ").append(3).append(" END) WHEN 1 THEN ").append(1).append(" ELSE ").append(0).append(" END AS smallint) AS \"COLUMN_TYPE\", cast(").append(MonetDatabaseMetaData.getSQLTypeMap("a.\"type\"")).append(" AS int) AS \"DATA_TYPE\", a.\"type\" AS \"TYPE_NAME\", CASE a.\"type\" WHEN 'tinyint' THEN 3 WHEN 'smallint' THEN 5 WHEN 'int' THEN 10 WHEN 'bigint' THEN 19 WHEN 'hugeint' THEN 38 WHEN 'oid' THEN 19 WHEN 'wrd' THEN 19 ELSE a.\"type_digits\" END AS \"PRECISION\", CASE a.\"type\" WHEN 'tinyint' THEN 1 WHEN 'smallint' THEN 2 WHEN 'int' THEN 4 WHEN 'bigint' THEN 8 WHEN 'hugeint' THEN 16 WHEN 'oid' THEN 8 WHEN 'wrd' THEN 8 ELSE a.\"type_digits\" END AS \"LENGTH\", cast(CASE WHEN a.\"type\" IN ('tinyint','smallint','int','bigint','hugeint','oid','wrd','decimal','numeric','time','timetz','timestamp','timestamptz','sec_interval') THEN a.\"type_scale\" ELSE NULL END AS smallint) AS \"SCALE\", cast(CASE WHEN a.\"type\" IN ('tinyint','smallint','int','bigint','hugeint','oid','wrd','decimal','numeric') THEN 10 WHEN a.\"type\" IN ('real','float','double') THEN 2 ELSE NULL END AS smallint) AS \"RADIX\", cast(").append(2).append(" AS smallint) AS \"NULLABLE\", cast(null as char(1)) AS \"REMARKS\", cast(CASE WHEN a.\"type\" IN ('char','varchar','clob') THEN a.\"type_digits\" ELSE NULL END as int) AS \"CHAR_OCTET_LENGTH\", cast(a.\"number\" as int) AS \"ORDINAL_POSITION\", cast('' as varchar(3)) AS \"IS_NULLABLE\", cast(f.\"id\" as varchar(10)) AS \"SPECIFIC_NAME\" FROM \"sys\".\"args\" a JOIN \"sys\".\"functions\" f ON a.\"func_id\" = f.\"id\" JOIN \"sys\".\"schemas\" s ON f.\"schema_id\" = s.\"id\" WHERE f.\"type\" <> 2");
        if (catalog != null && !catalog.isEmpty()) {
            query.append(" AND 1=0");
        } else {
            if (schemaPattern != null && !schemaPattern.equals("%")) {
                query.append(" AND s.\"name\" ").append(this.composeMatchPart(schemaPattern));
            }
            if (functionNamePattern != null && !functionNamePattern.equals("%")) {
                query.append(" AND f.\"name\" ").append(this.composeMatchPart(functionNamePattern));
            }
            if (columnNamePattern != null && !columnNamePattern.equals("%")) {
                query.append(" AND a.\"name\" ").append(this.composeMatchPart(columnNamePattern));
            }
        }
        query.append(" ORDER BY \"FUNCTION_SCHEM\", \"FUNCTION_NAME\", \"SPECIFIC_NAME\", \"ORDINAL_POSITION\"");
        return this.executeMetaDataQuery(query.toString());
    }

    @Override
    public ResultSet getPseudoColumns(String catalog, String schemaPattern, String tableNamePattern, String columnNamePattern) throws SQLException {
        String query = "SELECT cast(null as char(1)) AS \"TABLE_CAT\", '' AS \"TABLE_SCHEM\", '' AS \"TABLE_NAME\", '' AS \"COLUMN_NAME\", cast(0 as int) AS \"DATA_TYPE\", cast(0 as int) AS \"COLUMN_SIZE\", cast(0 as int) AS \"DECIMAL_DIGITS\", cast(0 as int) AS \"NUM_PREC_RADIX\", '' AS \"COLUMN_USAGE\", '' AS \"REMARKS\", cast(0 as int) AS \"CHAR_OCTET_LENGTH\", '' AS \"IS_NULLABLE\" WHERE 1=0";
        return this.executeMetaDataQuery("SELECT cast(null as char(1)) AS \"TABLE_CAT\", '' AS \"TABLE_SCHEM\", '' AS \"TABLE_NAME\", '' AS \"COLUMN_NAME\", cast(0 as int) AS \"DATA_TYPE\", cast(0 as int) AS \"COLUMN_SIZE\", cast(0 as int) AS \"DECIMAL_DIGITS\", cast(0 as int) AS \"NUM_PREC_RADIX\", '' AS \"COLUMN_USAGE\", '' AS \"REMARKS\", cast(0 as int) AS \"CHAR_OCTET_LENGTH\", '' AS \"IS_NULLABLE\" WHERE 1=0");
    }

    @Override
    public boolean generatedKeyAlwaysReturned() throws SQLException {
        return true;
    }

    @Override
    public long getMaxLogicalLobSize() {
        return 0L;
    }

    @Override
    public boolean supportsRefCursors() {
        return false;
    }

    private final ResultSet executeMetaDataQuery(String query) throws SQLException {
        Statement stmt = this.con.createStatement(1004, 1007);
        ResultSet rs = null;
        if (stmt != null) {
            rs = stmt.executeQuery(query);
            if (rs != null) {
                stmt.closeOnCompletion();
            } else {
                stmt.close();
            }
        }
        return rs;
    }

    private final String composeMatchPart(String in) {
        if (in == null) {
            return "IS NULL";
        }
        String cmp = "= '";
        if (in.contains("%") || in.contains("_")) {
            cmp = "LIKE '";
        }
        return cmp + in + "'";
    }

    static {
        typeMap.put("bigint", -5);
        typeMap.put("blob", 2004);
        typeMap.put("boolean", 16);
        typeMap.put("char", 1);
        typeMap.put("clob", 2005);
        typeMap.put("date", 91);
        typeMap.put("decimal", 3);
        typeMap.put("double", 8);
        typeMap.put("hugeint", 2);
        typeMap.put("inet", 12);
        typeMap.put("int", 4);
        typeMap.put("json", 12);
        typeMap.put("month_interval", 4);
        typeMap.put("oid", -5);
        typeMap.put("real", 7);
        typeMap.put("sec_interval", 3);
        typeMap.put("smallint", 5);
        typeMap.put("str", 12);
        typeMap.put("time", 92);
        typeMap.put("timestamp", 93);
        typeMap.put("timestamptz", 93);
        typeMap.put("timetz", 92);
        typeMap.put("tinyint", -6);
        typeMap.put("url", 12);
        typeMap.put("uuid", 12);
        typeMap.put("varchar", 12);
        typeMap.put("wrd", -5);
    }
}

