/*
 * Decompiled with CFR 0.152.
 */
package org.monetdb.monetdbe;

import java.nio.ByteBuffer;
import java.sql.Array;
import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.NClob;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLClientInfoException;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.sql.SQLWarning;
import java.sql.SQLXML;
import java.sql.Savepoint;
import java.sql.Statement;
import java.sql.Struct;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.Executor;
import org.monetdb.monetdbe.MonetBlob;
import org.monetdb.monetdbe.MonetCallableStatement;
import org.monetdb.monetdbe.MonetClob;
import org.monetdb.monetdbe.MonetDatabaseMetaData;
import org.monetdb.monetdbe.MonetNative;
import org.monetdb.monetdbe.MonetPreparedStatement;
import org.monetdb.monetdbe.MonetStatement;
import org.monetdb.monetdbe.MonetWrapper;

public class MonetConnection
extends MonetWrapper
implements Connection {
    protected ByteBuffer dbNative;
    private Properties properties;
    private List<MonetStatement> statements;
    private SQLWarning warnings;
    private int sessiontimeout;
    private int querytimeout;
    private int memorylimit;
    private int nr_threads;
    private boolean autoCommit;
    private String jdbcURL;

    MonetConnection(Properties props) throws SQLException, IllegalArgumentException {
        String error_msg;
        this.sessiontimeout = Integer.parseInt(props.getProperty("sessiontimeout", "0"));
        this.querytimeout = Integer.parseInt(props.getProperty("querytimeout", "0"));
        this.memorylimit = Integer.parseInt(props.getProperty("memorylimit", "0"));
        this.nr_threads = Integer.parseInt(props.getProperty("nr_threads", "0"));
        this.jdbcURL = props.getProperty("jdbc-url");
        if (props.getProperty("connectionType").equals("remote")) {
            String host = props.getProperty("host", "localhost");
            int port = Integer.parseInt(props.getProperty("port", "50000"));
            String database = props.getProperty("database", "test");
            String user = props.getProperty("user", "monetdb");
            String password = props.getProperty("password", "monetdb");
            error_msg = MonetNative.monetdbe_open(null, this, this.sessiontimeout, this.querytimeout, this.memorylimit, this.nr_threads, host, port, database, user, password);
        } else {
            String path = props.getProperty("path", null);
            error_msg = MonetNative.monetdbe_open(path, this, this.sessiontimeout, this.querytimeout, this.memorylimit, this.nr_threads);
        }
        if (this.dbNative == null || error_msg != null) {
            throw new SQLException(error_msg);
        }
        this.properties = props;
        this.statements = new ArrayList<MonetStatement>();
        this.autoCommit = true;
        if (props.containsKey("autocommit") && props.getProperty("autocommit").equals("false")) {
            this.setAutoCommit(false);
        }
    }

    private void executeCommand(String sql) throws SQLException {
        this.checkNotClosed();
        MonetStatement st = null;
        try {
            st = (MonetStatement)this.createStatement();
            if (st != null) {
                st.execute(sql);
            }
        }
        finally {
            st.close();
            this.statements.remove(st);
        }
    }

    @Override
    public void commit() throws SQLException {
        this.checkNotClosed();
        if (this.getAutoCommit()) {
            throw new SQLException("COMMIT: not allowed in auto commit mode");
        }
        this.executeCommand("COMMIT");
    }

    @Override
    public void rollback() throws SQLException {
        this.checkNotClosed();
        if (this.getAutoCommit()) {
            throw new SQLException("Operation not permitted in autocommit");
        }
        this.executeCommand("ROLLBACK");
    }

    private void checkNotClosed() throws SQLException {
        if (this.isClosed()) {
            throw new SQLException("Connection is closed", "M1M20");
        }
    }

    @Override
    public void close() throws SQLException {
        this.checkNotClosed();
        for (MonetStatement s : this.statements) {
            try {
                s.close();
            }
            catch (SQLException sQLException) {}
        }
        this.statements = null;
        String error_msg = MonetNative.monetdbe_close(this.dbNative);
        if (error_msg != null) {
            throw new SQLException(error_msg);
        }
        this.dbNative = null;
    }

    @Override
    public boolean isClosed() throws SQLException {
        return this.dbNative == null;
    }

    @Override
    public void abort(Executor executor) throws SQLException {
        this.checkNotClosed();
        if (executor == null) {
            throw new SQLException("executor is null", "M1M05");
        }
        this.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isValid(int timeout) throws SQLException {
        if (timeout < 0) {
            throw new SQLException("timeout is less than 0", "M1M05");
        }
        if (this.isClosed()) {
            return false;
        }
        Statement st = null;
        ResultSet rs = null;
        boolean isValid = false;
        try {
            st = this.createStatement();
            if (st != null && (rs = st.executeQuery("SELECT 1")) != null && rs.next()) {
                isValid = true;
            }
        }
        catch (SQLException sQLException) {
        }
        finally {
            if (rs != null) {
                rs.close();
            }
            if (st != null) {
                st.close();
            }
        }
        return isValid;
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        this.checkNotClosed();
        return this.warnings;
    }

    private void addWarning(String reason, String sqlstate) {
        SQLWarning warn = new SQLWarning(reason, sqlstate);
        if (this.warnings == null) {
            this.warnings = warn;
        } else {
            this.warnings.setNextWarning(warn);
        }
    }

    @Override
    public void clearWarnings() throws SQLException {
        this.checkNotClosed();
        this.warnings = null;
    }

    protected ByteBuffer getDbNative() {
        return this.dbNative;
    }

    @Override
    public void setAutoCommit(boolean autoCommit) throws SQLException {
        this.checkNotClosed();
        if (autoCommit != this.autoCommit) {
            this.autoCommit = autoCommit;
            String error_msg = MonetNative.monetdbe_set_autocommit(this.dbNative, autoCommit ? 1 : 0);
            if (error_msg != null) {
                throw new SQLException(error_msg);
            }
        }
    }

    @Override
    public boolean getAutoCommit() throws SQLException {
        this.checkNotClosed();
        return MonetNative.monetdbe_get_autocommit(this.dbNative);
    }

    @Override
    public DatabaseMetaData getMetaData() throws SQLException {
        this.checkNotClosed();
        return new MonetDatabaseMetaData(this);
    }

    @Override
    public void setReadOnly(boolean readOnly) throws SQLException {
        this.checkNotClosed();
        if (readOnly) {
            this.addWarning("cannot setReadOnly(true): read-only Connection mode not supported", "01M08");
        }
    }

    @Override
    public boolean isReadOnly() throws SQLException {
        this.checkNotClosed();
        return false;
    }

    @Override
    public void setCatalog(String catalog) throws SQLException {
    }

    @Override
    public String getCatalog() throws SQLException {
        return null;
    }

    @Override
    public void setTransactionIsolation(int level) throws SQLException {
        this.checkNotClosed();
        if (level != 8) {
            this.addWarning("MonetDB only supports fully serializable transactions, continuing with transaction level raised to TRANSACTION_SERIALIZABLE", "01M09");
        }
    }

    @Override
    public int getTransactionIsolation() throws SQLException {
        this.checkNotClosed();
        return 8;
    }

    @Override
    public Map<String, Class<?>> getTypeMap() throws SQLException {
        this.checkNotClosed();
        throw new SQLFeatureNotSupportedException("getTypeMap()");
    }

    @Override
    public void setTypeMap(Map<String, Class<?>> map) throws SQLException {
        this.checkNotClosed();
        throw new SQLFeatureNotSupportedException("setTypeMap(Map<String, Class<?>> map)");
    }

    @Override
    public void setHoldability(int holdability) throws SQLException {
        this.checkNotClosed();
        if (holdability != 1) {
            throw new SQLFeatureNotSupportedException("setHoldability(CLOSE_CURSORS_AT_COMMIT)");
        }
    }

    @Override
    public int getHoldability() throws SQLException {
        this.checkNotClosed();
        return 1;
    }

    @Override
    public void setClientInfo(String name, String value) throws SQLClientInfoException {
        try {
            this.checkNotClosed();
        }
        catch (SQLException e) {
            throw new SQLClientInfoException();
        }
        this.properties.setProperty(name, value);
    }

    @Override
    public void setClientInfo(Properties properties) throws SQLClientInfoException {
        try {
            this.checkNotClosed();
        }
        catch (SQLException e) {
            throw new SQLClientInfoException();
        }
        this.properties = properties;
    }

    @Override
    public String getClientInfo(String name) throws SQLException {
        this.checkNotClosed();
        return this.properties.getProperty(name);
    }

    @Override
    public Properties getClientInfo() throws SQLException {
        this.checkNotClosed();
        return this.properties;
    }

    @Override
    public void setSchema(String schema) throws SQLException {
        this.checkNotClosed();
        if (schema == null || schema.isEmpty()) {
            throw new SQLException("Missing schema name", "M1M05");
        }
        this.executeCommand("SET SCHEMA \"" + schema + "\"");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getSchema() throws SQLException {
        this.checkNotClosed();
        String cur_schema = null;
        Statement st = null;
        ResultSet rs = null;
        try {
            st = this.createStatement();
            if (st != null && (rs = st.executeQuery("SELECT CURRENT_SCHEMA")) != null && rs.next()) {
                cur_schema = rs.getString(1);
            }
        }
        finally {
            rs.close();
            st.close();
        }
        if (cur_schema == null) {
            throw new SQLException("Failed to fetch schema name", "02000");
        }
        return cur_schema;
    }

    @Override
    public void setNetworkTimeout(Executor executor, int milliseconds) throws SQLException {
        this.checkNotClosed();
        if (executor == null || milliseconds < 0) {
            throw new SQLException();
        }
        this.sessiontimeout = milliseconds;
    }

    @Override
    public int getNetworkTimeout() throws SQLException {
        this.checkNotClosed();
        return this.sessiontimeout;
    }

    @Override
    public String nativeSQL(String sql) {
        return sql;
    }

    public String getJdbcURL() {
        return this.jdbcURL;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getUserName() throws SQLException {
        this.checkNotClosed();
        String cur_user = null;
        Statement st = null;
        ResultSet rs = null;
        try {
            st = this.createStatement();
            if (st != null && (rs = st.executeQuery("SELECT CURRENT_USER")) != null && rs.next()) {
                cur_user = rs.getString(1);
            }
        }
        finally {
            rs.close();
            st.close();
        }
        if (cur_user == null) {
            throw new SQLException("Failed to fetch user name");
        }
        return cur_user;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getMaxConnections() throws SQLException {
        this.checkNotClosed();
        int maxConnections = 0;
        Statement st = null;
        ResultSet rs = null;
        try {
            st = this.createStatement();
            if (st != null && (rs = st.executeQuery("SELECT value FROM sys.env() WHERE name = 'max_clients'")) != null && rs.next()) {
                maxConnections = rs.getInt(1);
            }
        }
        finally {
            rs.close();
            st.close();
        }
        return maxConnections;
    }

    @Override
    public Statement createStatement() throws SQLException {
        return this.createStatement(1004, 1007, 1);
    }

    @Override
    public Statement createStatement(int resultSetType, int resultSetConcurrency) throws SQLException {
        return this.createStatement(resultSetType, resultSetConcurrency, 1);
    }

    @Override
    public Statement createStatement(int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        this.checkNotClosed();
        try {
            MonetStatement s = new MonetStatement(this);
            this.statements.add(s);
            return s;
        }
        catch (IllegalArgumentException e) {
            throw new SQLException(e.toString(), "M0M03");
        }
    }

    @Override
    public CallableStatement prepareCall(String sql) throws SQLException {
        return this.prepareCall(sql, 1004, 1007, 1);
    }

    @Override
    public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        return this.prepareCall(sql, resultSetType, resultSetConcurrency, 1);
    }

    @Override
    public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        this.checkNotClosed();
        try {
            MonetCallableStatement s = new MonetCallableStatement(this, sql);
            this.statements.add(s);
            return s;
        }
        catch (IllegalArgumentException e) {
            throw new SQLException(e.toString(), "M0M03");
        }
    }

    @Override
    public PreparedStatement prepareStatement(String sql) throws SQLException {
        return this.prepareStatement(sql, 1004, 1007, 1);
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        return this.prepareStatement(sql, resultSetType, resultSetConcurrency, 1);
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        this.checkNotClosed();
        try {
            MonetPreparedStatement s = new MonetPreparedStatement(this, sql);
            this.statements.add(s);
            return s;
        }
        catch (IllegalArgumentException e) {
            throw new SQLException(e.toString(), "M0M03");
        }
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int autoGeneratedKeys) throws SQLException {
        throw new SQLFeatureNotSupportedException("prepareStatement(String sql, int autoGeneratedKeys)");
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int[] columnIndexes) throws SQLException {
        throw new SQLFeatureNotSupportedException("prepareStatement(String sql, int[] columnIndexes)");
    }

    @Override
    public PreparedStatement prepareStatement(String sql, String[] columnNames) throws SQLException {
        throw new SQLFeatureNotSupportedException("prepareStatement(String sql, String[] columnNames)");
    }

    @Override
    public Savepoint setSavepoint() throws SQLException {
        throw new SQLFeatureNotSupportedException("setSavepoint()");
    }

    @Override
    public Savepoint setSavepoint(String name) throws SQLException {
        throw new SQLFeatureNotSupportedException("setSavepoint(String name)");
    }

    @Override
    public void rollback(Savepoint savepoint) throws SQLException {
        throw new SQLFeatureNotSupportedException("rollback(Savepoint savepoint)");
    }

    @Override
    public void releaseSavepoint(Savepoint savepoint) throws SQLException {
        throw new SQLFeatureNotSupportedException("releaseSavepoint(Savepoint savepoint)");
    }

    @Override
    public Clob createClob() throws SQLException {
        this.checkNotClosed();
        return new MonetClob("");
    }

    @Override
    public Blob createBlob() throws SQLException {
        this.checkNotClosed();
        return new MonetBlob(new byte[1]);
    }

    @Override
    public Array createArrayOf(String typeName, Object[] elements) throws SQLException {
        throw new SQLFeatureNotSupportedException("createArrayOf");
    }

    @Override
    public Struct createStruct(String typeName, Object[] attributes) throws SQLException {
        throw new SQLFeatureNotSupportedException("createStruct");
    }

    @Override
    public NClob createNClob() throws SQLException {
        throw new SQLFeatureNotSupportedException("createNClob");
    }

    @Override
    public SQLXML createSQLXML() throws SQLException {
        throw new SQLFeatureNotSupportedException("createSQLXML");
    }
}

