/*
 * Decompiled with CFR 0.152.
 */
package org.monetdb.monetdbe;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import org.monetdb.monetdbe.MonetBlob;
import org.monetdb.monetdbe.MonetTypes;

public class MonetColumn {
    private ByteBuffer constData;
    private Object[] varData;
    private double scale;
    private String name;
    private int monetdbeType;
    private String typeName;

    public MonetColumn(String name, int monetdbeType, ByteBuffer constData, double scale) {
        this.name = name;
        this.monetdbeType = monetdbeType;
        this.typeName = MonetTypes.getMonetTypeString(monetdbeType);
        this.constData = constData.order(ByteOrder.LITTLE_ENDIAN);
        this.scale = scale;
    }

    public MonetColumn(String name, int monetdbeType, Object[] varData) {
        this.name = name;
        this.monetdbeType = monetdbeType;
        this.typeName = MonetTypes.getMonetTypeString(monetdbeType);
        this.varData = varData;
    }

    String getName() {
        return this.name;
    }

    int getMonetdbeType() {
        return this.monetdbeType;
    }

    String getTypeName() {
        return this.typeName;
    }

    public int getScaleJDBC() {
        return BigDecimal.valueOf(this.scale).precision() - 2;
    }

    Object getObject(int row) {
        switch (this.monetdbeType) {
            case 0: {
                return this.constData.get(row) != 0;
            }
            case 1: {
                return this.constData.get(row);
            }
            case 2: {
                return this.constData.asShortBuffer().get(row);
            }
            case 3: {
                return this.constData.asIntBuffer().get(row);
            }
            case 4: {
                return this.constData.asLongBuffer().get(row);
            }
            case 5: {
                return this.getBigInteger(row);
            }
            case 7: {
                return Float.valueOf(this.constData.asFloatBuffer().get(row));
            }
            case 8: {
                return this.constData.asDoubleBuffer().get(row);
            }
            case 9: {
                return this.getString(row);
            }
            case 10: {
                return this.getBlob(row);
            }
            case 11: {
                return this.getLocalDate(row);
            }
            case 12: {
                return this.getLocalTime(row);
            }
            case 13: {
                return this.getLocalDateTime(row);
            }
        }
        return null;
    }

    Boolean getBoolean(int row) {
        if (this.monetdbeType == 0) {
            return this.constData.get(row) != 0;
        }
        if (this.monetdbeType > 0 && this.monetdbeType < 9) {
            return ((Number)this.getObject(row)).byteValue() != 0;
        }
        if (this.monetdbeType == 9) {
            return Boolean.parseBoolean(this.getString(row));
        }
        return null;
    }

    Byte getByte(int row) {
        if (this.monetdbeType == 1) {
            return this.constData.get(row);
        }
        if (this.monetdbeType == 0) {
            return this.getBoolean(row) != false ? (byte)1 : 0;
        }
        if (this.monetdbeType > 0 && this.monetdbeType < 9) {
            return ((Number)this.getObject(row)).byteValue();
        }
        if (this.monetdbeType == 9) {
            return Byte.parseByte(this.getString(row));
        }
        return null;
    }

    Short getShort(int row) {
        if (this.monetdbeType == 2) {
            return this.constData.asShortBuffer().get(row);
        }
        if (this.monetdbeType == 1) {
            return this.constData.get(row);
        }
        if (this.monetdbeType == 0) {
            return this.getBoolean(row) != false ? (short)1 : 0;
        }
        if (this.monetdbeType > 0 && this.monetdbeType < 9) {
            return ((Number)this.getObject(row)).shortValue();
        }
        if (this.monetdbeType == 9) {
            return Short.parseShort(this.getString(row));
        }
        return null;
    }

    Integer getInt(int row) {
        if (this.monetdbeType == 3) {
            return this.constData.asIntBuffer().get(row);
        }
        if (this.monetdbeType == 0) {
            return this.getBoolean(row) != false ? 1 : 0;
        }
        if (this.monetdbeType > 0 && this.monetdbeType < 9) {
            return ((Number)this.getObject(row)).intValue();
        }
        if (this.monetdbeType == 9) {
            return Integer.parseInt(this.getString(row));
        }
        return null;
    }

    Long getLong(int row) {
        if (this.monetdbeType == 4) {
            return this.constData.asLongBuffer().get(row);
        }
        if (this.monetdbeType == 0) {
            return this.getBoolean(row) != false ? 1L : 0L;
        }
        if (this.monetdbeType > 0 && this.monetdbeType < 9) {
            return ((Number)this.getObject(row)).longValue();
        }
        if (this.monetdbeType == 9) {
            return Long.parseLong(this.getString(row));
        }
        return null;
    }

    Float getFloat(int row) {
        if (this.monetdbeType == 7) {
            return Float.valueOf(this.constData.asFloatBuffer().get(row));
        }
        if (this.monetdbeType == 0) {
            return Float.valueOf(this.getBoolean(row) != false ? 1.0f : 0.0f);
        }
        if (this.monetdbeType > 0 && this.monetdbeType < 9) {
            return Float.valueOf(((Number)this.getObject(row)).floatValue());
        }
        if (this.monetdbeType == 9) {
            return Float.valueOf(Float.parseFloat(this.getString(row)));
        }
        return null;
    }

    Double getDouble(int row) {
        if (this.monetdbeType == 8) {
            return this.constData.asDoubleBuffer().get(row);
        }
        if (this.monetdbeType == 0) {
            return this.getBoolean(row) != false ? 1.0 : 0.0;
        }
        if (this.monetdbeType > 0 && this.monetdbeType < 9) {
            return ((Number)this.getObject(row)).doubleValue();
        }
        if (this.monetdbeType == 9) {
            return Double.parseDouble(this.getString(row));
        }
        return null;
    }

    BigInteger getBigInteger(int row) {
        if (this.monetdbeType != 5) {
            return null;
        }
        int size = MonetTypes.getMonetSize(this.monetdbeType);
        byte[] byteData = new byte[size];
        for (int i = 0; i < size; ++i) {
            byteData[size - i - 1] = this.constData.get(row * size + i);
        }
        return new BigInteger(byteData);
    }

    BigDecimal getBigDecimal(int row) {
        int scale = this.getScaleJDBC();
        switch (this.monetdbeType) {
            case 1: {
                Byte unscaledByte = this.constData.get(row);
                return new BigDecimal(unscaledByte.intValue()).movePointRight(scale);
            }
            case 2: {
                Short unscaledShort = this.getShort(row);
                return new BigDecimal(unscaledShort.intValue()).movePointRight(scale);
            }
            case 3: {
                Integer unscaledInt = this.getInt(row);
                return new BigDecimal(unscaledInt).movePointLeft(scale);
            }
            case 4: {
                Long unscaledLong = this.getLong(row);
                return new BigDecimal(unscaledLong).movePointLeft(scale);
            }
            case 5: {
                BigInteger unscaledBigInt = this.getBigInteger(row);
                return new BigDecimal(unscaledBigInt).movePointLeft(scale);
            }
        }
        return new BigDecimal(0);
    }

    String getString(int row) {
        if (this.monetdbeType == 9) {
            return (String)this.varData[row];
        }
        return String.valueOf(this.getObject(row));
    }

    byte[] getBytes(int row) {
        if (this.monetdbeType == 10) {
            return (byte[])this.varData[row];
        }
        return null;
    }

    MonetBlob getBlob(int row) {
        if (this.monetdbeType == 10) {
            return new MonetBlob((byte[])this.varData[row]);
        }
        return null;
    }

    LocalDate getLocalDate(int row) throws DateTimeParseException {
        switch (this.monetdbeType) {
            case 9: {
                DateTimeFormatter dtf = DateTimeFormatter.ofPattern("yyyy-MM-dd");
                return LocalDate.parse((String)this.varData[row], dtf);
            }
            case 11: {
                return (LocalDate)this.varData[row];
            }
            case 13: {
                return ((LocalDateTime)this.varData[row]).toLocalDate();
            }
        }
        return LocalDate.ofEpochDay(0L);
    }

    LocalTime getLocalTime(int row) throws DateTimeParseException {
        switch (this.monetdbeType) {
            case 9: {
                DateTimeFormatter dtf = DateTimeFormatter.ofPattern("HH:mm:ss[.SSSSSS][.SSSS][.SS]");
                return LocalTime.parse((String)this.varData[row], dtf);
            }
            case 12: {
                return (LocalTime)this.varData[row];
            }
            case 13: {
                return ((LocalDateTime)this.varData[row]).toLocalTime();
            }
        }
        return LocalTime.ofSecondOfDay(0L);
    }

    LocalDateTime getLocalDateTime(int row) throws DateTimeParseException {
        switch (this.monetdbeType) {
            case 9: {
                DateTimeFormatter dtf = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss[.SSSSSS][.SSSS][.SS]");
                return LocalDateTime.parse((String)this.varData[row], dtf);
            }
            case 11: {
                return LocalDateTime.ofEpochSecond(0L, 0, ZoneOffset.UTC).with((LocalDate)this.varData[row]);
            }
            case 12: {
                return LocalDateTime.ofEpochSecond(0L, 0, ZoneOffset.UTC).with((LocalTime)this.varData[row]);
            }
            case 13: {
                return (LocalDateTime)this.varData[row];
            }
        }
        return LocalDateTime.ofEpochSecond(0L, 0, ZoneOffset.UTC);
    }
}

