/*
 * Decompiled with CFR 0.152.
 */
package org.monetdb.monetdbe;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.Writer;
import java.sql.Clob;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;

public final class MonetClob
implements Clob {
    private StringBuilder buf;

    protected MonetClob(String in) {
        this.buf = new StringBuilder(in);
    }

    private final void checkBufIsNotNull() throws SQLException {
        if (this.buf == null) {
            throw new SQLException("This MonetClob has been freed", "M1M20");
        }
    }

    @Override
    public void free() {
        this.buf = null;
    }

    @Override
    public InputStream getAsciiStream() throws SQLException {
        this.checkBufIsNotNull();
        return new ByteArrayInputStream(this.buf.toString().getBytes());
    }

    @Override
    public Reader getCharacterStream() throws SQLException {
        this.checkBufIsNotNull();
        return new StringReader(this.buf.toString());
    }

    @Override
    public Reader getCharacterStream(long pos, long length) throws SQLException {
        if (length < 0L || length > Integer.MAX_VALUE) {
            throw new SQLException("Invalid length value: " + length, "M1M05");
        }
        return new StringReader(this.getSubString(pos, (int)length));
    }

    @Override
    public String getSubString(long pos, int length) throws SQLException {
        this.checkBufIsNotNull();
        if (pos == 1L && length == this.buf.length()) {
            return this.buf.toString();
        }
        if (pos < 1L || pos > (long)this.buf.length()) {
            throw new SQLException("Invalid pos value: " + pos, "M1M05");
        }
        if (length < 0 || pos - 1L + (long)length > (long)this.buf.length()) {
            throw new SQLException("Invalid length value: " + length, "M1M05");
        }
        try {
            return this.buf.substring((int)(pos - 1L), (int)(pos - 1L + (long)length));
        }
        catch (IndexOutOfBoundsException e) {
            throw new SQLException(e.getMessage(), "M1M05");
        }
    }

    @Override
    public long length() throws SQLException {
        this.checkBufIsNotNull();
        return this.buf.length();
    }

    @Override
    public long position(Clob searchstr, long start) throws SQLException {
        if (searchstr == null) {
            throw new SQLException("Missing searchstr object", "M1M05");
        }
        return this.position(searchstr.toString(), start);
    }

    @Override
    public long position(String searchstr, long start) throws SQLException {
        this.checkBufIsNotNull();
        if (searchstr == null) {
            throw new SQLException("Missing searchstr object", "M1M05");
        }
        if (start < 1L || start > (long)this.buf.length()) {
            throw new SQLException("Invalid start value: " + start, "M1M05");
        }
        return this.buf.indexOf(searchstr, (int)(start - 1L));
    }

    @Override
    public OutputStream setAsciiStream(long pos) throws SQLException {
        throw new SQLFeatureNotSupportedException("setAsciiStream");
    }

    @Override
    public Writer setCharacterStream(long pos) throws SQLException {
        throw new SQLFeatureNotSupportedException("setCharacterStream");
    }

    @Override
    public int setString(long pos, String str) throws SQLException {
        int len = str != null ? str.length() : 0;
        return this.setString(pos, str, 0, len);
    }

    @Override
    public int setString(long pos, String str, int offset, int len) throws SQLException {
        this.checkBufIsNotNull();
        if (str == null) {
            throw new SQLException("Missing str object", "M1M05");
        }
        if (pos < 1L || pos > Integer.MAX_VALUE) {
            throw new SQLException("Invalid pos value: " + pos, "M1M05");
        }
        if (offset < 0 || offset > str.length()) {
            throw new SQLException("Invalid offset value: " + offset, "M1M05");
        }
        if (len < 1 || offset + len > str.length()) {
            throw new SQLException("Invalid len value: " + len, "M1M05");
        }
        if ((int)pos + len > this.buf.capacity()) {
            this.buf.ensureCapacity((int)pos + len);
        }
        this.buf.replace((int)pos - 1, (int)pos + len, str.substring(offset, offset + len));
        return len;
    }

    @Override
    public void truncate(long len) throws SQLException {
        this.checkBufIsNotNull();
        if (len < 0L || len > (long)this.buf.length()) {
            throw new SQLException("Invalid len value: " + len, "M1M05");
        }
        this.buf.setLength((int)len);
        this.buf.trimToSize();
    }

    public String toString() {
        if (this.buf == null) {
            return "";
        }
        return this.buf.toString();
    }
}

