/*
 * Decompiled with CFR 0.152.
 */
package org.monetdb.monetdbe;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.sql.Blob;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.util.Arrays;

public final class MonetBlob
implements Blob {
    private byte[] buf;

    public MonetBlob(byte[] data) {
        this.buf = data;
    }

    public MonetBlob(String hexString) {
        this.buf = MonetBlob.hexStrToByteArray(hexString);
    }

    static final byte[] hexStrToByteArray(String hexString) {
        int len = hexString.length() / 2;
        byte[] buf = new byte[len];
        for (int i = 0; i < len; ++i) {
            buf[i] = (byte)((Character.digit(hexString.charAt(2 * i), 16) << 4) + Character.digit(hexString.charAt(2 * i + 1), 16));
        }
        return buf;
    }

    private final void checkBufIsNotNull() throws SQLException {
        if (this.buf == null) {
            throw new SQLException("This MonetBlob has been freed", "M1M20");
        }
    }

    @Override
    public void free() throws SQLException {
        this.buf = null;
    }

    @Override
    public InputStream getBinaryStream() throws SQLException {
        this.checkBufIsNotNull();
        return new ByteArrayInputStream(this.buf);
    }

    @Override
    public InputStream getBinaryStream(long pos, long length) throws SQLException {
        this.checkBufIsNotNull();
        if (pos < 1L || pos > (long)this.buf.length) {
            throw new SQLException("Invalid pos value: " + pos, "M1M05");
        }
        if (length < 0L || pos - 1L + length > (long)this.buf.length) {
            throw new SQLException("Invalid length value: " + length, "M1M05");
        }
        return new ByteArrayInputStream(this.buf, (int)pos - 1, (int)length);
    }

    @Override
    public byte[] getBytes(long pos, int length) throws SQLException {
        this.checkBufIsNotNull();
        if (pos < 1L || pos > (long)this.buf.length) {
            throw new SQLException("Invalid pos value: " + pos, "M1M05");
        }
        if (length < 0 || pos - 1L + (long)length > (long)this.buf.length) {
            throw new SQLException("Invalid length value: " + length, "M1M05");
        }
        try {
            return Arrays.copyOfRange(this.buf, (int)pos - 1, (int)pos - 1 + length);
        }
        catch (IndexOutOfBoundsException e) {
            throw new SQLException(e.getMessage(), "M0M10");
        }
    }

    @Override
    public long length() throws SQLException {
        this.checkBufIsNotNull();
        return this.buf.length;
    }

    @Override
    public long position(Blob pattern, long start) throws SQLException {
        if (pattern == null) {
            throw new SQLException("Missing pattern object", "M1M05");
        }
        return this.position(pattern.getBytes(1L, (int)pattern.length()), start);
    }

    @Override
    public long position(byte[] pattern, long start) throws SQLException {
        this.checkBufIsNotNull();
        if (pattern == null) {
            throw new SQLException("Missing pattern object", "M1M05");
        }
        if (start < 1L || start > (long)this.buf.length) {
            throw new SQLException("Invalid start value: " + start, "M1M05");
        }
        try {
            int patternLength = pattern.length;
            int maxPos = this.buf.length - patternLength;
            for (int i = (int)(start - 1L); i < maxPos; ++i) {
                int j;
                for (j = 0; j < patternLength && this.buf[i + j] == pattern[j]; ++j) {
                }
                if (j != patternLength) continue;
                return i;
            }
        }
        catch (IndexOutOfBoundsException e) {
            throw new SQLException(e.getMessage(), "M0M10");
        }
        return -1L;
    }

    @Override
    public OutputStream setBinaryStream(long pos) throws SQLException {
        throw new SQLFeatureNotSupportedException("setBinaryStream");
    }

    @Override
    public int setBytes(long pos, byte[] bytes) throws SQLException {
        int len = bytes != null ? bytes.length : 0;
        return this.setBytes(pos, bytes, 1, len);
    }

    @Override
    public int setBytes(long pos, byte[] bytes, int offset, int len) throws SQLException {
        this.checkBufIsNotNull();
        if (bytes == null) {
            throw new SQLException("Missing bytes[] object", "M1M05");
        }
        if (pos < 1L || pos > (long)this.buf.length) {
            throw new SQLException("Invalid pos value: " + pos, "M1M05");
        }
        if (len < 0 || pos + (long)len > (long)this.buf.length) {
            throw new SQLException("Invalid len value: " + len, "M1M05");
        }
        if (offset < 0 || offset > bytes.length) {
            throw new SQLException("Invalid offset value: " + offset, "M1M05");
        }
        try {
            --offset;
            for (int i = (int)pos; i < len; ++i) {
                this.buf[i] = bytes[offset + i];
            }
        }
        catch (IndexOutOfBoundsException e) {
            throw new SQLException(e.getMessage(), "M0M10");
        }
        return len;
    }

    @Override
    public void truncate(long len) throws SQLException {
        this.checkBufIsNotNull();
        if (len < 0L || len > (long)this.buf.length) {
            throw new SQLException("Invalid len value: " + len, "M1M05");
        }
        if ((long)this.buf.length > len) {
            this.buf = Arrays.copyOf(this.buf, (int)len);
        }
    }
}

