/*
 * Decompiled with CFR 0.152.
 */
package nl.cwi.monetdb.jdbc;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.math.BigDecimal;
import java.net.MalformedURLException;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.Date;
import java.sql.NClob;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.RowId;
import java.sql.SQLData;
import java.sql.SQLDataException;
import java.sql.SQLException;
import java.sql.SQLInput;
import java.sql.SQLWarning;
import java.sql.SQLXML;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Map;
import java.util.UUID;
import nl.cwi.monetdb.jdbc.MonetBlob;
import nl.cwi.monetdb.jdbc.MonetClob;
import nl.cwi.monetdb.jdbc.MonetConnection;
import nl.cwi.monetdb.jdbc.MonetDriver;
import nl.cwi.monetdb.jdbc.MonetINET;
import nl.cwi.monetdb.jdbc.MonetStatement;
import nl.cwi.monetdb.jdbc.MonetURL;
import nl.cwi.monetdb.jdbc.MonetWrapper;
import nl.cwi.monetdb.mcl.protocol.ProtocolException;
import nl.cwi.monetdb.mcl.responses.AbstractDataBlockResponse;
import nl.cwi.monetdb.mcl.responses.ResultSetResponse;

public class MonetResultSet
extends MonetWrapper
implements ResultSet,
AutoCloseable {
    int curRow = 0;
    private final ResultSetResponse header;
    private final String[] columns;
    private final String[] types;
    private final int[] JdbcSQLTypes;
    final int tupleCount;
    private final Statement statement;
    private int type = 1003;
    private int concurrency = 1007;
    private SQLWarning warnings;
    private int fetchSize;
    private AbstractDataBlockResponse currentBlock;

    MonetResultSet(Statement statement, ResultSetResponse header) throws IllegalArgumentException {
        if (statement == null) {
            throw new IllegalArgumentException("Statement may not be null!");
        }
        if (header == null) {
            throw new IllegalArgumentException("ResultSetResponse may not be null!");
        }
        this.statement = statement;
        this.header = header;
        this.type = header.getRSType();
        this.concurrency = header.getRSConcur();
        this.fetchSize = header.getCacheSize();
        this.tupleCount = header.getTuplecount();
        this.columns = header.getNames();
        this.types = header.getTypes();
        this.JdbcSQLTypes = header.getJdbcSQLTypes();
    }

    MonetResultSet(Statement statement, String[] columns, String[] types, int[] JdbcSQLTypes, int results) throws IllegalArgumentException {
        if (statement == null) {
            throw new IllegalArgumentException("Statement may not be null!");
        }
        if (columns == null || types == null) {
            throw new IllegalArgumentException("One of the given arguments is null!");
        }
        if (columns.length != types.length) {
            throw new IllegalArgumentException("Given arguments are not the same size!");
        }
        if (results < 0) {
            throw new IllegalArgumentException("Negative rowcount not allowed!");
        }
        this.statement = statement;
        this.header = null;
        this.fetchSize = 0;
        this.tupleCount = results;
        this.columns = columns;
        this.types = types;
        this.JdbcSQLTypes = JdbcSQLTypes;
    }

    private void populateJdbcSQLtypesArray() {
        MonetConnection connection = null;
        try {
            connection = (MonetConnection)this.statement.getConnection();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        for (int i = 0; i < this.types.length; ++i) {
            int javaSQLtype = MonetDriver.getJdbcSQLType(this.types[i]);
            if (javaSQLtype == 2005) {
                if (connection != null && connection.mapClobAsVarChar()) {
                    javaSQLtype = 12;
                }
            } else if (javaSQLtype == 2004 && connection != null && connection.mapBlobAsVarBinary()) {
                javaSQLtype = -3;
            }
            this.JdbcSQLTypes[i] = javaSQLtype;
        }
    }

    @Override
    public boolean absolute(int row) throws SQLException {
        boolean overlap;
        this.checkNotClosed();
        if (row != this.curRow + 1 && this.type == 1003) {
            throw new SQLException("(Absolute) positioning not allowed on forward  only result sets!", "M1M05");
        }
        if (row < 0) {
            row = this.tupleCount + row + 1;
        }
        if (row < 0) {
            row = 0;
        } else if (row > this.tupleCount + 1) {
            row = this.tupleCount + 1;
        }
        this.curRow = row;
        boolean bl = overlap = row <= this.tupleCount;
        if (overlap) {
            this.currentBlock = this.header.getDataBlockCorrespondingToLine(row - 1);
        }
        return overlap;
    }

    @Override
    public void afterLast() throws SQLException {
        this.absolute(this.tupleCount + 1);
    }

    @Override
    public void beforeFirst() throws SQLException {
        this.absolute(0);
    }

    @Override
    public void clearWarnings() {
        this.warnings = null;
    }

    @Override
    public void close() {
        if (this.header != null && !this.header.isClosed()) {
            this.header.close();
        }
        if (this.statement instanceof MonetStatement) {
            ((MonetStatement)this.statement).closeIfCompletion();
        }
    }

    @Override
    public int findColumn(String columnLabel) throws SQLException {
        this.checkNotClosed();
        if (columnLabel != null) {
            int i;
            int array_size = this.columns.length;
            for (i = 0; i < array_size; ++i) {
                if (!columnLabel.equals(this.columns[i])) continue;
                return i + 1;
            }
            for (i = 0; i < array_size; ++i) {
                if (!columnLabel.equalsIgnoreCase(this.columns[i])) continue;
                return i + 1;
            }
        }
        throw new SQLException("No such column name: " + columnLabel, "M1M05");
    }

    @Override
    public boolean first() throws SQLException {
        return this.absolute(1);
    }

    @Override
    public Array getArray(int columnIndex) throws SQLException {
        throw MonetResultSet.newSQLFeatureNotSupportedException("getArray");
    }

    @Override
    public Array getArray(String columnLabel) throws SQLException {
        throw MonetResultSet.newSQLFeatureNotSupportedException("getArray");
    }

    @Override
    public InputStream getAsciiStream(int columnIndex) throws SQLException {
        try {
            InputStream res = null;
            switch (this.JdbcSQLTypes[columnIndex - 1]) {
                case 2005: {
                    Clob cl = this.getClob(columnIndex);
                    if (cl == null) break;
                    res = cl.getAsciiStream();
                    break;
                }
                case -4: 
                case -1: 
                case 1: 
                case 12: 
                case 2004: {
                    byte[] bytes = this.getBytes(columnIndex);
                    if (bytes == null) break;
                    res = new ByteArrayInputStream(this.getBytes(columnIndex));
                    break;
                }
                default: {
                    throw new SQLException("Conversion from " + this.types[columnIndex - 1] + " to ascii stream not supported", "M1M05");
                }
            }
            return res;
        }
        catch (ClassCastException ex) {
            throw new SQLException(ex.getMessage());
        }
        catch (IndexOutOfBoundsException e) {
            throw MonetResultSet.newSQLInvalidColumnIndexException(columnIndex);
        }
    }

    @Override
    public InputStream getAsciiStream(String columnLabel) throws SQLException {
        throw MonetResultSet.newSQLFeatureNotSupportedException("getAsciiStream");
    }

    @Override
    @Deprecated
    public InputStream getUnicodeStream(int columnIndex) throws SQLException {
        throw MonetResultSet.newSQLFeatureNotSupportedException("getUnicodeStream");
    }

    @Override
    @Deprecated
    public InputStream getUnicodeStream(String columnLabel) throws SQLException {
        throw MonetResultSet.newSQLFeatureNotSupportedException("getUnicodeStream");
    }

    @Override
    public InputStream getBinaryStream(int columnIndex) throws SQLException {
        this.checkNotClosed();
        try {
            InputStream res = null;
            switch (this.JdbcSQLTypes[columnIndex - 1]) {
                case 2004: {
                    Blob cl = this.getBlob(columnIndex);
                    if (cl == null) break;
                    res = cl.getBinaryStream();
                    break;
                }
                case -4: {
                    byte[] bytes = this.getBytes(columnIndex);
                    if (bytes == null) break;
                    res = new ByteArrayInputStream(this.getBytes(columnIndex));
                    break;
                }
                default: {
                    throw new SQLException("Conversion from " + this.types[columnIndex - 1] + " to binary stream not supported", "M1M05");
                }
            }
            return res;
        }
        catch (ClassCastException ex) {
            throw new SQLException(ex.getMessage());
        }
        catch (IndexOutOfBoundsException e) {
            throw MonetResultSet.newSQLInvalidColumnIndexException(columnIndex);
        }
    }

    @Override
    public InputStream getBinaryStream(String columnLabel) throws SQLException {
        return this.getBinaryStream(this.findColumn(columnLabel));
    }

    @Override
    public Reader getCharacterStream(int columnIndex) throws SQLException {
        this.checkNotClosed();
        try {
            String ss = this.currentBlock.getValueAsString(columnIndex - 1);
            return ss == null ? null : new StringReader(ss);
        }
        catch (ClassCastException ex) {
            throw new SQLException(ex.getMessage());
        }
        catch (ProtocolException e) {
            throw new SQLException(e);
        }
        catch (IndexOutOfBoundsException e) {
            throw MonetResultSet.newSQLInvalidColumnIndexException(columnIndex);
        }
    }

    @Override
    public Reader getCharacterStream(String columnLabel) throws SQLException {
        return this.getCharacterStream(this.findColumn(columnLabel));
    }

    @Override
    public Reader getNCharacterStream(int columnIndex) throws SQLException {
        return this.getCharacterStream(columnIndex);
    }

    @Override
    public Reader getNCharacterStream(String columnLabel) throws SQLException {
        return this.getCharacterStream(this.findColumn(columnLabel));
    }

    @Override
    public Blob getBlob(int columnIndex) throws SQLException {
        this.checkNotClosed();
        try {
            return (MonetBlob)this.currentBlock.getObjectValue(columnIndex - 1);
        }
        catch (ClassCastException ex) {
            throw new SQLException(ex.getMessage());
        }
        catch (ProtocolException e) {
            throw new SQLException(e);
        }
        catch (IndexOutOfBoundsException e) {
            throw MonetResultSet.newSQLInvalidColumnIndexException(columnIndex);
        }
    }

    @Override
    public Blob getBlob(String columnLabel) throws SQLException {
        return this.getBlob(this.findColumn(columnLabel));
    }

    @Override
    public Clob getClob(int columnIndex) throws SQLException {
        this.checkNotClosed();
        try {
            return (MonetClob)this.currentBlock.getObjectValue(columnIndex - 1);
        }
        catch (ClassCastException ex) {
            throw new SQLException(ex.getMessage());
        }
        catch (ProtocolException e) {
            throw new SQLException(e);
        }
        catch (IndexOutOfBoundsException e) {
            throw MonetResultSet.newSQLInvalidColumnIndexException(columnIndex);
        }
    }

    @Override
    public Clob getClob(String columnLabel) throws SQLException {
        return this.getClob(this.findColumn(columnLabel));
    }

    @Override
    public NClob getNClob(int columnIndex) throws SQLException {
        throw MonetResultSet.newSQLFeatureNotSupportedException("getNClob");
    }

    @Override
    public NClob getNClob(String columnLabel) throws SQLException {
        throw MonetResultSet.newSQLFeatureNotSupportedException("getNClob");
    }

    @Override
    public BigDecimal getBigDecimal(int columnIndex) throws SQLException {
        this.checkNotClosed();
        try {
            switch (this.JdbcSQLTypes[columnIndex - 1]) {
                case 2: 
                case 3: {
                    return (BigDecimal)this.currentBlock.getObjectValue(columnIndex - 1);
                }
                case 16: {
                    boolean bol = this.currentBlock.getBooleanValue(columnIndex - 1);
                    return this.currentBlock.isLastReadWasNull() ? null : new BigDecimal(bol ? 1 : 0);
                }
                case -6: {
                    byte bb = this.currentBlock.getByteValue(columnIndex - 1);
                    return this.currentBlock.isLastReadWasNull() ? null : new BigDecimal(bb);
                }
                case 5: {
                    short sh = this.currentBlock.getShortValue(columnIndex - 1);
                    return this.currentBlock.isLastReadWasNull() ? null : new BigDecimal(sh);
                }
                case 4: {
                    int in = this.currentBlock.getIntValue(columnIndex - 1);
                    return this.currentBlock.isLastReadWasNull() ? null : new BigDecimal(in);
                }
                case -5: {
                    long lon = this.currentBlock.getLongValue(columnIndex - 1);
                    return this.currentBlock.isLastReadWasNull() ? null : new BigDecimal(lon);
                }
                case 7: {
                    float floa = this.currentBlock.getFloatValue(columnIndex - 1);
                    return this.currentBlock.isLastReadWasNull() ? null : new BigDecimal(floa);
                }
                case 8: {
                    double dou = this.currentBlock.getDoubleValue(columnIndex - 1);
                    return this.currentBlock.isLastReadWasNull() ? null : new BigDecimal(dou);
                }
                case -4: 
                case -1: 
                case 1: 
                case 12: 
                case 2004: 
                case 2005: {
                    String ss = this.currentBlock.getValueAsString(columnIndex - 1);
                    return ss == null ? null : new BigDecimal(ss);
                }
            }
            throw new SQLException("Conversion from " + this.types[columnIndex - 1] + " to boolean type not supported", "M1M05");
        }
        catch (ClassCastException ex) {
            throw new SQLException(ex.getMessage());
        }
        catch (ProtocolException e) {
            throw new SQLException(e);
        }
        catch (IndexOutOfBoundsException e) {
            throw MonetResultSet.newSQLInvalidColumnIndexException(columnIndex);
        }
    }

    @Override
    @Deprecated
    public BigDecimal getBigDecimal(int columnIndex, int scale) throws SQLException {
        this.checkNotClosed();
        try {
            BigDecimal val = this.getBigDecimal(columnIndex);
            if (val != null) {
                val.setScale(scale);
            }
            return val;
        }
        catch (ClassCastException ex) {
            throw new SQLException(ex.getMessage());
        }
        catch (IndexOutOfBoundsException e) {
            throw MonetResultSet.newSQLInvalidColumnIndexException(columnIndex);
        }
    }

    @Override
    public BigDecimal getBigDecimal(String columnLabel) throws SQLException {
        return this.getBigDecimal(this.findColumn(columnLabel));
    }

    @Override
    @Deprecated
    public BigDecimal getBigDecimal(String columnLabel, int scale) throws SQLException {
        return this.getBigDecimal(this.findColumn(columnLabel), scale);
    }

    @Override
    public boolean getBoolean(int columnIndex) throws SQLException {
        this.checkNotClosed();
        try {
            switch (this.JdbcSQLTypes[columnIndex - 1]) {
                case 16: {
                    boolean bol = this.currentBlock.getBooleanValue(columnIndex - 1);
                    return !this.currentBlock.isLastReadWasNull() && bol;
                }
                case -6: {
                    byte bb = this.currentBlock.getByteValue(columnIndex - 1);
                    return !this.currentBlock.isLastReadWasNull() && bb != 0;
                }
                case 5: {
                    short sh = this.currentBlock.getShortValue(columnIndex - 1);
                    return !this.currentBlock.isLastReadWasNull() && sh != 0;
                }
                case 4: {
                    int in = this.currentBlock.getIntValue(columnIndex - 1);
                    return !this.currentBlock.isLastReadWasNull() && in != 0;
                }
                case -5: {
                    long lon = this.currentBlock.getLongValue(columnIndex - 1);
                    return !this.currentBlock.isLastReadWasNull() && lon != 0L;
                }
                case 7: {
                    float floa = this.currentBlock.getFloatValue(columnIndex - 1);
                    return !this.currentBlock.isLastReadWasNull() && floa != 0.0f;
                }
                case 8: {
                    double dou = this.currentBlock.getDoubleValue(columnIndex - 1);
                    return !this.currentBlock.isLastReadWasNull() && dou != 0.0;
                }
                case -4: 
                case -1: 
                case 1: 
                case 12: 
                case 2004: 
                case 2005: {
                    String val = this.currentBlock.getValueAsString(columnIndex - 1);
                    return val != null && !"0".equals(val) && ("1".equals(val) || Boolean.parseBoolean(val));
                }
                case 2: 
                case 3: {
                    BigDecimal bigdec = (BigDecimal)this.currentBlock.getValueAsObject(columnIndex - 1);
                    return bigdec != null && bigdec.compareTo(BigDecimal.ZERO) != 0;
                }
            }
            throw new SQLException("Conversion from " + this.types[columnIndex - 1] + " to boolean type not supported", "M1M05");
        }
        catch (ClassCastException ex) {
            throw new SQLException(ex.getMessage());
        }
        catch (ProtocolException e) {
            throw new SQLException(e);
        }
        catch (IndexOutOfBoundsException e) {
            throw MonetResultSet.newSQLInvalidColumnIndexException(columnIndex);
        }
    }

    @Override
    public boolean getBoolean(String columnLabel) throws SQLException {
        return this.getBoolean(this.findColumn(columnLabel));
    }

    @Override
    public byte getByte(int columnIndex) throws SQLException {
        this.checkNotClosed();
        try {
            switch (this.JdbcSQLTypes[columnIndex - 1]) {
                case -6: {
                    byte bb = this.currentBlock.getByteValue(columnIndex - 1);
                    return this.currentBlock.isLastReadWasNull() ? (byte)0 : bb;
                }
                case 16: {
                    boolean bol = this.currentBlock.getBooleanValue(columnIndex - 1);
                    return this.currentBlock.isLastReadWasNull() ? (byte)0 : (bol ? (byte)1 : 0);
                }
                case 5: {
                    short sh = this.currentBlock.getShortValue(columnIndex - 1);
                    return this.currentBlock.isLastReadWasNull() ? (byte)0 : (byte)sh;
                }
                case 4: {
                    int in = this.currentBlock.getIntValue(columnIndex - 1);
                    return this.currentBlock.isLastReadWasNull() ? (byte)0 : (byte)in;
                }
                case -5: {
                    long lon = this.currentBlock.getLongValue(columnIndex - 1);
                    return this.currentBlock.isLastReadWasNull() ? (byte)0 : (byte)lon;
                }
                case 7: {
                    float floa = this.currentBlock.getFloatValue(columnIndex - 1);
                    return this.currentBlock.isLastReadWasNull() ? (byte)0 : (byte)Math.round(floa);
                }
                case 8: {
                    double dou = this.currentBlock.getDoubleValue(columnIndex - 1);
                    return this.currentBlock.isLastReadWasNull() ? (byte)0 : (byte)Math.round(dou);
                }
                case -4: 
                case -1: 
                case 1: 
                case 12: 
                case 2004: 
                case 2005: {
                    String ss = this.currentBlock.getValueAsString(columnIndex - 1);
                    return ss == null ? (byte)0 : Byte.parseByte(ss);
                }
                case 2: 
                case 3: {
                    BigDecimal bigdec = (BigDecimal)this.currentBlock.getValueAsObject(columnIndex - 1);
                    return bigdec == null ? (byte)0 : bigdec.byteValue();
                }
            }
            throw new SQLException("Conversion from " + this.types[columnIndex - 1] + " to byte type not supported", "M1M05");
        }
        catch (ClassCastException ex) {
            throw new SQLException(ex.getMessage());
        }
        catch (ProtocolException e) {
            throw new SQLException(e);
        }
        catch (IndexOutOfBoundsException e) {
            throw MonetResultSet.newSQLInvalidColumnIndexException(columnIndex);
        }
    }

    @Override
    public byte getByte(String columnLabel) throws SQLException {
        return this.getByte(this.findColumn(columnLabel));
    }

    @Override
    public byte[] getBytes(int columnIndex) throws SQLException {
        this.checkNotClosed();
        try {
            switch (this.JdbcSQLTypes[columnIndex - 1]) {
                case 2004: {
                    MonetBlob mb = (MonetBlob)this.currentBlock.getObjectValue(columnIndex - 1);
                    return mb == null ? null : mb.getBuffer();
                }
                case -4: {
                    return (byte[])this.currentBlock.getObjectValue(columnIndex - 1);
                }
                case -1: 
                case 1: 
                case 12: 
                case 2005: {
                    String ss = this.currentBlock.getValueAsString(columnIndex - 1);
                    return ss == null ? null : ss.getBytes();
                }
            }
            throw new SQLException("Cannot operate on " + this.types[columnIndex - 1] + " type", "M1M05");
        }
        catch (ClassCastException ex) {
            throw new SQLException(ex.getMessage());
        }
        catch (ProtocolException e) {
            throw new SQLException(e);
        }
        catch (IndexOutOfBoundsException e) {
            throw MonetResultSet.newSQLInvalidColumnIndexException(columnIndex);
        }
    }

    @Override
    public byte[] getBytes(String columnLabel) throws SQLException {
        return this.getBytes(this.findColumn(columnLabel));
    }

    @Override
    public int getConcurrency() {
        return this.concurrency;
    }

    @Override
    public String getCursorName() throws SQLException {
        throw new SQLException("Positioned updates not supported for this cursor (" + (this.header != null ? Integer.valueOf(this.header.getId()) : "") + ")", "0AM21");
    }

    @Override
    public double getDouble(int columnIndex) throws SQLException {
        this.checkNotClosed();
        try {
            switch (this.JdbcSQLTypes[columnIndex - 1]) {
                case 8: {
                    double res = this.currentBlock.getDoubleValue(columnIndex - 1);
                    return this.currentBlock.isLastReadWasNull() ? 0.0 : res;
                }
                case 16: {
                    boolean bol = this.currentBlock.getBooleanValue(columnIndex - 1);
                    return this.currentBlock.isLastReadWasNull() ? 0.0 : (bol ? 1.0 : 0.0);
                }
                case -6: {
                    byte bb = this.currentBlock.getByteValue(columnIndex - 1);
                    return this.currentBlock.isLastReadWasNull() ? 0.0 : (double)bb;
                }
                case 5: {
                    short sh = this.currentBlock.getShortValue(columnIndex - 1);
                    return this.currentBlock.isLastReadWasNull() ? 0.0 : (double)sh;
                }
                case 4: {
                    int in = this.currentBlock.getIntValue(columnIndex - 1);
                    return this.currentBlock.isLastReadWasNull() ? 0.0 : (double)in;
                }
                case -5: {
                    long lon = this.currentBlock.getLongValue(columnIndex - 1);
                    return this.currentBlock.isLastReadWasNull() ? 0.0 : (double)lon;
                }
                case 7: {
                    float floa = this.currentBlock.getFloatValue(columnIndex - 1);
                    return this.currentBlock.isLastReadWasNull() ? 0.0 : (double)floa;
                }
                case -4: 
                case -1: 
                case 1: 
                case 12: 
                case 2004: 
                case 2005: {
                    String ss = this.currentBlock.getValueAsString(columnIndex - 1);
                    return ss == null ? 0.0 : Double.parseDouble(ss);
                }
                case 2: 
                case 3: {
                    BigDecimal bigdec = (BigDecimal)this.currentBlock.getValueAsObject(columnIndex - 1);
                    return bigdec == null ? 0.0 : bigdec.doubleValue();
                }
            }
            throw new SQLException("Conversion from " + this.types[columnIndex - 1] + " to double type not supported", "M1M05");
        }
        catch (ClassCastException ex) {
            throw new SQLException(ex.getMessage());
        }
        catch (ProtocolException e) {
            throw new SQLException(e);
        }
        catch (IndexOutOfBoundsException e) {
            throw MonetResultSet.newSQLInvalidColumnIndexException(columnIndex);
        }
    }

    @Override
    public double getDouble(String columnLabel) throws SQLException {
        return this.getDouble(this.findColumn(columnLabel));
    }

    @Override
    public int getHoldability() throws SQLException {
        return this.getStatement().getConnection().getHoldability();
    }

    @Override
    public int getFetchDirection() {
        return 1000;
    }

    @Override
    public void setFetchDirection(int direction) throws SQLException {
        switch (direction) {
            case 1000: {
                break;
            }
            case 1001: 
            case 1002: {
                throw new SQLException("Not supported direction " + direction, "0A000");
            }
            default: {
                throw new SQLException("Illegal direction: " + direction, "M1M05");
            }
        }
    }

    @Override
    public int getFetchSize() throws SQLException {
        return this.fetchSize;
    }

    @Override
    public void setFetchSize(int rows) throws SQLException {
        if (rows < 0) {
            throw new SQLException("Illegal fetch size value: " + rows, "M1M05");
        }
        this.fetchSize = rows;
    }

    @Override
    public float getFloat(int columnIndex) throws SQLException {
        this.checkNotClosed();
        try {
            switch (this.JdbcSQLTypes[columnIndex - 1]) {
                case 7: {
                    float res = this.currentBlock.getFloatValue(columnIndex - 1);
                    return this.currentBlock.isLastReadWasNull() ? 0.0f : res;
                }
                case 16: {
                    boolean bol = this.currentBlock.getBooleanValue(columnIndex - 1);
                    return this.currentBlock.isLastReadWasNull() ? 0.0f : (bol ? 1.0f : 0.0f);
                }
                case -6: {
                    byte bb = this.currentBlock.getByteValue(columnIndex - 1);
                    return this.currentBlock.isLastReadWasNull() ? 0.0f : (float)bb;
                }
                case 5: {
                    short sh = this.currentBlock.getShortValue(columnIndex - 1);
                    return this.currentBlock.isLastReadWasNull() ? 0.0f : (float)sh;
                }
                case 4: {
                    int in = this.currentBlock.getIntValue(columnIndex - 1);
                    return this.currentBlock.isLastReadWasNull() ? 0.0f : (float)in;
                }
                case -5: {
                    long lon = this.currentBlock.getLongValue(columnIndex - 1);
                    return this.currentBlock.isLastReadWasNull() ? 0.0f : (float)lon;
                }
                case 8: {
                    double dou = this.currentBlock.getDoubleValue(columnIndex - 1);
                    return this.currentBlock.isLastReadWasNull() ? 0.0f : (float)dou;
                }
                case -4: 
                case -1: 
                case 1: 
                case 12: 
                case 2004: 
                case 2005: {
                    String ss = this.currentBlock.getValueAsString(columnIndex - 1);
                    return ss == null ? 0.0f : Float.parseFloat(ss);
                }
                case 2: 
                case 3: {
                    BigDecimal bigdec = (BigDecimal)this.currentBlock.getValueAsObject(columnIndex - 1);
                    return bigdec == null ? 0.0f : bigdec.floatValue();
                }
            }
            throw new SQLException("Conversion from " + this.types[columnIndex - 1] + " to float type not supported", "M1M05");
        }
        catch (ClassCastException ex) {
            throw new SQLException(ex.getMessage());
        }
        catch (ProtocolException e) {
            throw new SQLException(e);
        }
        catch (IndexOutOfBoundsException e) {
            throw MonetResultSet.newSQLInvalidColumnIndexException(columnIndex);
        }
    }

    @Override
    public float getFloat(String columnLabel) throws SQLException {
        return this.getFloat(this.findColumn(columnLabel));
    }

    @Override
    public int getInt(int columnIndex) throws SQLException {
        this.checkNotClosed();
        try {
            switch (this.JdbcSQLTypes[columnIndex - 1]) {
                case 4: {
                    int res = this.currentBlock.getIntValue(columnIndex - 1);
                    return this.currentBlock.isLastReadWasNull() ? 0 : res;
                }
                case 16: {
                    boolean bol = this.currentBlock.getBooleanValue(columnIndex - 1);
                    return this.currentBlock.isLastReadWasNull() ? 0 : (bol ? 1 : 0);
                }
                case -6: {
                    byte bb = this.currentBlock.getByteValue(columnIndex - 1);
                    return this.currentBlock.isLastReadWasNull() ? (byte)0 : bb;
                }
                case 5: {
                    short sh = this.currentBlock.getShortValue(columnIndex - 1);
                    return this.currentBlock.isLastReadWasNull() ? (short)0 : sh;
                }
                case -5: {
                    long lon = this.currentBlock.getLongValue(columnIndex - 1);
                    return this.currentBlock.isLastReadWasNull() ? 0 : (int)lon;
                }
                case 7: {
                    float floa = this.currentBlock.getFloatValue(columnIndex - 1);
                    return this.currentBlock.isLastReadWasNull() ? 0 : Math.round(floa);
                }
                case 8: {
                    double dou = this.currentBlock.getDoubleValue(columnIndex - 1);
                    return this.currentBlock.isLastReadWasNull() ? 0 : (int)Math.round(dou);
                }
                case -4: 
                case -1: 
                case 1: 
                case 12: 
                case 2004: 
                case 2005: {
                    String ss = this.currentBlock.getValueAsString(columnIndex - 1);
                    return ss == null ? 0 : Integer.parseInt(ss);
                }
                case 2: 
                case 3: {
                    BigDecimal bigdec = (BigDecimal)this.currentBlock.getValueAsObject(columnIndex - 1);
                    return bigdec == null ? 0 : bigdec.intValue();
                }
                case 1111: {
                    if (!"oid".equals(this.types[columnIndex - 1])) break;
                    String val = this.currentBlock.getValueAsString(columnIndex - 1);
                    if (this.currentBlock.isLastReadWasNull()) {
                        return 0;
                    }
                    int len = val.length();
                    if (len <= 2 || !val.endsWith("@0")) break;
                    try {
                        return Integer.parseInt(val.substring(0, len - 2));
                    }
                    catch (NumberFormatException nfe) {
                        throw MonetResultSet.newSQLNumberFormatException(nfe);
                    }
                }
            }
            throw new SQLException("Conversion from " + this.types[columnIndex - 1] + " to integer type not supported", "M1M05");
        }
        catch (ClassCastException ex) {
            throw new SQLException(ex.getMessage());
        }
        catch (ProtocolException e) {
            throw new SQLException(e);
        }
        catch (IndexOutOfBoundsException e) {
            throw MonetResultSet.newSQLInvalidColumnIndexException(columnIndex);
        }
    }

    @Override
    public int getInt(String columnLabel) throws SQLException {
        return this.getInt(this.findColumn(columnLabel));
    }

    @Override
    public long getLong(int columnIndex) throws SQLException {
        this.checkNotClosed();
        try {
            switch (this.JdbcSQLTypes[columnIndex - 1]) {
                case -5: {
                    long res = this.currentBlock.getLongValue(columnIndex - 1);
                    return this.currentBlock.isLastReadWasNull() ? 0L : res;
                }
                case 16: {
                    boolean bol = this.currentBlock.getBooleanValue(columnIndex - 1);
                    return this.currentBlock.isLastReadWasNull() ? 0L : (long)(bol ? 1 : 0);
                }
                case -6: {
                    byte bb = this.currentBlock.getByteValue(columnIndex - 1);
                    return this.currentBlock.isLastReadWasNull() ? 0L : (long)bb;
                }
                case 5: {
                    short sh = this.currentBlock.getShortValue(columnIndex - 1);
                    return this.currentBlock.isLastReadWasNull() ? 0L : (long)sh;
                }
                case 4: {
                    int in = this.currentBlock.getIntValue(columnIndex - 1);
                    return this.currentBlock.isLastReadWasNull() ? 0L : (long)in;
                }
                case 7: {
                    float floa = this.currentBlock.getFloatValue(columnIndex - 1);
                    return this.currentBlock.isLastReadWasNull() ? 0L : (long)Math.round(floa);
                }
                case 8: {
                    double dou = this.currentBlock.getDoubleValue(columnIndex - 1);
                    return this.currentBlock.isLastReadWasNull() ? 0L : Math.round(dou);
                }
                case -4: 
                case -1: 
                case 1: 
                case 12: 
                case 2004: 
                case 2005: {
                    String ss = this.currentBlock.getValueAsString(columnIndex - 1);
                    return ss == null ? 0L : Long.parseLong(ss);
                }
                case 2: 
                case 3: {
                    BigDecimal bigdec = (BigDecimal)this.currentBlock.getValueAsObject(columnIndex - 1);
                    return bigdec == null ? 0L : bigdec.longValue();
                }
                case 1111: {
                    if (!"oid".equals(this.types[columnIndex - 1])) break;
                    String val = this.currentBlock.getValueAsString(columnIndex - 1);
                    if (this.currentBlock.isLastReadWasNull()) {
                        return 0L;
                    }
                    int len = val.length();
                    if (len <= 2 || !val.endsWith("@0")) break;
                    try {
                        return Long.parseLong(val.substring(0, len - 2));
                    }
                    catch (NumberFormatException nfe) {
                        throw MonetResultSet.newSQLNumberFormatException(nfe);
                    }
                }
            }
            throw new SQLException("Conversion from " + this.types[columnIndex - 1] + " to long type not supported", "M1M05");
        }
        catch (ClassCastException ex) {
            throw new SQLException(ex.getMessage());
        }
        catch (ProtocolException e) {
            throw new SQLException(e);
        }
        catch (IndexOutOfBoundsException e) {
            throw MonetResultSet.newSQLInvalidColumnIndexException(columnIndex);
        }
    }

    @Override
    public long getLong(String columnLabel) throws SQLException {
        return this.getLong(this.findColumn(columnLabel));
    }

    @Override
    public ResultSetMetaData getMetaData() throws SQLException {
        return new rsmdw(){
            private final int array_size;
            private final boolean[] _is_fetched;
            private final int[] _precision;
            private final int[] _scale;
            private final int[] _isNullable;
            private final boolean[] _isAutoincrement;
            private final Connection conn;
            private final DatabaseMetaData dbmd;
            {
                this.array_size = MonetResultSet.this.columns.length + 1;
                this._is_fetched = new boolean[this.array_size];
                this._precision = new int[this.array_size];
                this._scale = new int[this.array_size];
                this._isNullable = new int[this.array_size];
                this._isAutoincrement = new boolean[this.array_size];
                this.conn = MonetResultSet.this.getStatement().getConnection();
                this.dbmd = this.conn.getMetaData();
            }

            private void checkColumnIndexValidity(int column) throws SQLDataException {
                if (column < 1 || column > MonetResultSet.this.columns.length) {
                    throw MonetResultSet.newSQLInvalidColumnIndexException(column);
                }
            }

            private void fetchColumnInfo(int column) throws SQLException {
                ResultSet colInfo;
                String colName;
                String tblName;
                this.checkColumnIndexValidity(column);
                this._is_fetched[column] = true;
                this._precision[column] = 0;
                this._scale[column] = 0;
                this._isNullable[column] = 2;
                this._isAutoincrement[column] = false;
                String schName = this.getSchemaName(column);
                if (!(schName == null || schName.isEmpty() || (tblName = this.getTableName(column)) == null || tblName.isEmpty() || (colName = this.getColumnName(column)) == null || colName.isEmpty() || this.dbmd == null || (colInfo = this.dbmd.getColumns(null, schName, tblName, colName)) == null)) {
                    if (colInfo.next()) {
                        this._precision[column] = colInfo.getInt(7);
                        this._scale[column] = colInfo.getInt(9);
                        this._isNullable[column] = colInfo.getInt(11);
                        String strVal = colInfo.getString(23);
                        if (strVal != null && "YES".equals(strVal)) {
                            this._isAutoincrement[column] = true;
                        }
                    }
                    colInfo.close();
                }
            }

            @Override
            public int getColumnCount() {
                return MonetResultSet.this.columns.length;
            }

            @Override
            public boolean isAutoIncrement(int column) throws SQLException {
                this.checkColumnIndexValidity(column);
                try {
                    if (!this._is_fetched[column]) {
                        this.fetchColumnInfo(column);
                    }
                    return this._isAutoincrement[column];
                }
                catch (IndexOutOfBoundsException e) {
                    throw MonetResultSet.newSQLInvalidColumnIndexException(column);
                }
            }

            @Override
            public boolean isCaseSensitive(int column) throws SQLException {
                switch (this.getColumnType(column)) {
                    case -1: 
                    case 1: 
                    case 12: 
                    case 2005: {
                        return true;
                    }
                }
                return false;
            }

            @Override
            public boolean isSearchable(int column) throws SQLException {
                this.checkColumnIndexValidity(column);
                return true;
            }

            @Override
            public boolean isCurrency(int column) throws SQLException {
                this.checkColumnIndexValidity(column);
                return false;
            }

            @Override
            public boolean isSigned(int column) throws SQLException {
                switch (this.getColumnType(column)) {
                    case -6: 
                    case -5: 
                    case 2: 
                    case 3: 
                    case 4: 
                    case 5: 
                    case 7: 
                    case 8: {
                        return true;
                    }
                }
                return false;
            }

            @Override
            public int getColumnDisplaySize(int column) throws SQLException {
                this.checkColumnIndexValidity(column);
                int ret = 1;
                if (MonetResultSet.this.header != null) {
                    try {
                        ret = MonetResultSet.this.header.getColumnLengths()[column - 1];
                    }
                    catch (IndexOutOfBoundsException e) {
                        throw MonetResultSet.newSQLInvalidColumnIndexException(column);
                    }
                }
                return ret;
            }

            @Override
            public String getSchemaName(int column) throws SQLException {
                this.checkColumnIndexValidity(column);
                if (MonetResultSet.this.header != null) {
                    try {
                        String schema = MonetResultSet.this.header.getTableNames()[column - 1];
                        if (schema != null) {
                            int dot = schema.indexOf(46);
                            return dot >= 0 ? schema.substring(0, dot) : "";
                        }
                    }
                    catch (IndexOutOfBoundsException e) {
                        throw MonetResultSet.newSQLInvalidColumnIndexException(column);
                    }
                }
                return "";
            }

            @Override
            public String getTableName(int column) throws SQLException {
                this.checkColumnIndexValidity(column);
                if (MonetResultSet.this.header != null) {
                    try {
                        String table = MonetResultSet.this.header.getTableNames()[column - 1];
                        if (table != null) {
                            int dot = table.indexOf(46);
                            return dot >= 0 ? table.substring(dot + 1) : table;
                        }
                    }
                    catch (IndexOutOfBoundsException e) {
                        throw MonetResultSet.newSQLInvalidColumnIndexException(column);
                    }
                }
                return "";
            }

            @Override
            public int getPrecision(int column) throws SQLException {
                this.checkColumnIndexValidity(column);
                try {
                    if (!this._is_fetched[column]) {
                        this.fetchColumnInfo(column);
                    }
                    if (this._precision[column] == 0) {
                        switch (this.getColumnType(column)) {
                            case -4: 
                            case -1: 
                            case 1: 
                            case 2: 
                            case 3: 
                            case 12: 
                            case 2004: 
                            case 2005: {
                                this._precision[column] = this.getColumnDisplaySize(column);
                                break;
                            }
                            case -6: {
                                this._precision[column] = 3;
                                break;
                            }
                            case 5: {
                                this._precision[column] = 5;
                                break;
                            }
                            case 4: {
                                this._precision[column] = 10;
                                break;
                            }
                            case -5: {
                                this._precision[column] = 19;
                                break;
                            }
                            case 7: {
                                this._precision[column] = 7;
                                break;
                            }
                            case 8: {
                                this._precision[column] = 15;
                                break;
                            }
                            case 16: {
                                this._precision[column] = 5;
                                break;
                            }
                            case 91: {
                                this._precision[column] = 10;
                                break;
                            }
                            case 92: 
                            case 2013: {
                                this._precision[column] = 8;
                                break;
                            }
                            case 93: 
                            case 2014: {
                                this._precision[column] = 19;
                                break;
                            }
                            default: {
                                this._precision[column] = 30;
                            }
                        }
                    }
                    return this._precision[column];
                }
                catch (IndexOutOfBoundsException e) {
                    throw MonetResultSet.newSQLInvalidColumnIndexException(column);
                }
            }

            @Override
            public int getScale(int column) throws SQLException {
                this.checkColumnIndexValidity(column);
                try {
                    if (!this._is_fetched[column]) {
                        this.fetchColumnInfo(column);
                    }
                    return this._scale[column];
                }
                catch (IndexOutOfBoundsException e) {
                    throw MonetResultSet.newSQLInvalidColumnIndexException(column);
                }
            }

            @Override
            public int isNullable(int column) throws SQLException {
                this.checkColumnIndexValidity(column);
                try {
                    if (!this._is_fetched[column]) {
                        this.fetchColumnInfo(column);
                    }
                    return this._isNullable[column];
                }
                catch (IndexOutOfBoundsException e) {
                    throw MonetResultSet.newSQLInvalidColumnIndexException(column);
                }
            }

            @Override
            public String getCatalogName(int column) throws SQLException {
                this.checkColumnIndexValidity(column);
                return null;
            }

            @Override
            public boolean isReadOnly(int column) throws SQLException {
                this.checkColumnIndexValidity(column);
                return true;
            }

            @Override
            public boolean isWritable(int column) throws SQLException {
                this.checkColumnIndexValidity(column);
                return false;
            }

            @Override
            public boolean isDefinitelyWritable(int column) throws SQLException {
                this.checkColumnIndexValidity(column);
                return false;
            }

            @Override
            public String getColumnClassName(int column) throws SQLException {
                this.checkColumnIndexValidity(column);
                try {
                    Map<String, Class<?>> map;
                    String MonetDBType = MonetResultSet.this.types[column - 1];
                    Class<?> type = null;
                    if (this.conn != null && (map = this.conn.getTypeMap()) != null && map.containsKey(MonetDBType)) {
                        type = map.get(MonetDBType);
                    }
                    if (type == null) {
                        type = MonetResultSet.getClassForType(MonetResultSet.this.JdbcSQLTypes[column - 1]);
                    }
                    if (type != null) {
                        return type.getName();
                    }
                    throw new SQLException("column type mapping null: " + MonetDBType, "M0M03");
                }
                catch (IndexOutOfBoundsException e) {
                    throw MonetResultSet.newSQLInvalidColumnIndexException(column);
                }
            }

            @Override
            public String getColumnLabel(int column) throws SQLException {
                return this.getColumnName(column);
            }

            @Override
            public String getColumnName(int column) throws SQLException {
                this.checkColumnIndexValidity(column);
                try {
                    return MonetResultSet.this.columns[column - 1];
                }
                catch (IndexOutOfBoundsException e) {
                    throw MonetResultSet.newSQLInvalidColumnIndexException(column);
                }
            }

            @Override
            public int getColumnType(int column) throws SQLException {
                this.checkColumnIndexValidity(column);
                try {
                    return MonetResultSet.this.JdbcSQLTypes[column - 1];
                }
                catch (IndexOutOfBoundsException e) {
                    throw MonetResultSet.newSQLInvalidColumnIndexException(column);
                }
            }

            @Override
            public String getColumnTypeName(int column) throws SQLException {
                this.checkColumnIndexValidity(column);
                try {
                    return MonetResultSet.this.types[column - 1];
                }
                catch (IndexOutOfBoundsException e) {
                    throw MonetResultSet.newSQLInvalidColumnIndexException(column);
                }
            }
        };
    }

    @Override
    public Object getObject(int columnIndex) throws SQLException {
        this.checkNotClosed();
        try {
            int JdbcType = this.JdbcSQLTypes[columnIndex - 1];
            switch (JdbcType) {
                case -6: 
                case -5: 
                case -4: 
                case -1: 
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 7: 
                case 8: 
                case 12: 
                case 16: 
                case 2004: 
                case 2005: {
                    return this.currentBlock.getValueAsObject(columnIndex - 1);
                }
                case 91: {
                    return this.getDate(columnIndex);
                }
                case 92: 
                case 2013: {
                    return this.getTime(columnIndex);
                }
                case 93: 
                case 2014: {
                    return this.getTimestamp(columnIndex);
                }
                case 1111: {
                    String MonetDBType = this.types[columnIndex - 1];
                    String val = this.currentBlock.getValueAsString(columnIndex - 1);
                    if (val == null) {
                        return null;
                    }
                    switch (MonetDBType.length()) {
                        case 3: {
                            if (!"url".equals(MonetDBType)) break;
                            try {
                                return new MonetURL(val);
                            }
                            catch (Exception exc) {
                                return val;
                            }
                        }
                        case 4: {
                            if ("inet".equals(MonetDBType)) {
                                try {
                                    return new MonetINET(val);
                                }
                                catch (Exception exc) {
                                    return val;
                                }
                            }
                            if (!"uuid".equals(MonetDBType)) break;
                            try {
                                return UUID.fromString(val);
                            }
                            catch (IllegalArgumentException exc) {
                                return val;
                            }
                        }
                    }
                    return val;
                }
            }
            return this.getObject(columnIndex, this.getStatement().getConnection().getTypeMap());
        }
        catch (IndexOutOfBoundsException e) {
            throw MonetResultSet.newSQLInvalidColumnIndexException(columnIndex);
        }
        catch (ProtocolException e) {
            throw new SQLException(e);
        }
    }

    private boolean classImplementsSQLData(Class<?> cl) {
        Class<?>[] cls = cl.getInterfaces();
        for (int i = 0; i < cls.length; ++i) {
            if (cls[i] != SQLData.class) continue;
            return true;
        }
        return false;
    }

    private Object getObjectFromClass(int columnIndex, Class<?> type) throws SQLException {
        try {
            if (type == null) {
                type = MonetResultSet.getClassForType(this.JdbcSQLTypes[columnIndex - 1]);
            }
            if (type == null || type == String.class) {
                return this.currentBlock.getValueAsString(columnIndex - 1);
            }
            if (type == BigDecimal.class) {
                return this.getBigDecimal(columnIndex);
            }
            if (type == Boolean.class) {
                return this.getBoolean(columnIndex);
            }
            if (type == Byte.class) {
                return this.getByte(columnIndex);
            }
            if (type == Short.class) {
                return this.getShort(columnIndex);
            }
            if (type == Integer.class) {
                return this.getInt(columnIndex);
            }
            if (type == Long.class) {
                return this.getLong(columnIndex);
            }
            if (type == Float.class) {
                return Float.valueOf(this.getFloat(columnIndex));
            }
            if (type == Double.class) {
                return this.getDouble(columnIndex);
            }
            if (type == byte[].class) {
                return this.getBytes(columnIndex);
            }
            if (type == Date.class) {
                return this.getDate(columnIndex);
            }
            if (type == Time.class) {
                return this.getTime(columnIndex);
            }
            if (type == Timestamp.class) {
                return this.getTimestamp(columnIndex);
            }
            if (type == Clob.class) {
                return this.getClob(columnIndex);
            }
            if (type == Blob.class) {
                return this.getBlob(columnIndex);
            }
            if (this.classImplementsSQLData(type)) {
                SQLData x;
                try {
                    Constructor<?> ctor = type.getConstructor(new Class[0]);
                    x = (SQLData)ctor.newInstance(new Object[0]);
                }
                catch (IllegalAccessException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException nsme) {
                    throw new SQLException(nsme.getMessage(), "M0M27");
                }
                final int colnum = columnIndex;
                final boolean valwasnull = this.wasNull();
                SQLInput input = new SQLInput(){

                    @Override
                    public String readString() throws SQLException {
                        return MonetResultSet.this.getString(colnum);
                    }

                    @Override
                    public boolean readBoolean() throws SQLException {
                        return MonetResultSet.this.getBoolean(colnum);
                    }

                    @Override
                    public byte readByte() throws SQLException {
                        return MonetResultSet.this.getByte(colnum);
                    }

                    @Override
                    public short readShort() throws SQLException {
                        return MonetResultSet.this.getShort(colnum);
                    }

                    @Override
                    public int readInt() throws SQLException {
                        return MonetResultSet.this.getInt(colnum);
                    }

                    @Override
                    public long readLong() throws SQLException {
                        return MonetResultSet.this.getLong(colnum);
                    }

                    @Override
                    public float readFloat() throws SQLException {
                        return MonetResultSet.this.getFloat(colnum);
                    }

                    @Override
                    public double readDouble() throws SQLException {
                        return MonetResultSet.this.getDouble(colnum);
                    }

                    @Override
                    public BigDecimal readBigDecimal() throws SQLException {
                        return MonetResultSet.this.getBigDecimal(colnum);
                    }

                    @Override
                    public byte[] readBytes() throws SQLException {
                        return MonetResultSet.this.getBytes(colnum);
                    }

                    @Override
                    public Date readDate() throws SQLException {
                        return MonetResultSet.this.getDate(colnum);
                    }

                    @Override
                    public Time readTime() throws SQLException {
                        return MonetResultSet.this.getTime(colnum);
                    }

                    @Override
                    public Timestamp readTimestamp() throws SQLException {
                        return MonetResultSet.this.getTimestamp(colnum);
                    }

                    @Override
                    public Reader readCharacterStream() throws SQLException {
                        return MonetResultSet.this.getCharacterStream(colnum);
                    }

                    @Override
                    public InputStream readAsciiStream() throws SQLException {
                        return MonetResultSet.this.getAsciiStream(colnum);
                    }

                    @Override
                    public InputStream readBinaryStream() throws SQLException {
                        return MonetResultSet.this.getBinaryStream(colnum);
                    }

                    @Override
                    public Object readObject() throws SQLException {
                        return MonetResultSet.this.getObject(colnum);
                    }

                    @Override
                    public Ref readRef() throws SQLException {
                        return MonetResultSet.this.getRef(colnum);
                    }

                    @Override
                    public Blob readBlob() throws SQLException {
                        return MonetResultSet.this.getBlob(colnum);
                    }

                    @Override
                    public Clob readClob() throws SQLException {
                        return MonetResultSet.this.getClob(colnum);
                    }

                    @Override
                    public Array readArray() throws SQLException {
                        return MonetResultSet.this.getArray(colnum);
                    }

                    @Override
                    public boolean wasNull() throws SQLException {
                        return valwasnull;
                    }

                    @Override
                    public URL readURL() throws SQLException {
                        return MonetResultSet.this.getURL(colnum);
                    }

                    @Override
                    public NClob readNClob() throws SQLException {
                        return MonetResultSet.this.getNClob(colnum);
                    }

                    @Override
                    public String readNString() throws SQLException {
                        return MonetResultSet.this.getNString(colnum);
                    }

                    @Override
                    public SQLXML readSQLXML() throws SQLException {
                        return MonetResultSet.this.getSQLXML(colnum);
                    }

                    @Override
                    public RowId readRowId() throws SQLException {
                        return MonetResultSet.this.getRowId(colnum);
                    }
                };
                x.readSQL(input, this.types[columnIndex - 1]);
                return x;
            }
            return this.currentBlock.getObjectValue(columnIndex - 1);
        }
        catch (ProtocolException e) {
            throw new SQLException(e);
        }
    }

    @Override
    public Object getObject(int columnIndex, Map<String, Class<?>> map) throws SQLException {
        this.checkNotClosed();
        try {
            String MonetDBtype = this.types[columnIndex - 1];
            Class<?> type = null;
            if (map != null && map.containsKey(MonetDBtype)) {
                type = map.get(MonetDBtype);
            }
            return this.getObjectFromClass(columnIndex, type);
        }
        catch (IndexOutOfBoundsException e) {
            throw MonetResultSet.newSQLInvalidColumnIndexException(columnIndex);
        }
    }

    @Override
    public <T> T getObject(int columnIndex, Class<T> type) throws SQLException {
        this.checkNotClosed();
        if (type == null) {
            throw new SQLException("type is null", "M1M05");
        }
        try {
            return (T)this.getObjectFromClass(columnIndex, type);
        }
        catch (IndexOutOfBoundsException e) {
            throw MonetResultSet.newSQLInvalidColumnIndexException(columnIndex);
        }
    }

    @Override
    public <T> T getObject(String columnLabel, Class<T> type) throws SQLException {
        return this.getObject(this.findColumn(columnLabel), type);
    }

    static Class<?> getClassForType(int type) {
        switch (type) {
            case -1: 
            case 1: 
            case 12: {
                return String.class;
            }
            case 2: 
            case 3: {
                return BigDecimal.class;
            }
            case 16: {
                return Boolean.class;
            }
            case -6: {
                return Byte.class;
            }
            case 5: {
                return Short.class;
            }
            case 4: {
                return Integer.class;
            }
            case -5: {
                return Long.class;
            }
            case 7: {
                return Float.class;
            }
            case 8: {
                return Double.class;
            }
            case -4: {
                return byte[].class;
            }
            case 91: {
                return Date.class;
            }
            case 92: 
            case 2013: {
                return Time.class;
            }
            case 93: 
            case 2014: {
                return Timestamp.class;
            }
            case 2005: {
                return Clob.class;
            }
            case 2004: {
                return Blob.class;
            }
        }
        return String.class;
    }

    @Override
    public Object getObject(String columnLabel) throws SQLException {
        return this.getObject(this.findColumn(columnLabel));
    }

    @Override
    public Object getObject(String columnLabel, Map<String, Class<?>> map) throws SQLException {
        return this.getObject(this.findColumn(columnLabel), map);
    }

    @Override
    public Ref getRef(int columnIndex) throws SQLException {
        throw MonetResultSet.newSQLFeatureNotSupportedException("getRef");
    }

    @Override
    public Ref getRef(String columnLabel) throws SQLException {
        throw MonetResultSet.newSQLFeatureNotSupportedException("getRef");
    }

    @Override
    public int getRow() {
        return this.curRow;
    }

    @Override
    public RowId getRowId(int columnIndex) throws SQLException {
        throw MonetResultSet.newSQLFeatureNotSupportedException("getRowId");
    }

    @Override
    public RowId getRowId(String columnLabel) throws SQLException {
        throw MonetResultSet.newSQLFeatureNotSupportedException("getRowId");
    }

    @Override
    public short getShort(int columnIndex) throws SQLException {
        this.checkNotClosed();
        try {
            switch (this.JdbcSQLTypes[columnIndex - 1]) {
                case 5: {
                    short res = this.currentBlock.getShortValue(columnIndex - 1);
                    return this.currentBlock.isLastReadWasNull() ? (short)0 : res;
                }
                case 16: {
                    boolean bol = this.currentBlock.getBooleanValue(columnIndex - 1);
                    return this.currentBlock.isLastReadWasNull() ? (short)0 : (bol ? (short)1 : 0);
                }
                case -6: {
                    byte bb = this.currentBlock.getByteValue(columnIndex - 1);
                    return this.currentBlock.isLastReadWasNull() ? (short)0 : (short)bb;
                }
                case 4: {
                    int in = this.currentBlock.getIntValue(columnIndex - 1);
                    return this.currentBlock.isLastReadWasNull() ? (short)0 : (short)in;
                }
                case -5: {
                    long lon = this.currentBlock.getLongValue(columnIndex - 1);
                    return this.currentBlock.isLastReadWasNull() ? (short)0 : (short)lon;
                }
                case 7: {
                    float floa = this.currentBlock.getFloatValue(columnIndex - 1);
                    return this.currentBlock.isLastReadWasNull() ? (short)0 : (short)Math.round(floa);
                }
                case 8: {
                    double dou = this.currentBlock.getDoubleValue(columnIndex - 1);
                    return this.currentBlock.isLastReadWasNull() ? (short)0 : (short)Math.round(dou);
                }
                case -4: 
                case -1: 
                case 1: 
                case 12: 
                case 2004: 
                case 2005: {
                    String ss = this.currentBlock.getValueAsString(columnIndex - 1);
                    return ss == null ? (short)0 : Short.parseShort(ss);
                }
                case 2: 
                case 3: {
                    BigDecimal bigdec = (BigDecimal)this.currentBlock.getValueAsObject(columnIndex - 1);
                    return bigdec == null ? (short)0 : bigdec.shortValue();
                }
            }
            throw new SQLException("Conversion from " + this.types[columnIndex - 1] + " to short type not supported", "M1M05");
        }
        catch (ClassCastException ex) {
            throw new SQLException(ex.getMessage());
        }
        catch (ProtocolException e) {
            throw new SQLException(e);
        }
        catch (IndexOutOfBoundsException e) {
            throw MonetResultSet.newSQLInvalidColumnIndexException(columnIndex);
        }
    }

    @Override
    public short getShort(String columnLabel) throws SQLException {
        return this.getShort(this.findColumn(columnLabel));
    }

    @Override
    public Statement getStatement() {
        return this.statement;
    }

    @Override
    public String getString(int columnIndex) throws SQLException {
        this.checkNotClosed();
        try {
            return this.currentBlock.getValueAsString(columnIndex - 1);
        }
        catch (ClassCastException ex) {
            throw new SQLException(ex.getMessage());
        }
        catch (ProtocolException e) {
            throw new SQLException(e);
        }
        catch (IndexOutOfBoundsException e) {
            throw MonetResultSet.newSQLInvalidColumnIndexException(columnIndex);
        }
    }

    @Override
    public String getString(String columnLabel) throws SQLException {
        return this.getString(this.findColumn(columnLabel));
    }

    @Override
    public String getNString(int columnIndex) throws SQLException {
        return this.getString(columnIndex);
    }

    @Override
    public String getNString(String columnLabel) throws SQLException {
        return this.getString(this.findColumn(columnLabel));
    }

    @Override
    public SQLXML getSQLXML(int columnIndex) throws SQLException {
        throw MonetResultSet.newSQLFeatureNotSupportedException("getSQLXML");
    }

    @Override
    public SQLXML getSQLXML(String columnLabel) throws SQLException {
        throw MonetResultSet.newSQLFeatureNotSupportedException("getSQLXML");
    }

    @Override
    public Date getDate(int columnIndex) throws SQLException {
        return this.getDate(columnIndex, Calendar.getInstance());
    }

    @Override
    public Date getDate(int columnIndex, Calendar cal) throws SQLException {
        this.checkNotClosed();
        try {
            long millis;
            switch (this.JdbcSQLTypes[columnIndex - 1]) {
                case 91: 
                case 92: 
                case 93: {
                    Calendar res = (Calendar)this.currentBlock.getValueAsObject(columnIndex - 1);
                    if (res == null) {
                        return null;
                    }
                    millis = res.getTimeInMillis() - (long)res.getTimeZone().getRawOffset();
                    if (cal == null) break;
                    millis += (long)cal.getTimeZone().getRawOffset();
                    break;
                }
                case 2013: 
                case 2014: {
                    Calendar res = (Calendar)this.currentBlock.getValueAsObject(columnIndex - 1);
                    if (res == null) {
                        return null;
                    }
                    millis = res.getTimeInMillis();
                    break;
                }
                case -4: 
                case -1: 
                case 1: 
                case 12: 
                case 2004: 
                case 2005: {
                    Calendar res = this.currentBlock.getDateValueFromString(this, columnIndex - 1, 91);
                    if (res == null) {
                        return null;
                    }
                    millis = res.getTimeInMillis() - (long)res.getTimeZone().getRawOffset();
                    if (cal == null) break;
                    millis += (long)cal.getTimeZone().getRawOffset();
                    break;
                }
                default: {
                    this.addWarning("unsupported data type", "01M03");
                    if (cal != null) {
                        cal.clear();
                    }
                    millis = 0L;
                }
            }
            return new Date(millis);
        }
        catch (ClassCastException ex) {
            throw new SQLException(ex.getMessage());
        }
        catch (ProtocolException e) {
            throw new SQLException(e);
        }
        catch (IndexOutOfBoundsException e) {
            throw MonetResultSet.newSQLInvalidColumnIndexException(columnIndex);
        }
    }

    @Override
    public Date getDate(String columnLabel) throws SQLException {
        return this.getDate(this.findColumn(columnLabel), Calendar.getInstance());
    }

    @Override
    public Date getDate(String columnLabel, Calendar cal) throws SQLException {
        return this.getDate(this.findColumn(columnLabel), cal);
    }

    @Override
    public Time getTime(int columnIndex) throws SQLException {
        return this.getTime(columnIndex, Calendar.getInstance());
    }

    @Override
    public Time getTime(int columnIndex, Calendar cal) throws SQLException {
        this.checkNotClosed();
        try {
            long millis;
            switch (this.JdbcSQLTypes[columnIndex - 1]) {
                case 91: 
                case 92: 
                case 93: {
                    Calendar res = (Calendar)this.currentBlock.getValueAsObject(columnIndex - 1);
                    if (res == null) {
                        return null;
                    }
                    millis = res.getTimeInMillis() - (long)res.getTimeZone().getRawOffset();
                    if (cal == null) break;
                    millis += (long)cal.getTimeZone().getRawOffset();
                    break;
                }
                case 2013: 
                case 2014: {
                    Calendar res = (Calendar)this.currentBlock.getValueAsObject(columnIndex - 1);
                    if (res == null) {
                        return null;
                    }
                    millis = res.getTimeInMillis();
                    break;
                }
                case -4: 
                case -1: 
                case 1: 
                case 12: 
                case 2004: 
                case 2005: {
                    Calendar res = this.currentBlock.getDateValueFromString(this, columnIndex - 1, 92);
                    if (res == null) {
                        return null;
                    }
                    millis = res.getTimeInMillis() - (long)res.getTimeZone().getRawOffset();
                    if (cal == null) break;
                    millis += (long)cal.getTimeZone().getRawOffset();
                    break;
                }
                default: {
                    this.addWarning("unsupported data type", "01M03");
                    if (cal != null) {
                        cal.clear();
                    }
                    millis = 0L;
                }
            }
            return new Time(millis);
        }
        catch (ClassCastException ex) {
            throw new SQLException(ex.getMessage());
        }
        catch (ProtocolException e) {
            throw new SQLException(e);
        }
        catch (IndexOutOfBoundsException e) {
            throw MonetResultSet.newSQLInvalidColumnIndexException(columnIndex);
        }
    }

    @Override
    public Time getTime(String columnLabel) throws SQLException {
        return this.getTime(this.findColumn(columnLabel), Calendar.getInstance());
    }

    @Override
    public Time getTime(String columnLabel, Calendar cal) throws SQLException {
        return this.getTime(this.findColumn(columnLabel), cal);
    }

    @Override
    public Timestamp getTimestamp(int columnIndex) throws SQLException {
        return this.getTimestamp(columnIndex, Calendar.getInstance());
    }

    @Override
    public Timestamp getTimestamp(int columnIndex, Calendar cal) throws SQLException {
        this.checkNotClosed();
        try {
            long millis;
            int nanos = 0;
            switch (this.JdbcSQLTypes[columnIndex - 1]) {
                case 91: 
                case 92: {
                    Calendar res = (Calendar)this.currentBlock.getValueAsObject(columnIndex - 1);
                    if (res == null) {
                        return null;
                    }
                    millis = res.getTimeInMillis() - (long)res.getTimeZone().getRawOffset();
                    if (cal == null) break;
                    millis += (long)cal.getTimeZone().getRawOffset();
                    break;
                }
                case 2013: {
                    Calendar res = (Calendar)this.currentBlock.getValueAsObject(columnIndex - 1);
                    if (res == null) {
                        return null;
                    }
                    millis = res.getTimeInMillis();
                    break;
                }
                case 93: {
                    Calendar res = (Calendar)this.currentBlock.getValueAsObject(columnIndex - 1);
                    if (res == null) {
                        return null;
                    }
                    nanos = this.currentBlock.getLastNanos();
                    millis = res.getTimeInMillis() - (long)res.getTimeZone().getRawOffset();
                    if (cal == null) break;
                    millis += (long)cal.getTimeZone().getRawOffset();
                    break;
                }
                case 2014: {
                    Calendar res = (Calendar)this.currentBlock.getValueAsObject(columnIndex - 1);
                    if (res == null) {
                        return null;
                    }
                    nanos = this.currentBlock.getLastNanos();
                    millis = res.getTimeInMillis();
                    break;
                }
                case -4: 
                case -1: 
                case 1: 
                case 12: 
                case 2004: 
                case 2005: {
                    Calendar res = this.currentBlock.getDateValueFromString(this, columnIndex - 1, 93);
                    if (res == null) {
                        return null;
                    }
                    millis = res.getTimeInMillis() - (long)res.getTimeZone().getRawOffset();
                    if (cal == null) break;
                    millis += (long)cal.getTimeZone().getRawOffset();
                    break;
                }
                default: {
                    this.addWarning("unsupported data type", "01M03");
                    if (cal != null) {
                        cal.clear();
                    }
                    millis = 0L;
                }
            }
            Timestamp result = new Timestamp(millis);
            result.setNanos(nanos);
            return result;
        }
        catch (ClassCastException ex) {
            throw new SQLException(ex.getMessage());
        }
        catch (ProtocolException e) {
            throw new SQLException(e);
        }
        catch (IndexOutOfBoundsException e) {
            throw MonetResultSet.newSQLInvalidColumnIndexException(columnIndex);
        }
    }

    @Override
    public Timestamp getTimestamp(String columnLabel) throws SQLException {
        return this.getTimestamp(this.findColumn(columnLabel), Calendar.getInstance());
    }

    @Override
    public Timestamp getTimestamp(String columnLabel, Calendar cal) throws SQLException {
        return this.getTimestamp(this.findColumn(columnLabel), cal);
    }

    @Override
    public int getType() {
        return this.type;
    }

    @Override
    public URL getURL(int columnIndex) throws SQLException {
        this.checkNotClosed();
        try {
            switch (this.JdbcSQLTypes[columnIndex - 1]) {
                case 1111: {
                    if (!"url".equals(this.types[columnIndex - 1])) break;
                    String ss = this.currentBlock.getValueAsString(columnIndex - 1);
                    return ss == null ? null : new URL(ss);
                }
                case -4: 
                case -1: 
                case 1: 
                case 12: 
                case 2004: 
                case 2005: {
                    String sss = this.currentBlock.getValueAsString(columnIndex - 1);
                    return sss == null ? null : new URL(sss);
                }
            }
            throw new SQLException("Cannot convert " + this.types[columnIndex - 1] + " to an url", "M1M05");
        }
        catch (IndexOutOfBoundsException e) {
            throw MonetResultSet.newSQLInvalidColumnIndexException(columnIndex);
        }
        catch (ProtocolException e) {
            throw new SQLException(e);
        }
        catch (MalformedURLException e) {
            throw new SQLException(e.getMessage(), "M1M05");
        }
    }

    @Override
    public URL getURL(String columnLabel) throws SQLException {
        return this.getURL(this.findColumn(columnLabel));
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        this.checkNotClosed();
        return this.warnings;
    }

    @Override
    public boolean isAfterLast() throws SQLException {
        this.checkNotClosed();
        return this.curRow == this.tupleCount + 1;
    }

    @Override
    public boolean isBeforeFirst() throws SQLException {
        this.checkNotClosed();
        return this.curRow == 0;
    }

    @Override
    public boolean isClosed() throws SQLException {
        return this.header != null && this.header.isClosed();
    }

    @Override
    public boolean isFirst() throws SQLException {
        this.checkNotClosed();
        return this.curRow == 1;
    }

    @Override
    public boolean isLast() throws SQLException {
        this.checkNotClosed();
        return this.curRow == this.tupleCount;
    }

    @Override
    public boolean last() throws SQLException {
        return this.absolute(-1);
    }

    @Override
    public boolean next() throws SQLException {
        return this.relative(1);
    }

    @Override
    public boolean previous() throws SQLException {
        return this.relative(-1);
    }

    @Override
    public boolean relative(int rows) throws SQLException {
        return this.absolute(this.curRow + rows);
    }

    @Override
    public boolean rowDeleted() throws SQLException {
        this.checkNotClosed();
        return false;
    }

    @Override
    public boolean rowInserted() throws SQLException {
        this.checkNotClosed();
        return false;
    }

    @Override
    public boolean rowUpdated() throws SQLException {
        this.checkNotClosed();
        return false;
    }

    @Override
    public void cancelRowUpdates() throws SQLException {
        throw MonetResultSet.newSQLFeatureNotSupportedException("cancelRowUpdates");
    }

    @Override
    public void deleteRow() throws SQLException {
        throw MonetResultSet.newSQLFeatureNotSupportedException("deleteRow");
    }

    @Override
    public void insertRow() throws SQLException {
        throw MonetResultSet.newSQLFeatureNotSupportedException("insertRow");
    }

    @Override
    public void moveToCurrentRow() throws SQLException {
        throw MonetResultSet.newSQLFeatureNotSupportedException("moveToCurrentRow");
    }

    @Override
    public void moveToInsertRow() throws SQLException {
        throw MonetResultSet.newSQLFeatureNotSupportedException("moveToInsertRow");
    }

    @Override
    public void refreshRow() throws SQLException {
        throw MonetResultSet.newSQLFeatureNotSupportedException("refreshRow");
    }

    @Override
    public void updateArray(int columnIndex, Array x) throws SQLException {
        throw MonetResultSet.newSQLFeatureNotSupportedException("updateArray");
    }

    @Override
    public void updateArray(String columnLabel, Array x) throws SQLException {
        throw MonetResultSet.newSQLFeatureNotSupportedException("updateArray");
    }

    @Override
    public void updateAsciiStream(int columnIndex, InputStream x) throws SQLException {
        throw MonetResultSet.newSQLFeatureNotSupportedException("updateAsciiStream");
    }

    @Override
    public void updateAsciiStream(int columnIndex, InputStream x, int length) throws SQLException {
        throw MonetResultSet.newSQLFeatureNotSupportedException("updateAsciiStream");
    }

    @Override
    public void updateAsciiStream(int columnIndex, InputStream x, long length) throws SQLException {
        throw MonetResultSet.newSQLFeatureNotSupportedException("updateAsciiStream");
    }

    @Override
    public void updateAsciiStream(String columnLabel, InputStream x) throws SQLException {
        throw MonetResultSet.newSQLFeatureNotSupportedException("updateAsciiStream");
    }

    @Override
    public void updateAsciiStream(String columnLabel, InputStream x, int length) throws SQLException {
        throw MonetResultSet.newSQLFeatureNotSupportedException("updateAsciiStream");
    }

    @Override
    public void updateAsciiStream(String columnLabel, InputStream x, long length) throws SQLException {
        throw MonetResultSet.newSQLFeatureNotSupportedException("updateAsciiStream");
    }

    @Override
    public void updateBigDecimal(int columnIndex, BigDecimal x) throws SQLException {
        throw MonetResultSet.newSQLFeatureNotSupportedException("updateBigDecimal");
    }

    @Override
    public void updateBigDecimal(String columnLabel, BigDecimal x) throws SQLException {
        throw MonetResultSet.newSQLFeatureNotSupportedException("updateBigDecimal");
    }

    @Override
    public void updateBinaryStream(int columnIndex, InputStream x) throws SQLException {
        throw MonetResultSet.newSQLFeatureNotSupportedException("updateBinaryStream");
    }

    @Override
    public void updateBinaryStream(int columnIndex, InputStream x, int length) throws SQLException {
        throw MonetResultSet.newSQLFeatureNotSupportedException("updateBinaryStream");
    }

    @Override
    public void updateBinaryStream(int columnIndex, InputStream x, long length) throws SQLException {
        throw MonetResultSet.newSQLFeatureNotSupportedException("updateBinaryStream");
    }

    @Override
    public void updateBinaryStream(String columnLabel, InputStream x) throws SQLException {
        throw MonetResultSet.newSQLFeatureNotSupportedException("updateBinaryStream");
    }

    @Override
    public void updateBinaryStream(String columnLabel, InputStream x, int length) throws SQLException {
        throw MonetResultSet.newSQLFeatureNotSupportedException("updateBinaryStream");
    }

    @Override
    public void updateBinaryStream(String columnLabel, InputStream x, long length) throws SQLException {
        throw MonetResultSet.newSQLFeatureNotSupportedException("updateBinaryStream");
    }

    @Override
    public void updateBlob(int columnIndex, Blob x) throws SQLException {
        throw MonetResultSet.newSQLFeatureNotSupportedException("updateBlob");
    }

    @Override
    public void updateBlob(int columnIndex, InputStream s) throws SQLException {
        throw MonetResultSet.newSQLFeatureNotSupportedException("updateBlob");
    }

    @Override
    public void updateBlob(int columnIndex, InputStream s, long length) throws SQLException {
        throw MonetResultSet.newSQLFeatureNotSupportedException("updateBlob");
    }

    @Override
    public void updateBlob(String columnLabel, Blob x) throws SQLException {
        throw MonetResultSet.newSQLFeatureNotSupportedException("updateBlob");
    }

    @Override
    public void updateBlob(String columnLabel, InputStream s) throws SQLException {
        throw MonetResultSet.newSQLFeatureNotSupportedException("updateBlob");
    }

    @Override
    public void updateBlob(String columnLabel, InputStream s, long length) throws SQLException {
        throw MonetResultSet.newSQLFeatureNotSupportedException("updateBlob");
    }

    @Override
    public void updateBoolean(int columnIndex, boolean x) throws SQLException {
        throw MonetResultSet.newSQLFeatureNotSupportedException("updateBoolean");
    }

    @Override
    public void updateBoolean(String columnLabel, boolean x) throws SQLException {
        throw MonetResultSet.newSQLFeatureNotSupportedException("updateBoolean");
    }

    @Override
    public void updateByte(int columnIndex, byte x) throws SQLException {
        throw MonetResultSet.newSQLFeatureNotSupportedException("updateByte");
    }

    @Override
    public void updateByte(String columnLabel, byte x) throws SQLException {
        throw MonetResultSet.newSQLFeatureNotSupportedException("updateByte");
    }

    @Override
    public void updateBytes(int columnIndex, byte[] x) throws SQLException {
        throw MonetResultSet.newSQLFeatureNotSupportedException("updateBytes");
    }

    @Override
    public void updateBytes(String columnLabel, byte[] x) throws SQLException {
        throw MonetResultSet.newSQLFeatureNotSupportedException("updateBytes");
    }

    @Override
    public void updateCharacterStream(int columnIndex, Reader x) throws SQLException {
        throw MonetResultSet.newSQLFeatureNotSupportedException("updateCharacterStream");
    }

    @Override
    public void updateCharacterStream(int columnIndex, Reader x, int length) throws SQLException {
        throw MonetResultSet.newSQLFeatureNotSupportedException("updateCharacterStream");
    }

    @Override
    public void updateCharacterStream(int columnIndex, Reader x, long length) throws SQLException {
        throw MonetResultSet.newSQLFeatureNotSupportedException("updateCharacterStream");
    }

    @Override
    public void updateCharacterStream(String columnLabel, Reader reader) throws SQLException {
        throw MonetResultSet.newSQLFeatureNotSupportedException("updateCharacterStream");
    }

    @Override
    public void updateCharacterStream(String columnLabel, Reader reader, int length) throws SQLException {
        throw MonetResultSet.newSQLFeatureNotSupportedException("updateCharacterStream");
    }

    @Override
    public void updateCharacterStream(String columnLabel, Reader reader, long length) throws SQLException {
        throw MonetResultSet.newSQLFeatureNotSupportedException("updateCharacterStream");
    }

    @Override
    public void updateNCharacterStream(int columnIndex, Reader x) throws SQLException {
        throw MonetResultSet.newSQLFeatureNotSupportedException("updateNCharacterStream");
    }

    @Override
    public void updateNCharacterStream(int columnIndex, Reader x, long length) throws SQLException {
        throw MonetResultSet.newSQLFeatureNotSupportedException("updateNCharacterStream");
    }

    @Override
    public void updateNCharacterStream(String columnLabel, Reader reader) throws SQLException {
        throw MonetResultSet.newSQLFeatureNotSupportedException("updateNCharacterStream");
    }

    @Override
    public void updateNCharacterStream(String columnLabel, Reader reader, long length) throws SQLException {
        throw MonetResultSet.newSQLFeatureNotSupportedException("updateNCharacterStream");
    }

    @Override
    public void updateClob(int columnIndex, Clob x) throws SQLException {
        throw MonetResultSet.newSQLFeatureNotSupportedException("updateClob");
    }

    @Override
    public void updateClob(int columnIndex, Reader r) throws SQLException {
        throw MonetResultSet.newSQLFeatureNotSupportedException("updateClob");
    }

    @Override
    public void updateClob(int columnIndex, Reader r, long length) throws SQLException {
        throw MonetResultSet.newSQLFeatureNotSupportedException("updateClob");
    }

    @Override
    public void updateClob(String columnLabel, Clob x) throws SQLException {
        throw MonetResultSet.newSQLFeatureNotSupportedException("updateClob");
    }

    @Override
    public void updateClob(String columnLabel, Reader r) throws SQLException {
        throw MonetResultSet.newSQLFeatureNotSupportedException("updateClob");
    }

    @Override
    public void updateClob(String columnLabel, Reader r, long length) throws SQLException {
        throw MonetResultSet.newSQLFeatureNotSupportedException("updateClob");
    }

    @Override
    public void updateNClob(int columnIndex, NClob x) throws SQLException {
        throw MonetResultSet.newSQLFeatureNotSupportedException("updateNClob");
    }

    @Override
    public void updateNClob(int columnIndex, Reader r) throws SQLException {
        throw MonetResultSet.newSQLFeatureNotSupportedException("updateNClob");
    }

    @Override
    public void updateNClob(int columnIndex, Reader r, long length) throws SQLException {
        throw MonetResultSet.newSQLFeatureNotSupportedException("updateNClob");
    }

    @Override
    public void updateNClob(String columnLabel, NClob x) throws SQLException {
        throw MonetResultSet.newSQLFeatureNotSupportedException("updateNClob");
    }

    @Override
    public void updateNClob(String columnLabel, Reader r) throws SQLException {
        throw MonetResultSet.newSQLFeatureNotSupportedException("updateNClob");
    }

    @Override
    public void updateNClob(String columnLabel, Reader r, long length) throws SQLException {
        throw MonetResultSet.newSQLFeatureNotSupportedException("updateNClob");
    }

    @Override
    public void updateDate(int columnIndex, Date x) throws SQLException {
        throw MonetResultSet.newSQLFeatureNotSupportedException("updateDate");
    }

    @Override
    public void updateDate(String columnLabel, Date x) throws SQLException {
        throw MonetResultSet.newSQLFeatureNotSupportedException("updateDate");
    }

    @Override
    public void updateDouble(int columnIndex, double x) throws SQLException {
        throw MonetResultSet.newSQLFeatureNotSupportedException("updateDouble");
    }

    @Override
    public void updateDouble(String columnLabel, double x) throws SQLException {
        throw MonetResultSet.newSQLFeatureNotSupportedException("updateDouble");
    }

    @Override
    public void updateFloat(int columnIndex, float x) throws SQLException {
        throw MonetResultSet.newSQLFeatureNotSupportedException("updateFloat");
    }

    @Override
    public void updateFloat(String columnLabel, float x) throws SQLException {
        throw MonetResultSet.newSQLFeatureNotSupportedException("updateFloat");
    }

    @Override
    public void updateInt(int columnIndex, int x) throws SQLException {
        throw MonetResultSet.newSQLFeatureNotSupportedException("updateInt");
    }

    @Override
    public void updateInt(String columnLabel, int x) throws SQLException {
        throw MonetResultSet.newSQLFeatureNotSupportedException("updateInt");
    }

    @Override
    public void updateLong(int columnIndex, long x) throws SQLException {
        throw MonetResultSet.newSQLFeatureNotSupportedException("updateLong");
    }

    @Override
    public void updateLong(String columnLabel, long x) throws SQLException {
        throw MonetResultSet.newSQLFeatureNotSupportedException("updateLong");
    }

    @Override
    public void updateNull(int columnIndex) throws SQLException {
        throw MonetResultSet.newSQLFeatureNotSupportedException("updateNull");
    }

    @Override
    public void updateNull(String columnLabel) throws SQLException {
        throw MonetResultSet.newSQLFeatureNotSupportedException("updateNull");
    }

    @Override
    public void updateObject(int columnIndex, Object x) throws SQLException {
        throw MonetResultSet.newSQLFeatureNotSupportedException("updateObject");
    }

    @Override
    public void updateObject(int columnIndex, Object x, int scale) throws SQLException {
        throw MonetResultSet.newSQLFeatureNotSupportedException("updateObject");
    }

    @Override
    public void updateObject(String columnLabel, Object x) throws SQLException {
        throw MonetResultSet.newSQLFeatureNotSupportedException("updateObject");
    }

    @Override
    public void updateObject(String columnLabel, Object x, int scale) throws SQLException {
        throw MonetResultSet.newSQLFeatureNotSupportedException("updateObject");
    }

    @Override
    public void updateRef(int columnIndex, Ref x) throws SQLException {
        throw MonetResultSet.newSQLFeatureNotSupportedException("updateRef");
    }

    @Override
    public void updateRef(String columnLabel, Ref x) throws SQLException {
        throw MonetResultSet.newSQLFeatureNotSupportedException("updateRef");
    }

    @Override
    public void updateRow() throws SQLException {
        throw MonetResultSet.newSQLFeatureNotSupportedException("updateRow");
    }

    @Override
    public void updateRowId(int columnIndex, RowId x) throws SQLException {
        throw MonetResultSet.newSQLFeatureNotSupportedException("updateRowId");
    }

    @Override
    public void updateRowId(String columnLabel, RowId x) throws SQLException {
        throw MonetResultSet.newSQLFeatureNotSupportedException("updateRowId");
    }

    @Override
    public void updateShort(int columnIndex, short x) throws SQLException {
        throw MonetResultSet.newSQLFeatureNotSupportedException("updateShort");
    }

    @Override
    public void updateShort(String columnLabel, short x) throws SQLException {
        throw MonetResultSet.newSQLFeatureNotSupportedException("updateShort");
    }

    @Override
    public void updateString(int columnIndex, String x) throws SQLException {
        throw MonetResultSet.newSQLFeatureNotSupportedException("updateString");
    }

    @Override
    public void updateString(String columnLabel, String x) throws SQLException {
        throw MonetResultSet.newSQLFeatureNotSupportedException("updateString");
    }

    @Override
    public void updateNString(int columnIndex, String x) throws SQLException {
        throw MonetResultSet.newSQLFeatureNotSupportedException("updateNString");
    }

    @Override
    public void updateNString(String columnLabel, String x) throws SQLException {
        throw MonetResultSet.newSQLFeatureNotSupportedException("updateNString");
    }

    @Override
    public void updateSQLXML(int columnIndex, SQLXML x) throws SQLException {
        throw MonetResultSet.newSQLFeatureNotSupportedException("updateSQLXML");
    }

    @Override
    public void updateSQLXML(String columnLabel, SQLXML x) throws SQLException {
        throw MonetResultSet.newSQLFeatureNotSupportedException("updateSQLXML");
    }

    @Override
    public void updateTime(int columnIndex, Time x) throws SQLException {
        throw MonetResultSet.newSQLFeatureNotSupportedException("updateTime");
    }

    @Override
    public void updateTime(String columnLabel, Time x) throws SQLException {
        throw MonetResultSet.newSQLFeatureNotSupportedException("updateTime");
    }

    @Override
    public void updateTimestamp(int columnIndex, Timestamp x) throws SQLException {
        throw MonetResultSet.newSQLFeatureNotSupportedException("updateTimestamp");
    }

    @Override
    public void updateTimestamp(String columnLabel, Timestamp x) throws SQLException {
        throw MonetResultSet.newSQLFeatureNotSupportedException("updateTimestamp");
    }

    @Override
    public boolean wasNull() {
        return this.currentBlock.isLastReadWasNull();
    }

    public void addWarning(String reason, String sqlstate) {
        SQLWarning warng = new SQLWarning(reason, sqlstate);
        if (this.warnings == null) {
            this.warnings = warng;
        } else {
            this.warnings.setNextWarning(warng);
        }
    }

    private void checkNotClosed() throws SQLException {
        if (this.isClosed()) {
            throw new SQLException("ResultSet is closed", "M1M20");
        }
    }

    public static final SQLDataException newSQLInvalidColumnIndexException(int colIdx) {
        return new SQLDataException("Invalid Column Index number: " + colIdx, "22010");
    }

    private static final SQLDataException newSQLNumberFormatException(NumberFormatException error) {
        return new SQLDataException("Could not convert value to a number. " + error.getMessage(), "22003");
    }

    private abstract class rsmdw
    extends MonetWrapper
    implements ResultSetMetaData {
        private rsmdw() {
        }
    }
}

