/*
 * Decompiled with CFR 0.152.
 */
package nl.cwi.monetdb.jdbc;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.net.SocketException;
import java.net.URI;
import java.net.URISyntaxException;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.DriverPropertyInfo;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.sql.SQLNonTransientConnectionException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Logger;
import nl.cwi.monetdb.jdbc.MonetConnection;
import nl.cwi.monetdb.mcl.connection.MCLException;
import nl.cwi.monetdb.mcl.connection.mapi.MapiConnection;
import nl.cwi.monetdb.mcl.connection.mapi.MapiLanguage;
import nl.cwi.monetdb.mcl.protocol.ProtocolException;

public final class MonetDriver
implements Driver {
    private static final String MONETURL = "jdbc:monetdb:";
    private static final int DRIVERMAJOR = 2;
    private static final int DRIVERMINOR = 35;
    private static final String DRIVERVERSIONSUFFIX = "Liberica  based on MCL v1.14";
    private static final boolean MONETJDBCCOMPLIANT = false;
    private static final String PORT = "50000";
    private static Class embeddedConnectionClass = null;
    private static Map<String, Integer> typeMap;
    private static String TypeMapppingSQL;

    @Override
    public boolean acceptsURL(String url) {
        return url != null && url.startsWith(MONETURL);
    }

    @Override
    public int getMajorVersion() {
        return 2;
    }

    @Override
    public int getMinorVersion() {
        return 35;
    }

    @Override
    public DriverPropertyInfo[] getPropertyInfo(String url, Properties info) {
        if (!this.acceptsURL(url)) {
            return null;
        }
        ArrayList<DriverPropertyInfo> props = new ArrayList<DriverPropertyInfo>();
        DriverPropertyInfo prop = new DriverPropertyInfo("user", info.getProperty("user"));
        prop.required = true;
        prop.description = "The user name to use when authenticating on the database server";
        props.add(prop);
        prop = new DriverPropertyInfo("password", info.getProperty("password"));
        prop.required = true;
        prop.description = "The password to use when authenticating on the database server";
        props.add(prop);
        prop = new DriverPropertyInfo("hash", "");
        prop.required = false;
        prop.description = "Force the use of the given hash algorithm during challenge response (one of SHA1, MD5, plain) (MAPI connection only)";
        props.add(prop);
        prop = new DriverPropertyInfo("so_timeout", "0");
        prop.required = false;
        prop.description = "Defines the maximum time to wait in milliseconds on a blocking read socket call (MAPI connection only)";
        props.add(prop);
        prop = new DriverPropertyInfo("treat_blob_as_binary", "false");
        prop.required = false;
        prop.description = "Whether BLOBs on the server should be treated as BINARY types, thus mapped to byte[] (MAPI connection only)";
        props.add(prop);
        prop = new DriverPropertyInfo("treat_clob_as_varchar", "false");
        prop.required = false;
        prop.description = "Whether CLOBs on the server should be treated and handled as VARCHAR types in the JDBC driver (MAPI connection only)";
        props.add(prop);
        prop = new DriverPropertyInfo("treat_clob_as_longvarchar", "false");
        prop.required = false;
        prop.description = "Whether CLOBs on the server should be treated as LONGVARCHAR types, thus mapped to String (MAPI connection only)";
        props.add(prop);
        prop = new DriverPropertyInfo("language", "sql");
        prop.required = false;
        prop.description = "What language to use for MonetDB conversations (experts only)";
        props.add(prop);
        prop = new DriverPropertyInfo("silentFlag", "true");
        prop.required = false;
        prop.description = "Don't produce output from the server (i.e. debug) (Embedded connection only)";
        props.add(prop);
        prop = new DriverPropertyInfo("sequentialFlag", "false");
        prop.required = false;
        prop.description = "Use sequential pipeline instead of default pipeline (Embedded connection only)";
        props.add(prop);
        DriverPropertyInfo[] dpi = new DriverPropertyInfo[props.size()];
        return props.toArray(dpi);
    }

    @Override
    public boolean jdbcCompliant() {
        return false;
    }

    public static int getJavaType(String type) {
        Integer tp = typeMap.get(type);
        if (tp != null) {
            return tp;
        }
        return 1111;
    }

    static String getSQLTypeMap(String column) {
        if (TypeMapppingSQL == null) {
            StringBuilder val = new StringBuilder(typeMap.size() * 25 + 14);
            for (Map.Entry<String, Integer> entry : typeMap.entrySet()) {
                val.append(" WHEN '").append(entry.getKey()).append("' THEN ").append(entry.getValue().toString());
            }
            val.append(" ELSE ").append(1111).append(" END");
            TypeMapppingSQL = val.toString();
        }
        return "CASE " + column + TypeMapppingSQL;
    }

    public static String getDriverVersion() {
        return "2.35 (Liberica  based on MCL v1.14)";
    }

    public static int getDriverMajorVersion() {
        return 2;
    }

    public static int getDriverMinorVersion() {
        return 35;
    }

    @Override
    public Logger getParentLogger() throws SQLFeatureNotSupportedException {
        throw new SQLFeatureNotSupportedException("java.util.logging not in use", "0A000");
    }

    @Override
    public Connection connect(String url, Properties info) throws SQLException {
        boolean isEmbedded;
        Properties props = new Properties();
        if (!this.acceptsURL(url)) {
            throw new SQLException("Invalid URL: it does not start with: jdbc:monetdb:", "08M26");
        }
        if (!url.startsWith("jdbc:monetdb:embedded:")) {
            String uri_query;
            String uri_path;
            URI uri;
            props.put("port", PORT);
            props.put("debug", "false");
            props.put("language", "sql");
            props.put("so_timeout", "0");
            props.putAll((Map<?, ?>)info);
            info = props;
            isEmbedded = false;
            try {
                uri = new URI(url.substring(5));
            }
            catch (URISyntaxException e) {
                throw new SQLNonTransientConnectionException(e.toString(), "08M26");
            }
            String uri_host = uri.getHost();
            if (uri_host == null) {
                throw new SQLNonTransientConnectionException("Invalid URL: no hostname given or unparsable in '" + url + "'", "08M26");
            }
            info.put("host", uri_host);
            int uri_port = uri.getPort();
            if (uri_port > 0) {
                info.put("port", "" + uri_port);
            }
            if ((uri_path = uri.getPath()) != null && uri_path.length() != 0 && !(uri_path = uri_path.substring(1)).trim().isEmpty()) {
                info.put("database", uri_path);
            }
            if ((uri_query = uri.getQuery()) != null) {
                String[] args;
                for (String arg : args = uri_query.split("&")) {
                    int tmp = arg.indexOf(61);
                    if (tmp <= 0) continue;
                    info.put(arg.substring(0, tmp), arg.substring(tmp + 1));
                }
            }
        } else {
            props.putAll((Map<?, ?>)info);
            info = props;
            isEmbedded = true;
            info.put("directory", url.substring(22));
        }
        info.put("embedded", Boolean.toString(isEmbedded));
        return MonetDriver.CreateMonetDBJDBCConnection(info);
    }

    private static MonetConnection CreateMonetDBJDBCConnection(Properties props) throws SQLException, IllegalArgumentException {
        MonetConnection res;
        boolean isEmbedded = Boolean.parseBoolean(props.getProperty("embedded", "false"));
        String language = props.getProperty("language", "sql");
        String username = props.getProperty("user");
        String password = props.getProperty("password");
        String hash = props.getProperty("hash");
        int sockTimeout = 0;
        if (isEmbedded) {
            try {
                String directory = props.getProperty("directory");
                Boolean silentFlag = props.getProperty("silentFlag", "true").equals("true");
                Boolean sequentialFlag = props.getProperty("sequentialFlag", "false").equals("true");
                if (directory != null && (directory.trim().isEmpty() || directory.equals(":memory:"))) {
                    directory = null;
                }
                if (embeddedConnectionClass == null && (embeddedConnectionClass = Class.forName("nl.cwi.monetdb.embedded.jdbc.EmbeddedConnection")) == null) {
                    throw new SQLNonTransientConnectionException("EmbeddedConnection Class not found! Please add monetdb-java-lite jar to the CLASSPATH");
                }
                res = (MonetConnection)embeddedConnectionClass.getDeclaredConstructor(Properties.class, String.class, String.class, String.class, Boolean.class, Boolean.class).newInstance(props, hash, language, directory, silentFlag, sequentialFlag);
            }
            catch (ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
                throw new SQLNonTransientConnectionException(e);
            }
        }
        String hostname = props.getProperty("host");
        if (hostname == null || hostname.trim().isEmpty()) {
            throw new IllegalArgumentException("hostname should not be null or empty");
        }
        if (username == null || username.trim().isEmpty()) {
            throw new IllegalArgumentException("user should not be null or empty");
        }
        if (password == null || password.trim().isEmpty()) {
            throw new IllegalArgumentException("password should not be null or empty");
        }
        String database = props.getProperty("database");
        if (database == null || database.trim().isEmpty()) {
            throw new IllegalArgumentException("database should not be null or empty");
        }
        boolean blobIsBinary = Boolean.valueOf(props.getProperty("treat_blob_as_binary", "false"));
        boolean clobIsLongChar = Boolean.valueOf(props.getProperty("treat_clob_as_longvarchar", "false"));
        boolean negative1 = false;
        boolean failedparse1 = false;
        int port = 0;
        try {
            port = Integer.parseInt(props.getProperty("port", PORT));
        }
        catch (NumberFormatException e) {
            failedparse1 = true;
            props.setProperty("port", PORT);
        }
        if (port <= 0) {
            negative1 = true;
            port = Integer.parseInt(PORT);
            props.setProperty("port", PORT);
        }
        String timeout = props.getProperty("so_timeout", "0");
        boolean negative2 = false;
        boolean failedparse2 = false;
        try {
            sockTimeout = Integer.parseInt(timeout);
        }
        catch (NumberFormatException e) {
            sockTimeout = 0;
            failedparse2 = true;
            props.setProperty("so_timeout", "0");
        }
        if (sockTimeout < 0) {
            negative2 = true;
            sockTimeout = 0;
            props.setProperty("so_timeout", "0");
        }
        res = new MapiConnection(props, hash, language, blobIsBinary, clobIsLongChar, hostname, port, database);
        if (failedparse1) {
            res.addWarning("Unable to parse port number from: " + port, "M1M05");
        }
        if (negative1) {
            res.addWarning("Negative port not allowed. Value ignored", "M1M05");
        }
        if (failedparse2) {
            res.addWarning("Unable to parse socket timeout number from: " + timeout, "M1M05");
        }
        if (negative2) {
            res.addWarning("Negative socket timeout not allowed. Value ignored", "M1M05");
        }
        try {
            res.setSoTimeout(sockTimeout);
        }
        catch (SocketException ex) {
            res.addWarning("Failed to set socket timeout: " + ex.getMessage(), "M1M05");
        }
        try {
            List<String> warnings = res.connect(username, password);
            if (warnings != null) {
                for (String warning : warnings) {
                    res.addWarning(warning, "01M02");
                }
            }
            if (!isEmbedded) {
                res.setSoTimeout(sockTimeout);
            }
        }
        catch (IOException e) {
            if (!isEmbedded) {
                MapiConnection con = (MapiConnection)res;
                throw new SQLException("Unable to connect (" + con.getHostname() + ":" + con.getPort() + "): " + e.getMessage(), "08006");
            }
            throw new SQLNonTransientConnectionException("Unable to connect: " + e.getMessage(), "08006");
        }
        catch (ProtocolException e) {
            throw new SQLNonTransientConnectionException(e.getMessage(), "08001");
        }
        catch (MCLException e) {
            String[] connex = e.getMessage().split("\n");
            SQLNonTransientConnectionException sqle = new SQLNonTransientConnectionException(connex[0], "08001", e);
            for (int i = 1; i < connex.length; ++i) {
                sqle.setNextException(new SQLNonTransientConnectionException(connex[1], "08001"));
            }
            throw sqle;
        }
        if (!isEmbedded && res.getLanguage() == MapiLanguage.LANG_SQL) {
            res.setAutoCommit(true);
            Calendar cal = Calendar.getInstance();
            int offset = cal.get(15) + cal.get(16);
            String tz = (offset /= 60000) < 0 ? "-" : "+";
            tz = tz + (Math.abs(offset) / 60 < 10 ? "0" : "") + Math.abs(offset) / 60 + ":";
            offset -= offset / 60 * 60;
            tz = tz + (offset < 10 ? "0" : "") + offset;
            res.sendIndependentCommand("SET TIME ZONE INTERVAL '" + tz + "' HOUR TO MINUTE");
        }
        return res;
    }

    static {
        try {
            DriverManager.registerDriver(new MonetDriver());
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        typeMap = new HashMap<String, Integer>();
        typeMap.put("bigint", -5);
        typeMap.put("blob", 2004);
        typeMap.put("boolean", 16);
        typeMap.put("char", 1);
        typeMap.put("clob", 2005);
        typeMap.put("date", 91);
        typeMap.put("decimal", 3);
        typeMap.put("double", 8);
        typeMap.put("geometry", 1111);
        typeMap.put("geometrya", 1111);
        typeMap.put("hugeint", 2);
        typeMap.put("inet", 1111);
        typeMap.put("int", 4);
        typeMap.put("json", 1111);
        typeMap.put("month_interval", 4);
        typeMap.put("real", 7);
        typeMap.put("sec_interval", -5);
        typeMap.put("smallint", 5);
        typeMap.put("time", 92);
        typeMap.put("timestamp", 93);
        typeMap.put("timestamptz", 2014);
        typeMap.put("timetz", 2013);
        typeMap.put("tinyint", -6);
        typeMap.put("url", 1111);
        typeMap.put("uuid", 1111);
        typeMap.put("varchar", 12);
        typeMap.put("wrd", -5);
        TypeMapppingSQL = null;
    }
}

