/*
 * Decompiled with CFR 0.152.
 */
package nl.cwi.monetdb.mcl.connection.mapi;

import nl.cwi.monetdb.mcl.connection.IMonetDBLanguage;

public enum MapiLanguage implements IMonetDBLanguage
{
    LANG_SQL(new String[]{"s", "\n;", "\n;\n"}, new String[]{"X", null, "\nX"}, "sql"),
    LANG_MAL(new String[]{null, ";\n", ";\n"}, new String[]{null, null, null}, "mal"),
    LANG_UNKNOWN(null, null, "unknown");

    private final String[] queryTemplates;
    private final String[] commandTemplates;
    private final String representation;

    private MapiLanguage(String[] queryTemplates, String[] commandTemplates, String representation) {
        this.queryTemplates = queryTemplates;
        this.commandTemplates = commandTemplates;
        this.representation = representation;
    }

    @Override
    public String getQueryTemplateIndex(int index) {
        return this.queryTemplates[index];
    }

    @Override
    public String getCommandTemplateIndex(int index) {
        return this.commandTemplates[index];
    }

    @Override
    public String[] getQueryTemplates() {
        return this.queryTemplates;
    }

    @Override
    public String[] getCommandTemplates() {
        return this.commandTemplates;
    }

    @Override
    public String getRepresentation() {
        return this.representation;
    }

    public static MapiLanguage getLanguageFromString(String language) {
        switch (language) {
            case "sql": {
                return LANG_SQL;
            }
            case "mal": {
                return LANG_MAL;
            }
        }
        return LANG_UNKNOWN;
    }
}

