/*
 * Decompiled with CFR 0.152.
 */
package nl.cwi.monetdb.mcl.protocol.oldmapi;

import java.math.BigDecimal;
import java.nio.CharBuffer;
import java.util.Calendar;
import nl.cwi.monetdb.jdbc.MonetBlob;
import nl.cwi.monetdb.jdbc.MonetClob;
import nl.cwi.monetdb.mcl.connection.helpers.BufferReallocator;
import nl.cwi.monetdb.mcl.connection.helpers.GregorianCalendarParser;
import nl.cwi.monetdb.mcl.connection.helpers.TimestampHelper;
import nl.cwi.monetdb.mcl.protocol.ProtocolException;
import nl.cwi.monetdb.mcl.protocol.oldmapi.OldMapiProtocol;
import nl.cwi.monetdb.mcl.protocol.oldmapi.OldMapiTupleLineParserHelper;

final class OldMapiTupleLineParser {
    private static final char[] NULL_STRING = new char[]{'N', 'U', 'L', 'L'};

    private OldMapiTupleLineParser() {
    }

    static int oldMapiParseTupleLine(OldMapiProtocol protocol, int lineNumber, int[] typesMap, Object[] values) throws ProtocolException {
        CharBuffer lineBuffer = protocol.lineBuffer;
        CharBuffer tupleLineBuffer = protocol.tupleLineBuffer;
        int len = lineBuffer.limit();
        char[] array = lineBuffer.array();
        if (array[0] == '=') {
            if (typesMap.length != 1) {
                throw new ProtocolException(typesMap.length + " columns expected, but only single value found");
            }
            OldMapiTupleLineParser.oldMapiStringToJavaDataConversion(protocol, array, 1, len - 1, lineNumber, values[0], typesMap[0]);
            return 1;
        }
        boolean inString = false;
        boolean escaped = false;
        int cursor = 2;
        int column = 0;
        block20: for (int i = 2; i < len; ++i) {
            switch (array[i]) {
                default: {
                    escaped = false;
                    continue block20;
                }
                case '\\': {
                    escaped = !escaped;
                    continue block20;
                }
                case '\"': {
                    if (!inString) {
                        inString = true;
                    } else if (!escaped) {
                        inString = false;
                    }
                    escaped = false;
                    continue block20;
                }
                case '\t': {
                    if (!inString && i > 0 && array[i - 1] == ',' || i + 1 == len - 1 && array[++i] == ']') {
                        if (array[cursor] == '\"' && array[i - 2] == '\"') {
                            tupleLineBuffer.clear();
                            tupleLineBuffer = BufferReallocator.ensureCapacity(tupleLineBuffer, i - 2 - (cursor + 1));
                            for (int pos = cursor + 1; pos < i - 2; ++pos) {
                                if (array[cursor] == '\\' && pos + 1 < i - 2) {
                                    switch (array[++pos]) {
                                        case '\\': {
                                            tupleLineBuffer.put('\\');
                                            break;
                                        }
                                        case 'n': {
                                            tupleLineBuffer.put('\n');
                                            break;
                                        }
                                        case 't': {
                                            tupleLineBuffer.put('\t');
                                            break;
                                        }
                                        case '\"': {
                                            tupleLineBuffer.put('\"');
                                            break;
                                        }
                                        case '0': 
                                        case '1': 
                                        case '2': 
                                        case '3': {
                                            if (pos + 2 < i - 2 && array[pos + 1] >= '0' && array[pos + 1] <= '7' && array[pos + 2] >= '0' && array[pos + 2] <= '7') {
                                                try {
                                                    tupleLineBuffer.put((char)Integer.parseInt("" + array[pos] + array[pos + 1] + array[pos + 2], 8));
                                                    pos += 2;
                                                    break;
                                                }
                                                catch (NumberFormatException e) {
                                                    throw new AssertionError((Object)"Flow error, should never try to parse non-number");
                                                }
                                            }
                                            tupleLineBuffer.put(array[pos]);
                                            break;
                                        }
                                        default: {
                                            tupleLineBuffer.put(array[pos]);
                                            break;
                                        }
                                    }
                                    continue;
                                }
                                if (array[pos] == '\\') {
                                    switch (array[++pos]) {
                                        case '\\': {
                                            tupleLineBuffer.put('\\');
                                            break;
                                        }
                                        case 'n': {
                                            tupleLineBuffer.put('\n');
                                            break;
                                        }
                                        case 't': {
                                            tupleLineBuffer.put('\t');
                                            break;
                                        }
                                        case '\"': {
                                            tupleLineBuffer.put('\"');
                                        }
                                    }
                                    continue;
                                }
                                tupleLineBuffer.put(array[pos]);
                            }
                            tupleLineBuffer.flip();
                            OldMapiTupleLineParser.oldMapiStringToJavaDataConversion(protocol, tupleLineBuffer.array(), 0, tupleLineBuffer.limit(), lineNumber, values[column], typesMap[column]);
                        } else if (i - 1 - cursor == 4 && OldMapiTupleLineParserHelper.charIndexOf(array, 0, array.length, NULL_STRING, 0, 4, cursor) == cursor) {
                            OldMapiTupleLineParser.setNullValue(lineNumber, values[column], typesMap[column]);
                        } else {
                            OldMapiTupleLineParser.oldMapiStringToJavaDataConversion(protocol, array, cursor, i - 1 - cursor, lineNumber, values[column], typesMap[column]);
                        }
                        ++column;
                        cursor = i + 1;
                    }
                    escaped = false;
                }
            }
        }
        protocol.tupleLineBuffer = tupleLineBuffer;
        if (column != typesMap.length) {
            throw new ProtocolException("illegal result length: " + column + "\nlast read: " + (column > 0 ? values[column - 1] : "<none>"));
        }
        return column;
    }

    private static byte[] binaryBlobConverter(char[] toParse, int startPosition, int count) {
        int len = (startPosition + count) / 2;
        byte[] res = new byte[len];
        for (int i = 0; i < len; ++i) {
            res[i] = (byte)Integer.parseInt(new String(toParse, 2 * i, 2 * i + 2), 16);
        }
        return res;
    }

    private static void oldMapiStringToJavaDataConversion(OldMapiProtocol protocol, char[] toParse, int startPosition, int count, int lineNumber, Object columnArray, int jDBCMapping) throws ProtocolException {
        switch (jDBCMapping) {
            case 16: {
                ((byte[])columnArray)[lineNumber] = OldMapiTupleLineParserHelper.charArrayToBoolean(toParse, startPosition);
                break;
            }
            case -6: {
                ((byte[])columnArray)[lineNumber] = OldMapiTupleLineParserHelper.charArrayToByte(toParse, startPosition, count);
                break;
            }
            case 5: {
                ((short[])columnArray)[lineNumber] = OldMapiTupleLineParserHelper.charArrayToShort(toParse, startPosition, count);
                break;
            }
            case 4: {
                ((int[])columnArray)[lineNumber] = OldMapiTupleLineParserHelper.charArrayToInt(toParse, startPosition, count);
                break;
            }
            case -5: {
                ((long[])columnArray)[lineNumber] = OldMapiTupleLineParserHelper.charArrayToLong(toParse, startPosition, count);
                break;
            }
            case 7: {
                ((float[])columnArray)[lineNumber] = Float.parseFloat(new String(toParse, startPosition, count));
                break;
            }
            case 8: {
                ((double[])columnArray)[lineNumber] = Double.parseDouble(new String(toParse, startPosition, count));
                break;
            }
            case 2: 
            case 3: {
                ((BigDecimal[])columnArray)[lineNumber] = new BigDecimal(toParse, startPosition, count);
                break;
            }
            case -1: 
            case 1: 
            case 12: 
            case 1111: {
                ((String[])columnArray)[lineNumber] = new String(toParse, startPosition, count);
                break;
            }
            case 91: {
                ((Calendar[])columnArray)[lineNumber] = GregorianCalendarParser.parseDate(new String(toParse, startPosition, count), protocol.getMonetParserPosition(), protocol.getMonetDate());
                break;
            }
            case 92: {
                ((Calendar[])columnArray)[lineNumber] = GregorianCalendarParser.parseTime(new String(toParse, startPosition, count), protocol.getMonetParserPosition(), protocol.timeParser, false);
                break;
            }
            case 2013: {
                ((Calendar[])columnArray)[lineNumber] = GregorianCalendarParser.parseTime(new String(toParse, startPosition, count), protocol.getMonetParserPosition(), protocol.timeParser, true);
                break;
            }
            case 93: {
                ((TimestampHelper[])columnArray)[lineNumber] = GregorianCalendarParser.parseTimestamp(new String(toParse, startPosition, count), protocol.getMonetParserPosition(), protocol.timestampParser, false);
                break;
            }
            case 2014: {
                ((TimestampHelper[])columnArray)[lineNumber] = GregorianCalendarParser.parseTimestamp(new String(toParse, startPosition, count), protocol.getMonetParserPosition(), protocol.timestampParser, true);
                break;
            }
            case 2005: {
                ((MonetClob[])columnArray)[lineNumber] = new MonetClob(toParse, startPosition, count);
                break;
            }
            case 2004: {
                ((MonetBlob[])columnArray)[lineNumber] = new MonetBlob(OldMapiTupleLineParser.binaryBlobConverter(toParse, startPosition, count));
                break;
            }
            case -4: {
                ((byte[][])columnArray)[lineNumber] = OldMapiTupleLineParser.binaryBlobConverter(toParse, startPosition, count);
                break;
            }
            default: {
                throw new ProtocolException("Unknown JDBC mapping!");
            }
        }
    }

    private static void setNullValue(int lineNumber, Object columnArray, int jDBCMapping) {
        switch (jDBCMapping) {
            case -6: 
            case 16: {
                ((byte[])columnArray)[lineNumber] = -128;
                break;
            }
            case 5: {
                ((short[])columnArray)[lineNumber] = Short.MIN_VALUE;
                break;
            }
            case 4: {
                ((int[])columnArray)[lineNumber] = Integer.MIN_VALUE;
                break;
            }
            case -5: {
                ((long[])columnArray)[lineNumber] = Long.MIN_VALUE;
                break;
            }
            case 7: {
                ((float[])columnArray)[lineNumber] = Float.MIN_VALUE;
                break;
            }
            case 8: {
                ((double[])columnArray)[lineNumber] = Double.MIN_VALUE;
                break;
            }
            default: {
                ((Object[])columnArray)[lineNumber] = null;
            }
        }
    }
}

