/*
 * Decompiled with CFR 0.152.
 */
package nl.cwi.monetdb.jdbc;

import java.net.MalformedURLException;
import java.net.URL;
import java.sql.SQLData;
import java.sql.SQLException;
import java.sql.SQLInput;
import java.sql.SQLOutput;

public class MonetURL
implements SQLData {
    private String url;

    public static String FromString(String newurl) throws Exception {
        if (newurl == null) {
            return null;
        }
        new URL(newurl);
        return newurl;
    }

    public MonetURL(String inet) throws Exception {
        this.url = MonetURL.FromString(inet);
    }

    @Override
    public String getSQLTypeName() {
        return "url";
    }

    @Override
    public void readSQL(SQLInput stream, String typeName) throws SQLException {
        if (typeName.compareTo("url") != 0) {
            throw new SQLException("can only use this class with 'url' type", "M1M05");
        }
        this.url = stream.readString();
    }

    @Override
    public void writeSQL(SQLOutput stream) throws SQLException {
        stream.writeString(this.url);
    }

    public String toString() {
        return this.url;
    }

    public URL getURL() throws SQLException {
        if (this.url == null) {
            return null;
        }
        try {
            return new URL(this.url);
        }
        catch (MalformedURLException mue) {
            throw new SQLException("data is not a valid URL", "M0M27");
        }
    }

    public void setURL(URL nurl) throws Exception {
        this.url = nurl.toString();
    }
}

