/*
 * Decompiled with CFR 0.152.
 */
package nl.cwi.monetdb.jdbc;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.sql.Blob;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.util.Arrays;

public class MonetBlob
implements Blob,
Serializable,
Comparable<MonetBlob> {
    private byte[] buffer;

    public MonetBlob(byte[] buf) {
        this.buffer = buf;
    }

    public byte[] getBuffer() {
        return this.buffer;
    }

    static MonetBlob create(String in) {
        int len = in.length() / 2;
        byte[] buf = new byte[len];
        for (int i = 0; i < len; ++i) {
            int offset = 2 * i;
            buf[i] = (byte)Integer.parseInt(in.substring(offset, offset + 2), 16);
        }
        return new MonetBlob(buf);
    }

    private void checkBufIsNotNull() throws SQLException {
        if (this.buffer == null) {
            throw new SQLException("This MonetBlob has been freed", "M1M20");
        }
    }

    @Override
    public void free() throws SQLException {
        this.buffer = null;
    }

    @Override
    public InputStream getBinaryStream() throws SQLException {
        this.checkBufIsNotNull();
        return new ByteArrayInputStream(this.buffer);
    }

    @Override
    public InputStream getBinaryStream(long pos, long length) throws SQLException {
        this.checkBufIsNotNull();
        if (pos < 1L) {
            throw new SQLException("pos is less than 1", "M1M05");
        }
        if (pos - 1L > (long)this.buffer.length) {
            throw new SQLException("pos is greater than the number of bytes in the Blob", "M1M05");
        }
        if (pos - 1L + length > (long)this.buffer.length) {
            throw new SQLException("pos + length is greater than the number of bytes in the Blob", "M1M05");
        }
        return new ByteArrayInputStream(this.buffer, (int)(pos - 1L), (int)length);
    }

    @Override
    public byte[] getBytes(long pos, int length) throws SQLException {
        this.checkBufIsNotNull();
        try {
            return Arrays.copyOfRange(this.buffer, (int)pos - 1, (int)pos - 1 + length);
        }
        catch (IndexOutOfBoundsException e) {
            throw new SQLException(e.getMessage(), "M0M10");
        }
    }

    @Override
    public long length() throws SQLException {
        this.checkBufIsNotNull();
        return this.buffer.length;
    }

    @Override
    public long position(Blob pattern, long start) throws SQLException {
        return this.position(pattern.getBytes(1L, (int)pattern.length()), start);
    }

    @Override
    public long position(byte[] pattern, long start) throws SQLException {
        this.checkBufIsNotNull();
        try {
            for (int i = (int)(start - 1L); i < this.buffer.length - pattern.length; ++i) {
                int j;
                for (j = 0; j < pattern.length && this.buffer[i + j] == pattern[j]; ++j) {
                }
                if (j != pattern.length) continue;
                return i;
            }
        }
        catch (IndexOutOfBoundsException e) {
            throw new SQLException(e.getMessage(), "M0M10");
        }
        return -1L;
    }

    @Override
    public OutputStream setBinaryStream(long pos) throws SQLException {
        throw new SQLFeatureNotSupportedException("Method setBinaryStream(long pos) not supported", "0A000");
    }

    @Override
    public int setBytes(long pos, byte[] bytes) throws SQLException {
        return this.setBytes(pos, bytes, 1, bytes.length);
    }

    @Override
    public int setBytes(long pos, byte[] bytes, int offset, int len) throws SQLException {
        this.checkBufIsNotNull();
        try {
            System.arraycopy(bytes, offset - 1 + (int)pos, this.buffer, (int)pos, len - (int)pos);
        }
        catch (IndexOutOfBoundsException e) {
            throw new SQLException(e.getMessage(), "M0M10");
        }
        return len;
    }

    @Override
    public void truncate(long len) throws SQLException {
        this.checkBufIsNotNull();
        if ((long)this.buffer.length > len) {
            byte[] newbuf = new byte[(int)len];
            System.arraycopy(this.buffer, 0, newbuf, 0, (int)len);
            this.buffer = newbuf;
        }
    }

    public boolean equals(Object obj) {
        return obj instanceof MonetBlob && Arrays.equals(this.buffer, ((MonetBlob)obj).buffer);
    }

    public int hashCode() {
        return Arrays.hashCode(this.buffer);
    }

    public String toString() {
        return Arrays.toString(this.buffer);
    }

    @Override
    public int compareTo(MonetBlob o) {
        byte[] first = this.buffer;
        byte[] second = o.buffer;
        int len = Math.min(first.length, second.length);
        int res = 0;
        for (int i = 0; i < len; ++i) {
            res = res + first[i] - second[i];
        }
        return res;
    }
}

