/*
 * Decompiled with CFR 0.152.
 */
package nl.cwi.monetdb.embedded.env;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.RoundingMode;
import java.net.MalformedURLException;
import java.net.URL;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.ParameterMetaData;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import nl.cwi.monetdb.embedded.env.AbstractConnectionResult;
import nl.cwi.monetdb.embedded.env.MonetDBEmbeddedConnection;
import nl.cwi.monetdb.embedded.env.MonetDBEmbeddedException;
import nl.cwi.monetdb.embedded.mapping.MonetDBToJavaMapping;
import nl.cwi.monetdb.embedded.resultset.ExecResultSet;
import nl.cwi.monetdb.embedded.resultset.PreparedQueryResultSet;
import nl.cwi.monetdb.embedded.resultset.QueryResultSet;
import nl.cwi.monetdb.jdbc.MonetWrapper;

public final class MonetDBEmbeddedPreparedStatement
extends AbstractConnectionResult {
    private int id;
    private final int size;
    private final int rscolcnt;
    private final String[] values;
    private final String[] monetdbType;
    private final int[] digits;
    private final int[] scale;
    private final String[] schema;
    private final String[] table;
    private final String[] column;
    private final SimpleDateFormat mTimestampZ;
    private final SimpleDateFormat mTimestamp;
    private final SimpleDateFormat mTimeZ;
    private final SimpleDateFormat mTime;
    private final SimpleDateFormat mDate;
    private static final String HEXES = "0123456789ABCDEF";

    MonetDBEmbeddedPreparedStatement(MonetDBEmbeddedConnection connection, PreparedQueryResultSet qrs) throws MonetDBEmbeddedException {
        super(connection);
        this.id = qrs.getPreparedID();
        this.size = qrs.getNumberOfRows();
        this.rscolcnt = qrs.getNumberOfColumns();
        this.values = new String[this.size];
        this.monetdbType = new String[this.size];
        this.digits = new int[this.size];
        this.scale = new int[this.size];
        this.schema = new String[this.size];
        this.table = new String[this.size];
        this.column = new String[this.size];
        qrs.getStringColumnByIndex(3, this.monetdbType);
        qrs.getIntColumnByIndex(4, this.digits);
        qrs.getIntColumnByIndex(5, this.scale);
        qrs.getStringColumnByIndex(6, this.schema);
        qrs.getStringColumnByIndex(7, this.table);
        qrs.getStringColumnByIndex(8, this.column);
        qrs.close();
        this.mTimestampZ = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSSZ");
        this.mTimestamp = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS");
        this.mTimeZ = new SimpleDateFormat("HH:mm:ss.SSSZ");
        this.mTime = new SimpleDateFormat("HH:mm:ss.SSS");
        this.mDate = new SimpleDateFormat("yyyy-MM-dd");
    }

    @Override
    public int getNumberOfColumns() {
        return this.rscolcnt;
    }

    @Override
    public int getNumberOfRows() {
        return this.size;
    }

    @Override
    public void getColumnNames(String[] input) throws MonetDBEmbeddedException {
        if (this.rscolcnt == 3) {
            throw new MonetDBEmbeddedException("The column names information is not available in Prepared Statement");
        }
        System.arraycopy(this.column, 0, input, 0, Math.min(this.column.length, input.length));
    }

    @Override
    public void getColumnTypes(String[] input) throws MonetDBEmbeddedException {
        System.arraycopy(this.monetdbType, 0, input, 0, Math.min(this.monetdbType.length, input.length));
    }

    @Override
    public void getMappings(MonetDBToJavaMapping[] input) throws MonetDBEmbeddedException {
        for (int i = 0; i < input.length && i < this.monetdbType.length; ++i) {
            input[i] = MonetDBToJavaMapping.getJavaMappingFromMonetDBString(this.monetdbType[i]);
        }
    }

    @Override
    public void getColumnDigits(int[] input) throws MonetDBEmbeddedException {
        System.arraycopy(this.digits, 0, input, 0, Math.min(this.digits.length, input.length));
    }

    @Override
    public void getColumnScales(int[] input) throws MonetDBEmbeddedException {
        System.arraycopy(this.scale, 0, input, 0, Math.min(this.scale.length, input.length));
    }

    public boolean isPreparedStatementClosed() {
        return this.id == 0;
    }

    public void clearParameters() {
        for (int i = 0; i < this.values.length; ++i) {
            this.values[i] = null;
        }
    }

    private String transform() throws MonetDBEmbeddedException {
        StringBuilder buf = new StringBuilder(8 + 12 * this.size);
        buf.append("execute ");
        buf.append(this.id);
        buf.append("(");
        int col = 0;
        for (int i = 0; i < this.size; ++i) {
            if (this.column[i] != null) continue;
            if (++col > 1) {
                buf.append(',');
            }
            if (this.values[i] == null) {
                throw new MonetDBEmbeddedException("Cannot execute, parameter " + col + " is missing.");
            }
            buf.append(this.values[i]);
        }
        buf.append(");");
        return buf.toString();
    }

    public boolean execute() throws MonetDBEmbeddedException {
        ExecResultSet result = this.getConnection().executePrepareStatement(this.transform());
        boolean res = result.getStatus();
        if (res) {
            result.getResultSet().close();
        }
        return result.getStatus();
    }

    public void executeAndIgnore() throws MonetDBEmbeddedException {
        this.getConnection().executePreparedStatementAndIgnore(this.transform());
    }

    public QueryResultSet executeQuery() throws MonetDBEmbeddedException {
        ExecResultSet result = this.getConnection().executePrepareStatement(this.transform());
        if (!result.getStatus()) {
            throw new MonetDBEmbeddedException("Query did not produce a result set");
        }
        return result.getResultSet();
    }

    public int executeUpdate() throws MonetDBEmbeddedException {
        ExecResultSet result = this.getConnection().executePrepareStatement(this.transform());
        if (result.getStatus()) {
            throw new MonetDBEmbeddedException("Query produced a result set");
        }
        return result.getNumberOfRows();
    }

    private int getColumnIdx(int colnr) throws MonetDBEmbeddedException {
        int curcol = 0;
        for (int i = 0; i < this.size; ++i) {
            if (this.column[i] == null || ++curcol != colnr) continue;
            return i;
        }
        throw new MonetDBEmbeddedException("No such column with index: " + colnr);
    }

    private int getParamIdx(int paramnr) throws MonetDBEmbeddedException {
        int curparam = 0;
        for (int i = 0; i < this.size; ++i) {
            if (this.column[i] != null || ++curparam != paramnr) continue;
            return i;
        }
        throw new MonetDBEmbeddedException("No such parameter with index: " + paramnr);
    }

    private void setValue(int index, String val) throws MonetDBEmbeddedException {
        this.values[this.getParamIdx((int)index)] = val;
    }

    public void setNull(int parameterIndex, int sqlType) throws MonetDBEmbeddedException {
        this.setValue(parameterIndex, "NULL");
    }

    public void setNull(int paramIndex, int sqlType, String typeName) throws MonetDBEmbeddedException {
        this.setNull(paramIndex, sqlType);
    }

    public void setBigDecimal(int idx, BigDecimal x) throws MonetDBEmbeddedException {
        int i = this.getParamIdx(idx);
        if ((x = x.setScale(this.scale[i], RoundingMode.HALF_UP)).precision() > this.digits[i]) {
            throw new MonetDBEmbeddedException("DECIMAL value exceeds allowed digits/scale: " + x.toPlainString() + " (" + this.digits[i] + "/" + this.scale[i] + ")");
        }
        String xStr = x.toPlainString();
        int dot = xStr.indexOf(46);
        if (dot >= 0) {
            xStr = xStr.substring(0, Math.min(xStr.length(), dot + 1 + this.scale[i]));
        }
        while (xStr.startsWith("0") && xStr.length() > 1) {
            xStr = xStr.substring(1);
        }
        this.setValue(idx, xStr);
    }

    public void setBlob(int parameterIndex, Blob x) throws MonetDBEmbeddedException {
        byte[] bbytes;
        if (x == null) {
            this.setNull(parameterIndex, -1);
            return;
        }
        try {
            long length = x.length();
            bbytes = x.getBytes(0L, (int)length);
        }
        catch (SQLException ex) {
            throw new MonetDBEmbeddedException(ex);
        }
        this.setBytes(parameterIndex, bbytes);
    }

    public void setBoolean(int parameterIndex, boolean x) throws MonetDBEmbeddedException {
        this.setValue(parameterIndex, Boolean.toString(x));
    }

    public void setByte(int parameterIndex, byte x) throws MonetDBEmbeddedException {
        this.setValue(parameterIndex, Byte.toString(x));
    }

    public void setBytes(int parameterIndex, byte[] x) throws MonetDBEmbeddedException {
        if (x == null) {
            this.setNull(parameterIndex, -1);
            return;
        }
        StringBuilder hex = new StringBuilder(x.length * 2);
        for (byte aX : x) {
            hex.append(HEXES.charAt((aX & 0xF0) >> 4)).append(HEXES.charAt(aX & 0xF));
        }
        this.setValue(parameterIndex, "blob '" + hex.toString() + "'");
    }

    public void setClob(int i, Clob x) throws MonetDBEmbeddedException {
        String bbytes;
        if (x == null) {
            this.setNull(i, -1);
            return;
        }
        try {
            int length = (int)x.length();
            bbytes = x.getSubString(1L, length);
        }
        catch (SQLException ex) {
            throw new MonetDBEmbeddedException(ex);
        }
        this.setString(i, bbytes);
    }

    public void setDate(int parameterIndex, Date x) throws MonetDBEmbeddedException {
        this.setDate(parameterIndex, x, null);
    }

    public void setDate(int parameterIndex, Date x, Calendar cal) throws MonetDBEmbeddedException {
        if (x == null) {
            this.setNull(parameterIndex, -1);
            return;
        }
        if (cal == null) {
            this.setValue(parameterIndex, "date '" + x.toString() + "'");
        } else {
            this.mDate.setTimeZone(cal.getTimeZone());
            this.setValue(parameterIndex, "date '" + this.mDate.format(x) + "'");
        }
    }

    public void setDouble(int parameterIndex, double x) throws MonetDBEmbeddedException {
        this.setValue(parameterIndex, Double.toString(x));
    }

    public void setFloat(int parameterIndex, float x) throws MonetDBEmbeddedException {
        this.setValue(parameterIndex, Float.toString(x));
    }

    public void setInt(int parameterIndex, int x) throws MonetDBEmbeddedException {
        this.setValue(parameterIndex, Integer.toString(x));
    }

    public void setLong(int parameterIndex, long x) throws MonetDBEmbeddedException {
        this.setValue(parameterIndex, Long.toString(x));
    }

    public void setObject(int index, Object x) throws MonetDBEmbeddedException {
        int targetSqlType = MonetDBToJavaMapping.getJavaMappingFromMonetDBStringOrdinalValue(this.monetdbType[this.getParamIdx(index)]);
        this.setObject(index, x, targetSqlType);
    }

    public void setObject(int parameterIndex, Object x, int targetSqlType) throws MonetDBEmbeddedException {
        this.setObject(parameterIndex, x, targetSqlType, 0);
    }

    public void setObject(int parameterIndex, Object x, int targetSqlType, int scale) throws MonetDBEmbeddedException {
        block69: {
            block74: {
                block73: {
                    block72: {
                        block71: {
                            block70: {
                                block68: {
                                    if (x == null) {
                                        this.setNull(parameterIndex, -1);
                                        return;
                                    }
                                    if (!(x instanceof String)) break block68;
                                    this.setString(parameterIndex, (String)x);
                                    break block69;
                                }
                                if (!(x instanceof BigDecimal) && !(x instanceof Byte) && !(x instanceof Short) && !(x instanceof Integer) && !(x instanceof Long) && !(x instanceof Float) && !(x instanceof Double)) break block70;
                                Number num = (Number)x;
                                switch (targetSqlType) {
                                    case 4: {
                                        this.setByte(parameterIndex, num.byteValue());
                                        break;
                                    }
                                    case 5: {
                                        this.setShort(parameterIndex, num.shortValue());
                                        break;
                                    }
                                    case 6: 
                                    case 11: {
                                        this.setInt(parameterIndex, num.intValue());
                                        break;
                                    }
                                    case 7: 
                                    case 12: {
                                        if (x instanceof BigDecimal) {
                                            BigDecimal bd = (BigDecimal)x;
                                            this.setLong(parameterIndex, bd.setScale(scale, 4).longValue());
                                            break;
                                        }
                                        this.setLong(parameterIndex, num.longValue());
                                        break;
                                    }
                                    case 9: {
                                        this.setFloat(parameterIndex, num.floatValue());
                                        break;
                                    }
                                    case 10: {
                                        this.setDouble(parameterIndex, num.doubleValue());
                                        break;
                                    }
                                    case 8: {
                                        if (x instanceof BigDecimal) {
                                            this.setBigDecimal(parameterIndex, (BigDecimal)x);
                                            break;
                                        }
                                        this.setBigDecimal(parameterIndex, new BigDecimal(num.doubleValue()));
                                        break;
                                    }
                                    case 0: {
                                        if (num.doubleValue() != 0.0) {
                                            this.setBoolean(parameterIndex, true);
                                            break;
                                        }
                                        this.setBoolean(parameterIndex, false);
                                        break;
                                    }
                                    case 1: 
                                    case 2: 
                                    case 3: {
                                        this.setString(parameterIndex, x.toString());
                                        break;
                                    }
                                    default: {
                                        throw new MonetDBEmbeddedException("Conversion not allowed");
                                    }
                                }
                                break block69;
                            }
                            if (!(x instanceof Boolean)) break block71;
                            boolean val = (Boolean)x;
                            switch (targetSqlType) {
                                case 4: {
                                    this.setByte(parameterIndex, (byte)(val ? 1 : 0));
                                    break;
                                }
                                case 5: {
                                    this.setShort(parameterIndex, (short)(val ? 1 : 0));
                                    break;
                                }
                                case 6: 
                                case 11: {
                                    this.setInt(parameterIndex, val ? 1 : 0);
                                    break;
                                }
                                case 7: 
                                case 12: {
                                    this.setLong(parameterIndex, val ? 1 : 0);
                                    break;
                                }
                                case 9: {
                                    this.setFloat(parameterIndex, (float)(val ? 1.0 : 0.0));
                                    break;
                                }
                                case 10: {
                                    this.setDouble(parameterIndex, val ? 1.0 : 0.0);
                                    break;
                                }
                                case 8: {
                                    BigDecimal dec;
                                    try {
                                        dec = new BigDecimal(val ? 1.0 : 0.0);
                                    }
                                    catch (NumberFormatException e) {
                                        throw new MonetDBEmbeddedException("Internal error: unable to create template BigDecimal: " + e.getMessage());
                                    }
                                    this.setBigDecimal(parameterIndex, dec);
                                    break;
                                }
                                case 0: {
                                    this.setBoolean(parameterIndex, val);
                                    break;
                                }
                                case 1: 
                                case 2: 
                                case 3: {
                                    this.setString(parameterIndex, x.toString());
                                    break;
                                }
                                default: {
                                    throw new MonetDBEmbeddedException("Conversion not allowed");
                                }
                            }
                            break block69;
                        }
                        if (!(x instanceof BigInteger)) break block72;
                        BigInteger num = (BigInteger)x;
                        switch (targetSqlType) {
                            case 7: 
                            case 12: {
                                this.setLong(parameterIndex, num.longValue());
                                break;
                            }
                            case 8: {
                                BigDecimal dec;
                                try {
                                    dec = new BigDecimal(num);
                                }
                                catch (NumberFormatException e) {
                                    throw new MonetDBEmbeddedException("Internal error: unable to create template BigDecimal: " + e.getMessage());
                                }
                                this.setBigDecimal(parameterIndex, dec);
                                break;
                            }
                            case 1: 
                            case 2: 
                            case 3: {
                                this.setString(parameterIndex, x.toString());
                                break;
                            }
                            default: {
                                throw new MonetDBEmbeddedException("Conversion not allowed");
                            }
                        }
                        break block69;
                    }
                    if (!(x instanceof byte[])) break block73;
                    switch (targetSqlType) {
                        case 18: {
                            this.setBytes(parameterIndex, (byte[])x);
                            break block69;
                        }
                        default: {
                            throw new MonetDBEmbeddedException("Conversion not allowed");
                        }
                    }
                }
                if (!(x instanceof Date) && !(x instanceof Timestamp) && !(x instanceof Time) && !(x instanceof Calendar) && !(x instanceof java.util.Date)) break block74;
                switch (targetSqlType) {
                    case 15: {
                        if (x instanceof Date) {
                            this.setDate(parameterIndex, (Date)x);
                        } else if (x instanceof Timestamp) {
                            this.setDate(parameterIndex, new Date(((Timestamp)x).getTime()));
                        } else if (x instanceof java.util.Date) {
                            this.setDate(parameterIndex, new Date(((java.util.Date)x).getTime()));
                        } else {
                            this.setDate(parameterIndex, new Date(((Calendar)x).getTimeInMillis()));
                        }
                        break block69;
                    }
                    case 13: 
                    case 14: {
                        if (x instanceof Time) {
                            this.setTime(parameterIndex, (Time)x);
                        } else if (x instanceof Timestamp) {
                            this.setTime(parameterIndex, new Time(((Timestamp)x).getTime()));
                        } else if (x instanceof java.util.Date) {
                            this.setTime(parameterIndex, new Time(((java.util.Date)x).getTime()));
                        } else {
                            this.setTime(parameterIndex, new Time(((Calendar)x).getTimeInMillis()));
                        }
                        break block69;
                    }
                    case 16: 
                    case 17: {
                        if (x instanceof Timestamp) {
                            this.setTimestamp(parameterIndex, (Timestamp)x);
                        } else if (x instanceof Date) {
                            this.setTimestamp(parameterIndex, new Timestamp(((Date)x).getTime()));
                        } else if (x instanceof java.util.Date) {
                            this.setTimestamp(parameterIndex, new Timestamp(((java.util.Date)x).getTime()));
                        } else {
                            this.setTimestamp(parameterIndex, new Timestamp(((Calendar)x).getTimeInMillis()));
                        }
                        break block69;
                    }
                    case 1: 
                    case 2: 
                    case 3: {
                        this.setString(parameterIndex, x.toString());
                        break block69;
                    }
                    default: {
                        throw new MonetDBEmbeddedException("Conversion not allowed");
                    }
                }
            }
            if (x instanceof Blob) {
                this.setBlob(parameterIndex, (Blob)x);
            } else if (x instanceof Clob) {
                this.setClob(parameterIndex, (Clob)x);
            } else if (x instanceof URL) {
                this.setURL(parameterIndex, (URL)x);
            } else {
                throw new MonetDBEmbeddedException("No support for setObject() with object of type: " + x.getClass().getName());
            }
        }
    }

    public void setShort(int parameterIndex, short x) throws MonetDBEmbeddedException {
        this.setValue(parameterIndex, Short.toString(x));
    }

    public void setString(int parameterIndex, String x) throws MonetDBEmbeddedException {
        if (x == null) {
            this.setNull(parameterIndex, -1);
            return;
        }
        int paramIdx = this.getParamIdx(parameterIndex);
        int targetSqlType = MonetDBToJavaMapping.getJavaMappingFromMonetDBStringOrdinalValue(this.monetdbType[this.getParamIdx(parameterIndex)]);
        String paramMonetdbType = this.monetdbType[paramIdx];
        switch (targetSqlType) {
            case 1: 
            case 2: 
            case 3: {
                String castprefix = "";
                switch (paramMonetdbType) {
                    case "url": {
                        try {
                            URL uRL = new URL(x);
                        }
                        catch (MalformedURLException mue) {
                            throw new MonetDBEmbeddedException("Conversion of string: " + x + " to parameter data type " + paramMonetdbType + " failed. " + mue.getMessage());
                        }
                        castprefix = "url ";
                    }
                }
                this.setValue(parameterIndex, castprefix + "'" + x.replaceAll("\\\\", "\\\\\\\\").replaceAll("'", "\\\\'") + "'");
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                try {
                    if (targetSqlType == 4) {
                        byte castprefix = Byte.parseByte(x);
                    } else if (targetSqlType == 5) {
                        short castprefix = Short.parseShort(x);
                    } else if (targetSqlType == 6 || targetSqlType == 11) {
                        int castprefix = Integer.parseInt(x);
                    } else if (targetSqlType == 7 || targetSqlType == 12) {
                        long castprefix = Long.parseLong(x);
                    } else if (targetSqlType == 9 || targetSqlType == 10) {
                        double castprefix = Double.parseDouble(x);
                    } else {
                        BigDecimal castprefix = new BigDecimal(x);
                    }
                }
                catch (NumberFormatException nfe) {
                    throw new MonetDBEmbeddedException("Conversion of string: " + x + " to parameter data type " + paramMonetdbType + " failed. " + nfe.getMessage());
                }
                this.setValue(parameterIndex, x);
                break;
            }
            case 0: {
                if (x.equalsIgnoreCase("false") || x.equalsIgnoreCase("true") || x.equals("0") || x.equals("1")) {
                    this.setValue(parameterIndex, x);
                    break;
                }
                throw new MonetDBEmbeddedException("Conversion of string: " + x + " to parameter data type " + paramMonetdbType + " failed");
            }
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: {
                try {
                    if (targetSqlType == 15) {
                        Date nfe = Date.valueOf(x);
                    } else if (targetSqlType == 13 || targetSqlType == 14) {
                        Time nfe = Time.valueOf(x);
                    } else {
                        Timestamp nfe = Timestamp.valueOf(x);
                    }
                }
                catch (IllegalArgumentException iae) {
                    throw new MonetDBEmbeddedException("Conversion of string: " + x + " to parameter data type " + paramMonetdbType + " failed. " + iae.getMessage());
                }
                this.setValue(parameterIndex, paramMonetdbType + " '" + x + "'");
                break;
            }
            case 18: {
                int xlen = x.length();
                for (int i = 0; i < xlen; ++i) {
                    char c = x.charAt(i);
                    if (c >= '0' && c <= '9' || c >= 'A' && c <= 'F' || c >= 'a' && c <= 'f') continue;
                    throw new MonetDBEmbeddedException("Invalid string for parameter data type " + paramMonetdbType + ". The string may contain only hex chars");
                }
                this.setValue(parameterIndex, "blob '" + x + "'");
                break;
            }
            default: {
                throw new MonetDBEmbeddedException("Conversion of string to parameter data type " + paramMonetdbType + " is not (yet) supported");
            }
        }
    }

    public void setTime(int index, Time x) throws MonetDBEmbeddedException {
        this.setTime(index, x, null);
    }

    public void setTime(int index, Time x, Calendar cal) throws MonetDBEmbeddedException {
        boolean hasTimeZone;
        if (x == null) {
            this.setNull(index, -1);
            return;
        }
        String MonetDBType = this.monetdbType[this.getParamIdx(index)];
        boolean bl = hasTimeZone = "timetz".equals(MonetDBType) || "timestamptz".equals(MonetDBType);
        if (hasTimeZone) {
            String RFC822 = this.mTimeZ.format(x);
            this.setValue(index, "timetz '" + RFC822.substring(0, 15) + ":" + RFC822.substring(15) + "'");
        } else if (cal == null) {
            this.setValue(index, "time '" + x.toString() + "'");
        } else {
            this.mTime.setTimeZone(cal.getTimeZone());
            this.setValue(index, "time '" + this.mTime.format(x) + "'");
        }
    }

    public void setTimestamp(int index, Timestamp x) throws MonetDBEmbeddedException {
        this.setTimestamp(index, x, null);
    }

    public void setTimestamp(int index, Timestamp x, Calendar cal) throws MonetDBEmbeddedException {
        boolean hasTimeZone;
        if (x == null) {
            this.setNull(index, -1);
            return;
        }
        String MonetDBType = this.monetdbType[this.getParamIdx(index)];
        boolean bl = hasTimeZone = "timestamptz".equals(MonetDBType) || "timetz".equals(MonetDBType);
        if (hasTimeZone) {
            String RFC822 = this.mTimestampZ.format(x);
            this.setValue(index, "timestamptz '" + RFC822.substring(0, 26) + ":" + RFC822.substring(26) + "'");
        } else if (cal == null) {
            this.setValue(index, "timestamp '" + x.toString() + "'");
        } else {
            this.mTimestamp.setTimeZone(cal.getTimeZone());
            this.setValue(index, "timestamp '" + this.mTimestamp.format(x) + "'");
        }
    }

    public void setURL(int parameterIndex, URL x) throws MonetDBEmbeddedException {
        if (x == null) {
            this.setNull(parameterIndex, -1);
            return;
        }
        String val = x.toString();
        this.setValue(parameterIndex, "url '" + val.replaceAll("\\\\", "\\\\\\\\").replaceAll("'", "\\\\'") + "'");
    }

    public ResultSetMetaData getMetaData() {
        if (this.rscolcnt == 3) {
            return null;
        }
        return new ersmdw(){

            @Override
            public int getColumnCount() {
                int cnt = 0;
                for (int i = 0; i < MonetDBEmbeddedPreparedStatement.this.size; ++i) {
                    if (MonetDBEmbeddedPreparedStatement.this.column[i] == null) continue;
                    ++cnt;
                }
                return cnt;
            }

            @Override
            public boolean isAutoIncrement(int column) throws SQLException {
                return false;
            }

            @Override
            public boolean isCaseSensitive(int column) throws SQLException {
                switch (this.getColumnType(column)) {
                    case 1: 
                    case 2: 
                    case 3: {
                        return true;
                    }
                }
                return false;
            }

            @Override
            public boolean isSearchable(int column) {
                return true;
            }

            @Override
            public boolean isCurrency(int column) {
                return false;
            }

            @Override
            public boolean isSigned(int column) throws SQLException {
                switch (this.getColumnType(column)) {
                    case 4: 
                    case 5: 
                    case 6: 
                    case 7: 
                    case 8: 
                    case 9: 
                    case 10: {
                        return true;
                    }
                }
                return false;
            }

            @Override
            public int getColumnDisplaySize(int column) throws SQLException {
                try {
                    return MonetDBEmbeddedPreparedStatement.this.digits[MonetDBEmbeddedPreparedStatement.this.getColumnIdx(column)];
                }
                catch (IndexOutOfBoundsException e) {
                    throw new SQLException(e);
                }
            }

            @Override
            public String getSchemaName(int column) throws SQLException {
                try {
                    return MonetDBEmbeddedPreparedStatement.this.schema[MonetDBEmbeddedPreparedStatement.this.getColumnIdx(column)];
                }
                catch (IndexOutOfBoundsException e) {
                    throw new SQLException(e);
                }
            }

            @Override
            public String getTableName(int column) throws SQLException {
                try {
                    return MonetDBEmbeddedPreparedStatement.this.table[MonetDBEmbeddedPreparedStatement.this.getColumnIdx(column)];
                }
                catch (IndexOutOfBoundsException e) {
                    throw new SQLException(e);
                }
            }

            @Override
            public int getPrecision(int column) throws SQLException {
                try {
                    return MonetDBEmbeddedPreparedStatement.this.digits[MonetDBEmbeddedPreparedStatement.this.getColumnIdx(column)];
                }
                catch (IndexOutOfBoundsException e) {
                    throw new SQLException(e);
                }
            }

            @Override
            public int getScale(int column) throws SQLException {
                try {
                    return MonetDBEmbeddedPreparedStatement.this.scale[MonetDBEmbeddedPreparedStatement.this.getColumnIdx(column)];
                }
                catch (IndexOutOfBoundsException e) {
                    throw new SQLException(e);
                }
            }

            @Override
            public int isNullable(int column) throws SQLException {
                return 2;
            }

            @Override
            public String getCatalogName(int column) throws SQLException {
                return null;
            }

            @Override
            public boolean isReadOnly(int column) {
                return true;
            }

            @Override
            public boolean isWritable(int column) {
                return false;
            }

            @Override
            public boolean isDefinitelyWritable(int column) {
                return false;
            }

            @Override
            public String getColumnClassName(int column) throws SQLException {
                try {
                    return MonetDBToJavaMapping.getJavaMappingFromMonetDBString(MonetDBEmbeddedPreparedStatement.this.monetdbType[MonetDBEmbeddedPreparedStatement.this.getColumnIdx(column)]).getJavaClass().getName();
                }
                catch (IndexOutOfBoundsException e) {
                    throw new SQLException(e);
                }
            }

            @Override
            public String getColumnLabel(int column) throws SQLException {
                return this.getColumnName(column);
            }

            @Override
            public String getColumnName(int colnr) throws SQLException {
                try {
                    return MonetDBEmbeddedPreparedStatement.this.column[MonetDBEmbeddedPreparedStatement.this.getColumnIdx(colnr)];
                }
                catch (IndexOutOfBoundsException e) {
                    throw new SQLException(e);
                }
            }

            @Override
            public int getColumnType(int column) throws SQLException {
                try {
                    return MonetDBToJavaMapping.getJavaMappingFromMonetDBStringOrdinalValue(MonetDBEmbeddedPreparedStatement.this.monetdbType[MonetDBEmbeddedPreparedStatement.this.getColumnIdx(column)]);
                }
                catch (IndexOutOfBoundsException e) {
                    throw new SQLException(e);
                }
            }

            @Override
            public String getColumnTypeName(int column) throws SQLException {
                try {
                    return MonetDBEmbeddedPreparedStatement.this.monetdbType[MonetDBEmbeddedPreparedStatement.this.getColumnIdx(column)];
                }
                catch (IndexOutOfBoundsException e) {
                    throw new SQLException(e);
                }
            }
        };
    }

    public ParameterMetaData getParameterMetaData() throws SQLException {
        return new epmdw(){

            @Override
            public int getParameterCount() throws SQLException {
                int cnt = 0;
                for (int i = 0; i < MonetDBEmbeddedPreparedStatement.this.size; ++i) {
                    if (MonetDBEmbeddedPreparedStatement.this.column[i] != null) continue;
                    ++cnt;
                }
                return cnt;
            }

            @Override
            public int isNullable(int param) throws SQLException {
                return 2;
            }

            @Override
            public boolean isSigned(int param) throws SQLException {
                switch (this.getParameterType(param)) {
                    case 4: 
                    case 5: 
                    case 6: 
                    case 7: 
                    case 8: 
                    case 9: 
                    case 10: {
                        return true;
                    }
                }
                return false;
            }

            @Override
            public int getPrecision(int param) throws SQLException {
                try {
                    return MonetDBEmbeddedPreparedStatement.this.digits[MonetDBEmbeddedPreparedStatement.this.getParamIdx(param)];
                }
                catch (IndexOutOfBoundsException e) {
                    throw new SQLException(e);
                }
            }

            @Override
            public int getScale(int param) throws SQLException {
                try {
                    return MonetDBEmbeddedPreparedStatement.this.scale[MonetDBEmbeddedPreparedStatement.this.getParamIdx(param)];
                }
                catch (IndexOutOfBoundsException e) {
                    throw new SQLException(e);
                }
            }

            @Override
            public int getParameterType(int param) throws SQLException {
                try {
                    return MonetDBToJavaMapping.getJavaMappingFromMonetDBStringOrdinalValue(MonetDBEmbeddedPreparedStatement.this.monetdbType[MonetDBEmbeddedPreparedStatement.this.getParamIdx(param)]);
                }
                catch (IndexOutOfBoundsException e) {
                    throw new SQLException(e);
                }
            }

            @Override
            public String getParameterTypeName(int param) throws SQLException {
                try {
                    return MonetDBEmbeddedPreparedStatement.this.monetdbType[MonetDBEmbeddedPreparedStatement.this.getParamIdx(param)];
                }
                catch (IndexOutOfBoundsException e) {
                    throw new SQLException(e);
                }
            }

            @Override
            public String getParameterClassName(int param) throws SQLException {
                try {
                    return MonetDBToJavaMapping.getJavaMappingFromMonetDBString(MonetDBEmbeddedPreparedStatement.this.monetdbType[MonetDBEmbeddedPreparedStatement.this.getColumnIdx(param)]).getJavaClass().getName();
                }
                catch (IndexOutOfBoundsException e) {
                    throw new SQLException(e);
                }
            }

            @Override
            public int getParameterMode(int param) throws SQLException {
                return 0;
            }
        };
    }

    private native void freePreparedStatement(long var1, int var3) throws MonetDBEmbeddedException;

    @Override
    public void close() {
        super.close();
        this.id = 0;
    }

    @Override
    protected void closeResultImplementation() {
        if (!this.isPreparedStatementClosed()) {
            try {
                this.freePreparedStatement(this.getConnection().connectionPointer, this.id);
            }
            catch (MonetDBEmbeddedException monetDBEmbeddedException) {
                // empty catch block
            }
            this.id = 0;
        }
    }

    private abstract class epmdw
    extends MonetWrapper
    implements ParameterMetaData {
        private epmdw() {
        }
    }

    private abstract class ersmdw
    extends MonetWrapper
    implements ResultSetMetaData {
        private ersmdw() {
        }
    }
}

