/*
 * Decompiled with CFR 0.152.
 */
package nl.cwi.monetdb.embedded.env;

import java.io.Closeable;
import java.lang.reflect.Array;
import nl.cwi.monetdb.embedded.env.MonetDBEmbeddedConnection;
import nl.cwi.monetdb.embedded.env.MonetDBEmbeddedException;
import nl.cwi.monetdb.embedded.mapping.MonetDBToJavaMapping;
import nl.cwi.monetdb.embedded.utils.Randomizer;

public abstract class AbstractConnectionResult
implements Closeable {
    private final MonetDBEmbeddedConnection connection;
    private final long randomIdentifier;

    protected AbstractConnectionResult(MonetDBEmbeddedConnection connection) {
        this.connection = connection;
        this.randomIdentifier = Randomizer.generateNextResultSetId();
    }

    public MonetDBEmbeddedConnection getConnection() {
        return this.connection;
    }

    public abstract int getNumberOfColumns() throws MonetDBEmbeddedException;

    public abstract int getNumberOfRows();

    protected long getRandomIdentifier() {
        return this.randomIdentifier;
    }

    protected void checkMetadataArrayLength(Object input) throws MonetDBEmbeddedException {
        int arrayLength = Array.getLength(input);
        if (arrayLength != this.getNumberOfColumns()) {
            throw new ArrayIndexOutOfBoundsException("The array length is different from the number of columns! " + this.getNumberOfColumns() + " != " + arrayLength);
        }
    }

    public abstract void getColumnNames(String[] var1) throws MonetDBEmbeddedException;

    public abstract void getColumnTypes(String[] var1) throws MonetDBEmbeddedException;

    public abstract void getMappings(MonetDBToJavaMapping[] var1) throws MonetDBEmbeddedException;

    public abstract void getColumnDigits(int[] var1) throws MonetDBEmbeddedException;

    public abstract void getColumnScales(int[] var1) throws MonetDBEmbeddedException;

    @Override
    public void close() {
        this.connection.removeQueryResult(this);
    }

    protected abstract void closeResultImplementation();
}

