/*
 * Decompiled with CFR 0.152.
 */
package nl.cwi.monetdb.embedded.tables;

import nl.cwi.monetdb.embedded.env.MonetDBEmbeddedException;
import nl.cwi.monetdb.embedded.mapping.AbstractRowSet;
import nl.cwi.monetdb.embedded.mapping.MonetDBRow;
import nl.cwi.monetdb.embedded.tables.MonetDBTable;

public final class RowIterator
extends AbstractRowSet {
    private int currentIterationNumber = 0;
    private final int firstIndex;
    private final int lastIndex;

    RowIterator(MonetDBTable table, Object[][] rows, int firstIndex, int lastIndex) throws MonetDBEmbeddedException {
        super(table, rows);
        this.firstIndex = firstIndex;
        this.lastIndex = lastIndex;
    }

    @Override
    public int getColumnIndexByName(String columnName) {
        int numberOfColumns = this.getQueryResultTable().getNumberOfColumns();
        String[] columnNames = new String[numberOfColumns];
        try {
            this.getQueryResultTable().getColumnNames(columnNames);
        }
        catch (MonetDBEmbeddedException ex) {
            throw new IllegalArgumentException(ex);
        }
        int index = 0;
        for (String colName : columnNames) {
            if (columnName.equals(colName)) {
                return (Integer)this.getColumnByIndex(index + 1);
            }
            ++index;
        }
        throw new ArrayIndexOutOfBoundsException("The column is not present in the result set!");
    }

    public MonetDBTable getTable() {
        return (MonetDBTable)this.getQueryResultTable();
    }

    public int getFirstIndex() {
        return this.firstIndex;
    }

    public int getLastIndex() {
        return this.lastIndex;
    }

    public int getCurrentIterationNumber() {
        return this.currentIterationNumber + 1;
    }

    public int getCurrentTableRowNumber() {
        return this.firstIndex + this.currentIterationNumber;
    }

    public MonetDBRow getCurrentRow() {
        return this.rows[this.currentIterationNumber];
    }

    public boolean hasMore() {
        return this.firstIndex + this.currentIterationNumber <= this.lastIndex;
    }

    public <T> T getColumnByIndex(int index, Class<T> javaClass) {
        return javaClass.cast(this.getCurrentRow().getColumnByIndex(index, javaClass));
    }

    public <T> T getColumnByIndex(int index) {
        Class javaClass = this.mappings[index - 1].getJavaClass();
        return javaClass.cast(this.getCurrentRow().getColumnByIndex(index));
    }

    public <T> T getColumnByName(String columnName, Class<T> javaClass) {
        int index = this.getColumnIndexByName(columnName);
        return this.getColumnByIndex(index, javaClass);
    }

    public <T> T getColumnByName(String columnName) {
        int index = this.getColumnIndexByName(columnName);
        return this.getColumnByIndex(index);
    }

    void setNextIteration() {
        ++this.currentIterationNumber;
    }
}

