/*
 * Decompiled with CFR 0.152.
 */
package nl.cwi.monetdb.embedded.resultset;

import java.lang.reflect.Array;
import java.util.Arrays;
import java.util.ListIterator;
import nl.cwi.monetdb.embedded.env.MonetDBEmbeddedException;
import nl.cwi.monetdb.embedded.mapping.AbstractRowSet;
import nl.cwi.monetdb.embedded.mapping.MonetDBRow;
import nl.cwi.monetdb.embedded.resultset.QueryResultSet;

public class QueryResultRowSet
extends AbstractRowSet
implements Iterable {
    QueryResultRowSet(QueryResultSet queryResultSet, Object[][] rows) throws MonetDBEmbeddedException {
        super(queryResultSet, rows);
    }

    public MonetDBRow[] getAllRows() {
        return this.rows;
    }

    public int getNumberOfRows() {
        return this.rows.length;
    }

    public MonetDBRow getSingleRow(int row) {
        return this.rows[row - 1];
    }

    @Override
    public int getColumnIndexByName(String columnName) {
        return ((QueryResultSet)this.getQueryResultTable()).getColumnIndexByName(columnName);
    }

    public <T> T getSingleValueByIndex(int row, int column, Class<T> javaClass) {
        return javaClass.cast(this.rows[row - 1].getColumnByIndex(column));
    }

    public <T> T getSingleValueByIndex(int row, int column) {
        Class javaClass = this.mappings[column - 1].getJavaClass();
        return javaClass.cast(this.rows[row - 1].getColumnByIndex(column));
    }

    public <T> T getSingleValueByName(int row, String columnName, Class<T> javaClass) {
        int index = this.getColumnIndexByName(columnName);
        return this.getSingleValueByIndex(row, index, javaClass);
    }

    public <T> T getSingleValueByName(int row, String columnName) {
        int index = this.getColumnIndexByName(columnName);
        return this.getSingleValueByIndex(row, index);
    }

    public <T> T[] getColumnByIndex(int column, Class<T> javaClass) {
        Object[] res = (Object[])Array.newInstance(javaClass, this.rows.length);
        for (int i = 0; i < this.rows.length; ++i) {
            res[i] = this.rows[i].getColumnByIndex(column);
        }
        return res;
    }

    public <T> T[] getColumnByIndex(int column) {
        Object[] res = (Object[])Array.newInstance(this.mappings[column - 1].getJavaClass(), this.rows.length);
        for (int i = 0; i < this.rows.length; ++i) {
            res[i] = this.rows[i].getColumnByIndex(column);
        }
        return res;
    }

    public <T> T[] getColumnByName(String columnName, Class<T> javaClass) {
        int index = this.getColumnIndexByName(columnName);
        return this.getColumnByIndex(index, javaClass);
    }

    public <T> T[] getColumnByName(String columnName) {
        int index = this.getColumnIndexByName(columnName);
        return this.getColumnByIndex(index);
    }

    public ListIterator<MonetDBRow> iterator() {
        return Arrays.asList(this.rows).listIterator();
    }
}

