/*
 * Decompiled with CFR 0.152.
 */
package nl.cwi.monetdb.embedded.jdbc;

import java.math.BigDecimal;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Arrays;
import java.util.Calendar;
import nl.cwi.monetdb.embedded.jdbc.EmbeddedProtocol;
import nl.cwi.monetdb.embedded.mapping.NullMappings;
import nl.cwi.monetdb.mcl.protocol.AbstractProtocol;
import nl.cwi.monetdb.mcl.protocol.ProtocolException;
import nl.cwi.monetdb.mcl.responses.AbstractDataBlockResponse;

public strictfp final class EmbeddedDataBlockResponse
extends AbstractDataBlockResponse {
    private long structPointer;
    private boolean isInitialized;

    EmbeddedDataBlockResponse(int rowcount, AbstractProtocol protocol, int[] JdbcSQLTypes) {
        super(rowcount, protocol, JdbcSQLTypes);
    }

    public boolean wantsMore() {
        return !this.isInitialized;
    }

    public void addLines(AbstractProtocol protocol) throws ProtocolException {
        ((EmbeddedProtocol)this.protocol).initializePointers(this);
        this.isInitialized = true;
    }

    private native byte getByteValueInternal(long var1, int var3, int var4);

    private native short getShortValueInternal(long var1, int var3, int var4);

    private native int getIntValueInternal(long var1, int var3, int var4);

    private native long getLongValueInternal(long var1, int var3, int var4);

    private native float getFloatValueInternal(long var1, int var3, int var4);

    private native double getDoubleValueInternal(long var1, int var3, int var4);

    private native String getStringValueInternal(long var1, int var3, int var4);

    private native Date getDateValueInternal(long var1, int var3, int var4);

    private native Timestamp getTimestampValueInternal(long var1, int var3, int var4);

    private native Time getTimeValueInternal(long var1, int var3, int var4);

    private native BigDecimal getDecimalValueInternal(long var1, int var3, int var4);

    private native byte[] getBlobValueInternal(long var1, int var3, int var4);

    private native Calendar getDateAsCalendarValueInternal(long var1, int var3, int var4);

    private native Calendar getTimestampAsCalendarValueInternal(long var1, int var3, int var4);

    private native Calendar getTimeAsCalendarValueInternal(long var1, int var3, int var4);

    public boolean getBooleanValue(int column) {
        byte b = this.getByteValueInternal(this.structPointer, column, this.blockLine);
        if (b == NullMappings.getByteNullConstant()) {
            this.lastReadWasNull = true;
            return false;
        }
        this.lastReadWasNull = false;
        return b == 1;
    }

    public byte getByteValue(int column) {
        byte b = this.getByteValueInternal(this.structPointer, column, this.blockLine);
        this.lastReadWasNull = NullMappings.checkByteIsNull(b);
        return b;
    }

    public short getShortValue(int column) {
        short s = this.getShortValueInternal(this.structPointer, column, this.blockLine);
        this.lastReadWasNull = NullMappings.checkShortIsNull(s);
        return s;
    }

    public int getIntValue(int column) {
        int i = this.getIntValueInternal(this.structPointer, column, this.blockLine);
        this.lastReadWasNull = NullMappings.checkIntIsNull(i);
        return i;
    }

    public long getLongValue(int column) {
        long j = this.getLongValueInternal(this.structPointer, column, this.blockLine);
        this.lastReadWasNull = NullMappings.checkLongIsNull(j);
        return j;
    }

    public float getFloatValue(int column) {
        float f = this.getFloatValueInternal(this.structPointer, column, this.blockLine);
        this.lastReadWasNull = NullMappings.checkFloatIsNull(f);
        return f;
    }

    public double getDoubleValue(int column) {
        double d = this.getDoubleValueInternal(this.structPointer, column, this.blockLine);
        this.lastReadWasNull = NullMappings.checkDoubleIsNull(d);
        return d;
    }

    private Object getJavaPrimitiveAsObject(int column) {
        switch (this.jdbcSQLTypes[column]) {
            case 16: {
                byte b = this.getByteValueInternal(this.structPointer, column, this.blockLine);
                if (b == NullMappings.getByteNullConstant()) {
                    this.lastReadWasNull = true;
                    return null;
                }
                this.lastReadWasNull = false;
                return b == 1;
            }
            case -6: {
                byte bbb = this.getByteValueInternal(this.structPointer, column, this.blockLine);
                if (NullMappings.checkByteIsNull(bbb)) {
                    this.lastReadWasNull = true;
                    return null;
                }
                this.lastReadWasNull = false;
                return bbb;
            }
            case 5: {
                short sss = this.getShortValueInternal(this.structPointer, column, this.blockLine);
                if (NullMappings.checkShortIsNull(sss)) {
                    this.lastReadWasNull = true;
                    return null;
                }
                this.lastReadWasNull = false;
                return sss;
            }
            case 4: {
                int in = this.getIntValueInternal(this.structPointer, column, this.blockLine);
                if (NullMappings.checkIntIsNull(in)) {
                    this.lastReadWasNull = true;
                    return null;
                }
                this.lastReadWasNull = false;
                return in;
            }
            case -5: {
                long lon = this.getLongValueInternal(this.structPointer, column, this.blockLine);
                if (NullMappings.checkLongIsNull(lon)) {
                    this.lastReadWasNull = true;
                    return null;
                }
                this.lastReadWasNull = false;
                return lon;
            }
            case 7: {
                float floa = this.getFloatValueInternal(this.structPointer, column, this.blockLine);
                if (NullMappings.checkFloatIsNull(floa)) {
                    this.lastReadWasNull = true;
                    return null;
                }
                this.lastReadWasNull = false;
                return Float.valueOf(floa);
            }
            case 8: {
                double doa = this.getDoubleValueInternal(this.structPointer, column, this.blockLine);
                if (NullMappings.checkDoubleIsNull(doa)) {
                    this.lastReadWasNull = true;
                    return null;
                }
                this.lastReadWasNull = false;
                return doa;
            }
        }
        return null;
    }

    public Object getValueAsObject(int column) {
        switch (this.jdbcSQLTypes[column]) {
            case -1: 
            case 1: 
            case 12: 
            case 1111: {
                String res = this.getStringValueInternal(this.structPointer, column, this.blockLine);
                this.lastReadWasNull = res == null;
                return res;
            }
            case -4: {
                byte[] bytes = this.getBlobValueInternal(this.structPointer, column, this.blockLine);
                this.lastReadWasNull = bytes == null;
                return bytes;
            }
            case 91: {
                Calendar d = this.getDateAsCalendarValueInternal(this.structPointer, column, this.blockLine);
                this.lastReadWasNull = d == null;
                return d;
            }
            case 92: 
            case 2013: {
                Calendar t = this.getTimeAsCalendarValueInternal(this.structPointer, column, this.blockLine);
                this.lastReadWasNull = t == null;
                return t;
            }
            case 93: 
            case 2014: {
                Calendar tt = this.getTimestampAsCalendarValueInternal(this.structPointer, column, this.blockLine);
                this.lastReadWasNull = tt == null;
                return tt;
            }
            case 3: {
                BigDecimal bb = this.getDecimalValueInternal(this.structPointer, column, this.blockLine);
                this.lastReadWasNull = bb == null;
                return bb;
            }
        }
        return this.getJavaPrimitiveAsObject(column);
    }

    public Object getObjectValue(int column) {
        switch (this.jdbcSQLTypes[column]) {
            case -1: 
            case 1: 
            case 12: 
            case 1111: {
                String res = this.getStringValueInternal(this.structPointer, column, this.blockLine);
                this.lastReadWasNull = res == null;
                return res;
            }
            case -4: {
                byte[] blob = this.getBlobValueInternal(this.structPointer, column, this.blockLine);
                this.lastReadWasNull = blob == null;
                return blob;
            }
            case 91: {
                Date ddd = this.getDateValueInternal(this.structPointer, column, this.blockLine);
                this.lastReadWasNull = ddd == null;
                return ddd;
            }
            case 92: 
            case 2013: {
                Time ty = this.getTimeValueInternal(this.structPointer, column, this.blockLine);
                this.lastReadWasNull = ty == null;
                return ty;
            }
            case 93: 
            case 2014: {
                Timestamp tt = this.getTimestampValueInternal(this.structPointer, column, this.blockLine);
                this.lastReadWasNull = tt == null;
                return tt;
            }
            case 3: {
                BigDecimal bb = this.getDecimalValueInternal(this.structPointer, column, this.blockLine);
                this.lastReadWasNull = bb == null;
                return bb;
            }
        }
        return this.getJavaPrimitiveAsObject(column);
    }

    public String getValueAsString(int column) {
        switch (this.jdbcSQLTypes[column]) {
            case -1: 
            case 1: 
            case 12: 
            case 1111: {
                String res = this.getStringValueInternal(this.structPointer, column, this.blockLine);
                this.lastReadWasNull = res == null;
                return res;
            }
            case -4: {
                byte[] blob = this.getBlobValueInternal(this.structPointer, column, this.blockLine);
                if (blob == null) {
                    this.lastReadWasNull = true;
                    return null;
                }
                this.lastReadWasNull = false;
                return Arrays.toString(blob);
            }
            case 91: {
                Date dd = this.getDateValueInternal(this.structPointer, column, this.blockLine);
                if (dd == null) {
                    this.lastReadWasNull = true;
                    return null;
                }
                this.lastReadWasNull = false;
                return this.protocol.getMonetDate().format(dd);
            }
            case 92: {
                Time tt = this.getTimeValueInternal(this.structPointer, column, this.blockLine);
                if (tt == null) {
                    this.lastReadWasNull = true;
                    return null;
                }
                this.lastReadWasNull = false;
                return this.protocol.getMonetTimePrinter().format(tt);
            }
            case 2013: {
                Time ty = this.getTimeValueInternal(this.structPointer, column, this.blockLine);
                if (ty == null) {
                    this.lastReadWasNull = true;
                    return null;
                }
                this.lastReadWasNull = false;
                return this.protocol.getMonetTimeTzPrinter().format(ty);
            }
            case 93: {
                Timestamp tim = this.getTimestampValueInternal(this.structPointer, column, this.blockLine);
                if (tim == null) {
                    this.lastReadWasNull = true;
                    return null;
                }
                this.lastReadWasNull = false;
                return this.protocol.getMonetTimestampPrinter().format(tim);
            }
            case 2014: {
                Timestamp timy = this.getTimestampValueInternal(this.structPointer, column, this.blockLine);
                if (timy == null) {
                    this.lastReadWasNull = true;
                    return null;
                }
                this.lastReadWasNull = false;
                return this.protocol.getMonetTimestampTzPrinter().format(timy);
            }
            case 3: {
                BigDecimal bd = this.getDecimalValueInternal(this.structPointer, column, this.blockLine);
                if (bd == null) {
                    this.lastReadWasNull = true;
                    return null;
                }
                this.lastReadWasNull = false;
                return bd.toString();
            }
            case 16: {
                byte b = this.getByteValueInternal(this.structPointer, column, this.blockLine);
                if (b == NullMappings.getByteNullConstant()) {
                    this.lastReadWasNull = true;
                    return null;
                }
                this.lastReadWasNull = false;
                return b == 1 ? "true" : "false";
            }
            case -6: {
                byte bbb = this.getByteValueInternal(this.structPointer, column, this.blockLine);
                if (NullMappings.checkByteIsNull(bbb)) {
                    this.lastReadWasNull = true;
                    return null;
                }
                this.lastReadWasNull = false;
                return Byte.toString(bbb);
            }
            case 5: {
                short sss = this.getShortValueInternal(this.structPointer, column, this.blockLine);
                if (NullMappings.checkShortIsNull(sss)) {
                    this.lastReadWasNull = true;
                    return null;
                }
                this.lastReadWasNull = false;
                return Short.toString(sss);
            }
            case 4: {
                int in = this.getIntValueInternal(this.structPointer, column, this.blockLine);
                if (NullMappings.checkIntIsNull(in)) {
                    this.lastReadWasNull = true;
                    return null;
                }
                this.lastReadWasNull = false;
                return Integer.toString(in);
            }
            case -5: {
                long lon = this.getLongValueInternal(this.structPointer, column, this.blockLine);
                if (NullMappings.checkLongIsNull(lon)) {
                    this.lastReadWasNull = true;
                    return null;
                }
                this.lastReadWasNull = false;
                return Long.toString(lon);
            }
            case 7: {
                float floa = this.getFloatValueInternal(this.structPointer, column, this.blockLine);
                if (NullMappings.checkFloatIsNull(floa)) {
                    this.lastReadWasNull = true;
                    return null;
                }
                this.lastReadWasNull = false;
                return Float.toString(floa);
            }
            case 8: {
                double doa = this.getDoubleValueInternal(this.structPointer, column, this.blockLine);
                if (NullMappings.checkDoubleIsNull(doa)) {
                    this.lastReadWasNull = true;
                    return null;
                }
                this.lastReadWasNull = false;
                return Double.toString(doa);
            }
        }
        return null;
    }

    public int getLastNanos() {
        return 0;
    }

    private native void freeResultSet(long var1);

    public void close() {
        if (this.structPointer != 0L && this.isInitialized) {
            this.freeResultSet(this.structPointer);
            this.structPointer = 0L;
        }
    }
}

