/*
 * Decompiled with CFR 0.152.
 */
package nl.cwi.monetdb.embedded.env;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.DigestInputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import java.util.Locale;
import nl.cwi.monetdb.embedded.env.MonetDBEmbeddedException;
import nl.cwi.monetdb.jdbc.MonetDriver;

public final class MonetDBJavaLiteLoader {
    private static String loadedLibraryFullPath = null;
    private static final String tempDirectory = new File(System.getProperty("java.io.tmpdir")).getAbsolutePath();
    private static final String monetDBJDBCDriverString;

    private MonetDBJavaLiteLoader() {
    }

    public static synchronized boolean isNativeLibraryLoaded() {
        return loadedLibraryFullPath != null;
    }

    private static OSLibraries detectRunningOperatingSystemAndLoadLibrary() throws MonetDBEmbeddedException {
        String OS = System.getProperty("os.name", "generic").toLowerCase(Locale.ENGLISH);
        boolean is64bit = OS.contains("win") ? System.getenv("ProgramFiles(x86)") != null : System.getProperty("os.arch").contains("64");
        if (!is64bit) {
            throw new MonetDBEmbeddedException("Currently we only support 64-bit architectures! Sorry! :(");
        }
        if (OS.contains("mac") || OS.contains("darwin")) {
            return OSLibraries.MacOSX;
        }
        if (OS.contains("win")) {
            return OSLibraries.Windows;
        }
        if (OS.contains("nux")) {
            return OSLibraries.Linux;
        }
        throw new MonetDBEmbeddedException("The operating system " + OS + " is currently not supported by MonetDBJavaLite! Sorry! :(");
    }

    private static byte[] makeSHA256Digest(InputStream input) throws MonetDBEmbeddedException {
        try {
            byte[] buffer = new byte[8192];
            MessageDigest md = MessageDigest.getInstance("SHA-256");
            try (DigestInputStream dis = new DigestInputStream(input, md);){
                while (dis.read(buffer) != -1) {
                }
            }
            return md.digest();
        }
        catch (IOException | NoSuchAlgorithmException e) {
            throw new MonetDBEmbeddedException(e);
        }
    }

    private static String loadNativeLibrary(String libraryFilePath, String libraryFileName) {
        File libPath = new File(libraryFilePath, libraryFileName);
        if (libPath.exists()) {
            System.load(new File(libraryFilePath, libraryFileName).getAbsolutePath());
            return libPath.getAbsolutePath();
        }
        return null;
    }

    private static String loadLibraryIntoDirectory(String libraryFilePath, String prefix, String libraryFileName, String destinationDirectory) throws MonetDBEmbeddedException {
        try {
            int bytesRead;
            String nativeLibraryFilePath = libraryFilePath + "/" + libraryFileName;
            String extractedLibFileName = prefix + libraryFileName;
            File extractedLibFile = new File(destinationDirectory, extractedLibFileName);
            if (extractedLibFile.exists()) {
                byte[] digest2;
                byte[] digest1 = MonetDBJavaLiteLoader.makeSHA256Digest(MonetDBJavaLiteLoader.class.getResourceAsStream(nativeLibraryFilePath));
                if (Arrays.equals(digest1, digest2 = MonetDBJavaLiteLoader.makeSHA256Digest(new FileInputStream(extractedLibFile)))) {
                    return MonetDBJavaLiteLoader.loadNativeLibrary(destinationDirectory, extractedLibFileName);
                }
                if (!extractedLibFile.delete()) {
                    throw new IOException("failed to remove existing native library file: " + extractedLibFile.getAbsolutePath());
                }
            }
            InputStream reader = MonetDBJavaLiteLoader.class.getResourceAsStream(nativeLibraryFilePath);
            FileOutputStream writer = new FileOutputStream(extractedLibFile);
            byte[] buffer = new byte[8192];
            while ((bytesRead = reader.read(buffer)) != -1) {
                writer.write(buffer, 0, bytesRead);
            }
            writer.close();
            reader.close();
            return MonetDBJavaLiteLoader.loadNativeLibrary(destinationDirectory, extractedLibFileName);
        }
        catch (IOException ex) {
            throw new MonetDBEmbeddedException(ex);
        }
    }

    static synchronized void loadMonetDBJavaLite() throws MonetDBEmbeddedException {
        if (loadedLibraryFullPath != null) {
            return;
        }
        OSLibraries toLoad = MonetDBJavaLiteLoader.detectRunningOperatingSystemAndLoadLibrary();
        String nativeLibraryPath = toLoad.getLibraryFilePath();
        String nativeLibraryName = toLoad.getLibraryFileName();
        if (MonetDBJavaLiteLoader.class.getResource(nativeLibraryPath + "/" + nativeLibraryName) == null) {
            loadedLibraryFullPath = null;
            throw new MonetDBEmbeddedException("Error while loading library: " + nativeLibraryPath + "/" + nativeLibraryName);
        }
        int ordinalOSEnumValue = toLoad.ordinal();
        if (ordinalOSEnumValue == 0) {
            MonetDBJavaLiteLoader.loadLibraryIntoDirectory(nativeLibraryPath, "", "msvcr100.dll", tempDirectory);
        }
        String prefix = "MonetDBJavaLite-" + monetDBJDBCDriverString + "-";
        loadedLibraryFullPath = MonetDBJavaLiteLoader.loadLibraryIntoDirectory(nativeLibraryPath, prefix, nativeLibraryName, tempDirectory);
    }

    static {
        try {
            Class.forName("nl.cwi.monetdb.jdbc.MonetDriver");
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
            System.err.println("Monet new JDBC driver not found! Please add monetdb-jdbc-new jar to the CLASSPATH");
            System.exit(1);
        }
        monetDBJDBCDriverString = MonetDriver.getDriverMajorVersion() + "-36";
    }

    public static enum OSLibraries {
        Windows("/libs/windows", "libmonetdb5.dll"),
        MacOSX("/libs/macosx", "libmonetdb5.dylib"),
        Linux("/libs/linux", "libmonetdb5.so");

        private final String libraryFilePath;
        private final String libraryFileName;

        private OSLibraries(String libraryFilePath, String libraryFileName) {
            this.libraryFilePath = libraryFilePath;
            this.libraryFileName = libraryFileName;
        }

        public String getLibraryFilePath() {
            return this.libraryFilePath;
        }

        public String getLibraryFileName() {
            return this.libraryFileName;
        }
    }
}

