/*
 * Decompiled with CFR 0.152.
 */
package nl.cwi.monetdb.embedded.tables;

import nl.cwi.monetdb.embedded.env.AbstractConnectionResult;
import nl.cwi.monetdb.embedded.env.MonetDBEmbeddedConnection;
import nl.cwi.monetdb.embedded.env.MonetDBEmbeddedException;
import nl.cwi.monetdb.embedded.mapping.MonetDBRow;
import nl.cwi.monetdb.embedded.mapping.MonetDBToJavaMapping;
import nl.cwi.monetdb.embedded.resultset.QueryResultSet;
import nl.cwi.monetdb.embedded.tables.IMonetDBTableBaseIterator;
import nl.cwi.monetdb.embedded.tables.IMonetDBTableCursor;
import nl.cwi.monetdb.embedded.tables.MonetDBTableColumn;
import nl.cwi.monetdb.embedded.tables.RowIterator;

public final class MonetDBTable
extends AbstractConnectionResult {
    private final String tableSchema;
    private final String tableName;
    private int roundingMode = 6;

    private MonetDBTable(MonetDBEmbeddedConnection connection, String tableSchema, String tableName) {
        super(connection);
        this.tableSchema = tableSchema;
        this.tableName = tableName;
    }

    @Override
    public native int getNumberOfColumns();

    @Override
    public int getNumberOfRows() {
        int res;
        try {
            String query = "SELECT COUNT(*) FROM " + this.getTableSchema() + "." + this.getTableName() + ";";
            QueryResultSet eqr = this.getConnection().executeQuery(query);
            res = (int)eqr.getLongByColumnIndexAndRow(1, 1);
            eqr.close();
        }
        catch (MonetDBEmbeddedException ex) {
            res = -1;
        }
        return res;
    }

    protected native void getColumnNamesInternal(String[] var1);

    protected native void getColumnTypesInternal(String[] var1);

    protected native void getMappingsInternal(MonetDBToJavaMapping[] var1);

    protected native void getColumnDigitsInternal(int[] var1);

    protected native void getColumnScalesInternal(int[] var1);

    protected native void getColumnNullableIndexesInternal(boolean[] var1);

    protected native void getColumnDefaultValuesInternal(String[] var1);

    public String getTableSchema() {
        return this.tableSchema;
    }

    public String getTableName() {
        return this.tableName;
    }

    public int getRoundingMode() {
        return this.roundingMode;
    }

    public void setRoundingMode(int roundingMode) {
        if (roundingMode < 4 || roundingMode > 6) {
            throw new IllegalArgumentException("Unexpected rounding mode!");
        }
        this.roundingMode = roundingMode;
    }

    @Override
    public void getColumnNames(String[] input) throws MonetDBEmbeddedException {
        this.checkMetadataArrayLength(input);
        this.getColumnNamesInternal(input);
    }

    @Override
    public void getColumnTypes(String[] input) throws MonetDBEmbeddedException {
        this.checkMetadataArrayLength(input);
        this.getColumnTypesInternal(input);
    }

    @Override
    public void getMappings(MonetDBToJavaMapping[] input) throws MonetDBEmbeddedException {
        this.checkMetadataArrayLength(input);
        this.getMappingsInternal(input);
    }

    @Override
    public void getColumnDigits(int[] input) throws MonetDBEmbeddedException {
        this.checkMetadataArrayLength(input);
        this.getColumnDigitsInternal(input);
    }

    @Override
    public void getColumnScales(int[] input) throws MonetDBEmbeddedException {
        this.checkMetadataArrayLength(input);
        this.getColumnScalesInternal(input);
    }

    public void getColumnNullableIndexes(boolean[] input) {
        this.checkMetadataArrayLength(input);
        this.getColumnNullableIndexesInternal(input);
    }

    public void getColumnDefaultValues(String[] input) {
        this.checkMetadataArrayLength(input);
        this.getColumnDefaultValuesInternal(input);
    }

    public native MonetDBTableColumn getColumnMetadataByIndex(int var1);

    public native MonetDBTableColumn getColumnMetadataByName(String var1);

    public native MonetDBTableColumn[] getAllColumnsMetadata();

    private int[] prepareIterator(IMonetDBTableBaseIterator iterator) {
        int numberOfRows;
        int[] res = new int[]{iterator.getFirstRowToIterate(), iterator.getLastRowToIterate()};
        if (res[1] < res[0]) {
            res[0] = res[0] ^ res[1];
            res[1] = res[1] ^ res[0];
            res[0] = res[0] ^ res[1];
        }
        if (res[0] < 1) {
            res[0] = 1;
        }
        if (res[1] >= (numberOfRows = this.getNumberOfRows())) {
            res[1] = numberOfRows;
        }
        return res;
    }

    public int iterateTable(IMonetDBTableCursor cursor) throws MonetDBEmbeddedException {
        int[] limits = this.prepareIterator(cursor);
        int res = 0;
        String query = "SELECT * FROM " + this.getTableSchema() + "." + this.getTableName() + " LIMIT " + (limits[1] - limits[0] + 1) + " OFFSET " + (limits[0] - 1) + ";";
        QueryResultSet eqr = this.getConnection().executeQuery(query);
        MonetDBRow[] array = eqr.fetchAllRowValues().getAllRows();
        eqr.close();
        Object[][] data = new Object[eqr.getNumberOfRows()][this.getNumberOfColumns()];
        for (int i = 0; i < eqr.getNumberOfRows(); ++i) {
            data[i] = array[i].getAllColumns();
        }
        RowIterator ri = new RowIterator(this, data, limits[0], limits[1]);
        while (ri.hasMore()) {
            cursor.processNextRow(ri);
            ri.setNextIteration();
            ++res;
        }
        return res;
    }

    public int appendColumns(Object[] input) throws MonetDBEmbeddedException {
        int numberOfColumns = this.getNumberOfColumns();
        if (input.length != numberOfColumns) {
            throw new ArrayStoreException("The number of columns between the input and the table is not consistent!");
        }
        MonetDBToJavaMapping[] mappings = new MonetDBToJavaMapping[numberOfColumns];
        this.getMappings(mappings);
        int[] javaIndexes = new int[numberOfColumns];
        for (int i = 0; i < mappings.length; ++i) {
            javaIndexes[i] = mappings[i].ordinal();
        }
        return this.appendColumnsInternal(input, javaIndexes, this.roundingMode);
    }

    @Override
    protected void closeResultImplementation() {
    }

    private native int appendColumnsInternal(Object[] var1, int[] var2, int var3) throws MonetDBEmbeddedException;
}

