/*
 * Decompiled with CFR 0.152.
 */
package nl.cwi.monetdb.embedded.env;

import java.io.Closeable;
import java.sql.SQLException;
import java.sql.Savepoint;
import java.util.Hashtable;
import nl.cwi.monetdb.embedded.env.AbstractConnectionResult;
import nl.cwi.monetdb.embedded.env.MonetDBEmbeddedDatabase;
import nl.cwi.monetdb.embedded.env.MonetDBEmbeddedException;
import nl.cwi.monetdb.embedded.env.MonetDBEmbeddedPreparedStatement;
import nl.cwi.monetdb.embedded.env.MonetDBEmbeddedSavePoint;
import nl.cwi.monetdb.embedded.resultset.ExecResultSet;
import nl.cwi.monetdb.embedded.resultset.PreparedQueryResultSet;
import nl.cwi.monetdb.embedded.resultset.QueryResultSet;
import nl.cwi.monetdb.embedded.tables.MonetDBTable;
import nl.cwi.monetdb.embedded.utils.Randomizer;
import nl.cwi.monetdb.embedded.utils.StringEscaper;

public class MonetDBEmbeddedConnection
implements Closeable {
    protected volatile long connectionPointer;
    private final long randomIdentifier;
    private final Hashtable<Long, AbstractConnectionResult> results = new Hashtable();

    protected MonetDBEmbeddedConnection(long connectionPointer) {
        this.connectionPointer = connectionPointer;
        this.randomIdentifier = Randomizer.generateNextResultSetId();
    }

    public long getRandomIdentifier() {
        return this.randomIdentifier;
    }

    public boolean isClosed() {
        return this.connectionPointer == 0L;
    }

    private void checkConnectionIsNotClosed() throws MonetDBEmbeddedException {
        if (this.isClosed()) {
            throw new MonetDBEmbeddedException("This connection is already closed!");
        }
    }

    public String getSchema() throws MonetDBEmbeddedException {
        QueryResultSet eqr = this.executeQuery("SELECT current_schema FROM sys.var();");
        String res = eqr.getStringByColumnIndexAndRow(1, 1);
        eqr.close();
        return res;
    }

    public void setSchema(String newSchema) throws MonetDBEmbeddedException {
        newSchema = StringEscaper.sqlStringEscape(newSchema);
        this.executeUpdate("SET SCHEMA " + newSchema + ";");
    }

    public boolean getAutoCommit() throws MonetDBEmbeddedException {
        return this.getAutoCommitInternal(this.connectionPointer);
    }

    public void setAutoCommit(boolean autoCommit) throws MonetDBEmbeddedException {
        this.setAutoCommitInternal(this.connectionPointer, autoCommit);
    }

    public void startTransaction() throws MonetDBEmbeddedException {
        this.executeUpdate("START TRANSACTION;");
    }

    public void commit() throws MonetDBEmbeddedException {
        this.executeUpdate("COMMIT;");
    }

    public void rollback() throws MonetDBEmbeddedException {
        this.executeUpdate("ROLLBACK;");
    }

    public Savepoint setSavepoint() throws MonetDBEmbeddedException {
        MonetDBEmbeddedSavePoint sp = new MonetDBEmbeddedSavePoint();
        this.executeUpdate("SAVEPOINT " + sp.getSavepointName() + ";");
        return sp;
    }

    public Savepoint setSavepoint(String name) throws MonetDBEmbeddedException {
        MonetDBEmbeddedSavePoint sp = new MonetDBEmbeddedSavePoint(name);
        this.executeUpdate("SAVEPOINT " + sp.getSavepointName() + ";");
        return sp;
    }

    public void releaseSavepoint(Savepoint savepoint) throws MonetDBEmbeddedException {
        try {
            this.executeUpdate("RELEASE SAVEPOINT " + savepoint.getSavepointName() + ";");
        }
        catch (SQLException e) {
            throw new MonetDBEmbeddedException(e);
        }
    }

    public void rollback(Savepoint savepoint) throws MonetDBEmbeddedException {
        try {
            this.executeUpdate("ROLLBACK TO SAVEPOINT " + savepoint.getSavepointName() + ";");
        }
        catch (SQLException e) {
            throw new MonetDBEmbeddedException(e);
        }
    }

    public int executeUpdate(String query) throws MonetDBEmbeddedException {
        this.checkConnectionIsNotClosed();
        if (!query.endsWith(";")) {
            query = query + ";";
        }
        return this.sendUpdateInternal(this.connectionPointer, query, true);
    }

    public QueryResultSet executeQuery(String query) throws MonetDBEmbeddedException {
        this.checkConnectionIsNotClosed();
        if (!query.endsWith(";")) {
            query = query + ";";
        }
        QueryResultSet res = this.sendQueryInternal(this.connectionPointer, query, true);
        this.results.put(res.getRandomIdentifier(), res);
        return res;
    }

    public MonetDBEmbeddedPreparedStatement prepareStatement(String query) throws MonetDBEmbeddedException {
        this.checkConnectionIsNotClosed();
        if (!query.endsWith(";")) {
            query = query + ";";
        }
        PreparedQueryResultSet res = this.prepareStatementInternal(this.connectionPointer, "PREPARE " + query, true);
        this.results.put(res.getRandomIdentifier(), res);
        return new MonetDBEmbeddedPreparedStatement(this, res);
    }

    ExecResultSet executePrepareStatement(String query) throws MonetDBEmbeddedException {
        this.checkConnectionIsNotClosed();
        return this.executePrepareStatementInternal(this.connectionPointer, query, true);
    }

    void executePreparedStatementAndIgnore(String query) throws MonetDBEmbeddedException {
        this.checkConnectionIsNotClosed();
        this.executePrepareStatementAndIgnoreInternal(this.connectionPointer, query, true);
    }

    public MonetDBTable getMonetDBTable(String schemaName, String tableName) throws MonetDBEmbeddedException {
        this.checkConnectionIsNotClosed();
        MonetDBTable res = this.getMonetDBTableInternal(this.connectionPointer, schemaName, tableName);
        this.results.put(res.getRandomIdentifier(), res);
        return res;
    }

    public MonetDBTable getMonetDBTable(String tableName) throws MonetDBEmbeddedException {
        this.checkConnectionIsNotClosed();
        String schemaName = this.getSchema();
        MonetDBTable res = this.getMonetDBTableInternal(this.connectionPointer, schemaName, tableName);
        this.results.put(res.getRandomIdentifier(), res);
        return res;
    }

    public QueryResultSet listTables(boolean listSystemTables) throws MonetDBEmbeddedException {
        this.checkConnectionIsNotClosed();
        String query = "select schemas.name as sn, tables.name as tn from sys.tables join sys.schemas on tables.schema_id=schemas.id";
        if (!listSystemTables) {
            query = query + " where tables.system=false order by sn, tn";
        }
        return this.executeQuery(query + ";");
    }

    public boolean checkIfTableExists(String schemaName, String tableName) throws MonetDBEmbeddedException {
        this.checkConnectionIsNotClosed();
        schemaName = StringEscaper.sqlStringEscape(schemaName);
        tableName = StringEscaper.sqlStringEscape(tableName);
        String query = "select schemas.name as sn, tables.name as tn from sys.tables join sys.schemas on sys.tables.schema_id=schemas.id where tables.system=true order by sn, tn and schemas.name ='" + schemaName + "' and tables.name ='" + tableName + "';";
        QueryResultSet eqr = this.executeQuery(query);
        eqr.close();
        return eqr.getNumberOfRows() > 0;
    }

    public void removeTable(String schemaName, String tableName) throws MonetDBEmbeddedException {
        this.checkConnectionIsNotClosed();
        schemaName = StringEscaper.sqlStringEscape(schemaName);
        tableName = StringEscaper.sqlStringEscape(tableName);
        String query = "drop table " + schemaName + "." + tableName + ";";
        this.executeUpdate(query);
    }

    protected void closeConnectionImplementation() {
        for (AbstractConnectionResult res : this.results.values()) {
            res.closeResultImplementation();
        }
        this.results.clear();
        if (!this.isClosed()) {
            this.closeConnectionInternal(this.connectionPointer);
            this.connectionPointer = 0L;
        }
    }

    public String toString() {
        return "MonetDB EmbeddedConnection " + (this.isClosed() ? "disconnected" : "connected");
    }

    @Override
    public void close() {
        if (!this.isClosed()) {
            this.closeConnectionImplementation();
            MonetDBEmbeddedDatabase.removeConnection(this, false);
        }
    }

    protected void finalize() throws Throwable {
        this.close();
        super.finalize();
    }

    void removeQueryResult(AbstractConnectionResult res) {
        this.results.remove(res.getRandomIdentifier());
    }

    private native boolean getAutoCommitInternal(long var1) throws MonetDBEmbeddedException;

    private native void setAutoCommitInternal(long var1, boolean var3) throws MonetDBEmbeddedException;

    private native int sendUpdateInternal(long var1, String var3, boolean var4) throws MonetDBEmbeddedException;

    private native QueryResultSet sendQueryInternal(long var1, String var3, boolean var4) throws MonetDBEmbeddedException;

    private native PreparedQueryResultSet prepareStatementInternal(long var1, String var3, boolean var4) throws MonetDBEmbeddedException;

    private native ExecResultSet executePrepareStatementInternal(long var1, String var3, boolean var4) throws MonetDBEmbeddedException;

    private native void executePrepareStatementAndIgnoreInternal(long var1, String var3, boolean var4) throws MonetDBEmbeddedException;

    private native MonetDBTable getMonetDBTableInternal(long var1, String var3, String var4) throws MonetDBEmbeddedException;

    private native void closeConnectionInternal(long var1);
}

