/*
 * Decompiled with CFR 0.152.
 */
package nl.cwi.monetdb.embedded.env;

import java.util.HashMap;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import nl.cwi.monetdb.embedded.env.MonetDBEmbeddedConnection;
import nl.cwi.monetdb.embedded.env.MonetDBEmbeddedException;
import nl.cwi.monetdb.embedded.env.MonetDBJavaLiteLoader;
import nl.cwi.monetdb.embedded.jdbc.JDBCEmbeddedConnection;

public final class MonetDBEmbeddedDatabase {
    private static MonetDBEmbeddedDatabase monetDBEmbeddedDatabase = null;
    private static final MonetDBEmbeddedHook MonetDBHook;
    private static final long MonetDBHookID;
    private static volatile boolean isClosed;
    private static final ReentrantReadWriteLock locker;
    private final String databaseDirectory;
    private final boolean silentFlag;
    private final boolean sequentialFlag;
    private final HashMap<Long, MonetDBEmbeddedConnection> connections = new HashMap();

    public static boolean isDatabaseRunning() {
        locker.readLock().lock();
        boolean res = !isClosed;
        locker.readLock().unlock();
        return res;
    }

    public static boolean isDatabaseRunningInMemory() throws MonetDBEmbeddedException {
        locker.readLock().lock();
        try {
            if (monetDBEmbeddedDatabase == null) {
                throw new MonetDBEmbeddedException("The MonetDB Embedded database is not running!");
            }
            boolean res = MonetDBEmbeddedDatabase.monetDBEmbeddedDatabase.databaseDirectory == null;
            locker.readLock().unlock();
            return res;
        }
        catch (Exception ex) {
            locker.readLock().unlock();
            throw ex;
        }
    }

    public static void startDatabase(String dbDirectory, boolean silentFlag, boolean sequentialFlag) throws MonetDBEmbeddedException {
        if (dbDirectory != null && (dbDirectory.trim().isEmpty() || dbDirectory.equals(":memory:"))) {
            dbDirectory = null;
        }
        locker.writeLock().lock();
        try {
            if (monetDBEmbeddedDatabase != null) {
                throw new MonetDBEmbeddedException("The MonetDB Embedded database is still running!");
            }
            MonetDBJavaLiteLoader.loadMonetDBJavaLite();
            monetDBEmbeddedDatabase = MonetDBEmbeddedDatabase.startDatabaseInternal(dbDirectory, silentFlag, sequentialFlag);
            isClosed = false;
            locker.writeLock().unlock();
        }
        catch (Exception ex) {
            locker.writeLock().unlock();
            throw ex;
        }
    }

    public static void startDatabase(String dbDirectory) throws MonetDBEmbeddedException {
        MonetDBEmbeddedDatabase.startDatabase(dbDirectory, true, false);
    }

    public static String getDatabaseDirectory() throws MonetDBEmbeddedException {
        locker.readLock().lock();
        try {
            if (monetDBEmbeddedDatabase == null) {
                throw new MonetDBEmbeddedException("The MonetDB Embedded database is not running!");
            }
            String res = MonetDBEmbeddedDatabase.monetDBEmbeddedDatabase.databaseDirectory;
            locker.readLock().unlock();
            return res;
        }
        catch (Exception ex) {
            locker.readLock().unlock();
            throw ex;
        }
    }

    public static int getNumberOfConnections() throws MonetDBEmbeddedException {
        locker.readLock().lock();
        try {
            if (monetDBEmbeddedDatabase == null) {
                throw new MonetDBEmbeddedException("The MonetDB Embedded database is not running!");
            }
            int res = MonetDBEmbeddedDatabase.monetDBEmbeddedDatabase.connections.size();
            locker.readLock().unlock();
            return res;
        }
        catch (Exception ex) {
            locker.readLock().unlock();
            throw ex;
        }
    }

    public static boolean isSilentFlagSet() throws MonetDBEmbeddedException {
        locker.readLock().lock();
        try {
            if (monetDBEmbeddedDatabase == null) {
                throw new MonetDBEmbeddedException("The MonetDB Embedded database is not running!");
            }
            boolean res = MonetDBEmbeddedDatabase.monetDBEmbeddedDatabase.silentFlag;
            locker.readLock().unlock();
            return res;
        }
        catch (Exception ex) {
            locker.readLock().unlock();
            throw ex;
        }
    }

    public static boolean isSequentialFlagSet() throws MonetDBEmbeddedException {
        locker.readLock().lock();
        try {
            if (monetDBEmbeddedDatabase == null) {
                throw new MonetDBEmbeddedException("The MonetDB Embedded database is not running!");
            }
            boolean res = MonetDBEmbeddedDatabase.monetDBEmbeddedDatabase.sequentialFlag;
            locker.readLock().unlock();
            return res;
        }
        catch (Exception ex) {
            locker.readLock().unlock();
            throw ex;
        }
    }

    public static void stopDatabase() throws MonetDBEmbeddedException {
        long currentID = Thread.currentThread().getId();
        if (currentID != MonetDBHookID) {
            locker.writeLock().lock();
        }
        try {
            if (monetDBEmbeddedDatabase == null) {
                throw new MonetDBEmbeddedException("The MonetDB Embedded database is not running!");
            }
            for (MonetDBEmbeddedConnection mdbec : MonetDBEmbeddedDatabase.monetDBEmbeddedDatabase.connections.values()) {
                if (mdbec.isClosed()) continue;
                mdbec.closeConnectionImplementation();
            }
            MonetDBEmbeddedDatabase.monetDBEmbeddedDatabase.connections.clear();
            monetDBEmbeddedDatabase.stopDatabaseInternal();
            monetDBEmbeddedDatabase = null;
            isClosed = true;
            if (currentID != MonetDBHookID) {
                locker.writeLock().unlock();
            }
        }
        catch (Exception ex) {
            if (currentID != MonetDBHookID) {
                locker.writeLock().unlock();
            }
            throw ex;
        }
    }

    public static MonetDBEmbeddedConnection createConnection() throws MonetDBEmbeddedException {
        locker.writeLock().lock();
        try {
            if (monetDBEmbeddedDatabase == null) {
                throw new MonetDBEmbeddedException("The MonetDB Embedded database is not running!");
            }
            MonetDBEmbeddedConnection con = monetDBEmbeddedDatabase.createConnectionInternal();
            MonetDBEmbeddedDatabase.monetDBEmbeddedDatabase.connections.put(con.getRandomIdentifier(), con);
            locker.writeLock().unlock();
            return con;
        }
        catch (Exception ex) {
            locker.writeLock().unlock();
            throw ex;
        }
    }

    public static JDBCEmbeddedConnection createJDBCEmbeddedConnection(String directory) throws MonetDBEmbeddedException {
        if (directory != null && (directory.trim().isEmpty() || directory.equals(":memory:"))) {
            directory = null;
        }
        locker.writeLock().lock();
        try {
            if (monetDBEmbeddedDatabase != null) {
                if (MonetDBEmbeddedDatabase.monetDBEmbeddedDatabase.databaseDirectory == null && directory != null) {
                    throw new MonetDBEmbeddedException("The embedded database is already running in memory!");
                }
                if (MonetDBEmbeddedDatabase.monetDBEmbeddedDatabase.databaseDirectory != null && directory == null) {
                    throw new MonetDBEmbeddedException("The embedded database is already running in a directory!");
                }
                if (MonetDBEmbeddedDatabase.monetDBEmbeddedDatabase.databaseDirectory != null && !MonetDBEmbeddedDatabase.monetDBEmbeddedDatabase.databaseDirectory.equals(directory)) {
                    throw new MonetDBEmbeddedException("The embedded database is already running in a different directory!");
                }
            }
            if (monetDBEmbeddedDatabase == null) {
                MonetDBJavaLiteLoader.loadMonetDBJavaLite();
                monetDBEmbeddedDatabase = MonetDBEmbeddedDatabase.startDatabaseInternal(directory, true, false);
            }
            JDBCEmbeddedConnection con = monetDBEmbeddedDatabase.createJDBCEmbeddedConnectionInternal();
            MonetDBEmbeddedDatabase.monetDBEmbeddedDatabase.connections.put(con.getRandomIdentifier(), con);
            locker.writeLock().unlock();
            return con;
        }
        catch (Exception ex) {
            locker.writeLock().unlock();
            throw ex;
        }
    }

    public static void removeConnection(MonetDBEmbeddedConnection con, boolean toShutDown) {
        locker.writeLock().lock();
        MonetDBEmbeddedDatabase.monetDBEmbeddedDatabase.connections.remove(con.getRandomIdentifier());
        if (toShutDown && MonetDBEmbeddedDatabase.monetDBEmbeddedDatabase.connections.isEmpty()) {
            monetDBEmbeddedDatabase.stopDatabaseInternal();
            monetDBEmbeddedDatabase = null;
            isClosed = true;
        }
        locker.writeLock().unlock();
    }

    private MonetDBEmbeddedDatabase(String dbDirectory, boolean silentFlag, boolean sequentialFlag) {
        this.databaseDirectory = dbDirectory;
        this.silentFlag = silentFlag;
        this.sequentialFlag = sequentialFlag;
    }

    protected void finalize() throws Throwable {
        if (!isClosed) {
            this.stopDatabaseInternal();
            isClosed = true;
        }
        super.finalize();
    }

    private static native MonetDBEmbeddedDatabase startDatabaseInternal(String var0, boolean var1, boolean var2) throws MonetDBEmbeddedException;

    private native void stopDatabaseInternal();

    private native MonetDBEmbeddedConnection createConnectionInternal() throws MonetDBEmbeddedException;

    private native JDBCEmbeddedConnection createJDBCEmbeddedConnectionInternal() throws MonetDBEmbeddedException;

    static {
        isClosed = true;
        locker = new ReentrantReadWriteLock();
        MonetDBHook = new MonetDBEmbeddedHook();
        MonetDBHookID = MonetDBHook.getId();
        Runtime.getRuntime().addShutdownHook(MonetDBHook);
    }

    private static class MonetDBEmbeddedHook
    extends Thread {
        private MonetDBEmbeddedHook() {
        }

        @Override
        public void run() {
            try {
                MonetDBEmbeddedDatabase.stopDatabase();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

