/*
 * Decompiled with CFR 0.152.
 */
package nl.cwi.monetdb.embedded.jdbc;

import java.io.IOException;
import java.sql.SQLException;
import java.util.List;
import java.util.Properties;
import nl.cwi.monetdb.embedded.env.MonetDBEmbeddedConnection;
import nl.cwi.monetdb.embedded.env.MonetDBEmbeddedDatabase;
import nl.cwi.monetdb.embedded.env.MonetDBEmbeddedException;
import nl.cwi.monetdb.embedded.jdbc.EmbeddedLanguage;
import nl.cwi.monetdb.embedded.jdbc.EmbeddedProtocol;
import nl.cwi.monetdb.jdbc.MonetConnection;
import nl.cwi.monetdb.mcl.connection.IMonetDBLanguage;
import nl.cwi.monetdb.mcl.connection.MCLException;
import nl.cwi.monetdb.mcl.protocol.ProtocolException;

public final class EmbeddedConnection
extends MonetConnection {
    private final String directory;

    public EmbeddedConnection(Properties props, String hash, String language, String directory) throws IOException {
        super(props, hash, (IMonetDBLanguage)EmbeddedLanguage.GetLanguageFromString(language), true, true);
        this.directory = directory;
    }

    public String getDirectory() {
        return this.directory;
    }

    public MonetDBEmbeddedConnection getAsMonetDBEmbeddedConnection() {
        return ((EmbeddedProtocol)this.protocol).getEmbeddedConnection();
    }

    public List<String> connect(String user, String pass) throws IOException, ProtocolException, MCLException {
        try {
            this.protocol = new EmbeddedProtocol(MonetDBEmbeddedDatabase.createJDBCEmbeddedConnection(this.directory));
        }
        catch (MonetDBEmbeddedException ex) {
            throw new MCLException((Throwable)ex);
        }
        return null;
    }

    public String getJDBCURL() {
        return "jdbc:monetdb:embedded:" + this.directory;
    }

    public int getBlockSize() {
        return Integer.MAX_VALUE;
    }

    public int getDefFetchsize() {
        return Integer.MAX_VALUE;
    }

    public int initialStringBuilderSize() {
        return 0x3FFFFFFF;
    }

    public int getSoTimeout() {
        this.addWarning("Cannot get a timeout on a embedded connection!", "M1M05");
        return -1;
    }

    public void setSoTimeout(int timeout) {
        this.addWarning("Cannot set a timeout on a embedded connection!", "M1M05");
    }

    public synchronized void closeUnderlyingConnection() throws IOException {
        ((EmbeddedProtocol)this.protocol).getEmbeddedConnection().close();
    }

    public void sendControlCommand(int commandID, int data) throws SQLException {
        switch (commandID) {
            case 1: {
                ((EmbeddedProtocol)this.protocol).getEmbeddedConnection().sendAutocommitCommand(data);
                break;
            }
            case 3: {
                ((EmbeddedProtocol)this.protocol).getEmbeddedConnection().sendReleaseCommand(data);
                break;
            }
            case 4: {
                ((EmbeddedProtocol)this.protocol).getEmbeddedConnection().sendCloseCommand(data);
                break;
            }
            case 2: {
                ((EmbeddedProtocol)this.protocol).getEmbeddedConnection().sendReplySizeCommand(data);
            }
        }
    }
}

