/*
 * Decompiled with CFR 0.152.
 */
package nl.cwi.monetdb.embedded.env;

import java.sql.Savepoint;
import java.util.concurrent.atomic.AtomicInteger;
import nl.cwi.monetdb.embedded.env.MonetDBEmbeddedException;

public class MonetDBEmbeddedSavePoint
implements Savepoint {
    private static final AtomicInteger SavepointCounter = new AtomicInteger();
    private final String name;
    private final int id;

    private static int getNextId() {
        return SavepointCounter.incrementAndGet();
    }

    private static int getHighestId() {
        return SavepointCounter.get();
    }

    public MonetDBEmbeddedSavePoint(String name) throws IllegalArgumentException {
        if (name == null) {
            throw new IllegalArgumentException("Null name not allowed");
        }
        this.id = MonetDBEmbeddedSavePoint.getNextId();
        this.name = name;
    }

    public MonetDBEmbeddedSavePoint() {
        this.id = MonetDBEmbeddedSavePoint.getNextId();
        this.name = null;
    }

    private int getId() {
        return this.id;
    }

    String getName() {
        return "MonetDBSP" + this.id;
    }

    @Override
    public int getSavepointId() throws MonetDBEmbeddedException {
        if (this.name != null) {
            throw new MonetDBEmbeddedException("Cannot getID for named savepoint");
        }
        return this.getId();
    }

    @Override
    public String getSavepointName() throws MonetDBEmbeddedException {
        if (this.name == null) {
            throw new MonetDBEmbeddedException("Unable to retrieve name of unnamed savepoint");
        }
        return this.name;
    }
}

