/*
 * Decompiled with CFR 0.152.
 */
package com.mockobjects.io;

import com.mockobjects.ExpectationCounter;
import com.mockobjects.ExpectationValue;
import com.mockobjects.Verifiable;
import com.mockobjects.util.Verifier;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public class MockOutputStream
extends OutputStream
implements Verifiable {
    private ExpectationValue myWriteWasCalled = new ExpectationValue("MockOutputStream.writeWasCalled");
    private ExpectationCounter myCloseCalls = new ExpectationCounter("MockOutputStream.close()");
    private ByteArrayOutputStream myBuffer = new ByteArrayOutputStream();
    private boolean shouldThrowException = false;

    public void clearActualBuffer() {
        this.myBuffer = new ByteArrayOutputStream();
    }

    public void close() throws IOException {
        this.myCloseCalls.inc();
    }

    public String getContents() {
        return this.myBuffer.toString();
    }

    public byte[] getContentsAsByteArray() {
        return this.myBuffer.toByteArray();
    }

    public void setExpectedCloseCalls(int closeCall) {
        this.myCloseCalls.setExpected(closeCall);
    }

    public void setExpectingWriteCalls(boolean expectingWriteCall) {
        this.myWriteWasCalled.setExpected(expectingWriteCall);
    }

    public void setupThrowIOException(boolean throwException) {
        this.shouldThrowException = throwException;
    }

    public void verify() {
        Verifier.verifyObject((Object)this);
    }

    public void write(int b) throws IOException {
        this.myWriteWasCalled.setActual(true);
        if (this.shouldThrowException) {
            throw new IOException("Test IOException generated by request");
        }
        this.myBuffer.write(b);
    }
}

