/*
 * Decompiled with CFR 0.152.
 */
package com.mockobjects.sql;

import com.mockobjects.ExpectationCounter;
import com.mockobjects.MockObject;
import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Map;

public abstract class MockResultSet
extends MockObject
implements ResultSet {
    private ExpectationCounter myCloseCalls = new ExpectationCounter("MockResultSet.close");
    protected ExpectationCounter myNextCalls = new ExpectationCounter("MockResultSet.next");
    private ResultSetMetaData myMetaData;
    private Statement myStatement;

    public void setExpectedCloseCalls(int calls) {
        this.myCloseCalls.setExpected(calls);
    }

    public void setExpectedNextCalls(int calls) {
        this.myNextCalls.setExpected(calls);
    }

    public void setupMetaData(ResultSetMetaData metaData) {
        this.myMetaData = metaData;
    }

    public void setupStatement(Statement statement) {
        this.myStatement = statement;
    }

    public abstract Object getObject(int var1) throws SQLException;

    public abstract Object getObject(String var1) throws SQLException;

    public abstract boolean next() throws SQLException;

    public abstract int getRow() throws SQLException;

    public void close() throws SQLException {
        this.myCloseCalls.inc();
    }

    public Array getArray(int i) throws SQLException {
        return (Array)this.getObject(i);
    }

    public Array getArray(String colName) throws SQLException {
        return (Array)this.getObject(colName);
    }

    public InputStream getAsciiStream(int columnIndex) throws SQLException {
        return (InputStream)this.getObject(columnIndex);
    }

    public InputStream getAsciiStream(String columnName) throws SQLException {
        return (InputStream)this.getObject(columnName);
    }

    public BigDecimal getBigDecimal(String columnName, int scale) throws SQLException {
        return this.getBigDecimal(columnName);
    }

    public BigDecimal getBigDecimal(int columnIndex) throws SQLException {
        return (BigDecimal)this.getObject(columnIndex);
    }

    public BigDecimal getBigDecimal(int columnIndex, int scale) throws SQLException {
        return (BigDecimal)this.getObject(columnIndex);
    }

    public BigDecimal getBigDecimal(String columnName) throws SQLException {
        return (BigDecimal)this.getObject(columnName);
    }

    public InputStream getBinaryStream(int columnIndex) throws SQLException {
        return (InputStream)this.getObject(columnIndex);
    }

    public InputStream getBinaryStream(String columnName) throws SQLException {
        return (InputStream)this.getObject(columnName);
    }

    public Blob getBlob(int i) throws SQLException {
        return (Blob)this.getObject(i);
    }

    public Blob getBlob(String colName) throws SQLException {
        return (Blob)this.getObject(colName);
    }

    public boolean getBoolean(int columnIndex) throws SQLException {
        return (Boolean)this.getObject(columnIndex);
    }

    public boolean getBoolean(String columnName) throws SQLException {
        return (Boolean)this.getObject(columnName);
    }

    public byte getByte(int columnIndex) throws SQLException {
        return (Byte)this.getObject(columnIndex);
    }

    public byte getByte(String columnName) throws SQLException {
        return (Byte)this.getObject(columnName);
    }

    public byte[] getBytes(int columnIndex) throws SQLException {
        return (byte[])this.getObject(columnIndex);
    }

    public byte[] getBytes(String columnName) throws SQLException {
        return (byte[])this.getObject(columnName);
    }

    public Reader getCharacterStream(int columnIndex) throws SQLException {
        return (Reader)this.getObject(columnIndex);
    }

    public Reader getCharacterStream(String columnName) throws SQLException {
        return (Reader)this.getObject(columnName);
    }

    public Clob getClob(int i) throws SQLException {
        return (Clob)this.getObject(i);
    }

    public Clob getClob(String colName) throws SQLException {
        return (Clob)this.getObject(colName);
    }

    public Date getDate(int columnIndex) throws SQLException {
        return (Date)this.getObject(columnIndex);
    }

    public Date getDate(String columnName) throws SQLException {
        return (Date)this.getObject(columnName);
    }

    public Date getDate(int columnIndex, Calendar cal) throws SQLException {
        return this.getDate(columnIndex);
    }

    public Date getDate(String columnName, Calendar cal) throws SQLException {
        return this.getDate(columnName);
    }

    public double getDouble(int columnIndex) throws SQLException {
        return (Double)this.getObject(columnIndex);
    }

    public double getDouble(String columnName) throws SQLException {
        return (Double)this.getObject(columnName);
    }

    public float getFloat(int columnIndex) throws SQLException {
        return ((Float)this.getObject(columnIndex)).floatValue();
    }

    public float getFloat(String columnName) throws SQLException {
        return ((Float)this.getObject(columnName)).floatValue();
    }

    public int getInt(int columnIndex) throws SQLException {
        return (Integer)this.getObject(columnIndex);
    }

    public int getInt(String columnName) throws SQLException {
        return (Integer)this.getObject(columnName);
    }

    public long getLong(int columnIndex) throws SQLException {
        return (Long)this.getObject(columnIndex);
    }

    public long getLong(String columnName) throws SQLException {
        return (Long)this.getObject(columnName);
    }

    public ResultSetMetaData getMetaData() throws SQLException {
        return this.myMetaData;
    }

    public Ref getRef(int i) throws SQLException {
        return (Ref)this.getObject(i);
    }

    public Ref getRef(String colName) throws SQLException {
        return (Ref)this.getObject(colName);
    }

    public short getShort(String columnName) throws SQLException {
        return (Short)this.getObject(columnName);
    }

    public short getShort(int columnIndex) throws SQLException {
        return (Short)this.getObject(columnIndex);
    }

    public Statement getStatement() throws SQLException {
        return this.myStatement;
    }

    public String getString(int columnIndex) throws SQLException {
        return (String)this.getObject(columnIndex);
    }

    public String getString(String columnName) throws SQLException {
        return (String)this.getObject(columnName);
    }

    public Time getTime(int columnIndex) throws SQLException {
        return (Time)this.getObject(columnIndex);
    }

    public Time getTime(String columnName) throws SQLException {
        return (Time)this.getObject(columnName);
    }

    public Time getTime(int columnIndex, Calendar cal) throws SQLException {
        return this.getTime(columnIndex);
    }

    public Time getTime(String columnName, Calendar cal) throws SQLException {
        return this.getTime(columnName);
    }

    public Timestamp getTimestamp(int columnIndex) throws SQLException {
        return (Timestamp)this.getObject(columnIndex);
    }

    public Timestamp getTimestamp(String columnName) throws SQLException {
        return (Timestamp)this.getObject(columnName);
    }

    public Timestamp getTimestamp(int columnIndex, Calendar cal) throws SQLException {
        return this.getTimestamp(columnIndex);
    }

    public Timestamp getTimestamp(String columnName, Calendar cal) throws SQLException {
        return this.getTimestamp(columnName);
    }

    public InputStream getUnicodeStream(int columnIndex) throws SQLException {
        return (InputStream)this.getObject(columnIndex);
    }

    public InputStream getUnicodeStream(String columnName) throws SQLException {
        return (InputStream)this.getObject(columnName);
    }

    public String getCursorName() throws SQLException {
        this.notImplemented();
        return null;
    }

    public int getConcurrency() throws SQLException {
        this.notImplemented();
        return 0;
    }

    public int getFetchDirection() throws SQLException {
        this.notImplemented();
        return 0;
    }

    public int getFetchSize() throws SQLException {
        this.notImplemented();
        return 0;
    }

    public Object getObject(int i, Map map) throws SQLException {
        this.notImplemented();
        return null;
    }

    public Object getObject(String colName, Map map) throws SQLException {
        this.notImplemented();
        return null;
    }

    public int getType() throws SQLException {
        this.notImplemented();
        return 0;
    }

    public SQLWarning getWarnings() throws SQLException {
        this.notImplemented();
        return null;
    }

    public void clearWarnings() throws SQLException {
        this.notImplemented();
    }

    public int findColumn(String columnName) throws SQLException {
        this.notImplemented();
        return 0;
    }

    public boolean isBeforeFirst() throws SQLException {
        this.notImplemented();
        return false;
    }

    public boolean isAfterLast() throws SQLException {
        this.notImplemented();
        return false;
    }

    public boolean isFirst() throws SQLException {
        this.notImplemented();
        return false;
    }

    public boolean isLast() throws SQLException {
        this.notImplemented();
        return false;
    }

    public void beforeFirst() throws SQLException {
        this.notImplemented();
    }

    public void afterLast() throws SQLException {
        this.notImplemented();
    }

    public boolean first() throws SQLException {
        this.notImplemented();
        return false;
    }

    public boolean last() throws SQLException {
        this.notImplemented();
        return false;
    }

    public boolean absolute(int row) throws SQLException {
        this.notImplemented();
        return false;
    }

    public boolean relative(int rows) throws SQLException {
        this.notImplemented();
        return false;
    }

    public boolean previous() throws SQLException {
        this.notImplemented();
        return false;
    }

    public void setFetchDirection(int direction) throws SQLException {
        this.notImplemented();
    }

    public void setFetchSize(int rows) throws SQLException {
        this.notImplemented();
    }

    public boolean rowUpdated() throws SQLException {
        this.notImplemented();
        return false;
    }

    public boolean rowInserted() throws SQLException {
        this.notImplemented();
        return false;
    }

    public boolean rowDeleted() throws SQLException {
        this.notImplemented();
        return false;
    }

    public void updateNull(int columnIndex) throws SQLException {
        this.notImplemented();
    }

    public void updateBoolean(int columnIndex, boolean x) throws SQLException {
        this.notImplemented();
    }

    public void updateByte(int columnIndex, byte x) throws SQLException {
        this.notImplemented();
    }

    public void updateShort(int columnIndex, short x) throws SQLException {
        this.notImplemented();
    }

    public void updateInt(int columnIndex, int x) throws SQLException {
        this.notImplemented();
    }

    public void updateLong(int columnIndex, long x) throws SQLException {
        this.notImplemented();
    }

    public void updateFloat(int columnIndex, float x) throws SQLException {
        this.notImplemented();
    }

    public void updateDouble(int columnIndex, double x) throws SQLException {
        this.notImplemented();
    }

    public void updateBigDecimal(int columnIndex, BigDecimal x) throws SQLException {
        this.notImplemented();
    }

    public void updateString(int columnIndex, String x) throws SQLException {
        this.notImplemented();
    }

    public void updateBytes(int columnIndex, byte[] x) throws SQLException {
        this.notImplemented();
    }

    public void updateDate(int columnIndex, Date x) throws SQLException {
        this.notImplemented();
    }

    public void updateTime(int columnIndex, Time x) throws SQLException {
        this.notImplemented();
    }

    public void updateTimestamp(int columnIndex, Timestamp x) throws SQLException {
        this.notImplemented();
    }

    public void updateAsciiStream(int columnIndex, InputStream x, int length) throws SQLException {
        this.notImplemented();
    }

    public void updateBinaryStream(int columnIndex, InputStream x, int length) throws SQLException {
        this.notImplemented();
    }

    public void updateCharacterStream(int columnIndex, Reader x, int length) throws SQLException {
        this.notImplemented();
    }

    public void updateObject(int columnIndex, Object x, int scale) throws SQLException {
        this.notImplemented();
    }

    public void updateObject(int columnIndex, Object x) throws SQLException {
        this.notImplemented();
    }

    public void updateNull(String columnName) throws SQLException {
        this.notImplemented();
    }

    public void updateBoolean(String columnName, boolean x) throws SQLException {
        this.notImplemented();
    }

    public void updateByte(String columnName, byte x) throws SQLException {
        this.notImplemented();
    }

    public void updateShort(String columnName, short x) throws SQLException {
        this.notImplemented();
    }

    public void updateInt(String columnName, int x) throws SQLException {
        this.notImplemented();
    }

    public void updateLong(String columnName, long x) throws SQLException {
        this.notImplemented();
    }

    public void updateFloat(String columnName, float x) throws SQLException {
        this.notImplemented();
    }

    public void updateDouble(String columnName, double x) throws SQLException {
        this.notImplemented();
    }

    public void updateBigDecimal(String columnName, BigDecimal x) throws SQLException {
        this.notImplemented();
    }

    public void updateString(String columnName, String x) throws SQLException {
        this.notImplemented();
    }

    public void updateBytes(String columnName, byte[] x) throws SQLException {
        this.notImplemented();
    }

    public void updateDate(String columnName, Date x) throws SQLException {
        this.notImplemented();
    }

    public void updateTime(String columnName, Time x) throws SQLException {
        this.notImplemented();
    }

    public void updateTimestamp(String columnName, Timestamp x) throws SQLException {
        this.notImplemented();
    }

    public void updateAsciiStream(String columnName, InputStream x, int length) throws SQLException {
        this.notImplemented();
    }

    public void updateBinaryStream(String columnName, InputStream x, int length) throws SQLException {
        this.notImplemented();
    }

    public void updateCharacterStream(String columnName, Reader reader, int length) throws SQLException {
        this.notImplemented();
    }

    public void updateObject(String columnName, Object x, int scale) throws SQLException {
        this.notImplemented();
    }

    public void updateObject(String columnName, Object x) throws SQLException {
        this.notImplemented();
    }

    public void insertRow() throws SQLException {
        this.notImplemented();
    }

    public void updateRow() throws SQLException {
        this.notImplemented();
    }

    public void deleteRow() throws SQLException {
        this.notImplemented();
    }

    public void refreshRow() throws SQLException {
        this.notImplemented();
    }

    public void cancelRowUpdates() throws SQLException {
        this.notImplemented();
    }

    public void moveToInsertRow() throws SQLException {
        this.notImplemented();
    }

    public void moveToCurrentRow() throws SQLException {
        this.notImplemented();
    }

    public boolean wasNull() throws SQLException {
        this.notImplemented();
        return false;
    }
}

