/*
 * Decompiled with CFR 0.152.
 */
package com.mockobjects.sql;

import com.mockobjects.ExpectationCollection;
import com.mockobjects.ExpectationCounter;
import com.mockobjects.ExpectationList;
import com.mockobjects.ExpectationValue;
import com.mockobjects.MockObject;
import com.mockobjects.ReturnObjectList;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.util.Map;

public abstract class CommonMockConnection
extends MockObject
implements Connection {
    private ExpectationValue myAutoCommit = new ExpectationValue("CommonMockConnection.setAutoCommit");
    private ExpectationCounter myCloseCalls = new ExpectationCounter("CommonMockConnection.close");
    private ExpectationCounter myCommitCalls = new ExpectationCounter("CommonMockConnection.commit");
    private ExpectationCounter myCreateStatementCalls = new ExpectationCounter("CommonMockConnection.createStatement");
    private boolean myIsClosed;
    private SQLException myCloseException;
    private SQLException myIsClosedException;
    private DatabaseMetaData myMetaData;
    private ReturnObjectList myPreparedStatements = new ReturnObjectList("CommonMockConnection.PreparedStatements");
    private ExpectationCollection myPreparedStatementStrings = new ExpectationList("CommonMockConnection.preparedStatementString");
    private ExpectationCounter myRollbackCalls = new ExpectationCounter("CommonMockConnection.rollback");
    private Statement myStatement;
    private SQLException myStatementException = null;

    public void addExpectedPreparedStatementString(String sql) {
        this.myPreparedStatementStrings.addExpected((Object)sql);
    }

    public void addExpectedPreparedStatement(PreparedStatement prepared) {
        this.myPreparedStatements.addObjectToReturn((Object)prepared);
    }

    public void setExpectedAutoCommit(boolean autoCommit) {
        this.myAutoCommit.setExpected(autoCommit);
    }

    public void setExpectedCloseCalls(int callCount) {
        this.myCloseCalls.setExpected(callCount);
    }

    public void setExpectedCommitCalls(int callCount) {
        this.myCommitCalls.setExpected(callCount);
    }

    public void setExpectedCreateStatementCalls(int calls) {
        this.myCreateStatementCalls.setExpected(calls);
    }

    public void setExpectedRollbackCalls(int callCount) {
        this.myRollbackCalls.setExpected(callCount);
    }

    public void setupAddPreparedStatement(PreparedStatement prepared) {
        this.myPreparedStatements.addObjectToReturn((Object)prepared);
    }

    public void setupCloseException(SQLException aCloseException) {
        this.myCloseException = aCloseException;
    }

    public void setupIsClose(boolean aIsClosed) {
        this.myIsClosed = aIsClosed;
    }

    public void setupIsClosed(boolean aIsClosed) {
        this.myIsClosed = aIsClosed;
    }

    public void setupIsClosedException(SQLException aIsClosedException) {
        this.myIsClosedException = aIsClosedException;
    }

    public void setupMetaData(DatabaseMetaData metaData) {
        this.myMetaData = metaData;
    }

    public void setupStatement(Statement statement) {
        this.myStatement = statement;
    }

    public void setupThrowExceptionOnPrepareOrCreate(SQLException exception) {
        this.myStatementException = exception;
    }

    private void throwStatementExceptionIfAny() throws SQLException {
        if (null != this.myStatementException) {
            throw this.myStatementException;
        }
    }

    public void close() throws SQLException {
        if (this.myCloseException != null) {
            throw this.myCloseException;
        }
        this.myCloseCalls.inc();
    }

    public void commit() throws SQLException {
        this.myCommitCalls.inc();
    }

    public Statement createStatement() throws SQLException {
        this.myCreateStatementCalls.inc();
        this.throwStatementExceptionIfAny();
        return this.myStatement;
    }

    public DatabaseMetaData getMetaData() throws SQLException {
        return this.myMetaData;
    }

    public boolean isClosed() throws SQLException {
        if (this.myIsClosedException != null) {
            throw this.myIsClosedException;
        }
        return this.myIsClosed;
    }

    public PreparedStatement prepareStatement(String sql) throws SQLException {
        this.myPreparedStatementStrings.addActual((Object)sql);
        this.throwStatementExceptionIfAny();
        return (PreparedStatement)this.myPreparedStatements.nextReturnObject();
    }

    public void rollback() throws SQLException {
        this.myRollbackCalls.inc();
    }

    public void setAutoCommit(boolean autoCommit) throws SQLException {
        this.myAutoCommit.setActual(autoCommit);
    }

    public void clearWarnings() throws SQLException {
        this.notImplemented();
    }

    public Statement createStatement(int resultSetType, int resultSetConcurrency) throws SQLException {
        this.notImplemented();
        return null;
    }

    public boolean getAutoCommit() throws SQLException {
        this.notImplemented();
        return false;
    }

    public String getCatalog() throws SQLException {
        this.notImplemented();
        return null;
    }

    public int getTransactionIsolation() throws SQLException {
        this.notImplemented();
        return 0;
    }

    public Map getTypeMap() throws SQLException {
        this.notImplemented();
        return null;
    }

    public SQLWarning getWarnings() throws SQLException {
        this.notImplemented();
        return null;
    }

    public boolean isReadOnly() throws SQLException {
        this.notImplemented();
        return false;
    }

    public String nativeSQL(String sql) throws SQLException {
        this.notImplemented();
        return null;
    }

    public CallableStatement prepareCall(String sql) throws SQLException {
        this.notImplemented();
        return null;
    }

    public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        this.notImplemented();
        return null;
    }

    public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        this.notImplemented();
        return null;
    }

    public void setCatalog(String catalog) throws SQLException {
        this.notImplemented();
    }

    public void setReadOnly(boolean readOnly) throws SQLException {
        this.notImplemented();
    }

    public void setTransactionIsolation(int level) throws SQLException {
        this.notImplemented();
    }

    public void setTypeMap(Map map) throws SQLException {
        this.notImplemented();
    }
}

