/*
 * Decompiled with CFR 0.152.
 */
package com.mockobjects.servlet;

import com.mockobjects.ExpectationCounter;
import com.mockobjects.ExpectationValue;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import javax.servlet.ServletOutputStream;

public class MockServletOutputStream
extends ServletOutputStream {
    private ExpectationValue myWriteCalled = new ExpectationValue("MockServletOutputStream.write()");
    private boolean myThrowException = false;
    private ExpectationCounter myCloseCallCount = new ExpectationCounter("MockServletOutputstream.close()");
    private ByteArrayOutputStream myBuffer;

    public MockServletOutputStream() {
        this.setupClearContents();
    }

    public void setExpectedCloseCalls(int closeCall) {
        this.myCloseCallCount.setExpected(closeCall);
    }

    public void setExpectingWriteCalls(boolean expectingWriteCall) {
        this.myWriteCalled.setExpected(expectingWriteCall);
    }

    public void setThrowIOException(boolean throwException) {
        this.myThrowException = throwException;
    }

    public void close() throws IOException {
        this.myCloseCallCount.inc();
    }

    public String toString() {
        return this.getContents();
    }

    public void write(int b) throws IOException {
        this.myWriteCalled.setActual(true);
        if (this.myThrowException) {
            throw new IOException("Test IOException generated by request");
        }
        this.myBuffer.write(b);
    }

    public void setupClearContents() {
        this.myBuffer = new ByteArrayOutputStream();
    }

    public String getContents() {
        return this.myBuffer.toString();
    }

    public void verify() {
        this.myWriteCalled.verify();
        this.myCloseCallCount.verify();
    }
}

