/*
 * Decompiled with CFR 0.152.
 */
package com.mockobjects.dynamic;

import com.mockobjects.Verifiable;
import com.mockobjects.dynamic.MethodExpectation;
import com.mockobjects.dynamic.MockCall;
import java.util.HashMap;
import java.util.Iterator;

public class MethodMap
implements Verifiable {
    private HashMap map = new HashMap();

    public void setupCall(String methodName, MockCall call) {
        this.get(methodName).setupCall(call);
    }

    public void expectCall(String methodName, MockCall call) {
        this.get(methodName).expectCall(call);
    }

    public void expectNotCalled(String methodName) {
        this.get(methodName).expectNotCalled();
    }

    public void order(String preceding_method, String subsequent_method) {
        this.get(preceding_method).shouldCallBefore(this.get(subsequent_method));
    }

    public MethodExpectation startCall(String methodName) {
        MethodExpectation expectation = this.get(methodName);
        expectation.startCall();
        return expectation;
    }

    public void put(MethodExpectation expectation) {
        this.map.put(expectation.name, expectation);
    }

    public void verify() {
        Iterator i = this.map.values().iterator();
        while (i.hasNext()) {
            ((MethodExpectation)i.next()).verify();
        }
    }

    private MethodExpectation get(String methodName) {
        MethodExpectation expectation = (MethodExpectation)this.map.get(methodName);
        if (null == expectation) {
            expectation = new MethodExpectation(methodName);
            this.put(expectation);
        }
        return expectation;
    }
}

