/*
 * Decompiled with CFR 0.152.
 */
package com.mockobjects.util;

import com.mockobjects.Verifiable;
import com.mockobjects.util.NotImplementedException;
import junit.framework.Assert;
import junit.framework.AssertionFailedError;

public class AssertMo
extends Assert {
    protected AssertMo() {
    }

    public static void assertEquals(String description, Object[] expectedArray, Object[] actualArray) {
        Assert.assertEquals((String)(description + " (different lengths)"), (int)expectedArray.length, (int)actualArray.length);
        int i = 0;
        while (i < expectedArray.length) {
            Assert.assertEquals((String)(description + " (element " + i + ")"), (Object)expectedArray[i], (Object)actualArray[i]);
            ++i;
        }
    }

    public static void assertExcludes(String description, String excludeString, String targetString) {
        Assert.assertTrue((String)(description + "\nExclude String: " + excludeString + "\n Target String: " + targetString), (targetString.indexOf(excludeString) == -1 ? 1 : 0) != 0);
    }

    public static void assertIncludes(String description, String includeString, String targetString) {
        Assert.assertTrue((String)(description + "\nInclude String: " + includeString + "\n Target String: " + targetString), (targetString.indexOf(includeString) != -1 ? 1 : 0) != 0);
    }

    public static void assertStartsWith(String description, String startString, String targetString) {
        Assert.assertTrue((String)(description + "\n Start String: " + startString + "\nTarget String: " + targetString), (boolean)targetString.startsWith(startString));
    }

    public static void assertVerifyFails(Verifiable aVerifiable) {
        boolean threwException = false;
        try {
            aVerifiable.verify();
        }
        catch (AssertionFailedError ex) {
            threwException = true;
        }
        Assert.assertTrue((String)"Should not have verified", (boolean)threwException);
    }

    protected static void failNotEquals(String message, Object expected, Object actual) {
        String formatted = "";
        if (message != null) {
            formatted = message + " ";
        }
        Assert.fail((String)(formatted + "\nExpected:<" + expected + ">\nReceived:<" + actual + ">"));
    }

    public static void notImplemented(String mockName) {
        throw new NotImplementedException("Not Implemented in " + mockName);
    }

    public static void assertFails(String message, Runnable runnable) {
        try {
            runnable.run();
        }
        catch (AssertionFailedError expected) {
            return;
        }
        Assert.fail((String)message);
    }
}

