/*
 * Decompiled with CFR 0.152.
 */
package alt.java.io;

import alt.java.io.File;
import java.io.FileFilter;
import java.io.FilenameFilter;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;

public class FileImpl
implements File {
    private final java.io.File file;

    public FileImpl(java.io.File file) {
        this.file = file;
    }

    public FileImpl(String fileName) {
        this.file = new java.io.File(fileName);
    }

    public String getName() {
        return this.file.getName();
    }

    public String getParent() {
        return this.file.getParent();
    }

    public File getParentFile() {
        return new FileImpl(this.file.getParentFile());
    }

    public String getPath() {
        return this.file.getPath();
    }

    public boolean isAbsolute() {
        return this.file.isAbsolute();
    }

    public String getAbsolutePath() {
        return this.file.getAbsolutePath();
    }

    public File getAbsoluteFile() {
        return new FileImpl(this.file.getAbsoluteFile());
    }

    public String getCanonicalPath() throws IOException {
        return this.file.getCanonicalPath();
    }

    public File getCanonicalFile() throws IOException {
        return new FileImpl(this.file.getCanonicalFile());
    }

    public URL toURL() throws MalformedURLException {
        return this.file.toURL();
    }

    public boolean canRead() {
        return this.file.canRead();
    }

    public boolean canWrite() {
        return this.file.canWrite();
    }

    public boolean exists() {
        return this.file.exists();
    }

    public boolean isDirectory() {
        return this.file.isDirectory();
    }

    public boolean isFile() {
        return this.file.isFile();
    }

    public boolean isHidden() {
        return this.file.isHidden();
    }

    public long lastModified() {
        return this.file.lastModified();
    }

    public long length() {
        return this.file.length();
    }

    public boolean createNewFile() throws IOException {
        return this.file.createNewFile();
    }

    public boolean delete() {
        return this.file.delete();
    }

    public void deleteOnExit() {
        this.file.deleteOnExit();
    }

    public String[] list() {
        return this.file.list();
    }

    public String[] list(FilenameFilter filter) {
        return this.file.list();
    }

    public File[] listFiles() {
        return this.toAltFileArray(this.file.listFiles());
    }

    public File[] listFiles(FilenameFilter filter) {
        return this.toAltFileArray(this.file.listFiles(filter));
    }

    public File[] listFiles(FileFilter filter) {
        return this.toAltFileArray(this.file.listFiles(filter));
    }

    private final File[] toAltFileArray(java.io.File[] files) {
        if (files == null) {
            return null;
        }
        File[] altFiles = new File[files.length];
        int i = 0;
        while (i < files.length) {
            altFiles[i] = new FileImpl(files[i]);
            ++i;
        }
        return altFiles;
    }

    public boolean mkdir() {
        return this.file.mkdir();
    }

    public boolean mkdirs() {
        return this.file.mkdirs();
    }

    public File createTempFile(String prefix, String suffix, File directory) throws IOException {
        return new FileImpl(java.io.File.createTempFile(prefix, suffix, directory.getRealFile()));
    }

    public File createTempFile(String prefix, String suffix) throws IOException {
        return new FileImpl(java.io.File.createTempFile(prefix, suffix));
    }

    public File[] listRoots() {
        return this.toAltFileArray(java.io.File.listRoots());
    }

    public boolean renameTo(File dest) {
        return this.file.renameTo(dest.getRealFile());
    }

    public boolean setLastModified(long time) {
        return this.file.setLastModified(time);
    }

    public boolean setReadOnly() {
        return this.file.setReadOnly();
    }

    public int compareTo(File pathname) {
        return this.file.compareTo(pathname.getRealFile());
    }

    public int compareTo(Object o) {
        return this.file.compareTo(o);
    }

    public java.io.File getRealFile() {
        return this.file;
    }
}

