/*
 * Decompiled with CFR 0.152.
 */
package koeln.niemeier.log4j2.json;

import java.time.Instant;
import java.util.List;
import koeln.niemeier.log4j2.json.Json;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.impl.ThrowableProxy;
import org.apache.logging.log4j.message.Message;
import org.apache.logging.log4j.util.BiConsumer;
import org.apache.logging.log4j.util.ReadOnlyStringMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0013\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0002\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00042\b\u0010\u0007\u001a\u0004\u0018\u00010\bJ\u0018\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u0018\u0010\u000f\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u0010H\u0002R\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lkoeln/niemeier/log4j2/json/LogEventSerializer;", "", "ignoredPackages", "", "", "(Ljava/util/List;)V", "serialize", "event", "Lorg/apache/logging/log4j/core/LogEvent;", "serializeContextData", "Lkoeln/niemeier/log4j2/json/Json$Finished;", "generator", "Lkoeln/niemeier/log4j2/json/Json$Starting;", "value", "Lorg/apache/logging/log4j/util/ReadOnlyStringMap;", "serializeException", "Lorg/apache/logging/log4j/core/impl/ThrowableProxy;", "log4j2-json-layout"})
public final class LogEventSerializer {
    private final List<String> ignoredPackages;

    @NotNull
    public final String serialize(@Nullable LogEvent event) {
        Json.Starting json = Json.Companion.generate();
        if (event == null) {
            return json.nullObject().serialize();
        }
        Json.Ongoing ongoing = json.startObject();
        String string = Instant.ofEpochMilli(event.getTimeMillis()).toString();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"Instant.ofEpochMilli(event.timeMillis).toString()");
        Json.Ongoing ongoing2 = ongoing.stringField("time", string);
        String string2 = event.getLevel().name();
        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"event.level.name()");
        Json.Ongoing ongoing3 = ongoing2.stringField("severity", string2);
        String string3 = event.getLoggerName();
        Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"event.loggerName");
        Json.Ongoing ongoing4 = ongoing3.stringField("logger", string3);
        ReadOnlyStringMap readOnlyStringMap = event.getContextData();
        Intrinsics.checkExpressionValueIsNotNull((Object)readOnlyStringMap, (String)"event.contextData");
        Json.Ongoing ongoing5 = ongoing4.objectFieldIf(!readOnlyStringMap.isEmpty(), "context", (Function1<? super Json.Starting, ? extends Json.Finished>)((Function1)new Function1<Json.Starting, Json.Finished>(this, event){
            final /* synthetic */ LogEventSerializer this$0;
            final /* synthetic */ LogEvent $event;

            @NotNull
            public final Json.Finished invoke(@NotNull Json.Starting it) {
                Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                ReadOnlyStringMap readOnlyStringMap = this.$event.getContextData();
                Intrinsics.checkExpressionValueIsNotNull((Object)readOnlyStringMap, (String)"event.contextData");
                return LogEventSerializer.access$serializeContextData(this.this$0, it, readOnlyStringMap);
            }
            {
                this.this$0 = logEventSerializer;
                this.$event = logEvent;
                super(1);
            }
        }));
        Message message = event.getMessage();
        Intrinsics.checkExpressionValueIsNotNull((Object)message, (String)"event.message");
        String string4 = message.getFormattedMessage();
        Intrinsics.checkExpressionValueIsNotNull((Object)string4, (String)"event.message.formattedMessage");
        Json.Ongoing ongoing6 = ongoing5.stringField("message", string4).objectFieldIf(event.getThrownProxy() != null, "exception", (Function1<? super Json.Starting, ? extends Json.Finished>)((Function1)new Function1<Json.Starting, Json.Finished>(this, event){
            final /* synthetic */ LogEventSerializer this$0;
            final /* synthetic */ LogEvent $event;

            @NotNull
            public final Json.Finished invoke(@NotNull Json.Starting it) {
                Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                ThrowableProxy throwableProxy = this.$event.getThrownProxy();
                Intrinsics.checkExpressionValueIsNotNull((Object)throwableProxy, (String)"event.thrownProxy");
                return LogEventSerializer.access$serializeException(this.this$0, it, throwableProxy);
            }
            {
                this.this$0 = logEventSerializer;
                this.$event = logEvent;
                super(1);
            }
        }));
        String string5 = event.getThreadName();
        Intrinsics.checkExpressionValueIsNotNull((Object)string5, (String)"event.threadName");
        return ongoing6.stringField("thread", string5).endObject().serialize();
    }

    private final Json.Finished serializeContextData(Json.Starting generator, ReadOnlyStringMap value) {
        Json.Ongoing json = generator.startObject();
        value.forEach((BiConsumer)new BiConsumer<String, Object>(json){
            final /* synthetic */ Json.Ongoing $json;

            public final void accept(@NotNull String k, @NotNull Object v) {
                Intrinsics.checkParameterIsNotNull((Object)k, (String)"k");
                Intrinsics.checkParameterIsNotNull((Object)v, (String)"v");
                this.$json.stringField(k, v.toString());
            }
            {
                this.$json = ongoing;
            }
        });
        return json.endObject();
    }

    private final Json.Finished serializeException(Json.Starting generator, ThrowableProxy value) {
        Json.Ongoing ongoing = generator.startObject();
        String string = value.getThrowable().getClass().getName();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"value.throwable.javaClass.name");
        Json.Ongoing ongoing2 = ongoing.stringField("thrown", string).stringFieldIf(value.getMessage() != null, "message", (Function0<String>)((Function0)new Function0<String>(value){
            final /* synthetic */ ThrowableProxy $value;

            public final String invoke() {
                String string = this.$value.getMessage();
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"value.message");
                return string;
            }
            {
                this.$value = throwableProxy;
                super(0);
            }
        }));
        String string2 = value.getCauseStackTraceAsString(this.ignoredPackages);
        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"value.getCauseStackTraceAsString(ignoredPackages)");
        return ongoing2.stringField("stack", string2).endObject();
    }

    public LogEventSerializer(@NotNull List<String> ignoredPackages) {
        Intrinsics.checkParameterIsNotNull(ignoredPackages, (String)"ignoredPackages");
        this.ignoredPackages = ignoredPackages;
    }

    @NotNull
    public static final /* synthetic */ Json.Finished access$serializeContextData(LogEventSerializer $this, @NotNull Json.Starting generator, @NotNull ReadOnlyStringMap value) {
        return $this.serializeContextData(generator, value);
    }

    @NotNull
    public static final /* synthetic */ Json.Finished access$serializeException(LogEventSerializer $this, @NotNull Json.Starting generator, @NotNull ThrowableProxy value) {
        return $this.serializeException(generator, value);
    }
}

