/*
 * Decompiled with CFR 0.152.
 */
package ng.packaging;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Properties;
import ng.packaging.Dependency;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.project.MavenProject;

public class SourceProject {
    public static final String DEFAULT_WORESOURCES_FOLDER_NAME = "woresources";
    private final MavenProject _mavenProject;
    private final String _woresourcesFolderName;
    private final Properties _buildProperties;

    public SourceProject(MavenProject mavenProject, String woresourcesFolderName) {
        Objects.requireNonNull(mavenProject);
        Objects.requireNonNull(woresourcesFolderName);
        this._mavenProject = mavenProject;
        this._woresourcesFolderName = woresourcesFolderName;
        this._buildProperties = this.readBuildProperties();
        this.validateBuildProperties();
    }

    private MavenProject mavenProject() {
        return this._mavenProject;
    }

    public Collection<Dependency> dependencies() {
        ArrayList<Dependency> dependencies = new ArrayList<Dependency>();
        for (Artifact a : this.mavenProject().getArtifacts()) {
            dependencies.add(new Dependency(a.getGroupId(), a.getArtifactId(), a.getVersion(), a.getFile()));
        }
        return dependencies;
    }

    public String woresourcesFolderName() {
        return this._woresourcesFolderName;
    }

    public String principalClassName() {
        return this._buildProperties.getProperty("principalClass");
    }

    public String name() {
        String projectName = this._buildProperties.getProperty("project.name");
        if (projectName == null) {
            projectName = this.mavenProject().getName();
        }
        return projectName;
    }

    public String jvmOptions() {
        Object jvmOptions = this._buildProperties.getProperty("jvmOptions");
        if (jvmOptions == null) {
            jvmOptions = "";
        }
        String requiredParameter = "--add-exports java.base/sun.security.action=ALL-UNNAMED";
        if (!((String)jvmOptions).contains("--add-exports java.base/sun.security.action=ALL-UNNAMED")) {
            jvmOptions = (String)jvmOptions + " --add-exports java.base/sun.security.action=ALL-UNNAMED";
        }
        return jvmOptions;
    }

    public String version() {
        return this.mavenProject().getVersion();
    }

    public Path jarPath() {
        return this.mavenProject().getArtifact().getFile().toPath();
    }

    public Type type() {
        String stringType;
        switch (stringType = this.mavenProject().getPackaging()) {
            case "woapplication": {
                return Type.Application;
            }
            case "woframework": {
                return Type.Framework;
            }
        }
        throw new IllegalArgumentException(String.format("I'm not familiar with packaging '%s'. The only packaging types I know are 'woapplication' and 'woframework'", stringType));
    }

    private Properties readBuildProperties() {
        Properties properties;
        String pathToBuildPropertiesFile = this.mavenProject().getBasedir() + "/build.properties";
        if (!new File(pathToBuildPropertiesFile).exists()) {
            throw new IllegalStateException(String.format("build.properties not found in project root (%s). To build a project with vermilingua, a file called 'build.properties' file must exist in the root and must contain at least the properties %s", pathToBuildPropertiesFile, this.requiredBuildProperties()));
        }
        FileInputStream fis = new FileInputStream(pathToBuildPropertiesFile);
        try {
            Properties buildProperties = new Properties();
            buildProperties.load(fis);
            properties = buildProperties;
        }
        catch (Throwable throwable) {
            try {
                try {
                    fis.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }
        fis.close();
        return properties;
    }

    private void validateBuildProperties() {
        for (String propertyName : this.requiredBuildProperties()) {
            if (this._buildProperties.containsKey(propertyName)) continue;
            throw new IllegalArgumentException(String.format("%s must be present in build.properties", propertyName));
        }
    }

    private List<String> requiredBuildProperties() {
        ArrayList<String> requiredBuildProperties = new ArrayList<String>();
        if (this.type() == Type.Application) {
            requiredBuildProperties.add("principalClass");
        }
        return requiredBuildProperties;
    }

    public Path componentsPath() {
        return Path.of(this.mavenProject().getBasedir() + "/src/main/components", new String[0]);
    }

    public Path woresourcesPath() {
        return Path.of(this.mavenProject().getBasedir() + "/src/main/" + this.woresourcesFolderName(), new String[0]);
    }

    public Path webServerResourcesPath() {
        return Path.of(this.mavenProject().getBasedir() + "/src/main/webserver-resources", new String[0]);
    }

    public String targetJarNameForWOA() {
        return this.name() + ".jar";
    }

    public static enum Type {
        Application,
        Framework;


        public boolean isApp() {
            return this == Application;
        }

        public boolean isFramework() {
            return this == Framework;
        }
    }
}

