/*
 * Decompiled with CFR 0.152.
 */
package ng.packaging;

import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import ng.packaging.Dependency;
import ng.packaging.InfoPlist;
import ng.packaging.SourceProject;
import ng.packaging.Util;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PackageWOApplication {
    private static final Logger logger = LoggerFactory.getLogger(PackageWOApplication.class);

    public WOA execute(SourceProject sourceProject, String woaName, Path targetPath) {
        Objects.requireNonNull(sourceProject);
        Objects.requireNonNull(woaName);
        Objects.requireNonNull(targetPath);
        WOA woa = WOA.create(targetPath, woaName);
        String appJarFilename = sourceProject.targetJarNameForWOA();
        Util.copyFile(sourceProject.jarPath(), woa.javaPath().resolve(appJarFilename), StandardCopyOption.REPLACE_EXISTING);
        ArrayList<Object> classpathStrings = new ArrayList<Object>();
        classpathStrings.add("APPROOT/Resources/Java/");
        classpathStrings.add("APPROOT/Resources/Java/" + appJarFilename);
        for (Dependency dependency : sourceProject.dependencies()) {
            Path artifactPathInMavenRepository = dependency.file().toPath();
            Path artifactFolderPathInWOA = Util.folder(woa.javaPath().resolve(dependency.groupId().replace(".", "/") + "/" + dependency.artifactId() + "/" + dependency.version()));
            Path artifactPathInWOA = artifactFolderPathInWOA.resolve(dependency.file().getName());
            Util.copyFile(artifactPathInMavenRepository, artifactPathInWOA, StandardCopyOption.REPLACE_EXISTING);
            classpathStrings.add("APPROOT/" + woa.contentsPath().relativize(artifactPathInWOA));
        }
        for (Dependency dependency : sourceProject.dependencies()) {
            if (!Util.jarContainsNonEmptyWebServerResourcesDirectoryInRoot(dependency.file())) continue;
            Path destinationPath = woa.frameworksPath().resolve(dependency.artifactId() + ".framework");
            Util.copyFolderFromJarToPath("WebServerResources", dependency.file().toPath(), destinationPath);
        }
        if (Files.exists(sourceProject.componentsPath(), new LinkOption[0])) {
            Util.copyContentsOfDirectoryToDirectoryFlatten(sourceProject.componentsPath(), woa.woresourcesPath(), List.of("wo"));
        } else {
            logger.warn(String.format("Not copying components. %s does not exist", sourceProject.componentsPath()));
        }
        if (Files.exists(sourceProject.woresourcesPath(), new LinkOption[0])) {
            Util.copyContentsOfDirectoryToDirectory(sourceProject.woresourcesPath(), woa.woresourcesPath());
        } else {
            logger.warn(String.format("Not copying woresources. %s does not exist", sourceProject.woresourcesPath()));
        }
        if (Files.exists(sourceProject.webServerResourcesPath(), new LinkOption[0])) {
            Util.copyContentsOfDirectoryToDirectory(sourceProject.webServerResourcesPath(), woa.webServerResourcesPath());
        } else {
            logger.warn(String.format("Not copying WebServerResources. %s does not exist", sourceProject.webServerResourcesPath()));
        }
        String classPathFileTemplateString = Util.readTemplate("classpath");
        classPathFileTemplateString = classPathFileTemplateString.replace("${ApplicationClass}", sourceProject.principalClassName());
        classPathFileTemplateString = classPathFileTemplateString.replace("${JVMOptions}", sourceProject.jvmOptions());
        String standardClassPathString = classPathFileTemplateString + String.join((CharSequence)"\n", classpathStrings);
        Util.writeStringToPath(standardClassPathString, woa.unixPath().resolve("UNIXClassPath.txt"));
        Util.writeStringToPath(standardClassPathString, woa.macosPath().resolve("MacOSClassPath.txt"));
        Util.writeStringToPath(standardClassPathString, woa.macosPath().resolve("MacOSXServerClassPath.txt"));
        String windowsClassPathString = classPathFileTemplateString + String.join((CharSequence)"\r\n", classpathStrings).replace("/", "\\");
        Util.writeStringToPath(windowsClassPathString, woa.windowsPath().resolve("CLSSPATH.TXT"));
        String windowsSubPathsString = Util.readTemplate("subpaths");
        Util.writeStringToPath(windowsSubPathsString, woa.windowsPath().resolve("SUBPATHS.TXT"));
        String infoPlistString = InfoPlist.make(sourceProject);
        Util.writeStringToPath(infoPlistString, woa.infoPlistPath());
        String unixLaunchScriptString = Util.readTemplate("launch-script");
        Path unixLaunchScriptPath = woa.woaPath().resolve(sourceProject.name());
        Util.writeStringToPath(unixLaunchScriptString, unixLaunchScriptPath);
        Util.makeUserExecutable(unixLaunchScriptPath);
        Path redundantMacOSLaunchScriptPath = woa.macosPath().resolve(sourceProject.name());
        Util.writeStringToPath(unixLaunchScriptString, redundantMacOSLaunchScriptPath);
        Util.makeUserExecutable(redundantMacOSLaunchScriptPath);
        String windowsLaunchScriptString = Util.readTemplate("launch-script-cmd");
        Path windowsLaunchScriptPath = woa.woaPath().resolve(sourceProject.name() + ".cmd");
        Util.writeStringToPath(windowsLaunchScriptString, windowsLaunchScriptPath);
        Util.makeUserExecutable(windowsLaunchScriptPath);
        Path redundantWindowsLaunchScriptPath = woa.windowsPath().resolve(sourceProject.name() + ".cmd");
        Util.writeStringToPath(windowsLaunchScriptString, redundantWindowsLaunchScriptPath);
        Util.makeUserExecutable(redundantWindowsLaunchScriptPath);
        return woa;
    }

    public static class WOA {
        private final Path _woaPath;

        public static WOA create(Path containingDirectory, String applicationName) {
            Objects.requireNonNull(containingDirectory);
            Objects.requireNonNull(applicationName);
            Path woaPath = containingDirectory.resolve(applicationName + ".woa");
            return new WOA(woaPath, applicationName);
        }

        private WOA(Path woaPath, String applicationName) {
            Objects.requireNonNull(woaPath);
            Objects.requireNonNull(applicationName);
            this._woaPath = Util.folder(woaPath);
        }

        public Path woaPath() {
            return this._woaPath;
        }

        public Path contentsPath() {
            return Util.folder(this.woaPath().resolve("Contents"));
        }

        public Path frameworksPath() {
            return Util.folder(this.contentsPath().resolve("Frameworks"));
        }

        public Path macosPath() {
            return Util.folder(this.contentsPath().resolve("MacOS"));
        }

        public Path unixPath() {
            return Util.folder(this.contentsPath().resolve("UNIX"));
        }

        public Path windowsPath() {
            return Util.folder(this.contentsPath().resolve("Windows"));
        }

        public Path woresourcesPath() {
            return Util.folder(this.contentsPath().resolve("Resources"));
        }

        public Path webServerResourcesPath() {
            return Util.folder(this.contentsPath().resolve("WebServerResources"));
        }

        public Path javaPath() {
            return Util.folder(this.woresourcesPath().resolve("Java"));
        }

        public Path infoPlistPath() {
            return this.contentsPath().resolve("Info.plist");
        }

        public void extractWebServerResources() {
            Path splitPath = Util.folder(this.woaPath().getParent().resolve(this.woaPath().getFileName() + ".webserverresources"));
            Path splitWebServerResourcesPath = Util.folder(splitPath.resolve("Contents").resolve("WebServerResources"));
            Path splitFrameworksPath = Util.folder(splitPath.resolve("Contents").resolve("Frameworks"));
            Util.copyContentsOfDirectoryToDirectory(this.webServerResourcesPath(), splitWebServerResourcesPath);
            Util.copyContentsOfDirectoryToDirectory(this.frameworksPath(), splitFrameworksPath);
        }
    }
}

