/*
 * Decompiled with CFR 0.152.
 */
package ng.packaging;

import java.util.List;
import java.util.Map;
import java.util.Objects;

public class PlistSerialization {
    private final StringBuilder b = new StringBuilder();

    public PlistSerialization(Object plist) {
        Objects.requireNonNull(plist);
        this.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n");
        this.append("<!DOCTYPE plist PUBLIC \"-//Apple Computer//DTD PLIST 1.0//EN\" \"http://www.apple.com/DTDs/PropertyList-1.0.dtd\">\n");
        this.append("<plist version=\"1.0\">\n");
        this.appendEntry(1, plist);
        this.append("</plist>");
    }

    private void append(Object value) {
        this.b.append(value);
    }

    private void append(int indent, Object value) {
        this.append("\t".repeat(indent));
        this.append(value);
    }

    private void appendEntry(int indent, Object object) {
        if (object != null) {
            if (object instanceof Boolean) {
                if (((Boolean)object).booleanValue()) {
                    this.append(indent, "<true />\n");
                } else {
                    this.append(indent, "<false />\n");
                }
            } else {
                String elementName = PlistSerialization.elementNameFromObject(object);
                this.append(indent, "<" + elementName + ">");
                if (object instanceof String) {
                    this.append(object);
                    this.append("</" + elementName + ">\n");
                }
                if (object instanceof Map) {
                    Map map = (Map)object;
                    this.append("\n");
                    for (Map.Entry entry : map.entrySet()) {
                        this.append(indent + 1, "<key>" + (String)entry.getKey() + "</key>\n");
                        this.appendEntry(indent + 1, entry.getValue());
                    }
                    this.append(indent, "</" + elementName + ">\n");
                }
                if (object instanceof List) {
                    List list = (List)object;
                    this.append("\n");
                    for (Map.Entry o : list) {
                        this.appendEntry(indent + 1, o);
                    }
                    this.append(indent, "</" + elementName + ">\n");
                }
            }
        }
    }

    private static String elementNameFromObject(Object object) {
        if (object instanceof List) {
            return "array";
        }
        if (object instanceof Map) {
            return "dict";
        }
        if (object instanceof String) {
            return "string";
        }
        throw new IllegalArgumentException("I don't know how to serialize " + object.getClass());
    }

    public String toString() {
        return this.b.toString();
    }
}

