/*
 * Decompiled with CFR 0.152.
 */
package ng.maven;

import java.nio.file.Path;
import ng.packaging.PackageWOApplication;
import ng.packaging.PackageWOFramework;
import ng.packaging.SourceProject;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;

@Mojo(name="package", defaultPhase=LifecyclePhase.PACKAGE, requiresDependencyResolution=ResolutionScope.COMPILE_PLUS_RUNTIME, threadSafe=true)
public class PackageMojo
extends AbstractMojo {
    @Parameter(property="project", required=true, readonly=true)
    MavenProject project;
    @Parameter(property="woresourcesFolderName", required=false, defaultValue="woresources")
    String woresourcesFolderName;
    @Parameter(property="performSplit", required=false)
    boolean performSplit;

    public void execute() throws MojoExecutionException, MojoFailureException {
        SourceProject sourceProject;
        if (!this.woresourcesFolderName.equals("woresources")) {
            this.getLog().warn((CharSequence)String.format("Using non-standard woresources folder name '%s'. Using the standard name '%s' is recommended", this.woresourcesFolderName, "woresources"));
        }
        if ((sourceProject = new SourceProject(this.project, this.woresourcesFolderName)).type().isApp()) {
            String finalName = this.project.getBuild().getFinalName();
            Path targetPath = Path.of(this.project.getBuild().getDirectory(), new String[0]);
            PackageWOApplication.WOA woa = new PackageWOApplication().execute(sourceProject, finalName, targetPath);
            if (this.performSplit) {
                woa.extractWebServerResources();
            }
        } else if (sourceProject.type().isFramework()) {
            new PackageWOFramework().execute(sourceProject);
        } else {
            throw new MojoExecutionException(String.format("I have no idea what you're asking me to build ('%s'? WTF??) but I don't know how to do it.", this.project.getPackaging()));
        }
    }
}

