/*
 * Decompiled with CFR 0.152.
 */
package ng.packaging;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.nio.file.CopyOption;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitOption;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.PosixFilePermissions;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Objects;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import ng.packaging.PackageWOApplication;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Util {
    private static final Logger logger = LoggerFactory.getLogger(Util.class);

    public static void copyFile(Path sourcePath, Path destinationPath, CopyOption ... options) {
        Objects.requireNonNull(sourcePath);
        Objects.requireNonNull(destinationPath);
        try {
            Files.copy(sourcePath, destinationPath, options);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public static void copyContentsOfDirectoryToDirectory(Path sourceDirectory, Path destinationDirectory) {
        Objects.requireNonNull(sourceDirectory);
        Objects.requireNonNull(destinationDirectory);
        String sourceDirectoryLocationString = sourceDirectory.toString();
        String destinationDirectoryLocationString = destinationDirectory.toString();
        try {
            Files.walk(sourceDirectory, new FileVisitOption[0]).forEach(sourcePath -> {
                Path destinationPath = Path.of(destinationDirectoryLocationString, sourcePath.toString().substring(sourceDirectoryLocationString.length()));
                if (!Files.exists(destinationPath, new LinkOption[0])) {
                    Util.copyFile(sourcePath, destinationPath, new CopyOption[0]);
                } else {
                    logger.warn("File {} already exists at {}, not copying", sourcePath, (Object)destinationPath);
                }
            });
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public static void copyContentsOfDirectoryToDirectoryFlatten(Path sourceDirectory, final Path destinationDirectory, final Collection<String> directorySuffixesToNotFlatten) {
        Objects.requireNonNull(sourceDirectory);
        Objects.requireNonNull(destinationDirectory);
        Objects.requireNonNull(directorySuffixesToNotFlatten);
        SimpleFileVisitor<Path> visitor = new SimpleFileVisitor<Path>(){

            @Override
            public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes arg1) throws IOException {
                if (Util.hasAnyOfSuffixes(dir.getFileName().toString(), directorySuffixesToNotFlatten)) {
                    Util.copyContentsOfDirectoryToDirectory(dir, destinationDirectory.resolve(dir.getFileName()));
                    return FileVisitResult.SKIP_SUBTREE;
                }
                return FileVisitResult.CONTINUE;
            }

            @Override
            public FileVisitResult visitFile(Path file, BasicFileAttributes arg1) throws IOException {
                Util.copyFile(file, destinationDirectory.resolve(file.getFileName()), new CopyOption[0]);
                return FileVisitResult.CONTINUE;
            }
        };
        try {
            Files.walkFileTree(sourceDirectory, (FileVisitor<? super Path>)visitor);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    private static boolean hasAnyOfSuffixes(String string, Collection<String> suffixes) {
        Objects.requireNonNull(string);
        Objects.requireNonNull(suffixes);
        for (String suffix : suffixes) {
            if (!string.endsWith("." + suffix)) continue;
            return true;
        }
        return false;
    }

    public static void writeStringToPath(String string, Path path) {
        Objects.requireNonNull(string);
        Objects.requireNonNull(path);
        try {
            Files.write(path, string.getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public static String readTemplate(String name) {
        String string;
        block8: {
            Objects.requireNonNull(name);
            InputStream stream = PackageWOApplication.class.getResourceAsStream("/templates/" + name + ".template.txt");
            try {
                string = new String(stream.readAllBytes(), StandardCharsets.UTF_8);
                if (stream == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (stream != null) {
                        try {
                            stream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new UncheckedIOException(e);
                }
            }
            stream.close();
        }
        return string;
    }

    public static void makeUserExecutable(Path path) {
        Objects.requireNonNull(path);
        try {
            Files.setPosixFilePermissions(path, PosixFilePermissions.fromString("rwxr--r--"));
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean jarContainsNonEmptyWebServerResourcesDirectoryInRoot(File sourceJarFile) {
        Objects.requireNonNull(sourceJarFile);
        try (JarFile jarFile = new JarFile(sourceJarFile);){
            Enumeration<JarEntry> entries = jarFile.entries();
            int i = 0;
            while (entries.hasMoreElements()) {
                JarEntry entry = entries.nextElement();
                if (!entry.getName().startsWith("WebServerResources/") || ++i <= 1) continue;
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public static void copyFolderFromJarToPath(String folderName, Path sourceJarPath, Path destinationPath) {
        Objects.requireNonNull(folderName);
        Objects.requireNonNull(sourceJarPath);
        Objects.requireNonNull(destinationPath);
        try (JarFile jarFile = new JarFile(sourceJarPath.toFile());){
            Enumeration<JarEntry> entries = jarFile.entries();
            while (entries.hasMoreElements()) {
                JarEntry entry = entries.nextElement();
                if (!entry.getName().startsWith(folderName + "/")) continue;
                Path targetPath = destinationPath.resolve(entry.getName());
                if (entry.isDirectory()) {
                    Files.createDirectories(targetPath, new FileAttribute[0]);
                    continue;
                }
                InputStream inStream = jarFile.getInputStream(entry);
                try {
                    Files.copy(inStream, targetPath, new CopyOption[0]);
                }
                finally {
                    if (inStream == null) continue;
                    inStream.close();
                }
            }
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public static void copyContentsOfFolderAtPathToFolderInJar(Path sourcePath, String folderName, Path destinationJarPath) {
        Objects.requireNonNull(sourcePath);
        Objects.requireNonNull(folderName);
        Objects.requireNonNull(destinationJarPath);
        if (Files.exists(sourcePath, new LinkOption[0])) {
            URI uri = URI.create("jar:file:" + destinationJarPath.toString());
            try (FileSystem zipfs = FileSystems.newFileSystem(uri, Collections.emptyMap());){
                Files.walk(sourcePath, new FileVisitOption[0]).forEach(folderEntry -> {
                    try {
                        if (!Files.isDirectory(folderEntry, new LinkOption[0])) {
                            Path relativePath = sourcePath.relativize((Path)folderEntry);
                            Path pathInZipFile = zipfs.getPath(folderName + "/" + relativePath.toString(), new String[0]);
                            Files.createDirectories(pathInZipFile, new FileAttribute[0]);
                            Files.copy(folderEntry, pathInZipFile, StandardCopyOption.REPLACE_EXISTING);
                        }
                    }
                    catch (IOException e) {
                        throw new UncheckedIOException(e);
                    }
                });
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }
    }

    public static void writeStringToPathInJar(String string, String destinationFilePathInsideJar, Path destinationJarPath) {
        Objects.requireNonNull(string);
        Objects.requireNonNull(destinationFilePathInsideJar);
        Objects.requireNonNull(destinationJarPath);
        URI uri = URI.create("jar:file:" + destinationJarPath.toString());
        try (FileSystem zipfs = FileSystems.newFileSystem(uri, Collections.emptyMap());){
            Path pathInZipFile = zipfs.getPath(destinationFilePathInsideJar, new String[0]);
            Files.writeString(pathInZipFile, (CharSequence)string, StandardCharsets.UTF_8, new OpenOption[0]);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public static Path folder(Path path) {
        Objects.requireNonNull(path);
        if (Files.exists(path, new LinkOption[0])) {
            if (!Files.isDirectory(path, new LinkOption[0])) {
                throw new IllegalArgumentException("Given folder path exists but is not a folder");
            }
        } else {
            try {
                Files.createDirectories(path, new FileAttribute[0]);
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }
        return path;
    }
}

