/*
 * Decompiled with CFR 0.152.
 */
package ng.packaging;

import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import ng.packaging.PlistSerialization;
import ng.packaging.SourceProject;

public class InfoPlist {
    public static String make(SourceProject sourceProject) {
        SourceProject.Type type = sourceProject.type();
        String bundleName = sourceProject.name();
        String version = sourceProject.version();
        String mainJarFileName = sourceProject.targetJarNameForWOA();
        LinkedHashMap<String, Object> infoPlist = new LinkedHashMap<String, Object>();
        infoPlist.put("NSExecutable", bundleName);
        infoPlist.put("CFBundleDevelopmentRegion", "English");
        infoPlist.put("CFBundleExecutable", bundleName);
        infoPlist.put("CFBundleGetInfoString", "");
        infoPlist.put("CFBundleIconFile", type.isApp() ? "WOAfile.icns" : "");
        infoPlist.put("CFBundleIdentifier", "com.apple.myapp");
        infoPlist.put("CFBundleInfoDictionaryVersion", "6.0");
        infoPlist.put("CFBundleName", type.isApp() ? "WOA" : "WOF");
        infoPlist.put("CFBundlePackageType", type.isApp() ? "APPL" : "FMWK");
        infoPlist.put("CFBundleShortVersionString", version);
        infoPlist.put("CFBundleSignature", "webo");
        infoPlist.put("CFBundleVersion", version);
        infoPlist.put("Java", Map.of("JVMVersion", "1.5+"));
        infoPlist.put("NSJavaClientRoot", type.isApp() ? "Contents/WebServerResources/Java" : "WebServerResources/Java");
        infoPlist.put("NSJavaNeeded", true);
        infoPlist.put("NSJavaPath", List.of(mainJarFileName));
        infoPlist.put("NSJavaPathClient", mainJarFileName);
        infoPlist.put("NSJavaRoot", type.isApp() ? "Contents/Resources/Java" : "Resources/Java");
        if (type.isFramework()) {
            infoPlist.put("Has_WOComponents", true);
            String principalClassName = sourceProject.principalClassName();
            if (principalClassName != null && !principalClassName.isEmpty()) {
                infoPlist.put("NSPrincipalClass", principalClassName);
            }
        }
        return new PlistSerialization(infoPlist).toString();
    }
}

