/*
 * Decompiled with CFR 0.152.
 */
package is.codion.tools.server.monitor.ui;

import is.codion.common.state.State;
import is.codion.common.value.Value;
import is.codion.swing.common.ui.component.Components;
import is.codion.swing.common.ui.component.button.CheckBoxBuilder;
import is.codion.swing.common.ui.component.panel.BorderLayoutPanelBuilder;
import is.codion.swing.common.ui.component.panel.PanelBuilder;
import is.codion.swing.common.ui.component.spinner.NumberSpinnerBuilder;
import is.codion.swing.common.ui.component.table.FilterTable;
import is.codion.swing.common.ui.component.table.FilterTableColumn;
import is.codion.swing.common.ui.component.text.NumberField;
import is.codion.swing.common.ui.component.text.TextAreaBuilder;
import is.codion.swing.common.ui.component.text.TextFieldBuilder;
import is.codion.swing.common.ui.control.Control;
import is.codion.tools.server.monitor.ServerMonitor;
import is.codion.tools.server.monitor.ui.ChartUtil;
import is.codion.tools.server.monitor.ui.ClientUserMonitorPanel;
import is.codion.tools.server.monitor.ui.DatabaseMonitorPanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.rmi.RemoteException;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.border.Border;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.DateAxis;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.event.AxisChangeEvent;
import org.jfree.chart.event.AxisChangeListener;
import org.jfree.chart.plot.PlotOrientation;

public final class ServerMonitorPanel
extends JPanel {
    private static final int SPINNER_COLUMNS = 3;
    private static final String DOMAIN = "Domain";
    private final ServerMonitor model;
    private final JFreeChart requestsPerSecondChart = ChartFactory.createXYStepChart(null, null, null, null, (PlotOrientation)PlotOrientation.VERTICAL, (boolean)true, (boolean)true, (boolean)false);
    private final ChartPanel requestsPerSecondChartPanel = new ChartPanel(this.requestsPerSecondChart);
    private final JFreeChart memoryUsageChart = ChartFactory.createXYStepChart(null, null, null, null, (PlotOrientation)PlotOrientation.VERTICAL, (boolean)true, (boolean)true, (boolean)false);
    private final ChartPanel memoryUsageChartPanel = new ChartPanel(this.memoryUsageChart);
    private final JFreeChart connectionCountChart = ChartFactory.createXYStepChart(null, null, null, null, (PlotOrientation)PlotOrientation.VERTICAL, (boolean)true, (boolean)true, (boolean)false);
    private final ChartPanel connectionCountChartPanel = new ChartPanel(this.connectionCountChart);
    private final JFreeChart systemLoadChart = ChartFactory.createXYStepChart(null, null, null, null, (PlotOrientation)PlotOrientation.VERTICAL, (boolean)true, (boolean)true, (boolean)false);
    private final ChartPanel systemLoadChartPanel = new ChartPanel(this.systemLoadChart);
    private final JFreeChart threadCountChart = ChartFactory.createXYStepChart(null, null, null, null, (PlotOrientation)PlotOrientation.VERTICAL, (boolean)true, (boolean)true, (boolean)false);
    private final ChartPanel threadCountChartPanel = new ChartPanel(this.threadCountChart);
    private final JFreeChart gcEventsChart = ChartFactory.createXYBarChart(null, null, (boolean)true, null, null);
    private final ChartPanel gcEventsChartPanel = new ChartPanel(this.gcEventsChart);
    private final State synchronizedZoomState = State.state((boolean)true);

    public ServerMonitorPanel(ServerMonitor model) throws RemoteException {
        this.model = Objects.requireNonNull(model);
        this.requestsPerSecondChart.getXYPlot().setDataset(model.connectionRequestsDataset());
        this.memoryUsageChart.getXYPlot().setDataset(model.memoryUsageDataset());
        this.connectionCountChart.getXYPlot().setDataset(model.connectionCountDataset());
        this.systemLoadChart.getXYPlot().setDataset(model.systemLoadDataset());
        this.systemLoadChart.getXYPlot().getRangeAxis().setRange(0.0, 100.0);
        this.gcEventsChart.getXYPlot().setDataset(model.gcEventsDataset());
        this.threadCountChart.getXYPlot().setDataset(model.threadCountDataset());
        this.setColors(this.requestsPerSecondChart);
        this.setColors(this.memoryUsageChart);
        this.setColors(this.connectionCountChart);
        this.setColors(this.systemLoadChart);
        this.setColors(this.gcEventsChart);
        this.setColors(this.threadCountChart);
        this.initializeUI();
        this.bindEvents();
    }

    public ServerMonitor model() {
        return this.model;
    }

    public void shutdownServer() {
        if (JOptionPane.showConfirmDialog(this, "Are you sure you want to shut down this server?", "Confirm shutdown", 0) == 0) {
            this.model.shutdownServer();
        }
    }

    private void initializeUI() throws RemoteException {
        JPanel serverPanel = (JPanel)Components.flowLayoutPanel((int)0).add((JComponent)new JLabel("Connections", 4)).add((JComponent)this.createConnectionCountField()).add((JComponent)new JLabel("limit", 4)).add(((NumberSpinnerBuilder)Components.integerSpinner(this.model.connectionLimit()).columns(3)).build()).add((JComponent)new JLabel("Mem. usage", 4)).add((JComponent)this.createMemoryField()).add((JComponent)new JLabel("Logging", 4)).add(this.createLogLevelField()).build();
        JPanel northPanel = (JPanel)((BorderLayoutPanelBuilder)Components.borderLayoutPanel().border((Border)BorderFactory.createTitledBorder("Server"))).centerComponent((JComponent)serverPanel).eastComponent(Components.button((Control)Control.commandControl(this::shutdownServer)).text("Shutdown").build()).build();
        JTabbedPane tabbedPane = (JTabbedPane)Components.tabbedPane().tab("Performance", (JComponent)this.createPerformancePanel()).tab("Database", (JComponent)new DatabaseMonitorPanel(this.model.databaseMonitor())).tab("Clients/Users", (JComponent)new ClientUserMonitorPanel(this.model.clientMonitor())).tab("Server", (JComponent)this.createServerPanel()).build();
        this.setLayout(new BorderLayout());
        this.add((Component)northPanel, "North");
        this.add((Component)tabbedPane, "Center");
    }

    private JPanel createPerformancePanel() {
        JPanel intervalPanel = (JPanel)Components.borderLayoutPanel().westComponent((JComponent)new JLabel("Update interval (s)")).centerComponent(((NumberSpinnerBuilder)((NumberSpinnerBuilder)Components.integerSpinner(this.model.updateInterval()).minimum((Number)1).columns(3)).editable(false)).build()).build();
        JPanel chartsPanel = (JPanel)Components.borderLayoutPanel().centerComponent((JComponent)intervalPanel).eastComponent(Components.button((Control)Control.commandControl(this.model::clearStatistics)).text("Clear").build()).build();
        JPanel zoomPanel = (JPanel)Components.borderLayoutPanel().centerComponent(((CheckBoxBuilder)Components.checkBox((Value)this.synchronizedZoomState).text("Synchronize zoom")).build()).eastComponent(Components.button((Control)Control.commandControl(this::resetZoom)).text("Reset zoom").build()).build();
        JPanel controlPanel = (JPanel)((PanelBuilder)Components.flexibleGridLayoutPanel((int)1, (int)2).border((Border)BorderFactory.createTitledBorder("Charts"))).add((JComponent)chartsPanel).add((JComponent)zoomPanel).build();
        JPanel chartPanelLeft = (JPanel)Components.gridLayoutPanel((int)3, (int)1).add((JComponent)this.requestsPerSecondChartPanel).add((JComponent)this.connectionCountChartPanel).add((JComponent)this.systemLoadChartPanel).build();
        JPanel chartPanelRight = (JPanel)Components.gridLayoutPanel((int)3, (int)1).add((JComponent)this.threadCountChartPanel).add((JComponent)this.memoryUsageChartPanel).add((JComponent)this.gcEventsChartPanel).build();
        JPanel chartPanel = (JPanel)((PanelBuilder)Components.gridLayoutPanel((int)1, (int)2).border(BorderFactory.createEtchedBorder())).add((JComponent)chartPanelLeft).add((JComponent)chartPanelRight).build();
        JPanel controlPanelBase = (JPanel)Components.borderLayoutPanel().westComponent((JComponent)controlPanel).build();
        JPanel overviewPanel = (JPanel)Components.borderLayoutPanel().southComponent((JComponent)controlPanelBase).centerComponent((JComponent)chartPanel).build();
        return (JPanel)Components.borderLayoutPanel().centerComponent((JComponent)overviewPanel).build();
    }

    private JTabbedPane createServerPanel() throws RemoteException {
        return (JTabbedPane)Components.tabbedPane().tab("System", (JComponent)this.createEnvironmentInfoPanel()).tab("Entities", (JComponent)this.createEntityPanel()).tab("Operations", (JComponent)this.createOperationPanel()).tab("Reports", (JComponent)this.createReportPanel()).build();
    }

    private JPanel createOperationPanel() {
        FilterTable table = (FilterTable)FilterTable.builder(this.model.operationTableModel(), ServerMonitorPanel.createOperationColumns()).autoResizeMode(4).build();
        JPanel refreshPanel = (JPanel)Components.flowLayoutPanel((int)2).add(Components.button((Control)Control.commandControl(this.model::refreshOperationList)).text("Refresh").build()).build();
        return (JPanel)Components.borderLayoutPanel().northComponent((JComponent)refreshPanel).centerComponent((JComponent)new JScrollPane((Component)table)).build();
    }

    private JPanel createReportPanel() {
        FilterTable table = (FilterTable)FilterTable.builder(this.model.reportTableModel(), ServerMonitorPanel.createReportColumns()).autoResizeMode(4).build();
        JPanel clearCacheAndRefreshPanel = (JPanel)Components.flowLayoutPanel((int)2).add(Components.button((Control)Control.commandControl(this.model::clearReportCache)).text("Clear Cache").build()).add(Components.button((Control)Control.commandControl(this.model::refreshReportList)).text("Refresh").build()).build();
        return (JPanel)Components.borderLayoutPanel().northComponent((JComponent)clearCacheAndRefreshPanel).centerComponent((JComponent)new JScrollPane((Component)table)).build();
    }

    private JPanel createEntityPanel() {
        FilterTable table = (FilterTable)FilterTable.builder(this.model.domainTableModel(), ServerMonitorPanel.createDomainColumns()).autoResizeMode(4).build();
        JPanel refreshPanel = (JPanel)Components.flowLayoutPanel((int)2).add(Components.button((Control)Control.commandControl(this.model::refreshDomainList)).text("Refresh").build()).build();
        return (JPanel)Components.borderLayoutPanel().northComponent((JComponent)refreshPanel).centerComponent((JComponent)new JScrollPane((Component)table)).build();
    }

    private JScrollPane createEnvironmentInfoPanel() throws RemoteException {
        return (JScrollPane)((TextAreaBuilder)((TextAreaBuilder)Components.textArea().autoscrolls(false).editable(false)).lineWrap(true).wrapStyleWord(true).initialValue((Object)this.model.environmentInfo())).scrollPane().build();
    }

    private JTextField createConnectionCountField() {
        return (JTextField)((NumberField.Builder)((NumberField.Builder)((NumberField.Builder)((NumberField.Builder)Components.integerField().columns(4)).editable(false)).horizontalAlignment(0)).link(this.model.connectionCount())).build();
    }

    private JTextField createMemoryField() {
        return (JTextField)((TextFieldBuilder)((TextFieldBuilder)Components.stringField().columns(8).editable(false)).horizontalAlignment(0).link(this.model.memoryUsage())).build();
    }

    private JComboBox<Object> createLogLevelField() {
        return (JComboBox)Components.comboBox(new DefaultComboBoxModel<Object>(this.model.logLevels().toArray()), this.model.logLevel()).build();
    }

    private void setColors(JFreeChart chart) {
        ChartUtil.linkColors(this, chart);
    }

    private void resetZoom() {
        boolean isSync = (Boolean)this.synchronizedZoomState.get();
        this.synchronizedZoomState.set((Object)false);
        this.requestsPerSecondChartPanel.restoreAutoBounds();
        this.memoryUsageChartPanel.restoreAutoBounds();
        this.connectionCountChartPanel.restoreAutoBounds();
        this.systemLoadChartPanel.restoreAutoBounds();
        this.gcEventsChartPanel.restoreAutoBounds();
        this.threadCountChartPanel.restoreAutoBounds();
        this.synchronizedZoomState.set((Object)isSync);
    }

    private void bindEvents() {
        ZoomSyncListener zoomSyncListener = new ZoomSyncListener();
        this.requestsPerSecondChart.getXYPlot().getDomainAxis().addChangeListener((AxisChangeListener)zoomSyncListener);
        this.memoryUsageChart.getXYPlot().getDomainAxis().addChangeListener((AxisChangeListener)zoomSyncListener);
        this.connectionCountChart.getXYPlot().getDomainAxis().addChangeListener((AxisChangeListener)zoomSyncListener);
        this.systemLoadChart.getXYPlot().getDomainAxis().addChangeListener((AxisChangeListener)zoomSyncListener);
        this.gcEventsChart.getXYPlot().getDomainAxis().addChangeListener((AxisChangeListener)zoomSyncListener);
        this.threadCountChart.getXYPlot().getDomainAxis().addChangeListener((AxisChangeListener)zoomSyncListener);
    }

    private static List<FilterTableColumn<ServerMonitor.ReportColumns.Id>> createReportColumns() {
        return Arrays.asList(FilterTableColumn.builder((Enum)ServerMonitor.ReportColumns.Id.DOMAIN).headerValue((Object)DOMAIN).build(), FilterTableColumn.builder((Enum)ServerMonitor.ReportColumns.Id.REPORT).headerValue((Object)"Report").build(), FilterTableColumn.builder((Enum)ServerMonitor.ReportColumns.Id.TYPE).headerValue((Object)"Type").build(), FilterTableColumn.builder((Enum)ServerMonitor.ReportColumns.Id.PATH).headerValue((Object)"Path").build(), FilterTableColumn.builder((Enum)ServerMonitor.ReportColumns.Id.CACHED).headerValue((Object)"Cached").build());
    }

    private static List<FilterTableColumn<ServerMonitor.DomainColumns.Id>> createDomainColumns() {
        return Arrays.asList(FilterTableColumn.builder((Enum)ServerMonitor.DomainColumns.Id.DOMAIN).headerValue((Object)DOMAIN).build(), FilterTableColumn.builder((Enum)ServerMonitor.DomainColumns.Id.ENTITY).headerValue((Object)"Entity").build(), FilterTableColumn.builder((Enum)ServerMonitor.DomainColumns.Id.TABLE).headerValue((Object)"Table").build());
    }

    private static List<FilterTableColumn<ServerMonitor.OperationColumns.Id>> createOperationColumns() {
        return Arrays.asList(FilterTableColumn.builder((Enum)ServerMonitor.OperationColumns.Id.DOMAIN).headerValue((Object)DOMAIN).build(), FilterTableColumn.builder((Enum)ServerMonitor.OperationColumns.Id.TYPE).headerValue((Object)"Type").build(), FilterTableColumn.builder((Enum)ServerMonitor.OperationColumns.Id.OPERATION).headerValue((Object)"Operation").build(), FilterTableColumn.builder((Enum)ServerMonitor.OperationColumns.Id.CLASS).headerValue((Object)"Class").build());
    }

    private final class ZoomSyncListener
    implements AxisChangeListener {
        private final List<JFreeChart> performanceCharts;

        private ZoomSyncListener() {
            this.performanceCharts = Arrays.asList(ServerMonitorPanel.this.requestsPerSecondChart, ServerMonitorPanel.this.memoryUsageChart, ServerMonitorPanel.this.connectionCountChart, ServerMonitorPanel.this.systemLoadChart, ServerMonitorPanel.this.gcEventsChart, ServerMonitorPanel.this.threadCountChart);
        }

        public void axisChanged(AxisChangeEvent event) {
            if (((Boolean)ServerMonitorPanel.this.synchronizedZoomState.get()).booleanValue()) {
                DateAxis dateAxis = (DateAxis)event.getAxis();
                this.performanceCharts.forEach(chart -> {
                    ValueAxis domainAxis;
                    if (!chart.equals((Object)event.getChart()) && !(domainAxis = chart.getXYPlot().getDomainAxis()).getRange().equals((Object)dateAxis.getRange())) {
                        domainAxis.setRange(dateAxis.getRange());
                    }
                });
            }
        }
    }
}

