/*
 * Decompiled with CFR 0.152.
 */
package is.codion.tools.server.monitor.ui;

import is.codion.swing.common.ui.component.Components;
import is.codion.swing.common.ui.control.Control;
import is.codion.swing.common.ui.control.Controls;
import is.codion.swing.common.ui.layout.Layouts;
import is.codion.tools.server.monitor.HostMonitor;
import is.codion.tools.server.monitor.ServerMonitor;
import is.codion.tools.server.monitor.ui.ServerMonitorPanel;
import java.awt.Component;
import java.rmi.RemoteException;
import java.util.Objects;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;

public final class HostMonitorPanel
extends JPanel {
    private final HostMonitor model;
    private JTabbedPane serverPane;

    public HostMonitorPanel(HostMonitor model) throws RemoteException {
        this.model = Objects.requireNonNull(model);
        this.initializeUI();
        this.bindEvents();
    }

    private void initializeUI() throws RemoteException {
        this.setLayout(Layouts.borderLayout());
        this.add((Component)Components.toolBar((Controls)this.controls()).build(), "North");
        this.serverPane = new JTabbedPane();
        this.add((Component)this.serverPane, "Center");
        this.addServerTabs();
    }

    private Controls controls() {
        return (Controls)Controls.builder().control(Control.builder().command(this.model::refresh).name("Refresh")).build();
    }

    private void bindEvents() {
        this.model.serverAddedEvent().addConsumer(serverMonitor -> {
            try {
                this.addServerTab((ServerMonitor)serverMonitor);
            }
            catch (RemoteException e) {
                throw new RuntimeException(e);
            }
        });
        this.model.serverRemovedEvent().addConsumer(serverMonitor -> {
            for (int i = 0; i < this.serverPane.getTabCount(); ++i) {
                ServerMonitorPanel panel = (ServerMonitorPanel)this.serverPane.getComponentAt(i);
                if (panel.model() != serverMonitor) continue;
                this.removeServerTab(panel);
            }
        });
    }

    private void addServerTabs() throws RemoteException {
        for (ServerMonitor serverMonitor : this.model.serverMonitors()) {
            this.addServerTab(serverMonitor);
        }
    }

    private void addServerTab(ServerMonitor serverMonitor) throws RemoteException {
        ServerMonitorPanel serverMonitorPanel = new ServerMonitorPanel(serverMonitor);
        this.serverPane.addTab(serverMonitor.serverInformation().serverName(), serverMonitorPanel);
    }

    private void removeServerTab(ServerMonitorPanel panel) {
        this.serverPane.remove(panel);
    }
}

