/*
 * Decompiled with CFR 0.152.
 */
package is.codion.tools.server.monitor.ui;

import is.codion.common.db.pool.ConnectionPoolStatistics;
import is.codion.common.format.LocaleDateTimePattern;
import is.codion.common.value.Value;
import is.codion.swing.common.ui.component.Components;
import is.codion.swing.common.ui.component.button.ButtonBuilder;
import is.codion.swing.common.ui.component.button.CheckBoxBuilder;
import is.codion.swing.common.ui.component.panel.BorderLayoutPanelBuilder;
import is.codion.swing.common.ui.component.panel.PanelBuilder;
import is.codion.swing.common.ui.component.spinner.NumberSpinnerBuilder;
import is.codion.swing.common.ui.component.text.TextComponents;
import is.codion.swing.common.ui.component.text.TextFieldBuilder;
import is.codion.swing.common.ui.control.Control;
import is.codion.swing.common.ui.layout.Layouts;
import is.codion.tools.server.monitor.ConnectionPoolMonitor;
import is.codion.tools.server.monitor.ui.ChartUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.LayoutManager;
import java.awt.Paint;
import java.text.NumberFormat;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.Objects;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.Border;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.renderer.xy.DeviationRenderer;
import org.jfree.chart.renderer.xy.XYItemRenderer;
import org.jfree.chart.renderer.xy.XYLineAndShapeRenderer;
import org.jfree.data.xy.XYDataset;

public final class ConnectionPoolMonitorPanel
extends JPanel {
    private static final int RESET_FIELD_COLUMNS = 14;
    private static final int HUNDRED = 100;
    private static final int SPINNER_COLUMNS = 3;
    private final ConnectionPoolMonitor model;
    private final NumberFormat format = NumberFormat.getInstance();
    private final DateTimeFormatter dateTimeFormatter = LocaleDateTimePattern.builder().delimiterDash().yearFourDigits().hoursMinutesSeconds().build().createFormatter();
    private final JFreeChart inPoolSnapshotChart = ChartFactory.createXYStepChart(null, null, null, null, (PlotOrientation)PlotOrientation.VERTICAL, (boolean)true, (boolean)true, (boolean)false);
    private final JFreeChart inPoolChart = ChartFactory.createXYStepChart(null, null, null, null, (PlotOrientation)PlotOrientation.VERTICAL, (boolean)true, (boolean)true, (boolean)false);
    private final JFreeChart requestsPerSecondChart = ChartFactory.createXYStepChart(null, null, null, null, (PlotOrientation)PlotOrientation.VERTICAL, (boolean)true, (boolean)true, (boolean)false);
    private final ChartPanel inPoolSnapshotChartPanel = new ChartPanel(this.inPoolSnapshotChart);
    private final ChartPanel inPoolChartPanel = new ChartPanel(this.inPoolChart);
    private final ChartPanel requestsPerSecondChartPanel = new ChartPanel(this.requestsPerSecondChart);
    private ChartPanel checkOutTimePanel;
    private final JTextField resetTimeField = (JTextField)Components.stringField().columns(14).build();
    private final JTextField poolSizeField = (JTextField)((TextFieldBuilder)Components.stringField().editable(false)).horizontalAlignment(0).build();
    private final JTextField createdField = (JTextField)((TextFieldBuilder)Components.stringField().editable(false)).horizontalAlignment(0).build();
    private final JTextField destroyedField = (JTextField)((TextFieldBuilder)Components.stringField().editable(false)).horizontalAlignment(0).build();
    private final JTextField requestedField = (JTextField)((TextFieldBuilder)Components.stringField().editable(false)).horizontalAlignment(0).build();
    private final JTextField failedField = (JTextField)((TextFieldBuilder)Components.stringField().editable(false)).horizontalAlignment(0).build();

    public ConnectionPoolMonitorPanel(ConnectionPoolMonitor model) {
        this.model = Objects.requireNonNull(model);
        this.format.setMaximumFractionDigits(2);
        this.initializeUI();
        this.updateView();
        this.bindEvents();
    }

    private void updateView() {
        ConnectionPoolStatistics statistics = this.model.connectionPoolStatistics();
        this.poolSizeField.setText(this.format.format(statistics.size()));
        this.createdField.setText(this.format.format(statistics.created()));
        this.destroyedField.setText(this.format.format(statistics.destroyed()));
        this.resetTimeField.setText(this.dateTimeFormatter.format(LocalDateTime.ofInstant(Instant.ofEpochMilli(statistics.resetTime()), ZoneId.systemDefault())));
        this.requestedField.setText(this.format.format(statistics.requests()));
        double prc = (double)statistics.failedRequests() / (double)statistics.requests() * 100.0;
        this.failedField.setText(this.format.format(statistics.failedRequests()) + (String)(prc > 0.0 ? " (" + this.format.format(prc) + "%)" : ""));
        if (this.model.datasetContainsData()) {
            this.inPoolSnapshotChart.getXYPlot().setDataset(this.model.snapshotDataset());
        }
    }

    private void initializeUI() {
        this.initializeCharts(this.model);
        this.setLayout(Layouts.borderLayout());
        this.add((Component)this.configurationPanel(), "North");
        this.add((Component)this.chartPanel(), "Center");
        this.add((Component)this.southPanel(), "South");
    }

    private void initializeCharts(ConnectionPoolMonitor model) {
        JFreeChart checkOutTimeChart = ChartFactory.createXYStepChart(null, null, null, (XYDataset)model.checkOutTimeCollection(), (PlotOrientation)PlotOrientation.VERTICAL, (boolean)true, (boolean)true, (boolean)false);
        this.setColors(checkOutTimeChart);
        this.checkOutTimePanel = new ChartPanel(checkOutTimeChart);
        this.checkOutTimePanel.setBorder(BorderFactory.createEtchedBorder());
        DeviationRenderer devRenderer = new DeviationRenderer();
        devRenderer.setDefaultShapesVisible(false);
        checkOutTimeChart.getXYPlot().setRenderer((XYItemRenderer)devRenderer);
        this.inPoolChart.getXYPlot().setDataset(model.inPoolDataset());
        XYLineAndShapeRenderer renderer = (XYLineAndShapeRenderer)this.inPoolChart.getXYPlot().getRenderer();
        renderer.setSeriesPaint(0, (Paint)Color.RED);
        renderer.setSeriesPaint(1, (Paint)Color.BLUE);
        renderer.setSeriesPaint(2, (Paint)Color.PINK);
        renderer.setSeriesPaint(3, (Paint)Color.GREEN);
        renderer.setSeriesPaint(4, (Paint)Color.MAGENTA);
        this.requestsPerSecondChart.getXYPlot().setDataset(model.requestsPerSecondDataset());
        checkOutTimeChart.getXYPlot().setDataset((XYDataset)model.checkOutTimeCollection());
        this.setColors(this.inPoolSnapshotChart);
        this.setColors(this.inPoolChart);
        this.setColors(this.requestsPerSecondChart);
        this.setColors(checkOutTimeChart);
    }

    private void setColors(JFreeChart chart) {
        ChartUtil.linkColors(this, chart);
    }

    private void bindEvents() {
        this.model.statisticsEvent().addListener(this::updateView);
    }

    private JPanel configurationPanel() {
        JPanel configBase = (JPanel)((PanelBuilder)Components.flexibleGridLayoutPanel((int)1, (int)0).border((Border)BorderFactory.createTitledBorder("Configuration"))).add(Components.borderLayoutPanel().westComponent((JComponent)new JLabel("Mininum size")).centerComponent(((NumberSpinnerBuilder)((NumberSpinnerBuilder)Components.integerSpinner(this.model.minimumPoolSize()).columns(3)).editable(false)).build()).build()).add(Components.borderLayoutPanel().westComponent((JComponent)new JLabel("Maximum size")).centerComponent(((NumberSpinnerBuilder)((NumberSpinnerBuilder)Components.integerSpinner(this.model.maximumPoolSize()).columns(3)).editable(false)).build()).build()).add(Components.borderLayoutPanel().westComponent((JComponent)new JLabel("Checkout timeout (ms)")).centerComponent(((NumberSpinnerBuilder)((NumberSpinnerBuilder)Components.integerSpinner(this.model.maximumCheckOutTime()).stepSize((Number)1000).columns(6)).editable(false)).build()).build()).add(Components.borderLayoutPanel().westComponent((JComponent)new JLabel("Idle timeout (ms)")).centerComponent(((NumberSpinnerBuilder)((NumberSpinnerBuilder)Components.integerSpinner(this.model.pooledConnectionTimeout()).stepSize((Number)1000).columns(6)).groupingUsed(true).editable(false)).build()).build()).add(Components.borderLayoutPanel().westComponent((JComponent)new JLabel("Cleanup interval (ms)")).centerComponent(((NumberSpinnerBuilder)((NumberSpinnerBuilder)Components.integerSpinner(this.model.poolCleanupInterval()).stepSize((Number)1000).columns(6)).groupingUsed(true).editable(false)).build()).build()).build();
        return (JPanel)Components.flowLayoutPanel((int)4).add((JComponent)configBase).build();
    }

    private JPanel chartPanel() {
        return (JPanel)((PanelBuilder)Components.panel((LayoutManager)new GridLayout(2, 2)).border(BorderFactory.createEtchedBorder())).add((JComponent)this.requestsPerSecondChartPanel).add((JComponent)this.inPoolChartPanel).add((JComponent)this.checkOutTimePanel).add((JComponent)this.inPoolSnapshotChartPanel).build();
    }

    private JPanel southPanel() {
        JPanel chartConfig = (JPanel)((PanelBuilder)Components.flexibleGridLayoutPanel((int)1, (int)4).border((Border)BorderFactory.createTitledBorder("Charts"))).add((JComponent)new JLabel("Update interval (s)")).add(((NumberSpinnerBuilder)((NumberSpinnerBuilder)Components.integerSpinner(this.model.updateInterval()).minimum((Number)1).columns(3)).editable(false)).build()).add(((CheckBoxBuilder)((CheckBoxBuilder)Components.checkBox((Value)this.model.collectSnapshotStatistics()).text("Snapshot")).maximumSize(TextComponents.preferredTextFieldSize())).build()).add(((CheckBoxBuilder)((CheckBoxBuilder)Components.checkBox((Value)this.model.collectCheckOutTimes()).text("Check out times")).maximumSize(TextComponents.preferredTextFieldSize())).build()).add(((ButtonBuilder)Components.button((Control)Control.commandControl(this.model::clearStatistics)).text("Clear").maximumSize(TextComponents.preferredTextFieldSize())).build()).build();
        return (JPanel)Components.borderLayoutPanel().westComponent((JComponent)chartConfig).centerComponent((JComponent)this.statisticsPanel()).build();
    }

    private JPanel statisticsPanel() {
        return (JPanel)((BorderLayoutPanelBuilder)Components.borderLayoutPanel().border((Border)BorderFactory.createTitledBorder("Statistics"))).centerComponent(Components.flexibleGridLayoutPanel((int)1, (int)0).add(Components.borderLayoutPanel().westComponent((JComponent)new JLabel("Connections")).centerComponent((JComponent)this.poolSizeField).build()).add(Components.borderLayoutPanel().westComponent((JComponent)new JLabel("Requested")).centerComponent((JComponent)this.requestedField).build()).add(Components.borderLayoutPanel().westComponent((JComponent)new JLabel("Failed")).centerComponent((JComponent)this.failedField).build()).add(Components.borderLayoutPanel().westComponent((JComponent)new JLabel("Created")).centerComponent((JComponent)this.createdField).build()).add(Components.borderLayoutPanel().westComponent((JComponent)new JLabel("Destroyed")).centerComponent((JComponent)this.destroyedField).build()).add(Components.borderLayoutPanel().westComponent((JComponent)new JLabel("Since")).centerComponent((JComponent)this.resetTimeField).build()).build()).eastComponent(Components.button((Control)Control.commandControl(this.model::resetStatistics)).text("Reset").build()).build();
    }
}

